# UBB.classic New Topic Routines : Perl Code

&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");
&RequireVars("$vars_config{VariablesPath}/vars_mods.cgi");

unless ($in{f}) {
	&StandardHTML($vars_wordlets_err{no_forum_selected});
	exit(0);
}

# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");

# get assigned style template!
%vars_style = &LoadStyleTemplate($this_forum);

&set_page_elements;

sub new_topic_page {
	local (@this_forum, $ubb_images, $post_permiss, $topic_restrict, $j, $is_html, $is_ubb, $html_allowed, $ubb_allowed, $ubb_images_wording, $icon_field, $email_notify, $show_sig, $disable_smilies, @user_profile, $close_option, $ubb_code_buttons);

	@this_forum   = &GetForumRecord($in{f});
	unless(@this_forum) {
		&StandardHTML("$vars_wordlets_err{no_such_forum}");
	}

	local($cat_line1, $category);
	if ($vars_display{CategoryView} eq 'yes') {

		if (!$category) {
			$category = $this_forum[0];
			$cat_name = &GetCatName($category);
		}

		$cat_line1 = qq!\n&raquo; <a href="$ULTIMATEBB?category=$category"><b>$cat_name</b></a>\n!;
	} else {
		$cat_line1 = '';
	}

	$post_permiss = $this_forum[6];

	if ($post_permiss eq 'private') {
		$topic_restrict = "restrict";
	} elsif($post_permiss =~ m/^private(.+)\&private(.+)$/) {
		$topic_restrict = $1;
	} else {
		($topic_restrict, $j) = split (/\&/, $post_permiss);
	}

	if ($topic_restrict eq 'none') {
		&StandardHTML("$vars_wordlets_err{no_one_can_post}");
	}

	# don't display if this forum status is off and forum is private
	if (($post_permiss =~ m/private/) && ($this_forum[3] ne 'On')) {
		&StandardHTML("$vars_wordlets_err{private_forum_off}");
	}

	if(!$username && ($vars_display{RequireLoginPosts} eq "YES")) {
		if($topic_restrict !~ m/all/) {
			&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a></p>!);
		} # end if
	} elsif(!$username && ($vars_display{RequireLoginPosts} eq "NO")) {
		if(($post_permiss =~ m/private/) || ($topic_restrict =~ m/restrict/)) {
			&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a></p>!);
		} # end if
	} # end if

	# check to make sure user has access/permission to post!
	if ($username && (($post_permiss =~ m/private/) || ($topic_restrict =~ m/restrict/))) {
		&check_private_access($in{f}, $this_forum[12]);
	}

	if((($topic_restrict eq 'allreg') || ($topic_restrict =~ m/restrict/)) && ($vars_registration{DisplayRegistration} eq "NO")) {
		&StandardHTML("$vars_wordlets_err{forum_misconfigured}");
	}


	# if unreg users not permitted to post, check to make user has write permissions
	if (($topic_restrict ne 'all') && ($vars_display{RequireLoginPosts} eq "YES")) {
		my @profile = &verify_id_num($username, $password, $user_number);
		chomp($profile[4]);
		if ($profile[4] !~ /Write/i) {
			&StandardHTML("$vars_wordlets_err{user_not_approved}");
		}
	}

	($html_allowed, $ubb_allowed, $is_ubb, $is_html, $ubb_images_wording) = &CheckCoding("$this_forum[4]", "$this_forum[5]", "$this_forum[10]");

	# -> is_html, is_ubb, ubb_images_wording

	if ($this_forum[5] eq 'is') {
		$ubb_code_buttons = &instant_ubb_code;
	} else {
		$ubb_code_buttons = "$is_ubb";
	}

	if ($vars_display{AllowIcons} eq 'TRUE') {
		$icon_field = &create_icon_field("1");
	}

	# email notify on?
	if (($vars_email{UseEmail} eq 'ON') && (($username ne '') || ($vars_display{RequireLoginPosts} eq "NO"))) {
		$email_notify = qq(<input type="checkbox" id="email_notification" name="email_notification" value="yes" /> $vars_wordlets{email_notify});
	}

	# show signature?
	if (($vars_display{AllowSignature} eq 'YES') && (($username ne '') || ($vars_display{RequireLoginPosts} eq "NO"))) {
		$show_sig = qq(<br /><input type="checkbox" name="Signature" id="Signature" value="yes" checked="checked" /> $vars_wordlets{show_signature});
	}

	# disable smilies?
	$disable_smilies = qq(<br /><input type="checkbox" id="disable_smilies" name="disable_smilies" value="yes" /> $vars_wordlets{disable_smilies});

	# allow closing of topic?
	# only admins or mods can close topics
	if ($username ne '') {
		@user_profile = &verify_id_num($username, $password, $user_number);
		my $is_one = &is_admin_or_mod($in{f}, @user_profile);
		if ($is_one eq "true") {
			$close_option = qq(<br /><input type="checkbox" id="close_topic" name="close_topic" value="yes" /> <b>$vars_wordlets{close_topic}</b>);
		}
	}

	# pull in instant smilie/ubb code javascript
	$direct_to = $instant_jscript;
	&set_page_elements;
	&LoadTemplate("public_new_topic_form");

}    # end new_topic_page

sub submit_new_topic {
	local (@this_forum, $ip_number, $permission, $topic_restrict, $j, $lc_your_name, $reg_name, $lc_reg_name, $lc_it, $status, $last_topic_number, $total_topic_count, $total_post_count, $Notes, $new_topic_number, @user_profile, $post_email, $message_ascii, @ip_banlist, $message, $mess_truncated, $email_message, $html_message, $this_subject);
	local (*FILE);


	#set proper path if forum is private
	@this_forum = &GetForumRecord($in{f});
	unless(@this_forum) {
		&StandardHTML("$vars_wordlets_err{no_such_forum}");
	}
	$permission = $this_forum[6];

	if ($permission eq 'private') {
		$exact_path     = "Forum$in{f}/private-$this_forum[7]";
		$topic_restrict = "restrict";
	} elsif($permission =~ m/^private(.+)\&private(.+)$/) {
		$exact_path     = "Forum$in{f}/private-$this_forum[7]";
		$topic_restrict = $1;
	} else {
		$exact_path           = "Forum$in{f}";
		($topic_restrict, $j) = split (/\&/, $permission);
	}

	# make sure we have someone logged in - unless unreg users allowed

	# if we got a post from a person who is posting without being logged in, fake the login
	my $cookie4;
	if (($in{your_name} ne "") && ($in{your_password} ne "") && ($vars_display{RequireLoginPosts} eq "NO")) {

		my @user_info = &verify_id("$in{your_name}", "$in{your_password}");    #validate their un/pw combo
		$username    = $in{your_name};
		$password    = $in{your_password};
		$pubname     = $user_info[0];
		$user_number = &GetUserNumber($username);

		my @this_profile = &verify_id_num_2($username, $password, $user_number);
		chomp($this_profile[1]);
		chomp($this_profile[0]);
		chomp($this_profile[21]);
		chomp($this_profile[34]);
		chomp($this_profile[15]);

		if ($this_profile[15] eq '') {
			$this_profile[15] = "$this_profile[0]";
		}

		$username = $this_profile[0];
		$password = $this_profile[1];

		$cookie4 = cookie(
			-name    => "ubber$vars_config{Cookie_Number}",
			-value   => [$this_profile[0], $this_profile[1], $this_profile[15], $this_profile[21], $user_number, $this_profile[34], (split(/\|/, $this_profile[38]))[2]],
			-path    => '/',
			-expires => '+2y'
		);

	}    #endif


	if ($cookie4) {
		print header(
			-cookie  => [$cookie4],
			-charset => "$masterCharset"
		);

	} else {
		print header(-charset => "$masterCharset");

	}



	# Require english letter/number in subject?
	if (($in{topic_subject} !~ /[a-zA-Z0-9]/) && ($vars_misc{EnglishSubjectCheck} eq 'ON')) {
		&StandardHTML("$vars_wordlets_err{subject_deficient}");
	}

	&CheckLength("topic_subject", 85);

	# check for HTML tags in subject
	if (($in{topic_subject} =~ /<.+>/) || ($in{topic_subject} =~ /</)) {
		&StandardHTML("$vars_wordlets_err{subject_with_html}");
	}

	$vars_misc{runOnLimit} = 30 unless $vars_misc{runOnLimit};

	# other subject checks/clean-ups
	if ($in{topic_subject} =~ /\S{$vars_misc{runOnLimit}}/) {
		&StandardHTML("$vars_wordlets_err{subject_with_runontext} : $in{topic_subject}");
	}    #test before trying to expand special characters

	$in{topic_subject} = &FixSubjectEncoding($in{topic_subject});

	# censor check the subject
	$in{topic_subject} = &CensorCheck("$in{topic_subject}");

	my $copy = &strip_lead_trail_space(&EscapeFilter($in{topic_subject}));
	if(length($copy) < 1) { &StandardHTML("$vars_wordlets_err{subject_deficient}"); }


	# is user banned?
	$ip_number = &GetIPAddress;
	&check_ip_bans;



	if ($topic_restrict eq 'none') {
		&StandardHTML("$vars_wordlets_err{no_one_can_post}");
	}



	#validate
	my @ValidateArray = ("topic_subject", "message");

	# in case this is an unreg user
	if ($username eq '') {
		push (@ValidateArray, "your_name");
	}

	if (($vars_display{RequireLoginPosts} eq "NO") && ($topic_restrict ne "all") && ($topic_restrict ne "restrict") && ($in{your_name} ne '')) {
		push (@ValidateArray, "your_password");
	}
	&Validate(@ValidateArray);



	#if there's no your_password, they're posting as unreg, so check...
	if (($username eq '') && ($topic_restrict ne 'all') && ($vars_display{RequireLoginPosts} eq "YES")) {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a></p>!);
	}

	# check to make sure user has access/permission to post!
	if (($permission =~ m/private/) || ($topic_restrict =~ m/restrict/)) {
		&check_private_access($in{f}, $this_forum[12]);
	}

	if (($topic_restrict eq 'all') && ($in{your_name} ne '') && ($in{your_password} eq "")) {

		# user is not registered, so...
		&CheckLengthOrDie("your_name", 25);
		my $tempuser = $in{your_name};

		&illegal_name_check($tempuser);

		#

		$username = "&lt;$tempuser&gt;";
		$pubname  = "&lt;$tempuser&gt;";

		# brackets differentiate from registered members
	} else {

		# user is saying he is registered so...
		#verify cookie id
		@user_profile = &verify_id_num($username, $password, $user_number);


		# does this person have permission to write?
		if ($user_profile[4] !~ /Write/i) {
			&StandardHTML("$vars_wordlets_err{user_not_approved}");
		}

	}    # if/else unregistered name


	if ($vars_misc{FloodCheck} eq 'ON') {

		#floodcheck courtesy of Michael Farris
		chomp($user_profile[8]);
		&floodcheck unless (($user_profile[8] eq 'Administrator') || ($user_profile[8] eq 'Moderator'));
	}

	# lock down
	$lockhandler = new UBB::FileHandler(\%vars_config, "topic_lock_$in{f}");
	$lockhandler->force_lock;

	# determine last topic number and increment by 1
	if (&FileExists("$vars_config{NonCGIPath}/$exact_path/lastnumber.file")) {
		my @forumcounter = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
		$last_topic_number = 0 + $forumcounter[0];
		chomp($last_topic_number);
		$total_topic_count = 0 + $forumcounter[1];
		chomp($total_topic_count);
		$total_post_count = 0 + $forumcounter[2];
		chomp($total_post_count);
	} else {
		$last_topic_number = 0;
		$total_topic_count = 0;
		$total_post_count  = 0;
	} # end else

	if (($in{email_notification}) && ($in{email_notification} eq 'yes') && (!$in{your_name})) {
		$Notes = 'N';
	} else {
		$Notes = '';
	}


	# close topic?
	# only admins or mods can close topics
	if ((!$in{your_name}) && ($in{close_topic}) && ($in{close_topic} eq 'yes')) {
		my $is_one = &is_admin_or_mod($in{f}, @user_profile);
		if ($is_one eq 'true') {
			$Notes .= 'X';
		}
	}

	if ($last_topic_number > 0) {
		$last_topic_number++;
		$new_topic_number = sprintf("%6d", $last_topic_number);
		$new_topic_number =~ tr/ /0/;
	} else {
		$new_topic_number = '000001';
	}

	$message_ascii = $in{message};

	# Process the post for UBBCode, Graemlins, etc
	$message = &cook_post($in{message}, $in{f}, $in{disable_smilies});

	## if email should not be displayed, don't
	chomp($user_profile[11]);
	chomp($user_profile[2]);
	if (($vars_display{EmailBlock} eq 'ON') || ($user_profile[11] eq 'no') || ($in{your_name})) {
		$post_email = '';
	} else {
		$post_email = "$user_profile[2]";
	}

	# we have IP, need to erase if we are not supposed to be keeping
	if ($vars_misc{IP} eq 'OFF') {
		$ip_number = '';
	}

	# post icons idea provided by KOMBAT03...
	unless ($in{msg_icon} =~ m/^\d+?$/) { $in{msg_icon} = '1'; }
	unless(&FileExists("$vars_config{NonCGIPath}/icons/icon$in{msg_icon}.gif")) {
		$in{msg_icon} = '1';
	}

	#create file lines
	my $stat_line = "A||$Notes||0";
	$stat_line .= "||$username|";
	$stat_line .= "|$in{topic_subject}||";
	$stat_line .= "||$in{msg_icon}||";
	$stat_line .= "||$pubname|";
	$stat_line .= "|$user_number";


	my $reg_status = 'reg';
	if (($in{your_name}) && (!$in{your_password}) && (!$user_number)) { $reg_status = 'unreg'; }
	if ($in{Signature} eq '') { $in{Signature} = 'no'; }

	my $topic_line = "Z||000000||$username||$GotTime{HyphenDate}||$GotTime{Time}||$post_email||$message||$ip_number||$reg_status||$in{msg_icon}||$pubname||$user_number||$in{Signature}";

	# test to make sure member file is writeable!
	if ($reg_status eq 'reg') {
		unless (-w "$vars_config{MembersPath}/$user_number.cgi") {
			chmod(SEVENSEVENSEVEN, "$vars_config{MembersPath}/$user_number.cgi") or die &Template($vars_wordlets_criterr{cant_reset_perms_on_profile}, {NUMBER => $user_number, OSERR => $!});
		}
	}

	die "Won't overwrite topic file $new_topic_number\n" if &TopicCheck($in{f}, $new_topic_number);

	my @topic_file = ($stat_line, $topic_line);
	&WriteTopic($in{f}, $new_topic_number, @topic_file);

	# update member file
	if ($reg_status eq 'reg') {
		$user_profile[7]++;

		# bump user up to Member if total posts reaches MemberMinimum
		if ($user_profile[8] !~ m/^(Administrator|Moderator)$/) {
			if ($user_profile[7] < $vars_misc{MemberMinimum}) {
				$user_profile[8] = 'Junior Member';
			} else {
				$user_profile[8] = 'Member';
			}
		}

		#last post in profile
		my $ipaddy = &GetIPAddress;
		$user_profile[30] = qq%$GotTime{YMDRunonDate}|$in{f}|$new_topic_number|000000|$ipaddy%;

		&WriteMemberProfile($user_number, @user_profile);
	}    # end update user profile

	# update last time file
	&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/lasttime.file", "$GotTime{HyphenDate}\n$GotTime{Time}\n");

	#update last number file for forum
	$total_topic_count++;
	$total_post_count++;
	&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/lastnumber.file", "$new_topic_number\n$total_topic_count\n$total_post_count\n$in{topic_subject}\n$pubname\n$in{msg_icon}\n$new_topic_number\n");

	my $ipaddy = &GetIPAddress;

	# update user_posts file
	if(($reg_status eq 'reg') && $user_number) {
		&AppendFileAsString("$vars_config{MembersPath}/user_posts/$user_number.cgi", "$GotTime{YMDRunonDate}|$in{f}|$new_topic_number|000000|$ipaddy\n");
	}    # if user is registered & forum is not private

	# update threads summary file
	if (&FileExists("$vars_config{NonCGIPath}/$exact_path/forum_$in{f}.threads")) {
		&update_forum_summary($in{f}, $new_topic_number, $in{topic_subject});
	} else {
		my $thistopics = &NiceForumThreadsRebuild($in{f});
		&UpdateForumTopics($in{f}, $thistopics, 1);	#1 == nowrite
		&update_forum_summary($in{f}, $new_topic_number, $in{topic_subject});	#writes
		%forum_topics = %{$thistopics};
	}

	&UpdateForumThreadDataForSingleThreadAndWrite($in{f}, $new_topic_number, \@topic_file);



	# index:
	# create promo edition of message
	$mess_truncated = &promo($message);
	&append_index($in{f}, $new_topic_number, $this_forum[6], "000000");

	# take viewer back to forum
	%vars_style = &LoadStyleTemplate("transition");
	&set_page_elements;
	&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic;f=$in{f};t=$new_topic_number", "$vars_wordlets{thanks_for_posting}", "$in{topic_subject}");

	$in{t} = $new_topic_number;
	$this_subject = $in{topic_subject};

	#strip UBBCode for moderator notification email
	$message =~ s/\[\/?(b|i|url|img|email|quote|code|list|\*)\]//gi;
	$message =~ s/\[\/?url=(.+)\]/($1) /;

	# release lock
	$lockhandler = undef;

	# notify moderator?
	if (($this_forum[11] eq 'yes') && ($vars_email{UseEmail} eq 'ON')) {

		# set email template
		%vars_style = &LoadStyleTemplate("email");
		&set_page_elements;

		&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");

		local ($Moderator);

		# $Moderator contains list of email addresses for modderators, separated by commas
		$Moderator = &build_mod_emails($in{f});

		if ($Moderator ne '') {

			if ($vars_email{email_format} ne 'html') {
				&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");

				my $s = &EmailWordletFixer;
				eval($s);
				if(defined &EmailWordletFiller) {
					%vars_wordlets_email = &EmailWordletFiller();
				} else {
					&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
				} # end if

				$email_message = qq!$vars_wordlets_email{mod_notify_post}!;
			} else {
				$email_message = '';
			}

			if ($vars_email{email_format} ne 'ascii') {
				$message = &ConvertReturns($message_ascii);

				&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");

				my $s = &EmailWordletFixer;
				eval($s);
				if(defined &EmailWordletFiller) {
					%vars_wordlets_email = &EmailWordletFiller();
				} else {
					&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
				} # end if

				my $html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{mod_notify_post_html}" . qq!</font>!;
				$html_message = "$EmailHeader $html_body $Footer";
			} else {
				$html_message = '';
			}

			&ubb_mail_tng({
				'EmailTo' => $Moderator,
				'EmailFrom' => $vars_display{BBEmail},
				'EmailReplyTo' => $vars_display{BBEmail},
				'BCCList' => undef,
				'Subject' => "$vars_wordlets_email{mod_notify_subject}: $this_forum[1]",
				'TextMessage' => $email_message,
				'HTMLMessage' => $html_message,
				'CCList' => undef,
			});

		}


	}    #end mod notify block

	# clear cache- we have new data!
	&ClearSummaryCacheCarefully((&GetForumRecord($in{f}))[0]);
	&ClearSingleForumPageCache($exact_path, $in{f});


}    # end submit new topic


# DANGER: Do not remove the next line!
1;
# $Id: ubb_new_topic.cgi,v 1.12 2002/05/03 18:27:33 cvscapps Exp $
