# UBB.classic New Reply Routines : Perl Code

&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");
&RequireVars("$vars_config{VariablesPath}/vars_mods.cgi");

unless ($in{f}) {
	&StandardHTML($vars_wordlets_err{no_forum_selected});
	exit(0);
}


# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");

# get assigned style template!
%vars_style = &LoadStyleTemplate($this_forum);

$direct_to = qq!
<base href="$vars_config{NonCGIURL}/" />
!;
&set_page_elements;

sub reply_page {
	local (@this_forum, @this_topic, $ubb_images, $post_permiss, $reply_restrict, $j, $is_html, $is_ubb, $html_allowed, $ubb_allowed, $ubb_images_wording, $icon_field, $show_sig, $disable_smilies, @reply_to, @stat_line, $clean_reply_to_message, $reply_to_message, $reply_to_author, $insert_reply_to, $i_frame, $i_frame_alt, @post_line, $go_to, $close_option, @user_profile, $ubb_code_buttons);

	# validate replyto=> reply with quote
	if ($in{replyto}) {
		unless ($in{replyto} >= 0) {
			&StandardHTML("$vars_wordlets_err{reply_to}");
		}
	}

	# get forum details
	@this_forum   = &GetForumRecord($in{f});
	unless(@this_forum) {
		&StandardHTML("$vars_wordlets_err{no_such_forum}");
	}

	local($cat_line1, $category);
	if ($vars_display{CategoryView} eq 'yes') {

		if (!$category) {
			$category = $this_forum[0];
			$cat_name = &GetCatName($category);
		}

		$cat_line1 = qq!\n&raquo; <a href="$ULTIMATEBB?category=$category"><b>$cat_name</b></a>\n!;
	} else {
		$cat_line1 = '';
	}

	$post_permiss = $this_forum[6];
	chomp($post_permiss);

	if ($post_permiss eq 'private') {
		$reply_restrict = "restrict";
	} elsif($post_permiss =~ m/^private(.+)\&private(.+)$/) {
		$reply_restrict = $2;
	} else {
		($j, $reply_restrict) = split (/\&/, $post_permiss);
	}

	if ($reply_restrict eq 'none') {
		&StandardHTML("$vars_wordlets_err{no_one_can_post}");
	}

	if((($reply_restrict eq 'allreg') || ($reply_restrict =~ m/restrict/)) && ($vars_registration{DisplayRegistration} eq "NO")) {
		&StandardHTML("$vars_wordlets_err{forum_misconfigured}");
	}

	# make sure we have someone logged in - unless unreg users allowed
#	if ((!$username) && ($reply_restrict ne 'all') && ($vars_display{RequireLoginPosts} eq "YES")) {
#		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a></p>!);
#	}

	if(!$username && ($vars_display{RequireLoginPosts} eq "YES")) {
		if($reply_restrict !~ m/all/) {
			&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a></p>!);
		} # end if
	} elsif(!$username && ($vars_display{RequireLoginPosts} eq "NO")) {
		if(($post_permiss =~ m/private/) || ($reply_restrict =~ m/restrict/)) {
			&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a> $vars_wordlets{or} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=agree">$vars_wordlets{register_title}</a></p>!);
		} # end if
	} # end if

	# check to make sure user has access/permission to post!
	if ($username && (($post_permiss =~ m/private/) || ($reply_restrict =~ m/restrict/))) {
		&check_private_access($in{f}, $this_forum[12]);
	}

	# grab topic
	@this_topic = &OpenTopic($in{t}, $in{f});

	# grab topic stat line
	@stat_line = split (/\|\|/, $this_topic[0]);

	# is topic closed?
	if ($stat_line[1] =~ /X/i) {
		&StandardHTML("$vars_wordlets_err{topic_closed}");
	}

	# don't display if this forum status is off and forum is private
	if (($post_permiss =~ m/private/) && ($this_forum[3] ne 'On')) {
		&StandardHTML("$vars_wordlets_err{private_forum_off}");
	}

	# if unreg users not permitted to post, check to make user has write permissions
	if (($reply_restrict ne 'all') && ($vars_display{RequireLoginPosts} eq "YES")) {
		my @profile = &verify_id_num($username, $password, $user_number);
		chomp($profile[4]);
		if ($profile[4] !~ /Write/i) {
			&StandardHTML("$vars_wordlets_err{user_not_approved}");
		}
	}

	($html_allowed, $ubb_allowed, $is_ubb, $is_html, $ubb_images_wording) = &CheckCoding("$this_forum[4]", "$this_forum[5]", "$this_forum[10]");

	# -> is_html, is_ubb, ubb_images_wording, html_allowed, ubb_allowed

	if ($this_forum[5] eq 'is') {
		$ubb_code_buttons = &instant_ubb_code;
	} else {
		$ubb_code_buttons = "$is_ubb";
	}

	if ($vars_display{AllowIcons} eq 'TRUE') {
		$icon_field = &create_icon_field("1");
	}

	# show signature?
	if (($vars_display{AllowSignature} eq 'YES') && ($username ne '')) {
		$show_sig = qq(<br /><input type="checkbox" name="Signature" id="Signature" value="yes" checked="checked" /> $vars_wordlets{show_signature});
	}

	# disable smilies?
	$disable_smilies = qq(<br /><input type="checkbox" id="disable_smilies" name="disable_smilies" value="yes" /> $vars_wordlets{disable_smilies});

	# allow closing of topic?
	# only admins or mods can close topics
	if ($username ne "") {
		@user_profile = &verify_id_num($username, $password, $user_number);
		my $is_one = &is_admin_or_mod($in{f}, @user_profile);
		if ($is_one eq 'true') {
			$close_option = qq(<br /><input type="checkbox" id="close_topic" name="close_topic" value="yes" /> <b>$vars_wordlets{close_topic}</b>);
		}
	}

	# reply with quote?
	$insert_reply_to = '';
	if ($in{replyto}) {

		# find particular post within topic
		@post_line = grep(/^Z\|\|$in{replyto}/, @this_topic);
		@reply_to = split (/\|\|/, $post_line[0]);

		$reply_to_message = $reply_to[6];

		if ($reply_to[10] ne '') {
			$reply_to_author = $reply_to[10];
		} else {
			$reply_to_author = $reply_to[2];
		}

		# prepare replyto post for form
		$clean_reply_to_message = &prep_for_edit("$reply_to_message", "$this_forum[5]", "$this_forum[10]");
		# Kludge 3: The Unreleased Sequel
		#my $counter = 0;
		#while($clean_reply_to_message =~ s/(\[QUOTE\])(.*?)(\[\/QUOTE\])/\n/is) { $counter++; }

		# strip off sig (if old UBB5 message)
		chomp($reply_to[12]);
		if ($reply_to[12] eq '') {
			$clean_reply_to_message =~ s/------------------(.*)//isg;
		}
		chomp($clean_reply_to_message);

		$insert_reply_to = "\[QUOTE\]$vars_wordlets{reply_to_lead} $reply_to_author:\n\[QB\]$clean_reply_to_message\[/QB\]\[/QUOTE\]\n";

	}    # end replyto get

	# set topic viewer:
	$go_to = "$ULTIMATEBB?ubb=get_topic;f=$in{f};t=$in{t}";


	$i_frame_alt = &build_topic_review(@this_topic, $go_to);

	if ($vars_display{InlineFrame} eq 'TRUE') {
		$i_frame = qq(<iframe frameborder="1" align="middle" width="$vars_style{TableWidth}" height="400" scrolling="yes" src="$go_to">
$i_frame_alt
</iframe>);
	} else {
		$i_frame = $i_frame_alt;
	}

	# pull in instant smilie/ubb code javascript
	$direct_to .= $instant_jscript;
	&set_page_elements;

	&LoadTemplate("public_new_reply_form");

}    # end new_reply_page

sub submit_new_reply {
	local (@this_forum, $ip_number, $permission, $reply_restrict, $j, $lc_your_name, $reg_name, $lc_reg_name, $lc_it, $status, $total_post_count, $last_topic_number, $total_topic_count, @user_profile, $post_email, $message_ascii, @stat_line, $post_number, @ip_banlist, @this_topic, $total_replies, @rev_this_topic, @last_post, $last_post_num, @get_email, $notify_email, $notify_user_number, $get_profile, $get_un, @notify_profile, $message, $mess_truncated, $this_subject, $this_subject_also, $email_message, $html_message);
	local (*FILE);

	&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");
	@this_forum = &GetForumRecord($in{f});
	unless(@this_forum) {
		&StandardHTML("$vars_wordlets_err{no_such_forum}");
	}
	$permission = $this_forum[6];

	#set proper path if forum is private
	if ($permission eq 'private') {
		$exact_path     = "Forum$in{f}/private-$this_forum[7]";
		$reply_restrict = "restrict";
	} elsif($permission =~ m/^private(.+)\&private(.+)$/) {
		$exact_path     = "Forum$in{f}/private-$this_forum[7]";
		$reply_restrict = $2;
	} else {
		$exact_path           = "Forum$in{f}";
		($j, $reply_restrict) = split (/\&/, $permission);
	}

	# if we got a post from a person who is posting without being logged in, fake the login
	my $cookie4;
	if (($in{your_name} ne "") && ($in{your_password} ne "") && ($vars_display{RequireLoginPosts} eq "NO")) {

		my @user_info = &verify_id("$in{your_name}", "$in{your_password}");    #validate their un/pw combo
		$username    = $in{your_name};
		$password    = $in{your_password};
		$pubname     = $user_info[0];
		$user_number = &GetUserNumber($username);

		my @this_profile = &verify_id_num_2($username, $password, $user_number);
		chomp($this_profile[1]);
		chomp($this_profile[0]);
		chomp($this_profile[21]);
		chomp($this_profile[34]);
		chomp($this_profile[15]);

		if ($this_profile[15] eq '') {
			$this_profile[15] = "$this_profile[0]";
		}

		$username = $this_profile[0];
		$password = $this_profile[1];

		$cookie4 = cookie(
			-name    => "ubber$vars_config{Cookie_Number}",
			-value   => [$this_profile[0], $this_profile[1], $this_profile[15], $this_profile[21], $user_number, $this_profile[34], (split(/\|/, $this_profile[38]))[2]],
			-path    => '/',
			-expires => '+2y'
		);

	}    #endif


	if ($cookie4) {
		print header(
			-cookie  => [$cookie4],
			-charset => "$masterCharset"
		);

	} else {
		print header(-charset => "$masterCharset");

	}



	# make sure hiddens are cool
	unless (($in{t} =~ /^\d{6}$/) && ($in{f} > 0)) {
		&StandardHTML("$vars_wordlets_err{invalid_input}");
	}

	# is user banned?
	$ip_number = &GetIPAddress;
	&check_ip_bans;

	#validate
	my @ValidateArray = ("message");

	if ($reply_restrict eq 'none') {
		&StandardHTML("$vars_wordlets_err{no_one_can_post}");
	}


	# in case this is an unreg user
	if (!$username) {
		push (@ValidateArray, "your_name");
	}
	if (($vars_display{RequireLoginPosts} eq "NO") && ($reply_restrict ne "all") && ($reply_restrict ne "restrict") && ($in{your_name} ne '')) {
		push (@ValidateArray, "your_password");
	}

	&Validate(@ValidateArray);

	# make sure we have someone logged in - unless unreg users allowed
	if (($username eq '') && ($reply_restrict ne 'all')) {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a></p>!);
	}

	# check to make sure user has access/permission to post!
	if (($permission =~ m/private/) || ($reply_restrict =~ m/restrict/)) {
		&check_private_access($in{f}, $this_forum[12]);
	}


	# we will need to timestamp this baby
	&GetDateTime;

	if (($reply_restrict eq 'all') && ($in{your_name} ne '') && ($in{your_password} eq "")) {

		# user is not registered, so...
		&CheckLengthOrDie("your_name", 25);
		my $tempuser = $in{your_name};

		&illegal_name_check($tempuser);

		#&CheckForExistingNames(lc $tempuser);

		$username = "&lt;$tempuser&gt;";
		$pubname  = "&lt;$tempuser&gt;";

		# brackets differentiate from registered members
	} else {

		# user is saying he is registered so...
		#verify cookie id
		@user_profile = &verify_id_num($username, $password, $user_number);
		chomp($user_number);

		# does this person have permission to write?
		if ($user_profile[4] !~ /Write/i) {
			&StandardHTML("$vars_wordlets_err{user_not_approved}");
		}

	}    # if/else unregistered name

	if ($vars_misc{FloodCheck} eq 'ON') {

		# floodcheck courtesy of Michael Farris
		chomp($user_profile[8]);
		&floodcheck unless (($user_profile[8] eq 'Administrator') || ($user_profile[8] eq 'Moderator'));
	}

	# lock down
	$lockhandler = new UBB::FileHandler(\%vars_config, "topic_lock_$in{f}");
	$lockhandler->force_lock;

	# get forum post count
	if (&FileExists("$vars_config{NonCGIPath}/$exact_path/lastnumber.file")) {
		my @forumcounter = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
		$last_topic_number = 0 + $forumcounter[0];
		chomp($last_topic_number);
		$total_topic_count = 0 + $forumcounter[1];
		chomp($total_topic_count);
		$total_post_count = 0 + $forumcounter[2];
		chomp($total_post_count);

		#yes, yes, I know...
	} else {
		$total_post_count  = 0;
		$last_topic_number = 0;
		$total_topic_count = 0;
	}

	# update post count
	$total_post_count++;

	# grab topic
	@this_topic = &OpenTopic($in{t}, $in{f});

	# grab topic stat line
	@stat_line = split (/\|\|/, $this_topic[0]);

	# is topic closed?
	if ($stat_line[1] =~ /X/i) {
		&StandardHTML("$vars_wordlets_err{topic_closed}");
	}

	# need to update total replies
	$stat_line[2] = scalar(@this_topic) - 1;  #1, not 2 - yet to add

	# close topic?
	# only admins or mods can close topics
	if (!($in{your_name}) && ($in{close_topic}) && ($in{close_topic} eq 'yes')) {
		my $is_one = &is_admin_or_mod($in{f}, @user_profile);
		if ($is_one eq 'true') { $stat_line[1] .= 'X'; }
	}

	# grab subject
	$this_subject      = $stat_line[4];
	$this_subject_also = $this_subject;

	# reassemble stat_line for @this_topic
	$this_topic[0] = join ("||", @stat_line);

	# grab last post
	@rev_this_topic = reverse(@this_topic);
	@last_post      = split (/\|\|/, $rev_this_topic[0]);
	$last_post_num  = $last_post[1];
	$last_post_num++;

	# format new post number
	$post_number = &Do6Digit($last_post_num);

	$message_ascii = $in{message};

	# Process the post for UBBCode, Graemlins, etc
	$message = &cook_post($in{message}, $in{f}, $in{disable_smilies});

	## if email should not be displayed, don't
	chomp($user_profile[11]);
	chomp($user_profile[2]);
	if (($vars_display{EmailBlock} eq 'ON') || ($user_profile[11] eq 'no') || (!$in{your_name})) {
		$post_email = '';
	} else {
		$post_email = "$user_profile[2]";
	}

	# we have IP, need to erase if we are not supposed to be keeping
	if ($vars_misc{IP} eq 'OFF') {
		$ip_number = '';
	}

	# post icons idea provided by KOMBAT03...
	unless ($in{msg_icon} =~ m/^\d+?$/) { $in{msg_icon} = '1'; }
	unless(&FileExists("$vars_config{NonCGIPath}/icons/icon$in{msg_icon}.gif")) {
		$in{msg_icon} = '1';
	}

	#create topic post line
	my $reg_status = 'reg';
	if (($in{your_name}) && (!$in{your_password}) && (!$user_number)) {
		$reg_status = 'unreg';
	}

	if (!$in{Signature}) {
		$in{Signature} = 'no';
	}

	my $topic_line = "Z||$post_number||$username||$GotTime{HyphenDate}||$GotTime{Time}||$post_email||$message||$ip_number||$reg_status||$in{msg_icon}||$pubname||$user_number||$in{Signature}\n";

	# append new reply to @this_topic
	push (@this_topic, $topic_line);

	# test to make sure member file is writeable!
	if ($reg_status eq 'reg') {
		unless (-w "$vars_config{MembersPath}/$user_number.cgi") {
			chmod(SEVENSEVENSEVEN, "$vars_config{MembersPath}/$user_number.cgi") or die &Template($vars_wordlets_criterr{cant_reset_perms_on_profile}, {NUMBER => $user_number, OSERR => $!});
		}
	}

	#update threads summary file
	if (&FileExists("$vars_config{NonCGIPath}/$exact_path/forum_$in{f}.threads")) {
		&update_forum_summary($in{f}, $in{t}, $this_subject);
	} else {
		my $thistopics = &NiceForumThreadsRebuild($in{f});
		&UpdateForumTopics($in{f}, $thistopics, 1);	#1 == nowrite
		&update_forum_summary($in{f}, $in{t}, $this_subject);
	}

	&UpdateForumThreadDataForSingleThreadAndWrite($in{f}, $in{t}, \@this_topic);

	die "Won't reply to a topic that doesn't exist.\n" unless &TopicCheck($in{f}, $in{t});

	# no problem, so proceed
	&WriteTopic($in{f}, $in{t}, @this_topic);

	# update member file?
	if ($reg_status eq 'reg') {
		$user_profile[7]++;

		# bump user up to Member if total posts reaches MemberMinimum
		if ($user_profile[8] !~ m/^(Administrator|Moderator)$/) {
			if ($user_profile[7] < $vars_misc{MemberMinimum}) {
				$user_profile[8] = 'Junior Member';
			} else {
				$user_profile[8] = 'Member';
			}
		}

		my $ipaddy = &GetIPAddress;

		# update user_posts file
		if(($reg_status eq 'reg') && $user_number) {
			&AppendFileAsString("$vars_config{MembersPath}/user_posts/$user_number.cgi", "$GotTime{YMDRunonDate}|$in{f}|$in{t}|$post_number|$ipaddy\n");
		}

		#last post in profile
		$user_profile[30] = qq%$GotTime{YMDRunonDate}|$in{f}|$in{t}|$post_number|$ipaddy%;

		&WriteMemberProfile($user_number, @user_profile);
	}    # end update user profile

	#update last time file
	&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/lasttime.file", "$GotTime{HyphenDate}\n$GotTime{Time}\n");

	&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/lastnumber.file", "$last_topic_number\n$total_topic_count\n$total_post_count\n$this_subject\n$pubname\n$in{msg_icon}\n$in{t}\n");

	# index---
	$in{topic_subject} = $this_subject;

	# create promo edition of message
	$mess_truncated = &promo($message);
	&append_index($in{f}, $in{t}, $this_forum[6], $post_number);

	# create promo edition of message
	$mess_truncated = &promo($message);

	# unlink old topic page
	#unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");
	my $thispath = qq($vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path);
	&DoThatClearCacheThing($thispath, $in{t});

	# lock down
	$lockhandler = undef;

	# lc the logged in user-- for comparisons below
	my $lc_un = lc($username);

	# take viewer back to topic
	%vars_style = &LoadStyleTemplate("transition");
	&set_page_elements;

#	print header . "<pre>";

	my $last_page_extra = "";
	if(($vars_display{HTMLDisplayMax} > 0) && ($vars_display{ReverseThreads} eq "FALSE")) {
		my $fraction = 1 / $vars_display{HTMLDisplayMax};
		my $outer = 0; #$fraction;

#		print "Fraction is $fraction\n";

		foreach(@this_topic) {
#			print "Foreach:\n";
			next if $_ !~ m/^Z/;
#			print "Got past the Z check.\n";
			next unless m/^Z\|\|(\d+)\|\|/;
#			print "Got past the number check.\n";
			my $this = $1;
#			print "This is '$this'\n";
			$outer += $fraction;
#			print "Outer is '$outer'\n";
			last if $this eq $post_number;
#			print "Got past the last check.\n\n";
		} # end if
#		print "Final outer: $outer...";
		my $page = &round_up_always($outer);
#		print " final page: $page\n";
#		$page++ if(int($page / $vars_display{HTMLDisplayMax}) eq ($page / $vars_display{HTMLDisplayMax}));

		if($page > 1) {
			$last_page_extra = ";p=$page";
		} # end if
		$last_page_extra .= "#$post_number"
	} # end if

#	print "</pre>";

	&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic;f=$in{f};t=$in{t}$last_page_extra", "$vars_wordlets{thanks_for_posting}", "$this_subject");

	# set email template
	if(($vars_email{UseEmail} eq 'ON') || (($this_forum[11] eq 'yes') || ($stat_line[1] =~ /N/i))) {
		%vars_style = &LoadStyleTemplate("email");
		&set_page_elements;
	}

	# notify moderator?
	if (($this_forum[11] eq 'yes') && ($vars_email{UseEmail} eq 'ON')) {

		local ($Moderator);

		# $Moderator contains list of email addresses for modderators, separated by commas
		$Moderator = &build_mod_emails($in{f});

		if ($Moderator ne '') {
			&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");

			if ($vars_email{email_format} ne 'ascii') {
				$message = ConvertReturns($message_ascii);

				my $s = &EmailWordletFixer;
				eval($s);
				if(defined &EmailWordletFiller) {
					%vars_wordlets_email = &EmailWordletFiller();
				} else {
					&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
				} # end if

				my $html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{mod_notify_post_html}" . qq!</font>!;
				$html_message = "$EmailHeader $html_body $Footer";
			} else {
				$html_message = '';
			}

			if ($vars_email{email_format} ne 'html') {

				my $s = &EmailWordletFixer;
				eval($s);
				if(defined &EmailWordletFiller) {
					%vars_wordlets_email = &EmailWordletFiller();
				} else {
					&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
				} # end if

				$email_message = qq!$vars_wordlets_email{mod_notify_post}!;
			} else {
				$email_message = '';
			}

			&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");
			&ubb_mail_tng({
				'EmailTo' => $Moderator,
				'EmailFrom' => $vars_display{BBEmail},
				'EmailReplyTo' => $vars_display{BBEmail},
				'BCCList' => undef,
				'Subject' => "$vars_wordlets_email{mod_notify_subject}: $this_forum[1]",
				'TextMessage' => $email_message,
				'HTMLMessage' => $html_message,
				'CCList' => undef,
			});
		}

	}    #end mod notify block

	# notify topic starter?
	my $lc_topic_starter = lc($stat_line[3]);

	if (($stat_line[1] =~ /N/i) && ($vars_email{UseEmail} eq 'ON') && ($lc_un ne "$lc_topic_starter")) {

		&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");

		# get topic writer email:
		chomp($stat_line[9]);
		if ($stat_line[9] ne '') {
			@get_profile = &OpenProfile($stat_line[9]);
		} else {
			$get_un      = &GetUserNumber($stat_line[3]);
			@get_profile = &OpenProfile($get_un);
		}

		$notify_email = $get_profile[2];
		chomp($notify_email);



		if ($vars_email{email_format} ne 'html') {
			&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");
			my $s = &EmailWordletFixer;
			eval($s);
			if(defined &EmailWordletFiller) {
				%vars_wordlets_email = &EmailWordletFiller();
			} else {
				&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
			} # end if
			$email_message = qq!$vars_wordlets_email{topic_notify}!;
		} else {
			$email_message = '';
		}

		if ($vars_email{email_format} ne 'ascii') {
			$message = &ConvertReturns($message_ascii);

			&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");

			my $s = &EmailWordletFixer;
			eval($s);
			if(defined &EmailWordletFiller) {
				%vars_wordlets_email = &EmailWordletFiller();
			} else {
				&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
			} # end if

			my $html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{topic_notify_html}" . qq!</font>!;
			$html_message = "$EmailHeader $html_body $Footer";
		} else {
			$html_message = '';
		}

		&ubb_mail_tng({
			'EmailTo' => $notify_email,
			'EmailFrom' => $vars_display{BBEmail},
			'EmailReplyTo' => $vars_display{BBEmail},
			'BCCList' => undef,
			'Subject' => "$vars_wordlets_email{topic_notify_subject}",
			'TextMessage' => $email_message,
			'HTMLMessage' => $html_message,
			'CCList' => undef,
		});


	}    #end topic starter notify block

	# clear cache- we have new data!
	&ClearSummaryCacheCarefully((&GetForumRecord($in{f}))[0]);
	&ClearSingleForumPageCache($exact_path, $in{f});


}    # end submit new reply


# DANGER: Do not remove the next line!
1;
# $Id: ubb_new_reply.cgi,v 1.19 2002/05/07 22:13:04 cvscapps Exp $
