# UBB.classic LIBRARY - DATE/TIME FUNCTIONS

sub AdjustPNTF {
	return $_[0] - int((time() - &GetAdjustedEpochTime) / 60);
} # end AdjustPNTF

sub GetDateTime {
	%GotTime = &GenerateTimeCore(&GetAdjustedEpochTime);
}    #end GetDateTime sr

sub GetAdjustedEpochTime {
	my $adjustTime = time();
	if ($vars_time{TimeZoneOffset} =~ m/^([\d\-\+]+)$/) {
		if($1) {
			$adjustTime = time() + ($vars_time{TimeZoneOffset} * 3600);
		} # end if
	} # end if
	return $adjustTime;
} # end GetAdjustedEpochTime

sub GenerateTimeCore {
	my $this_epoch = shift;
	my(%this_time);
	($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($this_epoch);

	$mon++;
	$this_time{JSMonth}             = $mon;
	$this_time{JSYear}              = $year + 1900;
	$this_time{LastLoginJulianDATE} = &jday($this_time{JSMonth}, $mday, $this_time{JSYear});
	$hour = sprintf("%.2d", $hour);
	$min = sprintf("%.2d", $min);
	$sec = sprintf("%.2d", $sec);
	$this_time{sec} = $sec;
	$JSTime = "$hour$min";
	$this_time{LastLoginJulian} = ($this_time{LastLoginJulianDATE} + ($JSTime * 0.0001));
	$this_time{SearchJulian}    = ("$this_time{LastLoginJulianDATE}" . "-$JSTime$this_time{sec}");
	($this_time{ampmhour}, $this_time{AMPM}) = &NormalTime($hour);
	$this_time{min} = $min;
	$this_time{hour} = $hour;
	$this_time{mon} = sprintf("%.2d", $mon);
	$this_time{mday} = sprintf("%.2d", $mday);
	$this_time{HyphenDate}   = "$this_time{mon}-$this_time{mday}-$this_time{JSYear}";
#	$this_time{RunonDate}    = "$this_time{mon}$this_time{mday}$year";
	$this_time{YMDRunonDate} = "$this_time{JSYear}$this_time{mon}$this_time{mday}";
	$this_time{Time}         = "$this_time{ampmhour}:$this_time{min} $this_time{AMPM}";
	$this_time{LastLoginDT}  = "$this_time{HyphenDate} $this_time{Time}";
	$this_time{CurrentPNTF}  = int($this_epoch / 60);
	$this_time{CurrentEpoch} = $this_epoch;

	use Time::Local;
	my $offset = ((&timegm(localtime()) - time()) / 60) / 60;
	$this_time{GMTOffset} = $offset;
	$this_time{PSTOffset} = -8 - $offset;

	return %this_time;
} # end GenerateTimeCore

sub ConvertTo24Hour {
	my ($thishr, $thismin, $thisampm) = @_;
	if ($_[2] eq 'PM') {
		if ($_[0] < 12) {
			$thishour = ($_[0] + 12);
		} else {
			$thishour = $_[0];
		}
	}

	if ($_[2] eq 'AM') {
		if ($_[0] == 12) {
			$thishour = '0';
		} else {
			$thishour = $_[0];
		}
	}
	$thishour = sprintf("%.2d", $thishour);
	$thismin = sprintf("%.2d", $thismin);
	return ("$thishour:$thismin");
}    # end convert to 24 hour format sr

sub ConvertTo24HourRunon {
	my ($thishr, $thismin, $thisampm);
	if ($_[2] eq 'PM') {
		if ($_[0] < 12) {
			$thishour = ($_[0] + 12);
		} else {
			$thishour = $_[0];
		}
	}

	if ($_[2] eq 'AM') {
		if ($_[0] == 12) {
			$thishour = '0';
		} else {
			$thishour = $_[0];
		}
	}
	$thishour = sprintf("%.2d", $thishour);
	$thismin = sprintf("%.2d", $_[1]);
	return ("$thishour$thismin");
}    # end convert to 24 hour runon format sr

# and as PNTF time is just int(time() / 60)...
sub ConvertPostTimeToUnixEpoch {
	return(&ConvertPostTimeToPNTF(@_) * 60);
} # end ConvertPostTimeToUnixEpoch

sub ConvertJulianToUnixEpoch {
	return(&ConvertJulianToPNTF(@_) * 60);
} # end ConvertJulianToUnixEpoch

sub ConvertUnixEpochToJulian {
	return(&ConvertPNTFToJulian(int($_[0] / 60)));
} # end ConvertUnixEpochToJulian

sub ConvertUnixEpochToJulianTime {
	return(&ConvertPNTFToJulianTime(int($_[0] / 60)));
} # end ConvertUnixEpochToJulianTime

sub ConvertUnixEpochToPostTime {
	return(&ConvertPNTFToPostTime(int($_[0] / 60)));
} # end ConvertUnixEpochToPostTime

sub FormatUnixEpoch {
	return &DateFormat2(&ConvertUnixEpochToPostTime(@_));
} # end FormatUnixEpoch

sub FormatPNTF {
	return &DateFormat2(&ConvertPNTFToPostTime(@_));
} # end FormatPNTF

sub FormatJulian {
	return &DateFormat2(&ConvertJulianToPostTime(@_));
} # end FormatJulian

sub NormalTime {
	my($AMPM, $hour);
	if ($_[0] < 12) { $AMPM = 'AM'; $hour = $_[0]; }
	elsif ($_[0] > 12) {
		$hour = $_[0] - 12;
		$AMPM = 'PM';
	} else {
		$AMPM = 'PM';
		$hour = $_[0];
	}
	if ($hour == 0) { $hour = '12'; }
	$hour = sprintf("%.2d", $hour);
	return ($hour, $AMPM);
} # end NormalTime

sub DateFormat {

	# $_[0] (thedate) is a hyphenated MM-DD-YYYY format

	my($mon, $mday, $year, $CheckLength, $FormattedDate);

	#prepare alternate formats
	($mon, $mday, $year) = split (/-/, $_[0]);

	# make sure we don't have any old pre-Y2K dates
	$CheckLength = length($year);
	if ($CheckLength < 4) {
		if ($CheckLength == 2) {
			$year = ("19" . "$year");
		} else {
			$year = $year - 100;
			$year = sprintf("%.2d", $year);
			$year = ("20" . "$year");
		}
	}

	my @months = ("blank", "$vars_wordlets_date{month_1}", "$vars_wordlets_date{month_2}", "$vars_wordlets_date{month_3}", "$vars_wordlets_date{month_4}", "$vars_wordlets_date{month_5}", "$vars_wordlets_date{month_6}", "$vars_wordlets_date{month_7}", "$vars_wordlets_date{month_8}", "$vars_wordlets_date{month_9}", "$vars_wordlets_date{month_10}", "$vars_wordlets_date{month_11}", "$vars_wordlets_date{month_12}");

	#date format options
	if ($vars_time{DateFormat} eq "US") {
		$FormattedDate = $_[0];
	} elsif ($vars_time{DateFormat} eq "Euro") {
		$FormattedDate = "$mday-$mon-$year";
	} elsif ($vars_time{DateFormat} eq "USX") {
		$FormattedDate = "$months[$mon] $mday, $year";
	} else {
		$FormattedDate = "$mday $months[$mon] $year";
	}
	return ($FormattedDate);
}

sub TimeFormat {
	my ($time_formatted, @timearray, $get_hour, $get_minute);

	if ($vars_time{TimeFormat} eq '24HR') {
		@timearray = split (/ /, $_[0]);
		chomp($timearray[1]);
		($get_hour, $get_minute) = split (/:/, $timearray[0]);
		chomp($get_minute);

		if ($timearray[1] eq 'PM') {
			if ($get_hour < 12) { $get_hour = ($get_hour + 12); }
		} else {
			if ($get_hour == 12) { $get_hour = '0'; }
		}
		$get_hour       = &Do2Digit($get_hour);
		$get_minute     = &Do2Digit($get_minute);
		$time_formatted = "$get_hour:$get_minute";
	} else {
		$time_formatted = $_[0];
	}
	return ($time_formatted);
}    # end TimeFormat


sub DateFormat2 {
	return(&DateFormat($_[0]), &TimeFormat($_[1]));
} # end DateFormat2


sub GetMonthsHash {
	my @months = ("blank", "$vars_wordlets_date{month_1}", "$vars_wordlets_date{month_2}", "$vars_wordlets_date{month_3}", "$vars_wordlets_date{month_4}", "$vars_wordlets_date{month_5}", "$vars_wordlets_date{month_6}", "$vars_wordlets_date{month_7}", "$vars_wordlets_date{month_8}", "$vars_wordlets_date{month_9}", "$vars_wordlets_date{month_10}", "$vars_wordlets_date{month_11}", "$vars_wordlets_date{month_12}");
	my %hash;
	my $count = 0;
	foreach my $month (@months) {
		$hash{$count} = $month;
		$count++;
	} # end foreach
	delete $hash{0};
	return %hash;
} # end GetMonthsHash


sub GenerateDateLists {
	# *sigh*
	my($year_form, $month_form, $day_form,
		$year_sel, $month_sel, $day_sel) = @_;

	my $year_options = &GenerateDropdownListHTML(
		# hash of options (key == 'value', value == 'option')
		{ a => "$vars_wordlets_date{year_cap}: ", b => "", &DuplicateArrayAsHash(1900 .. ($GotTime{JSYear} + 10)), },
		# Array index of item to be selected
		$year_sel + 10,
		# Array of options (keys of hash in sorted order)
		"a", "b", reverse(1900 .. ($GotTime{JSYear} + 10)),
		);


	my $month_options = &GenerateDropdownListHTML(
		{a => "$vars_wordlets_date{month_cap}: ", b => "", &GetMonthsHash},
		$month_sel, "a", "b", 1 .. 12,
		);


	my $day_options = &GenerateDropdownListHTML(
		{ a => "$vars_wordlets_date{day_cap}: ", b => "", &DuplicateArrayAsHash(1 .. 31), },
		$day_sel, "a", "b", (1 .. 31),
		);

	my $year_html = qq(<select size="1" name="$year_form">
	$year_options
	</select>);

	my $month_html = qq(<select size="1" name="$month_form">
	$month_options
	</select>);

	my $day_html = qq(<select size="1" name="$day_form">
	$day_options
	</select>);


	if ($vars_time{DateFormat} eq "US") {
		return("$month_html$day_html$year_html");
	} elsif ($vars_time{DateFormat} eq "Euro") {
		return("$day_html$month_html$year_html");
	} elsif ($vars_time{DateFormat} eq "USX") {
		return("$month_html$day_html$year_html");
	} else {
		return("$day_html$month_html$year_html");
	}

} # end GenerateDateLists

sub GenerateTimeLists {
	my($hourname, $minname, $ampmname,
		$hour, $min, $ampm) = @_;

	my @hour_list;
	foreach(1 .. 12) {
		push(@hour_list, sprintf("%.2d", $_));
	} # end if

	my $hour_options = &GenerateDropdownListHTML(
		# hash of options (key == 'value', value == 'option')
		{ a => "$vars_wordlets_date{hour_cap}: ", b => "",
		&DuplicateArrayAsHash(@hour_list), },
		# Array index of item to be selected
		$hour,
		# Array of options (keys of hash in sorted order)
		"a", "b", @hour_list,
		);

	my @min_list;
	foreach(0 .. 59) {
		push(@min_list, sprintf("%.2d", $_));
	} # end if

	my $min_options = &GenerateDropdownListHTML(
		# hash of options (key == 'value', value == 'option')
		{ a => "$vars_wordlets_date{minute_cap}: ", b => "",
		&DuplicateArrayAsHash(@min_list), },
		# Array index of item to be selected
		$min,
		# Array of options (keys of hash in sorted order)
		"a", "b", @min_list,
		);

	my $ampm_options = &GenerateDropdownListHTML(
		{ a => "$vars_wordlets_date{ampm_cap}: ", b => "",
		'AM' => 'AM', 'PM' => 'PM', },
		$ampm,
		"a", "b", "AM", "PM",
		);


	my $hour_html = qq(<select size="1" name="$hourname">
	$hour_options
	</select>);

	my $minute_html = qq(<select size="1" name="$minname">
	$min_options
	</select>);

	my $ampm_html = qq(<select size="1" name="$ampmname">
	$ampm_options
	</select>);

	return("$hour_html$minute_html$ampm_html");
} # end GenerateTimeLists

sub IsValidDate {
	# checks the provided date to ensure it's valid
	my($year, $month, $day) = @_;
	my($returned, $leapyear) = (0,0);

	$returned++ unless(($year > 1890) && ($year <= $GotTime{JSYear}));

	$month += 0; # crude but effective to get rid of zero padding
	$day += 0;

	my $real_month = 12;
	if(($year >= $GotTime{JSYear}) && ($month >= $GotTime{JSMonth})) {
		$real_month = $GotTime{JSMonth};
	} # end if
	$returned++ unless(($month > 0) && ($month <= $real_month));

	$leapyear = &YearIsLeap($year);

	my @mdays = qw( -1 31 28 31 30 31 30 31 31 30 31 30 31 );
	$mdays[2] += $leapyear;
	my $real_days = $mdays[$month];
	if(($year >= $GotTime{JSYear}) && ($month >= $GotTime{JSMonth})) {
		$real_days = ($GotTime{mday} + 0);
	} # end if
	$returned++ unless(($day > 0) && ($day <= $real_days));

	return ($returned);
} # end IsValidDate

sub IsValidFutureDate {
	# checks the provided date to ensure it's valid
	my($year, $month, $day) = @_;
	my($returned, $leapyear) = (0,0);

	$returned++ unless(($year > 1890) && ($year <= $GotTime{JSYear} + 10));

	$month += 0; # crude but effective to get rid of zero padding
	$day += 0;

	my $real_month = 12;
	$returned++ unless(($month > 0) && ($month <= $real_month));

	$leapyear = &YearIsLeap($year);

	my @mdays = qw( -1 31 28 31 30 31 30 31 31 30 31 30 31 );
	$mdays[2] += $leapyear;
	my $real_days = $mdays[$month];
	$returned++ unless(($day > 0) && ($day <= $real_days));

	return ($returned);
} # end IsValidFutureDate

sub IsInvalidTime {
	my($hour, $minute, $ampm) = @_;
	my $returned = 0;
	$hour =~ s/\D//g;
	$minute =~ s/\D//g;

	$returned++ unless($ampm && ($ampm =~ m/^(a|p)m$/i));

	$returned++ unless($hour && ($hour > 0) && ($hour < 13));

	$returned++ unless($minute && ($minute >= 0) && ($minute < 60));

	return $returned;
} # end IsInvalidTime

sub YearIsLeap {
	my $year = shift;
	# leap year code inspired and patched for correctness
	# originally from the Date::PCalc module, available on CPAN
	my $yy = int($year / 100);
	if( ( ($year & 0x03) == 0) &&
	  ( ( ($yy * 100) != $year) || ( ($yy & 0x03) == 0) &&
	  ( int($year / 400) eq ($year / 400) ) ) ) {	# exception of the 400 year rule
		return 1;
	} else {
		return 0;
	} # end if
} # end YearIsLeap


sub Y2K {
	my ($check_length, $year);
	$check_length = length($_[0]);
	if ($check_length < 4) {
		if ($check_length == 2) {
			$year = ("19" . "$_[0]");
		} else {
			$year = $_[0] - 100;
			$year = sprintf("%2d", $year);
			$year =~ tr/ /0/;
			$year = ("20" . "$year");
		}
	} else {
		$year = $_[0];
	}
	return ($year);
}    # end Y2K sr


### Conversions



sub ConvertJulianToPNTF {
	my $jul = shift;
	my $world_created_jul = 2440588;
	my $world_created_days = 20;

	my $pntf_time;
	if($jul =~ m/\./) {
		# if it's a Julian daytime
		my($l, $r) = split(/\./, $jul);
		my $diff = $l - $world_created_jul;
		if($diff < 0) { die $vars_wordlets_criterr{before_the_world}; }
		$diff *= 60;
		$pntf_time = $world_created_days + $diff;

		$r =~ m/^(\d{2})(\d{2})$/;
		my($h, $m) = ($1, $2);
		my $z = (($h * 60) + $m) / 24;
		$pntf_time = ($z + $pntf_time) * 24;
		$pntf_time += $GotTime{PSTOffset} * 60;
	} else {
		# if it's just a jday
		my $diff = $jul - $world_created_jul;
		$diff *= 60;
		if($diff < 0) { die $vars_wordlets_criterr{before_the_world}; }
		$pntf_time = ($world_created_days + $diff) * 24;
	} # end if

	return $pntf_time;
} # end sub


sub ConvertJulianToPostTime {
	my $jul = shift;
	if($jul =~ m/\./) {
		# if it's a Julian daytime
		my($l, $r) = split(/\./, $jul);
		my @mdy = (&jdate($l))[0,1,2];
		$r =~ m/^(\d{2})(\d{2})$/;
		my($h, $m) = ($1, $2);
		my $a;
		if($h > 12) {
			$h -= 12; $a = "PM";
		} else {
			$a = "AM";
		} # end if
		return(sprintf("%.2d-%.2d-%.4d", @mdy), sprintf("%02d:%02d %s", $h, $m, $a));
	} else {
		my @mdy = (&jdate($jul))[0,1,2];
		return(sprintf("%.2d-%.2d-%.4d", @mdy), "12:00 AM");
	} # end if
} # end sub


sub ConvertPNTFToJulian {
	return &jday( split("-", ( &ConvertPNTFToPostTime(@_) )[0]) );
} # end sub

sub ConvertPNTFToJulianTime {
	my @r = &ConvertPNTFToPostTime(@_);
	my $jul = &jday( split("-", $r[0]) );
	my $dot = &ConvertPostTimeTimeToJulianDot($r[1]);
	if($dot > 0) { $jul .= ".$dot"; }
	return $jul;
} # end sub


sub ConvertPNTFToPostTime {
	my $epoch = $_[0] * 60;

	my %this_time = &GenerateTimeCore($epoch);

	return($this_time{HyphenDate}, $this_time{Time});
} # end if


sub ConvertPostTimetoJulian {
	my ($indate, $intime) = @_;

	my ($month, $day, $year) = split (/\-/, $indate);

	# in case we have some pre Y2K posts....
	$year = &Y2K($year);

	# create j date
	my $post_date_j = &jday($month, $day, $year);

	# create j time
	my $post_time = $intime;
	my $am_pm;
	my ($get_hour, $get_min) = split (/:/, $post_time);
	($get_min, $am_pm) = split (/ /, $get_min);
	chomp($am_pm);
	my $military_time = &ConvertTo24HourRunon("$get_hour", "$get_min", "$am_pm");

	my $post_dt_j = ($post_date_j + ($military_time * 0.0001));
	$post_dt_j = sprintf("%7.4f", $post_dt_j);
	$post_dt_j =~ tr/ /0/;
	return ($post_dt_j);
} # end sub


sub ConvertPostTimeToPNTF {
	return &ConvertJulianToPNTF(&ConvertPostTimetoJulian(@_));
} # end sub


sub ConvertPostTimeTimeToJulianDot {
	my @tim = split(/[\s\:]+/, $_[0]);
	$tim[0] -= 12 if $tim[0] > 11;
	$tim[0] += 12 if(($tim[2] eq "PM") && ($tim[0] < 12));
	return sprintf("%0.d%.2d", @tim[0,1]);
} # end sub





# FROM OLD DATE.PL FILE:

# Edited to remove cruft, Perl4-isms

# The following defines the first day that the Gregorian calendar was used
# in the British Empire (Sep 14, 1752).  The previous day was Sep 2, 1752
# by the Julian Calendar.  The year began at March 25th before this date.

sub jdate {
	# Usage:  ($month,$day,$year,$weekday) = &jdate($julian_day)
	my $jd = $_[0];
	my ($jdate_tmp, $m, $d, $y, $wkday);

	$wkday     = ($jd + 1) % 7;	# calculate weekday (0=Sun,6=Sat)
	$jdate_tmp = $jd - 1721119;
	$y         = int((4 * $jdate_tmp - 1) / 146097);
	$jdate_tmp = 4 * $jdate_tmp - 1 - 146097 * $y;
	$d         = int($jdate_tmp / 4);
	$jdate_tmp = int((4 * $d + 3) / 1461);
	$d         = 4 * $d + 3 - 1461 * $jdate_tmp;
	$d         = int(($d + 4) / 4);
	$m         = int((5 * $d - 3) / 153);
	$d         = 5 * $d - 3 - 153 * $m;
	$d         = int(($d + 5) / 5);
	$y         = 100 * $y + $jdate_tmp;
	if ($m < 10) {
		$m += 3;
	} else {
		$m -= 9;
		++$y;
	}
	return ($m, $d, $y, $wkday);
} # end jdate


sub jday {
	# Usage:  $julian_day = &jday($month,$day,$year)
	my ($m, $d, $y) = @_;
	my ($ya, $c);

	$y = (localtime(time))[5] + 1900 if ($y eq '');

	if ($m > 2) {
		$m -= 3;
	} else {
		$m += 9;
		--$y;
	}
	$c  = int($y / 100);
	$ya = $y - (100 * $c);
	$jd = int((146097 * $c) / 4)
		+ int((1461 * $ya) / 4)
		+ int((153 * $m + 2) / 5)
		+ $d
		+ 1721119;

	return $jd;
} # end jday

## END OLD DATE.PL FILE

# DANGER: do note remove the next line!
1;
# $Id: ubb_lib_time.cgi,v 1.8 2002/04/18 22:27:17 cvscapps Exp $
