# UBB::SecurityGroups

# I'm useless, but not for long; the future is comin' on,
# is comin' on,  is comin' on,  is comin' on,  is comin' on...

package UBB::SecurityGroups;
use strict;
#no strict("refs");
#use warnings;

# Attention code hackers:
# Feel free to explore and tinker, however
# the entire secgroups mdoel is going to
# be retrofitted in the future... this one
# is too kludgy to be turned into the final
# implementation.

BEGIN {
	use vars qw($VERSION @ISA);

	$VERSION = 0.10;

	@ISA = qw(UBB::CommonElements);

	#$| = 1;
	#open(STDERR, ">>/net/ubb620-development/cache-PNVT5YXP/lock/sg.log") or die $!;
	#my $oldfh = select(STDERR); $|=1; select($oldfh);
}    # end BEGIN


sub UBB::SecurityGroups::new {
	my $protoobj = shift;
	my $class    = ref($protoobj) || $protoobj;
	my $self     = $_[0];
	bless($self, $class);

	if (!-d "$_[0]->{CONFIG}->{NonCGIPath}/cache-$_[0]->{CONFIG}->{cache_pw}") {
		mkdir("$_[0]->{CONFIG}->{NonCGIPath}/cache-$_[0]->{CONFIG}->{cache_pw}", 0777);
		chmod(0777, "$_[0]->{CONFIG}->{NonCGIPath}/cache-$_[0]->{CONFIG}->{cache_pw}");
	}    # cache

	if (!-d "$_[0]->{CONFIG}->{MembersPath}/user_groups") {
		mkdir("$_[0]->{CONFIG}->{MembersPath}/user_groups", 0777);
		chmod(0777, "$_[0]->{CONFIG}->{MembersPath}/user_groups");
	}    # user_groups

	#$self->warn("x" x 80);

	return $self;
}    # end new

sub UBB::SecurityGroups::DESTROY {    # laa dee daa
}                # end DESTROY

sub load_groups {
	my $self = shift;
	my $fn = $self->{CONFIG}->{MembersPath} . "/user_groups/groups.cgi";

	if((-e $fn) && (-s $fn)) {
		my $handle = $self->{FILEHANDLER}->open('file', 'readonly', $fn);
		my $string = $handle->readfile();
		{ # start local
			local $SIG{'__DIE__'}  = sub { return; };
			local $SIG{'__WARN__'} = sub { return; };
			eval $string;
		} # end local
		$self->{FILEHANDLER}->close($handle);

		if(defined &UBB::SecurityGroups::_load_groups) {
			$self->_load_groups;
		} # end if
	} elsif(!exists $self->{GROUPS}) {
		$self->{GROUPS} =  {};
	} # end if

	# Set up the predefined user groups
	# No permission sets are required here...
	$self->{GROUPS}->{predefined_groups} = {
		administrators => {},
		moderators => {},
		senior_members => {},
		junior_members => {},
		COPPA_members => {},
		unknown_members => {},
	}; # end predefined_groups

	# Defaults removed due to new model
	if($self->{VARSFORUMS}) {
		foreach my $number (keys %{$self->{VARSFORUMS}}) {
			my $permline = $self->{VARSFORUMS}->{$number}->[6];
			my($t, $r) = split(/\&/, $permline);

			$self->{GROUPS}->{forums}->{$number}->{view} = "public";

			if($permline eq "private") {
				$self->{GROUPS}->{forums}->{$number}->{view} = "private";
				$t = $r = "restrict";
			} elsif($permline =~ m/private/) {
				$self->{GROUPS}->{forums}->{$number}->{view} = "private";
				$t =~ s/private//;
				$r =~ s/private//;
			} # end if
			$self->{GROUPS}->{forums}->{$number}->{new_topic} = $t;
			$self->{GROUPS}->{forums}->{$number}->{new_reply} = $r;
		} # end foreach
	} # end if

#restrict	all
#allreg		none
#none		none


	return;
} # end load_groups

sub write_groups {
	my $self = shift;
	if(!defined &Data::ThatWhichDumps::Dumper) {
		require "ubb_lib_dumper.cgi";
	}

	my $this = $self->{GROUPS};
	delete($this->{predefined_groups});
	my $obj = Data::ThatWhichDumps->new([$this], ['$self->{GROUPS}']);

	my $z = q!
package UBB::SecurityGroups;
sub UBB::SecurityGroups::_load_groups {
	my $self = shift; ! . $obj->Dump . q!
} # end sub
1;
!;
	my $fn = $self->{CONFIG}->{MembersPath} . "/user_groups/groups.cgi";
	my $handle = $self->{FILEHANDLER}->open('file', 'writeonly', $fn);
	$handle->print($z);
	$self->{FILEHANDLER}->close($handle);
} # end write_groups

sub has_group {
	my $type = ( $_[1] =~ /pollgroup/ ? "polling" : "forums" );
	my $type2 = ( $_[1] =~ /pollgroup/ ? "pollgroup" : "forumgroup" );
	my $num = (split(/_/, $_[1]))[1]; my $n = $type2 . "_$num";
	return exists($_[0]->{GROUPS}->{$type}->{$n});
} # end has_group

sub raw_group_access {
	return $_[0]->{GROUPS}->{$_[1]};
} # end raw_group_access

sub _get_raw_group {
	my $type = ( $_[1] =~ /pollgroup/ ? "polling" : "forums" );
	my $type2 = ( $_[1] =~ /pollgroup/ ? "pollgroup" : "forumgroup" );
	my $num = (split(/_/, $_[1]))[1]; my $n = $type2 . "_$num";
	return $_[0]->{GROUPS}->{$type}->{$n};
} # end _get_raw_group

sub _get_raw_group_list {
	my $type = ( $_[1] =~ /poll/ ? "polling" : "forums" );
	return keys %{ $_[0]->{GROUPS}->{$type} };
} # end _get_raw_group_list





























##############################################################################
##############################################################################
#
# UBB::SecurityToken - Links a user profile to a set of permissions in the
# SecurityGroups list
#
##############################################################################
##############################################################################

package UBB::SecurityToken;
use strict;

BEGIN {
	use vars qw($VERSION @ISA);

	$VERSION = 0.10;

	@ISA = qw(UBB::CommonElements);

	#$| = 1;
	#open(STDERR, ">>/net/ubb620-development/cache-PNVT5YXP/lock/token.log") or die $!;
	#my $oldfh = select(STDERR); $|=1; select($oldfh);
}    # end BEGIN


sub UBB::SecurityToken::new {
	my $protoobj = shift;
	my $class    = ref($protoobj) || $protoobj;
	my $self     = {
		GROUPOBJ   => bless($_[0], "UBB::SecurityGroups"),	# $vars_groups
		USERNUM	   => $_[1],					# $user_number
		USERPROFILE=> $_[2],					# &OpenProfile($user_number)
		VARSFORUMS => $_[3],
		IN	   => $_[4],
		DEBUG      => 0,                			# debugging (warnings)
	};
	bless($self, $class);

	#$self->warn("x" x 80);

	$self->_decide_primary_group();
	$self->_decide_restricted_groups();
	$self->_decide_addtl_groups();

	return $self;
}    # end new

sub UBB::SecurityToken::DESTROY {    # laa dee daa
}                # end DESTROY

sub _decide_primary_group {
	my $self = shift;

	# COPPA users are always in the COPPA group
	if($self->{USERPROFILE}->[4] =~ m/COPPA/) {
		$self->{PRIMARY_GROUP} = 'COPPA_members';
		return;
	} # end if

	# We know the four basic groups will always be present and sane
	if($self->{USERPROFILE}->[8] eq "Administrator") {
		if($self->{USERPROFILE}->[4] =~ m/Admin/) {
			$self->{PRIMARY_GROUP} = 'administrators';
		} else {
			$self->{PRIMARY_GROUP} = 'unknown_members';
		} # end if
	} elsif($self->{USERPROFILE}->[8] eq "Moderator") {
		$self->{PRIMARY_GROUP} = 'moderators';
		if($self->{IN}->{f}) {	# if we got an $in{f}, we know about a forum, so...
			if($self->{VARSFORUMS}->{$self->{IN}->{f}}->[18] !~ m/$self->{USERNUM}/) {
				# ... make a Moderator that's outside his own forum equiv to a senior member
				$self->{PRIMARY_GROUP} = 'senior_members';
			} # end if
		} # end if
	} elsif($self->{USERPROFILE}->[8] eq "Member") {
		$self->{PRIMARY_GROUP} = 'senior_members';
	} elsif($self->{USERPROFILE}->[8] eq "Junior Member") {
		$self->{PRIMARY_GROUP} = 'junior_members';
	} else {	# unreg / something else has gone wrong
		$self->{PRIMARY_GROUP} = 'unknown_members';
	} # end if

	return;
} # end _decide_primary_group

sub _decide_addtl_groups { # unimplemented
} # end _decide_addtl_groups

sub _decide_restricted_groups {	# unimplemented
} # end _decide_restricted_groups


sub _is_in {	# not a method
	my $value = shift;
	if(ref($value) =~ m/^UBB::Security/) { die "Don't call _is_in as a method!" . join(", ", caller()) . "\n"; }
	my @list = @_;
	if(ref($list[0]) eq 'ARRAY') { @list = @{$list[0]} }
	foreach(@list) { return 1 if $value eq $_ }
	return 0;
} # end _is_in


sub has_permission {
	my $self = shift;
	my $type = shift;	# polling, forum
	my $action = shift;	# create, vote, new_topic, new_reply, view...
	my $extra = shift;	# forum group num / polling group num
	my $retval = 0;		# deny by default

	# $user_permissions->has_permission("polling", "vote", "1")
	my $particular = [];
	if($type eq "polling") {
		if($self->{GROUPOBJ}->has_group("pollgroup_$extra")) {
			# Was originally going to offer the ability to ban
			# a user from a certain security group's permission set
			# (i.e. ban a user from a forum), however we're not
			# going to implement that for now...
			#$retval-- if &_is_in("denied", $self->{RESTRICTED_GROUPS}->{"polling_$extra"});
			$particular = $self->{GROUPOBJ}->_get_raw_group("pollgroup_$extra");
		} else {
			# Defaults removed due to new model
			die;
			# Uh, ok, we were just told to load permissions
			# for a group that doesn't exist.. Riiiight.
			# $retval-- if &_is_in("denied", $self->{RESTRICTED_GROUPS}->{'polling_default'});
			# Fall back to the default.
			# $particular = $self->{GROUPOBJ}->_get_raw_group("pollgroup_default");
		} # end if
	} elsif($type eq "forum") {
		# Yes, I realize that this section doesn't seem to match
		# what the rest of the system does.  Yes, I know that makes
		# this horribly, horribly ugly.  Yes, I know that you know
		# this already.  Yes, this is gonna be reimplemented properly
		# in a future release.
		my $p = $self->{GROUPOBJ}->{GROUPS}->{forums}->{$extra}->{view};
		return -1 unless $p;

		if($action eq "view") {
			return 1 if $self->{PRIMARY_GROUP} eq "administrators";

			if($p eq "private") {
				return 3 if $self->{PRIMARY_GROUP} eq "moderators";
				my($j,$g) = split(/\&/, $self->{USERPROFILE}->[4]);
				$g =~ s/\w//g;	# COPPA, etc
				return 4 if _is_in($extra, split(/\,/, $g));
				return -3;
			} elsif($p eq "public") {
				return 2;
			} else {
				return -2;
			} # end if
			return 0;
		} else {
			return undef;
		} # end if
	} elsif($type eq "avatar") {
		return _is_in($self->{PRIMARY_GROUP}, @{$self->{GROUPOBJ}->{GROUPS}->{avatars}->{perms}->{$action}});
	} # end if

	# Right, if we've managed to get this far, the user doesn't have
	# an explicit 'denied' for this particular PRIMARY_GROUP

	# Secondary / admin-defined group rules will go here next

	if(ref($particular) eq 'ARRAY') {
		# Somehow the group options did not get loaded
		return -1;
	} # end if

	# Okay, so we have group data - now figure out
	# if we allow by default or not

	# -> -> -> Disabled in the current model!

	my $abd = 0;
	#if($particular->{defaultaction} eq "allow") {
	#	$abd = 1;
	#} elsif($particular->{defaultaction} eq "deny") {
	#	$abd = 0;
	#} else {
	#	die "Why wasn't '$particular->{defaultaction}' 'allow' or 'deny'?\n";
	#} # end if

	my($fd, $sd) = (0, 0);
	if($particular->{perms}->{$action} eq 'all') {
		# Okay, everyone has permission, and as we know this
		# user doesn't have an explicit deny, bump up the return value
		# in either case
		$fd = $sd = 1;
	} elsif($particular->{perms}->{$action} eq 'restrict') {
		# In case of restrict:
		# If ADB, allow if he's *NOT* in the list
		# If not ABD, allow only if he's in the list

		# Note: Only group lists (authlists->action->l) are implemented
		if($abd) {
			$fd = 0; $sd = 1;
		} else {
			$fd = 1; $sd = 0;
		}
	} elsif($particular->{perms}->{$action} eq 'none') {
		# none == NONE
		$fd = 0; $sd = 0;
	} else {
		$fd = 0; $sd = 0;
	} # end if

	if((&_is_in($self->{PRIMARY_GROUP}, $particular->{authlists}->{$action}->{l}))
	    || (&_is_in($self->{USERNUM}, $particular->{authlists}->{$action}->{u}))) {
		$retval += $fd;
	} else {
		$retval += $sd;
	} # end if

	return $retval;
} # end has_permission

2;    # Defy convention.
# $Id: ubb_lib_secgroups.cgi,v 1.8 2002/04/24 21:30:44 cvscapps Exp $