# UBB library for post related functions

sub FixSubjectEncoding {
	my $item = shift;
	$item =~ s/&/&amp\;/gi;                #no ampersand codes
	$item =~ s/"/&quot\;/gi;               #no quotes
	$item =~ s/\|/&#0124\;/gi;             #no pipes
	$item =~ s/&amp\;(#\d+)\;/&$1\;/gi;    #fix b0rked &# codes
	if($vars_misc{EnglishSubjectCheck} ne "OFF") {
		my $item2 = UBBCGI::unescapeHTML(UBBCGI::unescape($item));
		$item2 =~ s/[\x00-\x20\s\n\r]*//g;
		if($item2 eq '') {
			&StandardHTML($vars_wordlets_err{subject_deficient});
		} # end if
	} # end if
	return $item;
}


sub CheckCoding {
	my ($html_allowed, $ubb_allowed, $is_ubb, $is_html, $ubb_images_wording);
	# required parameters
	# $_[0] : html is/is not permitted
	# $_[1] : ubb code is/is not permitted
	# $_[2] : ubb code images ON/OFF

	if ($_[0] eq 'is') {
		$is_html      = $vars_wordlets{html_is_on};
		$html_allowed = 'yes';
	} else {
		$is_html      = $vars_wordlets{html_is_off};
		$html_allowed = 'no';
	}

	if ($_[1] eq 'is') {
		$is_ubb      = $vars_wordlets{ubbcode_is_on};
		$ubb_allowed = 'yes';
	} else {
		$is_ubb      = $vars_wordlets{ubbcode_is_off};
		$ubb_allowed = 'no';
	}

	if (($_[2] eq 'OFF') && ($_[1] eq 'is')) {
		$ubb_images_wording = $vars_wordlets{ubbcode_images_banned};
	} else {
		$ubb_images_wording = '';
	}

	return($html_allowed, $ubb_allowed, $is_ubb, $is_html, $ubb_images_wording);
}    # end checkcoding

sub floodcheck {
	# floodcheck written by Michael Farris!

	if($user_number) {
		if((&OpenProfile($user_number))[8] =~ m/(Administrator|Moderator)/) {
			return;
		} # end if
	} # end if

	my $lastpost_list_length = 80;

	my $IPNumber       = &GetIPAddress;    # the IP address
	my $this_post_time = time();           # secs since 1970

	# don't bother with error code if it doesn't exist
	my @last_post_list = &OpenFileAsArray("$vars_config{NonCGIPath}/BanLists/Floodcheck.cgi");

	my ($j, $last_post_time);

	foreach (@last_post_list) {                  # check if this user has posted already
		if (/^$IPNumber/) {
			($j, $last_post_time) = split (/\|!!\|/, $_);
			chomp($last_post_time);
			last;
		}
	}    # end foreach

	# $FloodCheckSpan (in seconds) is set in General Settings

	if (int(($this_post_time - $last_post_time) < $vars_misc{FloodCheckSpan})) {

		if ($in{ubb} eq 'submit_registration') {

			#print qq%Content-type: text/html\n\n%;
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			);

		}

		&StandardHTML(&Template($vars_wordlets_err{flood_check}, {TIME => $vars_misc{FloodCheckSpan}}));
	} else {    # add the IP and posting time to the list
		if (unshift (@last_post_list, "$IPNumber|!!|$this_post_time\n") > $lastpost_list_length) {
			$#last_post_list = $lastpost_list_length;    # limit length of list
		}
		chmod(SIXSIXSIX, "$vars_config{NonCGIPath}/BanLists/Floodcheck.cgi");

		&WriteFileAsArray("$vars_config{NonCGIPath}/BanLists/Floodcheck.cgi", @last_post_list);

	}    #  end else

}    # end SR


sub update_forum_summary {
	# two parameters must be passed:
	my $number     = $_[0];
	my $thread_num = $_[1];
	my $subject    = $_[2];

	undef(%forum_topics);

	# grab current threads file
	if ($number ne '') {
		my $this_forum_topics = &GetForumTopics($number);
		%forum_topics = %$this_forum_topics;
	}

	# now we have the current %forum_topics hash
	my @forum_info = &GetForumRecord($number);

	if ($forum_info[15] eq 'abc') {

		my $lc_subject = lc($subject);
		$lc_subject =~ s/"/\&quot\;/g;
		$lc_subject =~ s/\|/&#0124;/sg;
		$lc_subject = &EliminateReturns($lc_subject);
		if ($lc_subject =~ /\\$/) { $lc_subject .= ' '; }
		$forum_topics{$thread_num} = "$lc_subject";

	} else {
		# parse topic date
		$forum_topics{$thread_num} = &ConvertPostTimetoJulian($GotTime{HyphenDate}, $GotTime{Time});

	}    # if/else alphabetical storage

	&UpdateForumTopics($number, \%forum_topics);

}    # end update_forum_summary



sub update_forum_summary_for_topic_move {
	# four parameters must be passed:
	my $number     = $_[0];
	my $thread_num = $_[1];
	my $subject    = $_[2];
	my $julian     = $_[3];

	undef(%forum_topics);

	# grab current threads file
	if ($number ne '') {

		my $this_forum_topics = &GetForumTopics($number);
		%forum_topics = %$this_forum_topics;

	}

	# now we have the current %forum_topics hash

	my @forum_info = &GetForumRecord($number);

	if ($forum_info[15] eq 'abc') {

		my $lc_subject = lc($subject);
		$lc_subject =~ s/"/\&quot\;/g;
		$lc_subject =~ s/\|/&#0124;/sg;
		$lc_subject = &EliminateReturns($lc_subject);
		if ($lc_subject =~ /\\$/) { $lc_subject .= ' '; }
		$forum_topics{$thread_num} = "$lc_subject";

	} else {

		$forum_topics{$thread_num} = $julian;	# :)

	}    # if/else alphabetical storage

	&UpdateForumTopics($number, \%forum_topics);

}    # end update_forum_summary_for_topic_move


sub unlink_topic_from_forum_summary {
	local (%forum_topics);

	# two parameters must be passed:
	my $number     = $_[0];
	my $thread_num = $_[1];

	undef(%forum_topics);

	my $this_forum_topics = &GetForumTopics($number);
	%forum_topics = %$this_forum_topics;

	delete $forum_topics{$thread_num};

	my @array = &GetThreadData($number, $thread_num);    #make sure it's loaded
	$thread_num =~ m/^(\d{4})(\d{2})$/;
	my ($lefty, $righty) = ($1, $2);

	delete $forum_thread_data{$number}->{$lefty}->{$righty};

	&UpdateForumTopics($number,   \%forum_topics);
	&WriteForumThreadData($number, $lefty);

}    # end unlink_topic_from_forum_summary



sub nice_unlink_topic_from_forum_summary {
	# like its big brother, only doesn't write the changes out

	# two parameters must be passed:
	my $number     = $_[0];
	my $thread_num = $_[1];

	delete $forum_topics{$thread_num};

	&SafeGetThreadData2($number, $thread_num);    #make sure it's loaded
	$thread_num =~ m/^(\d{4})(\d{2})$/;
	my ($lefty, $righty) = ($1, $2);
	delete $forum_thread_data{$number}->{$lefty}->{$righty};

	&SetExactPath($number);

	&UpdateForumTopics($number, \%forum_topics, 1);    # ,1 == don't write the file, just update the hash
	#&WriteForumThreadData($lefty, "$vars_config{NonCGIPath}/$exact_path");

}    # end unlink_topic_from_forum_summary



sub create_icon_field {
	# one parameter
	# $_[0] : $icon_selection

	if ($_[0] eq '') { $_[0] = '1'; }

	# Find only icon# files, GIF, JPEG, or PNG
	opendir(DIRECTORY, "$vars_config{NonCGIPath}/icons");
	my @icons = grep(/^icon\d+\.(gif|jpg|jpeg|png)$/, readdir(DIRECTORY));
	closedir(DIRECTORY);

	# Now seperate the number from the name...
	my %the_icons;
	foreach my $one (@icons) {
		if($one =~ m/^icon(\d+)\.(gif|jpg|jpeg|png)$/) {
			$the_icons{$1} = $one;
		} # end if
	} # end foreach

	# Sort the numbers properly...
	my @sort_icons = sort { $a <=> $b }  keys %the_icons;

	my $count = 0;
	my $icon_list;

	# And then put together the list in the right order
	foreach $inumber (@sort_icons) {
		$count++;
		my $check_this = "";
		if ($inumber == $_[0]) {
			$check_this = 'checked="checked"';
		} # end if

		$icon_list .= qq(<input type="radio" name="msg_icon" value="$inumber" $check_this />
<img src="$vars_config{NonCGIURL}/icons/$the_icons{$inumber}" align="middle" alt="$vars_wordlets_img{alt_icon} $inumber" />&nbsp;&nbsp;&nbsp;&nbsp;);

		if ($count == 7) {
			$icon_list .= '<br />'; $count = 0;
		} # end if
	} # end foreach

	return ($icon_list);
} # end sub


sub prep_for_edit {

	my $message = shift;
	my $ubbcode = shift;
	my $images = shift;

	$ubbcode ||= "is";
	$images ||= "ON";

	# requires three parameters:
	# $message : the text to prep
	# $_[0] : ubbcode setting for forum (is/is not)
	# $_[1] : ubbcode IMG permission setting for forum (ON/OFF)

	$message =~ s/<p>/\n\r\n/isg;
	$message =~ s/<br>/\n/isg;
	$message =~ s/<br \/>/\n/isg;
	$message =~ s/<\/p>//gi;

	if (!exists $vars_graemlins->{'graems'}) {
		&RequireVars("$vars_config{VariablesPath}/vars_graemlins.cgi");
	}

	foreach my $item (sort keys %{$vars_graemlins->{'graems'}}) {
		my $short = %$vars_graemlins->{'graems'}->{$item};
		# old format
		$message =~ s/ ?<img src="graemlins\/$short->{'image'}" border="0" alt="\[[^\"\[\]]+\]" \/> ?/ :$short->{'trigger'}: /gi;
		# new format
		$message =~ s/ ?<img border="0" alt="\[[^\"\[\]]+\]" title="" src="graemlins\/$short->{'image'}" \/> ?/ :$short->{'trigger'}: /gi;
	}    #endforeach

	foreach my $item (sort keys %{$vars_graemlins->{'origs'}}) {
		my $short = %$vars_graemlins->{'origs'}->{$item};
		# old format
		$message =~ s/ ?<img src="$short->{'image'}" border="0" alt=" - " \/> ?/ $short->{'trigger'} /gi;
		# older format
		$message =~ s/ ?<img src="$short->{'image'}" border="0"> ?/ $short->{'trigger'} /gi;
		# new format
		$message =~ s/ ?<img border="0" title="[^\"\[\]]*\" alt="\[[^\"\[\]]+\]" src="$short->{'image'}" \/> ?/ $short->{'trigger'} /gi;
	}    #endforeach

	if ($ubbcode eq 'is') {

		#convert UBB Code
		$message = &reverse_ubb_code($message, $images);
	}
	$message = &FixCodeTagForEdit($message);

	$message =~ s/(\<small\>)?\[ [^\]\[]+: $vars_wordlets{edit_wording} [^\]\[]+ \](\<\/small\>)?$//gi;

	$message = &strip_lead_trail_whitespace($message);

	return ($message);
}


sub reverse_ubb_code {

	# two parameters:
	# $_[0] : the text to convert
	# $_[1] : ubbcode [IMG] enabled? (ON/OFF)

	my $match = 1;

	# Kludge the second
	while($match != 0) {
		$match = 0;

		# new URL
		$match++ if $_[0] =~ s/(<a href=")(http|https|ftp)(:\/\/)(\S+)(" target="_blank">)(.+?)(<\/a>)/\[URL=$2:\/\/$4\]$6\[\/URL\]/isg;
		# old URL
		$match++ if $_[0] =~ s/(<A HREF=")(http|https|ftp)(:\/\/)(\S+)(" TARGET=_blank>)(.+?)(<\/A>)/\[URL=$2:\/\/$4\]$6\[\/URL\]/isg;

		$match++ if $_[0] =~ s/(<a href="mailto:)(\S+)(">)(\S+)(<\/a>)/\[EMAIL\]$2\[\/EMAIL\]/isg;

		$match++ if $_[0] =~ s/(<i>)(.+?)(<\/i>)/\[i\]$2\[\/i\]/isg;
		$match++ if $_[0] =~ s/(<b>)(.+?)(<\/b>)/\[b\]$2\[\/b\]/isg;
		$match++ if $_[0] =~ s/(<strong>)(.+?)(<\/strong>)/\[qb\]$2\[\/qb\]/isg;

		# new quote/code
		$match++ if $_[0] =~ s/(<\/font><blockquote><font size="1" face="[^\"]*?">$vars_wordlets{ubbcode_code}:<\/font><hr \/><pre style="[^\"]*?">)(.+?)(<\/pre><HR \/><\/BLOCKQUOTE><font size="[^\"]*?" face="[^\"]*?">)/\[CODE\]$2\[\/CODE\]/isg;
		$match++ if $_[0] =~ s/(<\/font><blockquote><font size="1" face="[^\"]*?">$vars_wordlets{ubbcode_quote}:<\/font><hr \/><font size="[^\"]*?" face="[^\"]*?">)(.+?)(<\/font><hr \/><\/blockquote><font size="[^\"]*?" face="[^\"]*?">)/\[QUOTE\]$2\[\/QUOTE\]/isg;
		# old quote/code
		$match++ if $_[0] =~ s/(<BLOCKQUOTE><font size="1" face="[^\"]*?">$vars_wordlets{ubbcode_code}:<\/font><HR><pre>?)(.+?)(<\/pre><HR><\/BLOCKQUOTE>)/\[CODE\]$2\[\/CODE\]/isg;
		$match++ if $_[0] =~ s/(<BLOCKQUOTE><font size="1" face="[^\"]*?">$vars_wordlets{ubbcode_quote}:<\/font><HR>?)(.+?)(<HR><\/BLOCKQUOTE>)/\[QUOTE\]$2\[\/QUOTE\]/isg;

		if ($_[1] ne "OFF") {
			# New
			$match++ if $_[0] =~ s/(<img src=")(\S+)(" alt="" \/>)/\[IMG\]$2\[\/IMG\]/isg;
			# New + alt
			$match++ if $_[0] =~ s/(<img src=")(\S+)(" alt=" - " \/>)/\[IMG\]$2\[\/IMG\]/isg;
			# old
			$match++ if $_[0] =~ s/(<img src=")(\S+)(">)/\[IMG\]$2\[\/IMG\]/isg;
		}

		# new lists
		$match++ if $_[0] =~ s/(<\/font><ul type="square">)(.+?)(<\/ul><font size=".*?" face=".*?">)/\[list\]$2\[\/list\]/isg;
		$match++ if $_[0] =~ s/(<\/font><ol type=")(A|1)(">)(.+?)(<\/ol><font size=".*?" face=".*?">)/\[list=$2\]$4\[\/list\]/isg;
		# old lists
		$match++ if $_[0] =~ s/(<UL TYPE="SQUARE">)(.+?)(<\/UL>)/\[list\]$2\[\/list\]/isg;
		$match++ if $_[0] =~ s/(<OL TYPE=")(A|1)(">)(.+?)(<\/OL>)/\[list=$2\]$4\[\/list\]/isg;
		$match++ if $_[0] =~ s/(<ul type=square>)(.+?)(<\/ul>)/\[list\]$2\[\/list\]/isg;

		# newer li
		$match++ if $_[0] =~ s/(<li><font size=".*?" face=".*?">)(.+?)(<\/font><\/li>)/\[\*\]$2/isg;
		# new li
		$match++ if $_[0] =~ s/(<li>)(.+?)(<\/li>)/\[\*\]$2/isg;
		# old li
		$match++ if $_[0] =~ s/<LI>/\[\*\]/isg;
	} # end while

	return ($_[0]);
}    #end EditUBBConvert


sub build_topic_review {
	my $go_to = pop;
	my @sort_topic  = sort(@_);
	my $total_posts = @sort_topic - 1;

	my $cutoff = ($vars_display{HTMLDisplayMax} > 26 ? $vars_display{HTMLDisplayMax} : 26 );

	my $summary;

	if (($total_posts > $cutoff) || ($post_permiss =~ m/private/)) {
		$summary = qq(<font size="$vars_style{TextSize}" color="$vars_style{TableStripTextColor}" face="$vars_style{FontFace}"><a href="$go_to" target="_blank"> $vars_wordlets{topic_review_link}</a></font>);
	} else {
		$summary = qq~
$TBT
<tr bgcolor="$vars_style{TableColorStrip}">
<td colspan="2" align="left">
<font size="$vars_style{TextSize}" color="$vars_style{TableStripTextColor}" face="$vars_style{FontFace}">
<b>$vars_wordlets{topic_review}</b>
</font></td></tr>
~;

		my $alt_color2 = "$vars_style{AltColumnColor2}";

		foreach my $row (@sort_topic) {
			if ($alt_color2 eq "$vars_style{AltColumnColor1}") {
				$alt_color2 = "$vars_style{AltColumnColor2}";
			} else {
				$alt_color2 = "$vars_style{AltColumnColor1}";
			}

			if ($row =~ /^Z/) {
				my @posted = split (/\|\|/, $row);

				my($listed_name, $member_number, $this_user_number);

				if (($posted[8] eq 'unreg') or ($posted[8] eq '')) {
					$listed_name = $posted[2];
				} else {
					my(@user_profile);
					if($posted[10] eq '') {
						# old post- we need to find user number
						if($posted[11] =~ m/^\d{8}$/) {
							$this_user_number = $posted[11];
						} else {
							$this_user_number = &GetUserNumber($posted[2]);
						} # end if

						if ((&FileExists("$vars_config{MembersPath}/$this_user_number.cgi")) && ($this_user_number ne '')) {
							@user_profile = &OpenProfile($this_user_number);
						} else {
							$user_profile[0] = $posted[2];
						}

					} else {
						$user_profile[0] = $posted[10];
						$this_user_number = $posted[11];
					} # end if

					$listed_name = ($user_profile[15] ne '' ? $user_profile[15] : $user_profile[0] )
				} # end if

				if($this_user_number =~ m/^\d{8}$/) {
					my $u = $this_user_number + 0;
					$member_number = "<br /><small>$vars_wordlets{user_number_abbrev} $u</small>";
				} # end if

				my $timedate = join(" ", &DateFormat2(@posted[3,4]));
				my $this_icon = qq(<img src="$vars_config{NonCGIURL}/posticon.gif" border="0" alt=" - " />);
				$summary .= qq~
<tr bgcolor="$alt_color2">
<td valign="top" width="18%">
<font size="$vars_style{TextSize}" face="$vars_style{FontFace}">
<b>$listed_name</b>
$member_number
</font></td>
<td width="82%">
<font size="1" face="$vars_style{FontFace}">
$this_icon $vars_wordlets{posted} $timedate<hr />
</font>
<font size="$vars_style{TextSize}" face="$vars_style{FontFace}">
$posted[6]
<br />&nbsp;
</font>
</td></tr>
~;
			}

		}
		$summary .= "$TBB <br /> <br /> ";
	}
	return ($summary);

}

sub grab_last_numbers {
	my (@info);
	if (&FileExists("$vars_config{NonCGIPath}/$exact_path/lastnumber.file")) {
		@info = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
	} else {
		@info = ("0", "0", "0");
	}

	return (@info);
}    # end grab_last_numbers sr

sub append_index {
	local ($getkey, $index_file, $shrunk, $index_line, %daily_date_time);

	# sr parameters
	# $_[0] : forum number
	# $_[1] : topic number
	# $_[2] : forum permissions (check to see if private)
	# $_[3] : post number

	# only index if search is ON
	unless ($vars_search{AllowSearch} eq 'FALSE') {

		# index file to update will depend on index method...
		if ($vars_search{IndexMethod} eq 'ONEFILE') {
			$index_file = "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/forumindex.cgi";
		} else {
			$index_file = "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/forumindex$_[0].cgi";
		}

		# clean fields
		$shrunk = &indexify($message);
		$in{topic_subject} =~ s/\|/&#0124;/sg;

		# assemble index line
		$index_line = join("|", $_[0], $_[1], $_[3], $GotTime{HyphenDate}, $in{topic_subject}, $shrunk);

		# append index file
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/search_index", SEVENSEVENSEVEN); #jic
		&AppendFileAsString($index_file, "$index_line\n");
	}    # if search is activated


	# update daily index
	unless ($_[2] =~ m/private/) {

		# delete old daily indices
		&clean_dailies;

		undef(%daily_date_time);

		if (-s "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/daily_index-$GotTime{LastLoginJulianDATE}-main.cgi") {

			# whoops, there's another!
			eval { require "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/daily_index-$GotTime{LastLoginJulianDATE}-main.cgi"; };

			if ($@) {
				&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/daily_index-$GotTime{LastLoginJulianDATE}-main.cgi");
				undef(%daily_date_time);
			}

		}

		# print to daily file
		my $f = sprintf("%.4d", $_[0]);
		my $daily_key = ("$f" . "a" . "$_[1]");

		# set hash values
		$daily_date_time{$daily_key} = "$GotTime{LastLoginJulian}";

		unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/search_index")) {
			mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/search_index", SEVENSEVENSEVEN);
			chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index");
		}

		&WriteHashToFile("$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/daily_index-$GotTime{LastLoginJulianDATE}-main.cgi", "daily_date_time", \%daily_date_time);

		# unlink file from cache
		if (($vars_misc{use_cache} ne 'no') && (&FileExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_daily_topics.cgi"))) {
			&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_daily_topics.cgi");
		}

	}    # end update daily index

}    # end append_index

sub indexify {
	my $val = shift;
	my $notruncate = shift;

	$val =~ s/\[.+?\]//isg;	# UBBCode
	$val =~ s/------------------(.*?)$//isg;	# UBB5 sigs
	$val =~ s/<.+?>//sg;	# HTML
	$val =~ s/\|/&#0124;/sg;	# pipes
	$val =~ s/(\||\?|\!|\^|\"|\-\-)//sg;	# partial puncuation

	$vars_search{removelist} ||= $vars_search{removelist_stock};
	foreach my $word (split(/\|/, $vars_search{removelist})) {
		$val =~ s/\b$word\b//isg;
	} # end foreach

	$val =~ s/\s//sg;	# spaces

	$vars_search{truncateat} ||= 210;
	$val = substr($val, 0, $vars_search{truncateat}) unless $notruncate;

	return $val;
} # end indexify


sub clean_dailies {    # Thanks Graeme for this cleanup code
	opendir(DIRECTORY, "$vars_config{NonCGIPath}/cache-$cache_cookie/search_index");
	my @dailies = grep(/^daily_index\-.*/, readdir(DIRECTORY));
	closedir(DIRECTORY);

	foreach $dfile (@dailies) {
		my ($j, $dfiledate) = split (/\-/, $dfile);
		($dfiledate, $j)    = split (/\-/, $dfiledate);
		if ($dfiledate < $GotTime{LastLoginJulianDATE}) {
			&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/search_index/$dfile");
		}
	}
}    # END SR

sub promo {
	$_[0] =~ s/\<[^\>\<]+\>//sg;
	$_[0] = &strip_lead_trail_space($_[0]);
	return &GoodNiceTruncate($_[0], 200);
}    # end promo

sub excess_smilies_check {
	my $max_smilies  = 8;
	my $smilie_count = 0;
	while ($_[0] =~ m/\<IMG.+?SRC/gsi) { $smilie_count++; }
	if ($smilie_count > $max_smilies) { &StandardHTML("$vars_wordlets_err{excess_images}"); }
}    # end smilie check


sub preview_post {

	if($in{pm} ne "true") {
		$in{f} =~ m/^\d+$/ or &StandardHTML($vars_wordlets_err{choose_a_forum});

		my @this_forum = &GetForumRecord($in{f});
		unless(@this_forum) {
			&StandardHTML("$vars_wordlets_err{no_such_forum}");
		} # end unless

		my($topic_permiss, $reply_permiss);
		if($this_forum[6] =~ m/&/) {
			($topic_permiss, $reply_permiss) = split(/&/, $this_forum[6]);
		} else {
			($topic_permiss, $reply_permiss) = ($this_forum[6], $this_forum[6]);
		} # end if

		my $this;
		if($in{type} eq "topic" ) { $this = $topic_permiss; }
		elsif($in{type} eq "reply") { $this = $reply_permiss; }
		else { $this = $reply_permiss; } # no seperate edit permission per forum...

		if ($this =~ m/(private|restrict)/) {
			&check_private_access($in{f}, $this_forum[12]);
		} # end if

		if (($post_permiss =~ m/private/) && ($this_forum[3] ne 'On')) {
			&StandardHTML("$vars_wordlets_err{private_forum_off}");
		} # end if
	} # end if

	&LoadTemplate("public_post_preview");
	&just_do_it;
	exit;

} # end preview_post



sub cook_post {
	my($message, $forum, $disable_smilies) = @_;
	my @this_forum = &GetForumRecord($forum);

	my @codes;
	($message, @codes) = &UndoCodeTag($message);

	if ($this_forum[4] eq 'is not') {
		$message =~ s/</&lt;/g; $message =~ s/>/&gt;/g;
	} # end if

	$message = &Truncate(&CensorCheck($message));

	$disable_smilies = "no" unless $disable_smilies;
	if ($disable_smilies ne "yes") {
		$message = &Smilies($message);
	}
	if ($this_forum[5] eq 'is') {
		$message = &UBBCode($message, $this_forum[10]);
	}    #end if UBB Code allowed

	&check_html($message);

	$message = &PipeCleaner(&ConvertReturns(&LimitReturns($message)));

	&excess_smilies_check($message);

	$message = &RedoCodeTag($message, $this_forum[5], @codes);

	return $message;
} # end cook_post


sub UndoCodeTag {
	my $message = shift;

	my @codebits;
	my $trash;

	$message =~ s/\[eDoC\]/\[EDOC\]/sg; # silly people

	while($message =~ s/(\[CODE\].*?\[\/CODE\])/\[eDoC\]/is) {
		my $this = $1;
	    	push(@codebits, &ConvertReturns(&UBBCGI::escapeHTML($this)));
	} # end while

	return($message, @codebits);
} # end UndoCodeTag

sub FixCodeTagForEdit {
	my $message = shift;

	my @codebits;
	my $trash;

	$message =~ s/\[eDoC\]/\[EDOC\]/sg; # silly people

	while($message =~ s/(\[CODE\].*?\[\/CODE\])/\[eDoC\]/is) {
		my $this = $1;
	    	push(@codebits, &UBBCGI::unescapeHTML($this));
	} # end while

	while($message =~ s/\[eDoC\]/$codebits[0]/s) {
	    	$trash = shift @codebits;
	} # end while

	return($message);
}

sub RedoCodeTag {
	my($message, $no_code, @codes) = @_;

	my $trash;
	while($message =~ s/\[eDoC\]/$codes[0]/s) {
	    	$trash = shift @codes;
	} # end while

	if($no_code eq "is") {
		my $match = 1;
		while($match > 0) {
			$match = 0;
			$match++ if $message =~ s!(\[code\])(.+?)(\[/code\])(\s|\n|\r|\<br \/\>)*!&ProcessCodeTag($2)!eisg;
		} # end if
	} #end if nocode

	return $message;
} # end RedoCodeTag

sub ProcessCodeTag {
	my $message = shift;
	$message =~ s!^(\<br \/\>)+!!gi;
	$message =~ s!(\<br \/\>)+$!!gi;
	$message =~ s/\|\|/\&\#0124\;\&\#0124\;/g;
	return qq~<\/font><blockquote><font size="1" face="$vars_style{FontFace}">$vars_wordlets{ubbcode_code}:<\/font><hr \/><pre style="font-size:x-small; font-family: monospace;">$message</pre><hr \/><\/blockquote><font size="$vars_style{TextSize}" face="$vars_style{FontFace}">~;
} # end ProcessCodeTag

sub create_topic {
	# you are entering the most complicated (and important) subroutine in the UBB... beware!

	# local must die, and I shall be the one to slay it...
	local ($poll_link, $forum_number, $topic_number, $array_start,
		$page_number, @topic_file, @stat_line, @ordered_topic, $j,
		$ThisPage, $TopicPageTotal, $PostTotal, $PageName, $whole,
		@postinfo, $MaxPoint, $ContinueAt, $NextPage, $TotalPages,
		$close_transfer_wording, $ubb_friend_on, $close_option,
		$reply_button, $move_option, $delete_option, $reply_restrict,
		$topic_restrict, $reply_wording, $topic_wording, $category,
		$cat_name, $line, @thisline, $un_coded, $public_name,
		$this_user_name, $hyphen_date, $ip_number, $ip_wording, $is_reg,
		@datearray, @timearray, $year_check, $year, $ThisDate, $get_hour,
		$get_minute, $FormatTime, $post_body, $edit_link, @user_profile,
		$this_user_number, $user_status, @themonths, $RegDate, $RegMon,
		$RegDay, $RegYear, $AuthorExtra, $profile_link, $email_link,
		$icon_number, $this_icon, $direct_reply, $alt_color,
		$hop_to_options, $page_name, $show_public_name, $ip_divider,
		$cat_line1, $cat_line2, $user_rating, $user_type, %Rater, %User,
		%votes, %total, %avg, %weighted_avg, $homepage_link, @author_extra,
		$location_line, $regdate_line, $post_total_line, @blank, $u,
		$member_number, $allow_images, $overall_rating, $stars,
		$rating_line, $total_votes, $pm_link, %rate_list, $Avatar);


	# args:
	$forum_number = $_[0];
	$topic_number = $_[1];
	$array_start  = $_[2];
	$page_number  = $_[3];

	# for registration date...
	@themonths = ('', "$vars_wordlets_date{month_1_abbrev}",
	"$vars_wordlets_date{month_2_abbrev}",
	"$vars_wordlets_date{month_3_abbrev}",
	"$vars_wordlets_date{month_4_abbrev}",
	"$vars_wordlets_date{month_5_abbrev}",
	"$vars_wordlets_date{month_6_abbrev}",
	"$vars_wordlets_date{month_7_abbrev}",
	"$vars_wordlets_date{month_8_abbrev}",
	"$vars_wordlets_date{month_9_abbrev}",
	"$vars_wordlets_date{month_10_abbrev}",
	"$vars_wordlets_date{month_11_abbrev}",
	"$vars_wordlets_date{month_12_abbrev}");

	# used for mod check later:
	my $Moderator = ("Forum" . "$forum_number" . "Moderator");
	$Moderator = $$Moderator;

	# create hop-to list
	if (!$hop_to_options) {
		$in{f} = $forum_number;    # need this for hop to sr
		$hop_to_options = &hop_to_list;
	}

	#get topic file
	@topic_file = &OpenTopic("$topic_number", "$forum_number");
	my $topic_file_end = $#topic_file;

	# get forum stat line
	@stat_line = split (/\|\|/, $topic_file[0]);

	# remove statline from topic_file array
	@topic_file = @topic_file[1 .. $topic_file_end];

	#reverse topics?
	if ($vars_display{ReverseThreads} eq 'TRUE') {
		@ordered_topic = reverse(@topic_file);
	} else {
		@ordered_topic = @topic_file;
	}    # end if/else reverse threads option

	undef($ThisPage);
	undef($TopicPageTotal);
	undef($PostTotal);
	undef($PageName);


	#adjust for max post per page, if necessary
	if (($vars_display{HTMLDisplayMax} ne '') && ($vars_display{HTMLDisplayMax} ne 'NONE')) {

		$PostTotal = @ordered_topic;

		if ($PostTotal > $vars_display{HTMLDisplayMax}) {

			$TotalPages = int($PostTotal / $vars_display{HTMLDisplayMax});
			if ($PostTotal % $vars_display{HTMLDisplayMax}) { $TotalPages++; }
			my $thispage = $in{p} || 1;

			$TopicPageTotal = &Template($vars_wordlets{topic_total_pages}, {NUMBER => $TotalPages});


			if($vars_display{'PaginationType'}) {	# new style
				my @pages = &paginate($TotalPages, $thispage);
				foreach my $pa (@pages) {
					my($name, $num) = each(%{$pa});
					if($num == $thispage) {
						$TopicPageTotal .= qq(&nbsp;$name&nbsp;);
					} else {
						$TopicPageTotal .= qq(&nbsp;<a href="$ULTIMATEBB?ubb=get_topic;f=$in{f};t=$topic_number;p=$num">$name</a>&nbsp;)
					} # end if
				} # end foreach
			} else { # old style
				foreach (1 .. $TotalPages) {
					if ($_ == 1) {
						$PageName = '';
					} else {
						$PageName = "$_";
					}

					if ($page_number == $_) {
						$TopicPageTotal .= qq(&nbsp;$_&nbsp;);
					} else {
						$TopicPageTotal .= qq(&nbsp;<a href="$ULTIMATEBB?ubb=get_topic;f=$in{f};t=$topic_number;p=$PageName">$_</a>&nbsp;)

					}
				}    # foreach page...
			} # end if

			$ThisPage = "($vars_wordlets{page} $page_number)";

			# limit ordered_topic based on page limitations
			$MaxPoint = ($array_start + $vars_display{HTMLDisplayMax}) - 1;
			if ($MaxPoint >= $#ordered_topic) {
				$MaxPoint   = $#ordered_topic;
				@postinfo   = @ordered_topic[$array_start ... $MaxPoint];
				$ContinueAt = '';
			} else {
				@postinfo   = @ordered_topic[$array_start ... $MaxPoint];
				$ContinueAt = $MaxPoint + 1;
				$NextPage   = $page_number + 1;
			}

		} else {
			@postinfo   = @ordered_topic[0 ... $#ordered_topic];
			$ContinueAt = '';
			$TotalPages = 1;
		}

	} else {
		@postinfo   = @ordered_topic[0 ... $#ordered_topic];
		$ContinueAt = '';
		$TotalPages = 1;
	}    #end if HTML max display

	if ($TotalPages == 1) { $ThisPage = ""; $TopicPageTotal = ""; }

	# UBB Friend?
	if (($vars_email{UseEmail} eq 'ON') && ($this_forum[6] !~ m/private/) && ($vars_email{UBBFriendUSE} ne 'OFF')) {

		$ubb_friend_on = qq(<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=send_topic;t=$topic_number;f=$forum_number"><img src="$vars_config{NonCGIURL}/$vars_style{ubb_friend_mini}" border="0" alt=" - " /></a> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=send_topic;t=$topic_number;f=$forum_number">$vars_wordlets{ubb_friend}</a>);

	} else {

		$ubb_friend_on = '';

	}

	# set topic title
	$title_wording = $stat_line[4];
	&set_page_elements;

	# is topic closed?
	if ($stat_line[1] =~ m/X/) {

		$vars_style{plain_old_regular_lock} =
			($vars_style{plain_old_regular_lock} ne '' ? $vars_style{plain_old_regular_lock} : "lock.gif");

		$topic_closed = qq($vars_config{'jc'}->{'topic_closed'}<font size="1"><img src="$vars_config{NonCGIURL}/$vars_style{plain_old_regular_lock}" border="0" alt="$vars_wordlets{topic_closed}" />&nbsp;&nbsp;$vars_wordlets{topic_closed}</font>);

		if (($stat_line[7]) && ($stat_line[1] =~ m/X/)) {
			$close_transfer_wording = qq(<br /><b>$stat_line[7]</b>);
			$ubb_friend_on          = '';
		} else {
			$close_transfer_wording = "";
		}

		$close_option = qq(<a  href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=open_topic;t=$topic_number;f=$forum_number"><img src="$vars_config{NonCGIURL}/$vars_style{open_topic}" border="0" alt="$vars_wordlets{open_topic}" /></a>);

		$reply_button = $topic_closed;

	} else {

		$topic_closed           = '';
		$close_transfer_wording = '';

		$close_option = qq(<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=close_topic;t=$topic_number;f=$forum_number"><img src="$vars_config{NonCGIURL}/$vars_style{close_topic}" border="0" alt="$vars_wordlets{close_topic}" /></a>);

		$reply_button = qq(<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=reply;f=$forum_number;t=$topic_number"><img src="$vars_config{NonCGIURL}/$vars_style{BBReply}" border="0" alt="$vars_wordlets{post_reply}" /></a>);

	}

	$move_option = qq(<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=transfer;t=$topic_number;f=$forum_number"><img src="$vars_config{NonCGIURL}/$vars_style{move_topic}" border="0" alt="$vars_wordlets{move_topic}" /></a>);

	$delete_option = qq(<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=delete_topic;f=$forum_number;t=$topic_number"><img src="$vars_config{NonCGIURL}/$vars_style{delete_topic}" border="0" alt="$vars_wordlets{delete_topic}" /></a>);

	# recreate directory, if necessary
	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path");
	}

	if($this_forum[17] =~ m/^\d+$/) {
		my $num = $1;
		my $g = $vars_groups->_get_raw_group("pollgroup_$num");
		if(($g->{perms}->{create} ne "none") && ($vars_poll{Enabled} ne "off")) {
			$poll_link = qq!&nbsp;<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=poll;d=create;f=$in{f}"><img src="$vars_config{NonCGIURL}/$vars_style{BBPoll}" alt="$vars_wordlets_poll{new_poll}" border="0" /></a>&nbsp;!;
		} # end if
	} # end if polling field

	# get posting permissions
	if (!$reply_restrict) {

		if ($this_forum[6] =~ m/private/) {
			$reply_restrict = 'ok';
			$topic_restrict = 'ok';
		} else {
			($topic_restrict, $reply_restrict) = split (/&/, $this_forum[6]);
		}

		unless ($reply_restrict eq 'none') { $reply_wording = $reply_button; }

		unless ($topic_restrict eq 'none') {
			$topic_wording = qq(<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=newtopic;f=$forum_number"><img src="$vars_config{NonCGIURL}/$vars_style{BBTopic}" alt="$vars_wordlets{post_new_topic}" border="0" /></a>);
		}

	}    # end check for posting perms


	if ($vars_display{CategoryView} eq 'yes') {

		if (!$category) {
			$category = $this_forum[0];
			$cat_name = &GetCatName($category);
		}

		$cat_line1 = qq!
&nbsp;
&#187;  <a href="$ULTIMATEBB?category=$category">
<b>$cat_name</b></a>
!;
	} else {
		$cat_line1 = '';
	}

	# now we have $cat_line1 for breadcrumb

	&LoadTemplate("public_topic_page");

	$ThisHTML = $Header;

	$ThisHTML .= &topic_top;

	$alt_color = $vars_style{AltColumnColor2};

	THISPARTICULARLINE: foreach $line (@postinfo) {
		chomp($line);
		undef($this_user_number);
		undef($un_coded);
		undef($public_name);
		undef($show_public_name);
		undef($user_status);
		undef($email_link);
		undef($AuthorExtra);
		undef($pm_link);
		undef($member_number);
		undef(@user_profile);
		undef($profile_link);
		undef($overall_rating);
		undef($total_votes);
		undef($stars);
		undef(@thisline);
		undef($Avatar);

		#chomp($line);

		if ($line !~ m/^Z/) { next THISPARTICULARLINE; }    #not a Z line -> corrupt thread
		chomp $line;

		# get post values
		@thisline = split (/\|\|/, $line);

		# username
		$un_coded = $thisline[2];

		#print "\n$un_coded -> $thisline[2]!\n";

		# public name
		#chomp($thisline[10]);
		if ($thisline[10]) {
			$public_name = $thisline[10];
		} else {
			$public_name = $thisline[2];
		}

		# set user number (make sure it exists, too!)
		# very old format reg/unreg check
		#unless ($thisline[8]) { $thisline[8] = "" }

		$this_user_number = &GetUserNumber($thisline[2]);
		if (($this_user_number) && ($this_user_number =~ m/^\d{8}$/)) {
			unless (-s "$vars_config{MembersPath}/$this_user_number.cgi") {
				$this_user_number = '';
				$thisline[8] = 'unreg';
			}
		} else {

			$this_user_number = '';
			$thisline[8] = 'unreg';
		}    #no user number


		#chomp($thisline[11]);
		if ($thisline[11]) {
			$this_user_number = $thisline[11];
			unless (&FileExists("$vars_config{MembersPath}/$this_user_number.cgi")) {
				$this_user_number = '';
				$thisline[8] = 'unreg';
			}
		}


		# hyphen date
		$hyphen_date = $thisline[3];

		# IP
		$ip_number = $thisline[7];


		if ((($vars_display{author_location} ne "yes") && ($vars_display{author_reg_date} ne "yes") && ($vars_display{author_post_total} ne "yes")) || (($thisline[8]) && ($thisline[8] eq 'unreg'))) {
			$ip_divider = '';
		} else {
			$ip_divider = $vars_config{'jc'}->{'ip-divider'};
		}

		if(!$vars_config{'jc'}->{'is'}) {
			if (($ip_number) && ($vars_misc{IP} eq 'ON')) {
				$ip_wording = "$ip_divider $vars_wordlets{ip_logged}: $ip_number";
			} elsif (($ip_number) && ($vars_misc{IP} eq 'LOGONLY')) {
				$ip_wording = qq($ip_divider $vars_wordlets{ip}: <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_ip;f=$forum_number;t=$topic_number;reply_num=$thisline[1]">$vars_wordlets{ip_logged}</a>);
			} else {
				$ip_wording = '';
			}
		} else {
			if (($ip_number) && ($vars_misc{IP} eq 'ON')) {
				$ip_wording = " <acronym title=\"$vars_wordlets{ip_logged}: $ip_number\"><img src=\"$vars_config{NonCGIURL}/$vars_style{jc_ip}\" border=\"0\" alt=\"$vars_wordlets{ip_logged}: $ip_number\"></acronym> ";
			} elsif (($ip_number) && ($vars_misc{IP} eq 'LOGONLY')) {
				$ip_wording = qq( <acronym title=\"$vars_wordlets{ip_logged}\"><a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_ip;f=$forum_number;t=$topic_number;reply_num=$thisline[1]"><img src=\"$vars_config{NonCGIURL}/$vars_style{jc_ip}\" border=\"0\" alt=\"$vars_wordlets{ip_logged}\"></a></acronym>);
			} else {
				$ip_wording = '';
			}
		} # end if

		# registered?
		$is_reg = $thisline[8];
		$is_reg = "" unless $is_reg;
		chomp($is_reg) if $is_reg;

		#format date
		@datearray = split (/-/, $hyphen_date);
		chomp($datearray[2]);

		# just in case we have some really old posts that weren't Y2K-ready
		$year        = &Y2K($datearray[2]);
		$hyphen_date = "$datearray[0]-$datearray[1]-$year";
		$ThisDate    = &DateFormat($hyphen_date);

		#format time
		$FormatTime = &TimeFormat($thisline[4]);

		# grab post message
		$post_body = $thisline[6];

		# allow editing?
		$edit_link = qq($vars_config{'jc'}->{'no-space'}$vars_config{'jc'}->{'no-nbsp'}<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=edit_post;f=$forum_number;t=$topic_number;reply_num=$thisline[1];u=$this_user_number"><img src="$vars_config{NonCGIURL}/$vars_style{edit_icon}" border="0" alt="$vars_wordlets{edit_delete_post}" /></a>&nbsp;);


		# get user profile info- if registered
		if ($is_reg eq 'unreg') {

			if ($public_name) {
				$show_public_name = $thisline[2];
			} else {
				$show_public_name = $public_name;
			}

			$user_status   = $vars_wordlets{unregistered};
			$member_number = $rating_line = $this_icon = $profile_link = $homepage_link = $email_link = $pm_link = $direct_reply = $AuthorExtra = ""



		} else {    #it's not unreg...

			if (!$this_user_number) {

				# old post- we need to find user number
				$this_user_number = &GetUserNumber($thisline[2]);

				if ((&FileExists("$vars_config{MembersPath}/$this_user_number.cgi")) && ($this_user_number ne '')) {
					@user_profile = &OpenProfile("$this_user_number");
				} else {
					$thisline[8] = 'unreg';

					if (!$public_name) {
						$show_public_name = $thisline[2];
					} else {
						$show_public_name = $public_name;
					}

					$user_status = $vars_wordlets{unregistered};
				}

			} else {

				# already have user number
				@user_profile = &OpenProfile("$this_user_number");

				# one day, Dave will get a haircut...
			}

			# On October 6, 2001, Dave finally got a haircut.

			foreach (@user_profile) {chomp}

			if (!$show_public_name) {
				if (!$user_profile[15]) {
					$show_public_name = $user_profile[0];
				} else {
					$show_public_name = $user_profile[15];
				}
			}

			# get custom title
			if (!$user_profile[31]) {
				$user_status = &CustomTitle($user_profile[8], $user_profile[7]);
				# if moderator- only list as mod if actually a mod in this forum
				if ($user_profile[8] eq "Moderator") {
					unless($Moderator && ($Moderator =~ /$this_user_number/)) {
						$user_status = &CustomTitle($user_profile[8], $user_profile[7]);
					} # end if
				}    # end mod check
			} else {
				$user_status = $user_profile[31];
			} # end if

			$u             = $this_user_number + 0;  # rid extra zeros from member no.
			$member_number = "$vars_wordlets{user_number_abbrev} $u";

			unless (exists($rate_list{$u})) {
				($overall_rating, $total_votes) = &get_rating($u);
				$rate_list{$u} = $overall_rating;
			}

			# Right, now we do Avatars...
			my $avurl = $user_profile[37];
			my($avlock, $avok, $avview) = split(/\|/, $user_profile[38]);
			if($avurl && !$avok) {
				if($avurl !~ m!^https?://!) {
					$Avatar = "$vars_config{NonCGIURL}/$avurl" if -e "$vars_config{NonCGIPath}/$avurl";
				} elsif($avurl =~ m!^https?://!) {
					$Avatar = $avurl;
				} else {
					$Avatar = "";
				} # end if
			} else {
				$Avatar = "";
			} # end if

			# do some cleaning---
			$user_profile[6] =~ s/<.+?>//g;
			$user_profile[6] =~ s/<.*//g;     # delete unclosed HTML tags

			# registration date for user
			$RegDate = $user_profile[10];
			chomp($RegDate);

			if ($RegDate eq '') {
				$RegDate = "$vars_wordlets{pre_reg_date_wording}";
			} else {
				($RegMon, $RegDay, $RegYear) = split (/-/, $RegDate);
				$RegMonth = $themonths[$RegMon];
				$RegDate  = "$RegMonth $RegYear";
			}

			# author info options
			undef($post_total_line);
			undef($location_line);
			undef($regdate_line);
			@author_extra = @blank;

			if ($vars_display{author_post_total} eq 'yes') {
				$post_total_line = qq( $vars_wordlets{author_posts} $vars_config{'jc'}->{'no-b'}$user_profile[7]$vars_config{'jc'}->{'no-b-close'} );
				push (@author_extra, $post_total_line);
			}

			if ($vars_display{author_location} eq 'yes') {
				my $thislocation = &strip_lead_trail_space($user_profile[6]);
				if($thislocation) {
					$location_line = qq( $vars_wordlets{author_from} $vars_config{'jc'}->{'no-b'}$user_profile[6]$vars_config{'jc'}->{'no-b-close'} );
					push (@author_extra, $location_line);
				}
			}

			if ($vars_display{author_reg_date} eq 'yes') {
				$regdate_line = qq( $vars_wordlets{author_registered} $vars_config{'jc'}->{'no-b'}$RegDate$vars_config{'jc'}->{'no-b-close'} );
				push (@author_extra, $regdate_line);
			}

			if ($author_extra[0]) {
				$AuthorExtra = join ("|", @author_extra);
			} else {
				$AuthorExtra = '';
			}


			$profile_link = qq($vars_config{'jc'}->{'no-space'}$vars_config{'jc'}->{'no-nbsp'}<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$this_user_number" target="_blank"><img src="$vars_config{NonCGIURL}/$vars_style{profilegif}" border="0" alt="$vars_wordlets{view_profile_for} $show_public_name" /></a>&nbsp;);


			if (($vars_display{EmailBlock} eq 'ON') || ($user_profile[11] eq 'no')) {
				$email_link = '&nbsp;';
			} else {

				$email_link = qq($vars_config{'jc'}->{'no-space'}$vars_config{'jc'}->{'no-nbsp'}<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=email;ToWhom=$this_user_number" target="_blank"><img src="$vars_config{NonCGIURL}/$vars_style{mailgif}" border="0" alt="$vars_wordlets{send_email_to} $show_public_name" /></a>&nbsp;);
			}

			# Add poll data before the signature
			# polling bits
			if(($stat_line[10] =~ m/^(\w{12})$/) && ($thisline[1] eq "000000")) {
				&RequireCode("ubb_poll.cgi");
				&poll_load($1);
				$post_body .= &topic_poll_bits($poll->{$1}, $1, $topic_number, $this_forum[8]);
			} # end if

			# add signature, if necessary
			if ($thisline[12]) {

				# new format! - signature is not included in message
				if (($vars_display{AllowSignature} eq 'YES') && ($user_profile[12] ne '') && ($thisline[12] eq 'yes')) {

					if ($vars_display{AllowSignatureImage} eq 'YES') {
						$allow_images = 'ON';
					} else {
						$allow_images = 'OFF';
					}

					$user_profile[12] = &UBBCode(&ConvertReturns(&prep_for_edit($user_profile[12], undef, $allow_images)), $allow_images);
					$user_profile[12] = &Smilies($user_profile[12]) if $allow_images eq "ON";

					$post_body .= ("<br /><br />$vars_wordlets{signature_break}<br />$user_profile[12]<br />") unless $vars_config{'jc'}->{'is'};
				}

			}

		}    # if/else registered


		# message icons?
		if ($vars_display{AllowIcons} eq 'TRUE') {
			$icon_number = $thisline[9];
			if (!$icon_number) {
				$icon_number = '1';
			}
			unless (&FileExists("$vars_config{NonCGIPath}/icons/icon$icon_number.gif")) {
				$icon_number = '1';
			}
			$this_icon = qq(<img src="$vars_config{NonCGIURL}/icons/icon$icon_number.gif" border="0" alt="$vars_wordlets_img{alt_icon} $icon_number" />);
		} else {
			$this_icon = qq(<img src="$vars_config{NonCGIURL}/posticon.gif" border="0" alt=" - " />);
		}

		# reply with quote?
		if (($vars_misc{ReplyQuote} eq 'YES') && ($reply_restrict ne 'none') && ($this_forum[5] eq 'is') && ($stat_line[1] !~ m/X/)) {
			$direct_reply = qq($vars_config{'jc'}->{'no-space'}$vars_config{'jc'}->{'no-nbsp'}<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=reply;f=$forum_number;t=$topic_number;replyto=$thisline[1]"><img src="$vars_config{NonCGIURL}/$vars_style{reply_with_quote_icon}" border="0" alt="$vars_wordlets{reply_with_quote}" /></a>&nbsp;);
		} else {
			$direct_reply = '';
		}

		# homepage link?
		if (($user_profile[3]) && ($user_profile[3] ne "http://") && ($vars_display{homepage_icon_link} eq 'yes')) {

			# format URL if necessary
			if ($user_profile[3] !~ /^http/) { $user_profile[3] = ('http://' . $user_profile[3]); }

			$homepage_link = qq($vars_config{'jc'}->{'no-space'}$vars_config{'jc'}->{'no-nbsp'}<a href="$user_profile[3]" target="_new"><img src="$vars_config{NonCGIURL}/$vars_style{homepage_icon}" border="0" alt="$vars_wordlets{homepage}" /></a>&nbsp;);
		} else {
			$homepage_link = '';
		}

		# private message?
		unless ($vars_pm{feature} eq "off") {
			if ($user_profile[27]) {
				if (($user_profile[27] ne 'no') && ($user_status ne $vars_wordlets{unregistered})) {
					$pm_link = qq($vars_config{'jc'}->{'no-space'}$vars_config{'jc'}->{'no-nbsp'}<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=private_message;u=$this_user_number"><img src="$vars_config{NonCGIURL}/$vars_style{priv_message}" border='0' alt="$vars_wordlets{send_private_message}" /></a>&nbsp;);
				}
			} elsif ($user_status ne $vars_wordlets{unregistered}) {
				$pm_link = qq($vars_config{'jc'}->{'no-space'}$vars_config{'jc'}->{'no-nbsp'}<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=private_message;u=$this_user_number"><img src="$vars_config{NonCGIURL}/$vars_style{priv_message}" border='0' alt="$vars_wordlets{send_private_message}" /></a>&nbsp;);
			} else {
				$pm_link = $vars_config{'jc'}->{'nbsp-space'};
			}    #if
		}
		else {
			$pm_link = $vars_config{'jc'}->{'nbsp-space'};
		}    #unless


		# user rating?
		chomp($user_profile[25]) if $user_profile[25];
		$user_profile[25] = "" unless $user_profile[25];
		$rating_line = '';
		if (($vars_display{user_ratings} ne 'off') && ($user_profile[25] ne 'no') && ($user_status ne $vars_wordlets{unregistered})) {
			if ($rate_list{$u} ne '') {

				unless (($vars_display{user_ratings} eq 'feature_top') && ($rate_list{$u} < 4)) {
					if($rate_list{$u} > 5){ $rate_list{$u} = 5; }
					if($rate_list{$u} < 1){ $rate_list{$u} = 1; }
					if($rate_list{$u} < 1){ $rate_list{$u} = 1 unless $rate_list{$u} == 0 }
					$stars       = ("user_ratings_" . "$rate_list{$u}");
					$rating_line = qq!<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$this_user_number">$vars_wordlets{member_rated}</a>:<br /><a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$this_user_number"><img src="$vars_style{$stars}" border="0" alt="$rate_list{$u}" /></a>!;
				} else {
					$rating_line = qq!<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$this_user_number">$vars_wordlets{rate_member}</a>!;
				}
			} else {
				$rating_line = qq!<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$this_user_number">$vars_wordlets{rate_member}</a>!;
			}

		} else {

			# ratings off!
			$rating_line = '';
		}

		$ThisHTML .= &topic_row;

	}    # end post loop

	$ThisHTML .= &topic_bottom;
	$ThisHTML .= $Footer;


	# do file name
	if ($page_number eq '1') {
		$page_name = "$topic_number";
	} else {
		$page_name = "$topic_number-$page_number";
	}


	# is directory created?
	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path")) {

		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", SEVENSEVENSEVEN);
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums", SEVENSEVENSEVEN);
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/Forum$in{f}", SEVENSEVENSEVEN);
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums}");
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/Forum$in{f}");
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path");
	}


	unless (-w "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$page_name.cgi") {
		&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$page_name.cgi");
	}

	&WriteFileAsString("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$page_name.cgi", $ThisHTML);

}    # end create_topic


1;
# $Id: ubb_lib_posting.cgi,v 1.23 2002/04/30 18:19:05 cvscapps Exp $
