

package UBB::PNTF;
use strict;

#use UBBCGI::Carp qw(fatalsToBrowser);

BEGIN {
	use vars qw($VERSION @ISA);

	$VERSION = 0.10;

	@ISA = qw(UBB::CommonElements);

	#$| = 1;
	#open(STDERR, ">>/net/ubb620-development/cache-PNVT5YXP/lock/pntf.log") or die $!;
	#my $oldfh = select(STDERR); $|=1; select($oldfh);
}    # end BEGIN


sub new {
	my $protoobj = shift;
	my $class    = ref($protoobj) || $protoobj;
	my $self     = {
		CONFIG     => $_[0],                               # %vars_config
		FILEHANDLE => bless($_[1], "UBB::FileHandler"),    # $filehandler
		OPTIONS    => $_[2],                               # %vars_pntf
		VARSFORUMS => $_[3],
		DEBUG      => 0,                                   # debugging (warnings)
	};
	bless($self, $class);

	if (!-d "$_[0]->{NonCGIPath}/cache-$_[0]->{cache_pw}") {
		mkdir("$_[0]->{NonCGIPath}/cache-$_[0]->{cache_pw}", 0777);
		chmod(0777, "$_[0]->{NonCGIPath}/cache-$_[0]->{cache_pw}");
	}    # cache

	if (!-d "$_[0]->{NonCGIPath}/cache-$_[0]->{cache_pw}/pntf") {
		mkdir("$_[0]->{NonCGIPath}/cache-$_[0]->{cache_pw}/pntf", 0777);
		chmod(0777, "$_[0]->{NonCGIPath}/cache-$_[0]->{cache_pw}/pntf");
	}    # pntf

	#$self->warn("x" x 80);

	return $self;
}    # end new

sub load {
	my $self = shift;

	#$self->warn("Loading up...");

	$self->{HANDLE} = $self->{FILEHANDLE}->open('file', 'readwrite2', "$self->{CONFIG}->{NonCGIPath}/cache-$self->{CONFIG}->{cache_pw}/pntf/now.cgi");
	my $string = $self->{HANDLE}->readfile();

	#$self->warn("File loaded.");

	{    # start local block
		local $SIG{'__DIE__'}  = sub { return; };
		local $SIG{'__WARN__'} = sub { return; };
		eval $string;
	}    # end local block

	#$self->warn("Got past the eval");

	if (defined(&_load)) {

		#$self->warn("_loading");
		$self->_load;

		#$self->warn("_loaded");
	} else {

		#$self->warn("Didn't get to _load, setting defaults");
		$self->{DATA} = {
			ip2uniq => {},
			meta    => {
				import => -1,
				prune  => -1,
			},
			lids => {},
			uniq => {
				locs   => {},
				logins => {}
			},
		};
	}    # end if
}    # end load


sub DESTROY {    # laa dee daa
}                # end DESTROY

sub append {
	my $self = shift;
	my ($ip, $cookie, $ubber_cookie, $in, $thetime, $imported, $perms) = @_;

	my ($s, $l) = (caller(1))[3, 2];

	##$self->warn("Got this from $s($l):\n$out");

	if((exists $in->{ubb}) && ($in->{ubb} ne '')) {
		if($in->{ubb} !~ m/^(forum|get_topic|pntf)$/) {

	#		die "Bad action.";

			#$self->warn("The action ($in->{ubb}) was not within my process limits.");
			if ($self->{HANDLE} && !$imported) {
				$self->{FILEHANDLE}->close($self->{HANDLE});
				delete $self->{HANDLE};
			} # end if
			return undef;
		} elsif(((exists $in->{f}) && ($in->{f} =~ m/^\d+$/) && (ref($perms) =~ m/UBB::SecurityToken/) && (!$perms->has_permission("forum", "view", $in->{f}))) || ((exists $in->{f}) && ($in->{f} =~ m/^\d+$/) && (!exists $self->{VARSFORUMS}->{$in->{f}}))) {
	#		die "No perms.";
			if ($self->{HANDLE} && !$imported) {
				$self->{FILEHANDLE}->close($self->{HANDLE});
				delete $self->{HANDLE};
			} # end if
			return undef;
		}    # if the action isn't worth recording, don't
	} # end if

	#$self->warn("Action is worth recording ($in->{ubb})");

	$thetime = $self->get_time() unless $thetime > 0;

	my ($uniq, $uip, $timestamp, $user_number, $nologin, $hidden) = @{$cookie};
	my $oops = 0;
	if ((!$uniq) || ($uip ne $ip)) {

		#$self->warn("Looks like I didn't get a UNIQ out of the PNTF cookie.");
		$oops++;
		if ($self->_uniqs($ip) > $self->{OPTIONS}->{UNIQIDsPerIP}) {

			# If we've assigned ten UNIQs to this IP already...
			#$self->warn("But I've seen him before...");
			$uniq = ($self->_uniqs($ip))[0];

			#$self->warn("His new UNIQ is $uniq");
		} else {

			# ... chances are that the user is rejecting cookies
			$uniq = $self->_random(16);

			#$self->warn("Haven't seen him before, his UNIQ is $uniq");
		}    # end if
		$uip         = $ip;
		$timestamp   = $thetime;
		$user_number = "";         # explicit
		$nologin     = 1;
		$hidden      = 0;
	}    # end if
	     #$self->warn("Done processing PNTF cookie.  Processing UBBER cookie.");

	my ($user_name, $passwd, $pdn, $daysprune, $user_number2, $hidden2) = @{$ubber_cookie};
	if (!$user_name || ($user_name eq "")) {

		#$self->warn("No username!");
		$oops++;
		$user_number2 = "";     # explicit
		$nologin      = 1;
		$hidden       = 0;
		$daysprune    = 1000;
	} elsif ($user_number2 && ($user_number ne $user_number2)) {

		#$self->warn("Okay, looks like it's sane (user $user_number2)");
		$nologin = 0;
		$oops++;
	}    # end if

	if ($oops > 0) {

		#$self->warn("Got an OOPS!");
		$user_number = $user_number2;
	}    # end if

	$hidden = ($hidden2 ne "" ? $hidden2 : $hidden);

	#$self->warn("LIDizing:");

	my $lid = $self->_lidize($in);

	# Right, now we have all the data we need, so let's get appending!

	# Don't bother recording data if we didn't get a sane LID
	if ($lid ne undef) {

		#$self->warn("Adding record...");
		# Add this UNIQ to the IP
		$self->{DATA}->{ip2uniq}->{$ip}->{$uniq}++;

		# Add the UNIQ to the LID's entry for the current minute
		$self->{DATA}->{lids}->{$lid}->{$thetime}->{$uniq}++;

		# Add the LID to the time's entry for this UNIQ
		$self->{DATA}->{uniq}->{locs}->{$thetime}->{$uniq}->{$lid}++;

		# Set the UNIQ's pref data properly
		$self->{DATA}->{uniq}->{logins}->{$uniq} = [$user_number, $nologin, $hidden, $daysprune];

		#$self->warn("Done.");
	}    # end if

	#$self->warn("Returning new cookie");
	# Return a cookie if we need to change some of the data
	return ($uniq, $ip, $thetime, $user_number, $nologin, $hidden);
}    # end append


sub _uniqs {    # returns a list of uniqs for an IP
	my $self = shift;
	my @ips;
	if (exists $self->{DATA}->{ip2uniq}->{$_[0]}) {
		@ips = sort keys %{$self->{DATA}->{ip2uniq}->{$_[0]}};
	} else {
		@ips = ();
	}
	return @ips;
}    # end uniqs


sub _lidize {

	# Implemented:
	#0001020304 - LID for a topic.	(Forum 1, thread 20304)
	#00720365.0102 - LID for a forum (Forum 72, daysprune 365, page 102)
	#9999 - LID for the front page
	#9999.1 - LID for front page category 1

	my $self = shift;
	my %in   = %{$_[0]};
	if((!exists $in{ubb}) || ($in{ubb} eq '')) {

		#$self->warn("No in{ubb} - front page!");
		if ((exists $in{category}) && ($in{category} =~ m/^\d+$/)) {
			return "9999." . $in{category};
		} else {
			return 9999;
		}    # end if
	} elsif ($in{ubb} eq "get_topic") {

		#$self->warn("Looks like a topic");
		return sprintf("%04d%06d", $in{f}, $in{t});
	} elsif ($in{ubb} eq "forum") {

		#$self->warn("Looks like a forum");
		return sprintf("%04d%04d.%04d", $in{f}, $in{DaysPrune}, $in{p});
	} else {
		my $instring;
		foreach (keys %in) { $instring .= "$_:$in{$_}; "; }

		#$self->warn("I don't know what to do with $instring");
		return undef;
	}    # end if
}    # end _lidize


sub write {    # write out the data file
	my $self = shift;

	#$self->warn("Writing...");
	# Perl and I disagree on what an undefined value really is, so...
	if(	($self->{HANDLE} ne undef)
		&& ($self->{HANDLE} ne "")
		&& (ref($self->{HANDLE}) eq "UBB::FileHandle")
		&& (UNIVERSAL::can($self->{HANDLE}, "truncate"))
		) {

		# if we need to import data from the PHP script, do it now
		#$self->warn("Importing...");
		$self->_import unless $self->{DATA}->{meta}->{import} >= $self->get_time;

		#$self->warn("...imported!");

		# if we need to prune data from over $x minutes ago, do it now
		#$self->warn("Pruning...");
		$self->_prune unless $self->{DATA}->{meta}->{prune} >= $self->get_time;

		#$self->warn("...pruned!");

		my %current;

		# assemble a list of UNIQs that are still active
		foreach my $lid (keys %{$self->{DATA}->{lids}}) {
			foreach my $timestamp (keys %{$self->{DATA}->{lids}->{$lid}}) {
				foreach my $uniq (keys %{$self->{DATA}->{lids}->{$lid}->{$timestamp}}) {
					$current{$uniq}++;
				}    # end foreach
			}    # end foreach
		}    # end foreach
		my $current = scalar(keys %current);

		#$self->warn("There are $current active UNIQs.  Updating record.");

		$self->{DATA}->{meta}->{record} = ($current > $self->{DATA}->{meta}->{record}->[0] ? [$current, $self->get_time] : $self->{DATA}->{meta}->{record});

		# already pulled in lib_dumper in ultimatebb
		my $obj = Data::ThatWhichDumps->new([$self->{DATA}], ['$REPLACEMEPLEASE']);
		my $string = $obj->Dump;
		$string =~ s/REPLACEMEPLEASE/self->{DATA}/;

		#$self->warn("Performing write");
		$self->{HANDLE}->truncate();
		$self->{HANDLE}->print(q(package UBB::PNTF; sub _load { my $self = shift; ) . $string . q( } 1; ) . qq(\n));
		$self->{FILEHANDLE}->close($self->{HANDLE});
	}    # end if
	     #$self->warn("Write complete");

	# we're done - blow away our copies of the file handle and the filehandler
	delete $self->{HANDLE};
	delete $self->{FILEHANDLE};
}    # end write


sub _import {    # grab data from the Accelerator
	my $self = shift;

	my %permhash;

	#$self->warn("Performing IMPORT");

	my $file = qq($self->{CONFIG}->{NonCGIPath}/cache-$self->{CONFIG}->{cache_pw}/pntf/now-accel.cgi);
	if ((-e $file) && (-s $file)) {
		my $handle = $self->{FILEHANDLE}->open('file', 'readwrite2', $file);

		#$self->warn("File open...");
		while ($_ = $handle->readline) {

			#$self->warn("Read a line...");
			chomp;
			if (m/^\|\#\|(.+)\|\#\|$/) {

				#$self->warn("Dispatching the line");
				my @line  = split (/\|\!\^\!\|/, $1);
				my @cook  = split (/\|\!\|/, $line[1]);
				my @ubber = split (/\|\!\|/, $line[2]);
				my $inref = $self->_inize($line[4]);

				if((exists $inref->{f}) && ($inref->{f} =~ m/^\d$/)) {
					if(($ubber[0] && $ubber[4]) && (!exists $permhash{$ubber[4]})) {
						my @up = &main::OpenProfile($ubber[4]);
						$permhash{$ubber[4]} = new UBB::SecurityToken($main::vars_groups, $ubber[4], \@up, \%main::vars_forums, $inref);
					} # end if
				} # end if

				#$self->warn("Calling APPEND");
				$self->append($line[0], \@cook, \@ubber, $inref, $line[3], 1, $permhash{$ubber[4]}); # that last tells append to not close the filehandle

				#$self->warn("APPEND done");
			}    # end if
		}
		$handle->truncate();
		$self->{FILEHANDLE}->close($handle);

		#$self->warn("File closed");
	} else {

		#$self->warn("File wasn't there or was blank, skipping import");
	}    # end if

	$self->{DATA}->{meta}->{import} = $self->get_time() + $self->{OPTIONS}->{Import};

	#$self->warn("IMPORT done");
	return;
}    # end import


sub _inize {

	# takes a query string and does a quick hashref transform on it
	my $self = shift;
	my @array = split (/\&/, UBBCGI::unescape(shift));
	my %hash;
	foreach (@array) {
		my ($l, $r) = split (/=/);
		$hash{$l} = $r;
	}    # end foreach
	return \%hash;
}    # end inize

sub _prune {    # prune away data from the PNTF tree
	my $self = shift;
	my (%uniqs);
	my $time = $self->get_time;
	my $diff = $self->{OPTIONS}->{Timeout};

	#$self->warn("Called PRUNE");

	# delete old entries
	foreach my $timestamp (keys %{$self->{DATA}->{uniq}->{locs}}) {
		if ($timestamp < ($time - $diff + 1)) {
			delete $self->{DATA}->{uniq}->{locs}->{$timestamp};

			#$self->warn("Nuked a timestamp...");
		}    # end if
	}    # end foreach
	foreach my $lid (keys %{$self->{DATA}->{lids}}) {
		foreach my $timestamp (keys %{$self->{DATA}->{lids}->{$lid}}) {
			if ($timestamp < ($time - $diff + 1)) {
				delete $self->{DATA}->{lids}->{$lid}->{$timestamp};

				#$self->warn("Nuked another timestamp...");
			}    #end if
		}    # end foreach
	}    # end foreach


	# assemble a list of UNIQs that are still active
	foreach my $lid (keys %{$self->{DATA}->{lids}}) {
		foreach my $timestamp (keys %{$self->{DATA}->{lids}->{$lid}}) {
			foreach my $uniq (keys %{$self->{DATA}->{lids}->{$lid}->{$timestamp}}) {

				#$self->warn("$timestamp has $uniq");
				$uniqs{$uniq}++;
			}    # end foreach
		}    # end foreach
	}    # end foreach


	# now prune UNIQs that aren't active
	foreach my $ip (keys %{$self->{DATA}->{ip2uniq}}) {
		foreach my $uniq (keys %{$self->{DATA}->{ip2uniq}->{$ip}}) {
			unless (exists $uniqs{$uniq}) {

				#$self->warn("$ip -> $uniq is no longer active");
				delete $self->{DATA}->{ip2uniq}->{$ip}->{$uniq};
			}    # end unless
		}    # end foreach
	}    # end foreach
	foreach my $uniq (keys %{$self->{DATA}->{uniq}->{logins}}) {
		unless (exists $uniqs{$uniq}) {

			#$self->warn("$uniq is no longer active");
			delete $self->{DATA}->{uniq}->{logins}->{$uniq};
		}    # end unless
	}    # end foreach


	# now remove LIDs without UNIQa
	foreach my $lid (keys %{$self->{DATA}->{lids}}) {
		if (scalar(keys %{$self->{DATA}->{lids}->{$lid}}) < 1) {

			#$self->warn("$lid is now empty");
			delete $self->{DATA}->{lids}->{$lid};
		}    # end if
	}    # end foreach

	# now remove IPs without UNIQs
	foreach my $ip (keys %{$self->{DATA}->{ip2uniq}}) {
		if (scalar(keys %{$self->{DATA}->{ip2uniq}->{$ip}}) < 1) {

			#$self->warn("$ip is no longer active");
			delete $self->{DATA}->{ip2uniq}->{$ip};
		}    # end if
	}    # end foreach

	#$self->warn("Prune complete.");

	# bump up the prune timer and return
	$self->{DATA}->{meta}->{prune} = $time + $self->{OPTIONS}->{Prune};
}    # end prune





sub reset_record {
	my $self = shift;
	$self->{DATA}->{meta}->{record} = [];
	return;
}    # end reset_record





     # Everything below this line is part of the examine bits



sub examine {
	my $self = shift;
	my %r;

	# Quick and dirty stats

	$r{'001_minimum_unique'} = scalar(keys %{$self->{DATA}->{ip2uniq}});

	my $maxun = 0;
	foreach my $ip (keys %{$self->{DATA}->{ip2uniq}}) {
		$maxun += scalar(keys %{$self->{DATA}->{ip2uniq}->{$ip}});
	}    # end foreach
	$r{'002_maximum_unique'} = $maxun;

	my @lids   = sort keys %{$self->{DATA}->{lids}};
	my @summs  = grep(/^9999/, @lids);
	my @fora   = grep(/^\d{8}\.\d{4}$/, @lids);
	my @topics = grep(/^\d{10}$/, @lids);

	$r{'003_LID_total'} = scalar(@lids);
	$r{'004_LID_list'}  = join (", ", @lids);

	$r{'005_fora_total'} = scalar(@fora);
	$r{'006_fora_LIDs'}  = join (", ", @fora);

	$r{'007_topic_total'} = scalar(@topics);
	$r{'008_topic_LIDs'}  = join (", ", @topics);

	foreach my $forum (@fora) {
		$forum =~ m/^(\d{4})(\d{4})\.(\d{4})$/;
		my ($number, $dp, $page) = ($1, $2, $3);
		foreach my $timestamp (sort keys %{$self->{DATA}->{lids}->{$forum}}) {
			my %fora_on;
			foreach my $key (keys %{$self->{DATA}->{lids}->{$forum}->{$timestamp}}) {
				$fora_on{$key}++;
			}    # end foreach
			$r{"009.$number" . "_forum_visitors"} = scalar(keys %fora_on);
		}    # end foreach
	}    # end foreach

	foreach my $topic (@topics) {
		$topic =~ m/^(\d{4})(\d{6})$/;
		my ($forum, $number) = ($1, $2);
		my %topics_on;
		foreach my $timestamp (sort keys %{$self->{DATA}->{lids}->{$topic}}) {
			foreach my $key (keys %{$self->{DATA}->{lids}->{$topic}->{$timestamp}}) {
				$topics_on{$key}++;
			}    # end foreach
		}    # end foreach
		$r{"010.$forum-$number" . "_forum_topic_visitors"} = scalar(keys %topics_on);
	}    # end foreach

	# Note: Things go out of scope using my.
	my %another;
	foreach my $page (@summs) {
		foreach my $timestamp (sort keys %{ $self->{DATA}->{lids}->{$page} }) {
			foreach my $key (keys %{$self->{DATA}->{lids}->{$page}->{$timestamp}}) {
				$another{"$key"}++;
			}    # end foreach
		}    # end foreach
	}    # end foreach
	$r{'011_forum_summary_visitors'} = scalar(keys %another);

	# assemble a list of UNIQs that are still active
	my %current = $self->_examine_current;
	$r{"012_active_UNIQs"} = scalar(keys %current);
	$r{"013_record"}       = $self->{DATA}->{meta}->{record};
	return %r;

}    # end examine


sub _examine_current {
	my $self = shift;
	my %current;
	foreach my $lid (keys %{$self->{DATA}->{lids}}) {
		foreach my $timestamp (keys %{$self->{DATA}->{lids}->{$lid}}) {
			foreach my $uniq (keys %{$self->{DATA}->{lids}->{$lid}->{$timestamp}}) {
				$current{$uniq}++;
			}    # end foreach
		}    # end foreach
	}    # end foreach
	return %current;
}    # end _examine_current


sub examine_forums {
	my $self = shift;
	my %r;

	my @lids   = sort keys %{$self->{DATA}->{lids}};
	my @fora   = grep(/^\d{8}\.\d{4}$/, @lids);
	my @topics = grep(/^\d{10}$/, @lids);
	my @summs  = grep(/^9999/, @lids);

	my %summ_on;
	foreach my $summary (@summs) {
		foreach my $timestamp (sort keys %{$self->{DATA}->{lids}->{$summary}}) {
			foreach my $key (keys %{$self->{DATA}->{lids}->{$summary}->{$timestamp}}) {
				$summ_on{$key}++;
			}    # end foreach
		}    # end foreach
	}    # end foreach
	$r{"summary"} = scalar(keys %summ_on);

	my %fora_on;
	foreach my $forum (@fora) {
		$forum =~ m/^(\d{4})(\d{4})\.(\d{4})$/;
		my ($number, $dp, $page) = ($1, $2, $3);
		foreach my $timestamp (sort keys %{$self->{DATA}->{lids}->{$forum}}) {
			foreach my $key (keys %{$self->{DATA}->{lids}->{$forum}->{$timestamp}}) {
				$fora_on{"forum_$number"}->{$key}++;
			}    # end foreach
		}    # end foreach
	}    # end foreach

	foreach my $topic (@topics) {
		$topic =~ m/^(\d{4})(\d{6})$/;
		my ($forum, $number) = ($1, $2);
		foreach my $timestamp (sort keys %{$self->{DATA}->{lids}->{$topic}}) {
			foreach my $key (keys %{$self->{DATA}->{lids}->{$topic}->{$timestamp}}) {
				$fora_on{"forum_$forum"}->{$key}++;
			}    # end foreach
		}    # end foreach
	}    # end foreach

	foreach my $forum (keys %fora_on) {
		$r{"$forum"} = scalar(keys %{$fora_on{"$forum"}});
	}    # end foreach

	my $maxun = 0;
	foreach my $ip (keys %{$self->{DATA}->{ip2uniq}}) {
		$maxun += scalar(keys %{$self->{DATA}->{ip2uniq}->{$ip}});
	}    # end foreach
	$r{"fora_total"} = $maxun;

	$r{"record"} = $self->{DATA}->{meta}->{record};

	return \%r;

}    # end examine_forums



sub examine_topics {
	my $self = shift;
	my %r;

	my @lids   = sort keys %{$self->{DATA}->{lids}};
	my @fora   = grep(/^\d{8}\.\d{4}$/, @lids);
	my @topics = grep(/^\d{10}$/, @lids);

	$r{'003_LID_total'} = scalar(@lids);

	$r{'005_fora_total'} = scalar(@fora);

	$r{'007_topic_total'} = scalar(@topics);

	foreach my $topic (@topics) {
		$topic =~ m/^(\d{4})(\d{6})$/;
		my ($forum, $number) = ($1, $2);
		my %topics_on;
		foreach my $timestamp (sort keys %{$self->{DATA}->{lids}->{$topic}}) {
			foreach my $key (keys %{$self->{DATA}->{lids}->{$topic}->{$timestamp}}) {
				$topics_on{$key}++;
			}    # end foreach
		}    # end foreach
		$r{"$forum-$number"} = scalar(keys %topics_on);
	}    # end foreach

	return \%r;
}    # end examine_topics



sub examine_topic {
	my ($self, $forum, $topic) = @_;
	my %r;

	my $LID = sprintf("%04d%06d", $forum, $topic);

	return undef if !exists $self->{DATA}->{lids}->{$LID};

	my %visitors;
	foreach my $date (keys %{$self->{DATA}->{lids}->{$LID}}) {
		foreach my $uniq (keys %{$self->{DATA}->{lids}->{$LID}->{$date}}) {
			$visitors{$uniq} = $date if $visitors{$uniq} < $date;
		}    # end foreach
	}    # end foreach

	my @ar = sort { $visitors{$b} <=> $visitors{$a} } (keys %visitors);
	$r{'sorted'}   = \@ar;
	$r{'visitors'} = \%visitors;
	foreach my $uniq (@ar) {
		$r{'uniq'}->{$uniq} = $self->{DATA}->{uniq}->{logins}->{$uniq};
	}    # end foreach

	return \%r;
}    # end examine_LID



sub examine_forum {
	my ($self, $forum) = @_;
	my %r;

	my $numbah = sprintf("%04d", $forum);
	my @LIDs  = grep(/^$numbah\d{4}\.\d{4}$/, keys %{$self->{DATA}->{lids}});
	my @tLIDs = grep(/^$numbah\d{6}$/,        keys %{$self->{DATA}->{lids}});

	my %peeps;
	foreach my $lid (@LIDs, @tLIDs) {
		foreach my $time (keys %{$self->{DATA}->{lids}->{$lid}}) {
			foreach my $uniq (keys %{$self->{DATA}->{lids}->{$lid}->{$time}}) {
				$peeps{$uniq} = $time if $peeps{$uniq} < $time;
			}    # end foreach
		}    # end foreach
	}    # end foreach

	my @ar = sort { $peeps{$b} <=> $peeps{$a} } (keys %peeps);
	$r{'sorted'}   = \@ar;
	$r{'visitors'} = \%peeps;
	$r{'topics'}   = \@tLIDs;

	foreach my $uniq (@ar) {
		$r{'uniq'}->{$uniq} = $self->{DATA}->{uniq}->{logins}->{$uniq};
	}    # end foreach

	foreach my $topic (@tLIDs) {
		$topic =~ m/^(\d{4})(\d{6})$/;
		my ($forum, $number) = ($1, $2);
		my %topics_on;
		foreach my $timestamp (sort keys %{$self->{DATA}->{lids}->{$topic}}) {
			foreach my $key (keys %{$self->{DATA}->{lids}->{$topic}->{$timestamp}}) {
				$topics_on{$key}++;
			}    # end foreach
			$r{'topic_time'}->{$number} = $timestamp;
		}    # end foreach
		$r{'topic_count'}->{$number} = scalar(keys %topics_on);
	}    # end foreach

	return \%r;
}    # end examine_forum

sub _examine_lid {
	my $self = shift;
	my @lids = @_;

	my ($results, %uniqs, %users);

	foreach my $lid (@lids) {
		foreach my $timer (keys %{$self->{DATA}->{lids}->{$lid}}) {
			foreach my $uniq (keys %{$self->{DATA}->{lids}->{$lid}->{$timer}}) {
				$uniqs{$uniq} = ($self->{DATA}->{lids}->{$lid}->{$timer}->{$uniq} > $uniqs{$uniq} ? $self->{DATA}->{lids}->{$lid}->{$timer}->{$uniq} : $uniqs{$uniq});
			}    # end foreach
		}    # end foreach
	}    # end foreach

	$results->{"raw_total"} = scalar(keys %uniqs);
	$results->{"overflow"}  = 0;
	$results->{"guests"}    = 0;

	# Okay, figure out guests
	foreach my $uniq (keys %uniqs) {

		if (($self->{DATA}->{'uniq'}->{'logins'}->{$uniq}->[0] =~ m/^\d{8}$/) && (($self->{DATA}->{'uniq'}->{'logins'}->{$uniq}->[2] == 0) && ($self->{DATA}->{'uniq'}->{'logins'}->{$uniq}->[1] == 0)) && (!exists $users{$self->{DATA}->{'uniq'}->{'logins'}->{$uniq}->[0]})) {
			$users{$self->{DATA}->{'uniq'}->{'logins'}->{$uniq}->[0]} = $uniqs{$uniq};
		} else {
			$results->{"guests"}++;
		}
	}    # end foreach

	# Right, now sort them...
	my @sortorder = sort { $users{$b} <=> $users{a} } keys %users;

	if ($self->{OPTIONS}->{CountOnly} eq "limit") {
		if (scalar(@sortorder) > $self->{OPTIONS}->{NameLimit}) {
			$results->{"overflow"} = scalar(@sortorder) - $self->{OPTIONS}->{NameLimit};
			@sortorder = @sortorder[0 .. ($self->{OPTIONS}->{NameLimit} - 1)];
		}    # end if
	}    # end if

	$results->{"sortorder"} = \@sortorder;
	$results->{"users"}     = \%users;

	return $results;
}    # end _examine_lid


sub examine2_forum {
	my $self = shift;
	my $forum = sprintf("%04d", shift);
	return $self->_examine_lid(grep(/^$forum\d{4}\.\d{4}$/, keys %{$self->{DATA}->{lids}}));
}    # end examine2_forum


sub examine2_summary {
	my $self = shift;
	return $self->_examine_lid(keys %{$self->{DATA}->{lids}});
}    # end examine2_summary

sub _examine3_user {
	my $self       = shift;
	my $usernumber = shift;
	my $inviz = 0;

	my %uniqs;
	foreach my $uniq (keys %{$self->{DATA}->{uniq}->{logins}}) {
		if ($self->{DATA}->{uniq}->{logins}->{$uniq}->[0] eq $usernumber) {
			$uniqs{$uniq}++;# unless $self->{DATA}->{uniq}->{logins}->{$uniq}->[2] == 1;
			$inviz++ if $self->{DATA}->{uniq}->{logins}->{$uniq}->[2] > 0;
		}    # end if
	}    # end foreach

	my %places;
	foreach my $thistime (keys %{$self->{DATA}->{uniq}->{locs}}) {
		foreach my $unique (keys %{$self->{DATA}->{uniq}->{locs}->{$thistime}}) {
			if (exists $uniqs{$unique}) {
				PLACE: foreach my $place (keys %{$self->{DATA}->{uniq}->{locs}->{$thistime}->{$unique}}) {
					unless (    # get only forum-based LIDs
						($place =~ m/^9999(\.\d+)?$/) || ($place =~ m/^\d{10}$/) || ($place =~ m/^\d{8}\.\d{4}$/)
					    )
					{
						next PLACE;
					}    # end if
					$places{$place} = ($places{$place} < $thistime ? $thistime : $places{$place});
				}    # end foreach
			}    # end if
		}    # end foreach
	}    # end foreach

	my %realplaces;
	foreach my $place (keys %places) {
		push (@{$realplaces{$places{$place}}}, $place);
	}    # end foreach

	my @sortorder = reverse sort keys %realplaces;

	my %iph;
	foreach my $ip (keys %{$self->{DATA}->{ip2uniq}}) {
		foreach my $uniq (keys %uniqs) {
			if (exists $self->{DATA}->{ip2uniq}->{$ip}->{$uniq}) {
				$iph{$ip}++;
			}    # end if
		}    # end foreach
	}    # end foreach

	my @ips = keys %iph;

	return (\%realplaces, \@sortorder, \@ips, $inviz);
}    # end _examine3_user

sub examine3_user4admin {
	my $self = shift;
	my $user = shift;
	my ($places, $sortorder, $ips, $inviz) = $self->_examine3_user($user);

	my $r = {
		LASTSEEN => $sortorder,
		PLACE    => $places,
		IPS      => $ips,
		INVIZ	 => $inviz,
	};

	return $r;
}    # end examine3_user4admin

sub examine3_user {
	my $self = shift;
	my $user = shift;
	my ($places, $sortorder, $ips, $inviz) = $self->_examine3_user($user);

	my $r = {
		LASTSEEN => [$sortorder->[0]],
		PLACE    => {$sortorder->[0] => $places->{$sortorder->[0]}},
		INVIZ => $inviz,
	};
	return $r;
}    # end examine3_user4admin

# examine4 -> experimental, removed

sub examine5_overview {
	my $self = shift;

	my %r;
	my $s = $self->{DATA};

	foreach my $ip (keys %{ $s->{ip2uniq} }) {
		foreach my $uniq (keys %{ $s->{ip2uniq}->{$ip} }) {
			push(@{ $r{$uniq}->{ips} }, $ip);
		} # end foreach
	} # end foreach

	foreach my $uniq (keys %{ $s->{uniq}->{logins} }) {
		push(@{ $r{$uniq}->{login} }, @{ $s->{uniq}->{logins}->{$uniq} }[0,2]);
	} # end foreach

	foreach my $timer (reverse sort keys %{ $s->{uniq}->{locs} }) {
		foreach my $uniq (keys %{ $s->{uniq}->{locs}->{$timer} }) {
			if($r{$uniq}->{loc}->[0] < $timer) {
				my $p = (reverse sort keys %{ $s->{uniq}->{locs}->{$timer}->{$uniq} })[0];
				$r{$uniq}->{loc} = [$timer, $p];
			} # end if
		} # end foreach
	} # end foreach

	return %r;
} # end examine5_overview


sub examine5_ip {
	my $self = shift;
	my $ip = shift;
	my %r;

	return undef unless exists $self->{DATA}->{ip2uniq}->{$ip};

	foreach my $uniq (keys %{ $self->{DATA}->{ip2uniq}->{$ip} }) {
		$r{$uniq} = $self->examine5_uniq($uniq);
	} # end foreach

	return %r;
} # end examine5_ip

sub examine5_uniq {
	my $self = shift;
	my $uniq = shift;
	my %r;

	$r{'login'} = [@{$self->{DATA}->{uniq}->{logins}->{$uniq}}[0,2]];

	foreach my $timer (keys %{ $self->{DATA}->{uniq}->{locs} }) {
		foreach my $uid (keys %{ $self->{DATA}->{uniq}->{locs}->{$timer} }) {
			next unless $uid eq $uniq;
			foreach my $lid (keys %{ $self->{DATA}->{uniq}->{locs}->{$timer}->{$uid} }) {
				$r{'locs'}->{$timer}->{$lid}++;
			} # end foreach
		} # end foreach
	} # end foreach

	return \%r;
} # end examine5_uniq

sub _examine5_lids {
	my $self = shift;
	my @lids = @_;
	my %r;

	foreach my $lid (@lids) {
		$r{lids}->{$lid} = $self->{DATA}->{lids}->{$lid};
		foreach my $timer (keys %{ $r{lids}->{$lid} }) {
			foreach my $uniq (keys %{ $r{lids}->{$lid}->{$timer} }) {
				next if exists $r{uniq}->{$uniq};
				$r{uniq}->{$uniq} = $self->_examine5_uniqsimple($uniq);
			} # end foreach
		} # end foreach
	} # end foreach

	return \%r;
} # end _examine5_lids

sub examine5_forum {
	my $self = shift;
	my $spf = sprintf("%.4d", $_[0]);
	return $self->_examine5_lids(grep(/^$spf(\d{4}\.\d{4}|\d{6})$/, keys %{$self->{DATA}->{lids}}));
} # end examine5_forum

sub examine5_topic {
	my $self = shift;
	return $self->_examine5_lids(sprintf("%.4d%.6d", @_));
} # end examine5_topic

sub examine5_fsum {
	my $self = shift;
	return $self->_examine5_lids(grep(/^9999(\.\d+)?$/, keys %{$self->{DATA}->{lids}}));
} # end examine5_fsum

sub examine5_cat {
	my $self = shift;
	my $meow = shift;
	return $self;
} # end examine5_cat

sub _examine5_uniqsimple {
	my $self = shift;
	my $uniq = shift;
	my %r;

	foreach my $ip (keys %{ $self->{DATA}->{ip2uniq} }) {
		if(exists $self->{DATA}->{ip2uniq}->{$ip}->{$uniq}) {
			$r{ip} = $ip;
			$r{login} = [@{$self->{DATA}->{uniq}->{logins}->{$uniq}}[0,2]];
		} # end if
	} # end foreach

	return \%r;
} # end _examine5_uniqsimple

2;    # Defy convention.
# $Id: ubb_lib_pntf.cgi,v 1.8 2002/02/28 01:44:09 cvscapps Exp $
