# Miscellaneous UBB.classic routines

sub this_is_not_print_preview {
	# $_[0] = forum number, $_[1] = topic number

	# is input topic valid
	unless ($_[1] =~ /^\d{6}$/) {
		&StandardHTML("$vars_wordlets_err{invalid_topic_number}");
	}

	# is input forum number valid
	unless ($_[0] =~ /^\d{1,}$/) {
		&StandardHTML("$vars_wordlets_err{invalid_forum_number}");
	}

	#get forum details
	@this_forum = &GetForumRecord($_[0]);

	# determine exact path & check permission if necessary
	my $permission = $this_forum[6];
	$exact_path = "Forum$_[0]";
	if ($permission =~ m/private/) {

		$exact_path .= "/private-$this_forum[7]";

		# does user have permission to enter?
		&check_private_access($_[0], $this_forum[12]);

	}

	# does topic exist?
	unless (&FileExists("$vars_config{NonCGIPath}/$exact_path/$_[1].cgi")) {
		&StandardHTML("$vars_wordlets_err{topic_doesnt_exist}");
	}

	# Right, now do the thing...

	&LoadTemplate("public_print_topic");
	# Note use of OpenThread vs OpenTopic
	&print_topic(&OpenThread($_[1], $_[0]));

} # end this_is_not_print_preview



sub lost_password {
	%vars_style = &LoadStyleTemplate("transition");

	&set_page_elements;

	&LoadTemplate("public_lost_pw");
}    # end lost_password

sub find_lost {
	local ($row_email, $lc_row_email, $row_un, $match_total, $html_message, $confirm, $email_message, @user_profile, $match_results, $match_results_html);

	my %matches;

	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");

	#validate
	my @ValidateArray = ("email");
	&Validate(@ValidateArray);

	# get list of registered emails
	my @email_list = &GetEmailFileAsArray;

	#lowercase the input
	my $lc_email = lc($in{email});

	# find matches
	foreach (@email_list) {
		chomp;
		($row_email, $row_un) = split (/\|\|/, $_);
		$lc_row_email = lc($row_email);
		if ($lc_row_email eq $lc_email) {
			chomp($row_un);
			$matches{$row_un} = $lc_row_email;
		}
	}

	# now we have matches
	$match_total = scalar(keys %matches);

	# prepare for onscreen display & possible email display
	&set_page_elements;

	my $reallymatched = 0;

	# email confirmation- if we have a match
	if ($match_total > 0) {
		&floodcheck;

		# require mail routines--
		&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");
		&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");

		# onscreen wording
		$confirm = "$vars_wordlets{lost_pw_match} $in{email}";


		# assemble match data
		foreach (keys %matches) {
			@user_profile = &OpenProfile("$_");
			chomp($user_profile[0]);
			chomp($user_profile[2]);

			next unless lc($user_profile[2]) eq $matches{$_};

			$reallymatched++;

			$match_results .= qq!
$vars_wordlets{login_name}: $user_profile[0]
$vars_wordlets{password_field}: $user_profile[1]

!;

			$match_results_html .= qq!
$vars_wordlets{login_name}: <b>$user_profile[0]</b><br />
$vars_wordlets{password_field}: <b>$user_profile[1]</b>
<br /><br />
!;

		} # end foreach

		if($reallymatched > 0) {
			my $s = &EmailWordletFixer;
			eval($s);
			if(defined &EmailWordletFiller) {
				%vars_wordlets_email = &EmailWordletFiller();
			} else {
				&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
			} # end if

			if ($vars_email{email_format} eq 'ascii') {
				$email_message = qq!$vars_wordlets_email{lost_pw_intro}\n\r\n$match_results$vars_wordlets_email{signature_text}!;
			} else {
				$email_message = '';
			}

			if ($vars_email{email_format} eq "html") {
				my $html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{lost_pw_intro_html}" . "<br />$match_results_html<br />" . "$vars_wordlets_email{signature_html}<br />" . qq!</font>!;

				# set email template
				%vars_style = &LoadStyleTemplate("email");
				&set_page_elements;

				$html_message = "$EmailHeader $html_body $Footer";
			} else {
				$html_message = '';
			}

			&ubb_mail_tng({
				'EmailTo' => $in{email},
				'EmailFrom' => $vars_display{BBEmail},
				'EmailReplyTo' => $vars_display{BBEmail},
				'BCCList' => undef,
				'Subject' => $vars_wordlets_email{lost_pw_subject},
				'TextMessage' => $email_message,
				'HTMLMessage' => $html_message,
				'CCList' => undef,
			});
		} else {
			$confirm = "$vars_wordlets{lost_pw_no_match}";
		} # end if
	} else {
		$confirm = "$vars_wordlets{lost_pw_no_match}";
	} # end if

	# send onscreen confirmation
	%vars_style = &LoadStyleTemplate("transition");

	&set_page_elements;
#	&LoadTemplate("public_found_pw");
	&StandardHTML($confirm);

}    # end find_lost

sub ubb_code_page {
	local (*FILE);

	&ServeFromCache("ubb_files/misc/ubb_code_page.cgi");

	# get assigned style template!
	%vars_style = &LoadStyleTemplate("ubb_code");
	&set_page_elements;


	&LoadTemplate("public_ubb_code_page");

	$ThisHTML = $Header;

	$ThisHTML .= &ubb_code_body;
	$ThisHTML .= $Footer;


	# is ubb_files/misc directory created?
	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc")) {

		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc", 0777);
		chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc");

	}

	unless (-w "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_code_page.cgi") {
		&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_code_page.cgi");
	}

	&WriteFileAsString("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_code_page.cgi", $ThisHTML);
	chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/ubb_code_page.cgi");

	print "$ThisHTML";
	exit(0);

}    # end ubb code page

sub faq {

	# is the page available?
		&ServeFromCache("ubb_files/misc/faq.cgi");

		# get assigned style template!
		%vars_style = &LoadStyleTemplate("faq");

		&set_page_elements;
		&LoadTemplate("public_faq");

		$ThisHTML = $Header;

		$ThisHTML .= &faq;
		$ThisHTML .= $Footer;


		# is ubb_files/misc directory created?
		unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc")) {
			mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc", 0777);
			chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc");
		}

		unless (-w "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/faq.cgi") {
			&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/faq.cgi");
		}

		&WriteFileAsString("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/faq.cgi", $ThisHTML);

		print "$ThisHTML";
		exit(0);


}    # end faq page

sub clear_cookies {
	my @all_cookies = cookie();
	my @cookies;

	# Determine our domain name, then strip off the last subdomain
	# This will be used to forcefully clear the proper cookie,
	# esp if users enjoy coming in at the wrong domain...
	my $cgi = $vars_config{CGIURL};
	$cgi =~ s!^(https?:\/\/[^\/]+)\/.+!$1!;
	$cgi =~ m!^(https?):\/\/(.+)$!;
	my($protocal, $domain) = ($1, $2);
	my @dom = split(/\./, $domain); shift @dom;
	my $doma = join(".", @dom);
	my $newcgi = ($doma =~ m/\./ ? $doma : $domain);

	my $counter = 0;
	foreach (@all_cookies) {
		# Only clear cookies set by the board
		next unless $_ =~ m/$vars_config{Cookie_Number}/;
		# Don't clear the COPPA age check cookie
		next if $_ =~ m/^age/i;

		# First, set a pathed one...
		push(@cookies, cookie(
			-name    => "$_",
			-value   => [''],
			-path    => '/',
			-expires => '-10y'
		));

		# ... then an unpathed ...
		push(@cookies, cookie(
			-name    => "$_",
			-value   => [''],
			-expires => '-10y'
		));

		# ... and now one at the non-subdomain...
		push(@cookies, cookie(
			-name    => "$_",
			-value   => [''],
			-domain  => $newcgi,
			-path	 => '/',
			-expires => '-10y'
		));

		# ... and a pathed non-subdomain.  Phew!.
		push(@cookies, cookie(
			-name    => "$_",
			-value   => [''],
			-domain  => $newcgi,
			-expires => '-10y'
		));
		$counter++;
	} # end foreach

#	use Data::Dumper;
#	die Dumper(\@cookies);
#	die join("\n", @cookies);

	print header(
		-cookie  => [@cookies],
		-charset => "$masterCharset",
		-type    => "text/html",
	);


	%vars_style = &LoadStyleTemplate("transition");

	&set_page_elements;

	# take viewer back to topic
	$in{refer} = qq!$vars_config{CGIURL}/ultimatebb.cgi!;
	&StandardHTML(&Template($vars_wordlets{cookies_cleared2}, {NUMBER => $counter}));

	exit(0);
}    # end clear_cookies



sub mark_all_read {
	my ($last_login_dt, $last_login_j, $session_login_dt, $session_login_j);
	my (@login,         @session);

	@login = cookie("login$vars_config{Cookie_Number}");
	if ($login[0] ne '') { $last_login_dt = $login[0]; }
	if ($login[1] ne '') { $last_login_j  = $login[1]; }

	@session = cookie("session$vars_config{Cookie_Number}");
	if ($session[0] ne '') { $session_login_dt = $session[0]; }
	if ($session[1] ne '') { $session_login_j  = $session[1]; }

	# in case this is a new visitor!
	if ($last_login_dt eq '') { $last_login_dt = 'NEW'; }

	# set session cookie:
	# this is a temp cookie that stores previous last login

	my $cookie1 = cookie(
		-name  => "session$vars_config{Cookie_Number}",
		-value => [$last_login_dt, $last_login_j],
		-path  => '/'
	);

	# set new last login
	my $cookie2 = cookie(
		-name    => "login$vars_config{Cookie_Number}",
		-value   => [$GotTime{LastLoginDT}, $GotTime{LastLoginJulian}],
		-path    => '/',
		-expires => '+1y'
	);

	my $cookie3;

	# reconfirm user data- in case profile details were changed
	if ($username ne '') {
		my @this_profile = &verify_id_num_2($username, $password, $user_number);
		foreach (@this_profile) { chomp; }
		if (!$this_profile[15]) {
			$this_profile[15] = "$this_profile[0]";
		}
		$cookie3 = cookie(
			-name    => "ubber$vars_config{Cookie_Number}",
			-value   => [$this_profile[0], $this_profile[1], $this_profile[15], $this_profile[21], $user_number, $this_profile[34]],
			-path    => '/',
			-expires => '+2y'
		);
	}


	#print header(-cookie=>[$cookie1, $cookie2, $cookie3]);
	print header(
		-cookie  => [$cookie1,      $cookie2, $cookie3],
		-charset => "$masterCharset"
	);

	&Transition("$vars_config{CGIURL}/ultimatebb.cgi", "$vars_wordlets{updated_post_icons}", "$vars_config{CGIURL}/ultimatebb.cgi");

	exit(0);

}    #endsub


sub avatar_select_menu {
	%vars_style = &LoadStyleTemplate("transition");
	&set_page_elements;
	&LoadTemplate("public_avatar_select");

	if(!&FileExists("$vars_config{NonCGIPath}/Avatars/ot_avatars_lib.js")) {
		&RequireCode("$vars_config{CGIPath}/cp_upgrade.cgi");
		&RequireCode("$vars_config{CGIPath}/cp_upgrade_data.cgi");
		&c_u_d_6290_CheckAvatarDir;
	} # end if

	opendir(AVATARS, "$vars_config{NonCGIPath}/Avatars") or die "$! opening Avatars";
	my @files = grep(/^[\w\d_-]+$vars_display{AvatarFileExts}$/, readdir(AVATARS));
	closedir(AVATARS);
	my @avlist = sort { lc($a) cmp lc($b) } @files;
	my $htmlbits = join('", "', @avlist);

#	use Data::Dumper;
#	die scalar(@avlist) . " " . Dumper(\@avlist);

	&avatar_select_html($htmlbits, $in{cp});
	exit;
} # end avatar_select_menu


sub dump_cookies {
	# Diagnostic cookie handler
	print header;
	my %name = (
		session => ["Session DT", "Session Julian", "&nbsp;"],
		PnTf => ["UNIQid", "IP", "PNTFTimer", "Usernum", "Unreg?", "Hidden?", "&nbsp;"],
		ubber => ["Login Name", "passwd", "PDN", "DaysPrune", "Usernum", "?", "AvatarView", "&nbsp;"],
		login => ["Login DT", "Login Julian", "&nbsp;"],
		ubbadmin => ["Username", "passwd", "Status", "PDN", "Number", "&nbsp;"],
	);
	my @allcookies = cookie();
	my @mycookies = grep(/$vars_config{Cookie_Number}/, @allcookies);
	my $totalcount = scalar(@allcookies);
	my $mycount = scalar(@mycookies);
	my $output;
	foreach my $mine (@mycookies) {
		my @cookievals = cookie($mine);
		my $ours = $mine;
		$ours =~ s/[\d_\.]//g;	# nuke the numbers and _s.
		my @names = @{$name{$ours}};
		my $l = scalar(@cookievals) + 1;
		$output .= qq~<table border="1"><tr><td colspan="$l"><b>$mine</b></td></tr>~;
		$output .= qq~<tr><td>~ . join("</td><td>", @names) . qq~</td></xmp></tr><tr>~;
		my $cnt = 0;
		foreach my $crumb(@cookievals) {
			my $x = $crumb;
			if(($cnt == 1) && (($ours eq "ubber") || ($ours eq "ubbadmin"))) {
				$x = "--";
			} # end if
			$output .= qq~<td><xmp>$x</xmp></td>~;
			$cnt++;
		} # end foreach
		$output .= qq~<td>&nbsp;</td></tr></table><br />~;
	} # end foreach

	&StandardHTML("Your browser sent me $totalcount cookies.<br /><br />Of those, I own $mycount:<br />$output");

} # end dump_cookies

sub avatar_remote_url_filter {
	my $orig = shift;
	my $filtered = &EscapeFilter($orig);
	return( (($orig =~ m/$vars_display{AvatarRemoteFileExts}$/) && ($filtered =~ m/$vars_display{AvatarRemoteFileExts}$/)) ? 1 : 0 );
} # end avatar_remote_url_filter

# DANGER: Do not remove the next line!
1;
# $Id: ubb_lib_misc.cgi,v 1.20 2002/05/07 17:50:39 cvscapps Exp $
