# Thanks to Dave Dreezer for his work on UBB.classic Mail!

# And now, version 4.0...

sub ubb_mail {	# old interface
	return &ubb_mail_tng({
		'EmailTo' => $_[0],
		'EmailFrom' => $_[1],
		'EmailReplyTo' => $_[2],
		'BCCList' => $_[3],
		'Subject' => $_[4],
		'TextMessage' => $_[5],
		'HTMLMessage' => $_[6],
		'CCList' => $_[7],
	});
}    # end ubb_mail subroutine

sub ubb_mail_tng {
	my $params = shift;

	use lib "$vars_config{CGIPath}/Modules/";
	use Modules::MIME::Lite;

	# Figure out who called us so that we can blame errors on them
	my $file = (caller(1))[3]; my $line = (caller(0))[2];
	if($file =~ m/ubb_mail/) { $file = (caller(2))[3]; $line = (caller(1))[2] }
	my $thatcaller = "$file $line";

	# Figure out which message we really got...
	$params->{HTMLMessage} = &strip_lead_trail_whitespace($params->{HTMLMessage});
	$params->{HTMLMessage} = ($params->{HTMLMessage} ? "$params->{HTMLMessage}\n" : undef);
	$params->{TextMessage} = &strip_lead_trail_whitespace($params->{TextMessage});
	$params->{TextMessage} = ($params->{TextMessage} ? "$params->{TextMessage}\n" : undef);

	if((!defined $params->{HTMLMessage}) && (!defined $params->{TextMessage})) {
		die "No mail content from $thatcaller\n";
	} # end if

	if(!$params->{Subject}) {
		die "No subject from $thatcaller\n";
	} # end if

	if($in{email_type}) {
		$vars_email{email_format} = ( $in{email_type} ne "text" ? "html" : "ascii" );
	} # end if

	if($vars_email{email_format} eq "ascii") {
		if(!defined $params->{TextMessage}) {
			die "Told to send ASCII, got no ASCII from $thatcaller\n";
		} # end if
		$params->{MIMEType} = q!text/plain!;
	} elsif($vars_email{email_format} eq "html") {
		if(!defined $params->{HTMLMessage}) {
			die "Told to send HTML, got no HTML from $thatcaller\n";
		} # end if
		$params->{MIMEType} = q!multipart/mixed!;
	} else {
		die "I don't know what mail format '$vars_email{email_format}' is.\n";
	} # end if

	if(!$params->{EmailFrom}) {
		die "I won't send mail without a From address from $thatcaller.\n";
	} # end if

	# Make sure the EmailFrom doesn't fail email_check
	if(&email_test($params->{EmailFrom})) {
		if($params->{EmailFrom} eq $vars_display{BBEmail}) {
			die "BB Email address is not properly formed ($params->{BBEmail}).  I won't send mail from $thatcaller.\n";
		} elsif($params->{EmailFrom} eq $vars_registration{RegsAdminEmail}) {
			die "Registration Email address is not properly formed ($params->{RegsAdminEmail}).  I won't send mail from $thatcaller.\n";
		} else {
			if(!&email_test($vars_display{BBEmail})) {
				$params->{EmailFrom} = $vars_display{BBEmail};
			} else {
				die "I won't send mail using an improperly formed From address ($params->{EmailFrom}) from $thatcaller\n";
			} # end if
		} # end if
	} # end if

	if(!$params->{EmailReplyTo}) {
		$params->{EmailReplyTo} = $params->{EmailFrom};
	} # end if

	if(!$params->{EmailTo}) {
		die "I won't send mail without a To address from $thatcaller.\n";
	} # end if

# Removed 020415 - chokes over multiple addresses
#	if(&email_test($params->{EmailTo})) {
#		die "I won't send mail to an improperly formed address ($params->{EmailTo}) from $thatcaller.\n";
#	} # end if

	# We got past the sanity checks, so send the real mail...
	&ubb_mail_core($params);
} # end ubb_mail_tng

sub ubb_mail_core {
	my $params = shift;

	# Now the sending bits
	my $msg = MIME::Lite->new(
		"To"		=> $params->{EmailTo},
		"From"		=> $params->{EmailFrom},
		"Reply-To"	=> $params->{EmailReplyTo},
		"CC"		=> $params->{CCList},
		"BCC"		=> $params->{BCCList},
		"Subject"	=> $params->{Subject},
		"Type"		=> "$params->{MIMEType}; encoding=$masterCharset",
	);

	if($vars_email{email_format} eq "ascii") {
		# sending plaintext email - inline it
		$params->{TextMessage} = UBBCGI::unescapeHTML($params->{TextMessage});
		$params->{TextMessage} =~ s/\r//g;
		$msg->data([$params->{TextMessage}]);
	} elsif($vars_email{email_format} eq "html") {
		# sending HTML - attach it
		$params->{HTMLMessage} =~ s/\r//g;
		my $html_message = $msg->attach(
			Type => 'text/html',
			Data => [$params->{HTMLMessage}]
		);
	} # end if

	# figure out which method we're using
	if ($vars_email{SMTPEmail} eq 'On') {
		# SMTP
		MIME::Lite->send('smtp', "$vars_email{EmailServer}");
	} elsif(($vars_email{SendMailLocation} ne "") && (&FileExists($vars_email{SendMailLocation}))) {
		# Sendmail
		MIME::Lite->send('sendmail', "$vars_email{SendMailLocation} -t -oi");
	} else {
		# No SMTP, no sendmail, no mail for you!
		&StandardHTML($vars_wordlets_err{tell_admin_to_config_email});
		exit;
	} # end if

	return $msg->send;	# send the mail itself
} # end ubb_mail_core

1;
# $Id: ubb_lib_mail.cgi,v 1.15 2002/05/03 18:27:33 cvscapps Exp $
