# UBB.classic common I/O and thread data handling routines


sub CreateLastTimeFiles {
	my $forum = shift;
	unless($forum =~ m/^\d{1,}$/) {
		&StandardHTML("Not a forum number: '$forum'");
		exit(0);
	}
	my @topics;

	my @forumfacts = &GetForumRecord($forum);

	my $this_forum_topics = &GetForumTopics($forum);
	%forum_topics = %$this_forum_topics;

	&SetExactPath($forum);

	if ($forumfacts[15] eq 'abc') {
		@topics = sort { $forum_topics{$a} cmp $forum_topics{$b} } keys %forum_topics;
	} else {
		@topics = sort { $forum_topics{$b} <=> $forum_topics{$a} } keys %forum_topics;
	}

	my $lastnumber = shift @topics;
	unshift (@topics, $lastnumber);

	if (!$lastnumber) {

		#whoa, no threads?
		&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/lasttime.file",   "\n");
		&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/lastnumber.file", "\n");
		return;
	}

	my @tdata = &GetThreadData($forum, $lastnumber);

	my @lasttime = ($tdata[12], $tdata[13]);
	&WriteFileAsArray("$vars_config{NonCGIPath}/$exact_path/lasttime.file", @lasttime);

	my ($total_posts, $total_topics) = &GetTotalTopicsPosts($forum);
	$total_posts += $total_topics;

	my $pub_name = $tdata[15] || $tdata[11];
	my $icon     = $tdata[17]  || 1;

	my $reallast = (reverse(sort(@topics)))[0];

	my @lastnumb = ($reallast, $total_topics, $total_posts, $tdata[3], $pub_name, $icon, $lastnumber);
	&WriteFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file", @lastnumb);

}

sub UpdateForumTopics {
	my $forum     = shift;
	my $topicdata = shift;
	my $dontwrite = shift;

	$forum_threads->{$forum} = $topicdata;

	&SetExactPath($forum);
	my $path = "$vars_config{NonCGIPath}/$exact_path/forum_$forum.threads";

	if(&FileExists($path)) { &Unlink($path) or die &Template($vars_wordlets_criterr{bad_unlink}, {FILE => $path, OSERR => $!}); }
	&WriteHashToFile($path, "forum_topics", $topicdata) unless $dontwrite;
}

sub GetThreadData {

	my ($forum, $topic) = @_;

	die &Template("$vars_wordlets_criterr{get_thread_data_baddie}\n" . &Tracer, { FORUM => $forum, TOPIC => $topic}) unless $topic =~ m/^(\d{4})(\d{2})$/;
	my ($lefty, $righty) = ($1, $2);

	unless (exists $forum_thread_data{$forum}->{$lefty}) {
		$exact_path = "";
		$exact_path = &SetExactPath($forum);
		if((!&FileExists("$vars_config{NonCGIPath}/$exact_path/forum_thread_data_$lefty.cgi")) && ($in{ubb} !~ m/^submit_new_(topic|reply)$/)) {
			if (!&FileExists("$vars_config{NonCGIPath}/$exact_path/upgrade.txt")) {
				&StandardHTML("$vars_wordlets_err{no_forum_thread_data_files} $forum (NUPG)");
				exit;
			}
			&StandardHTML("$vars_wordlets_err{no_forum_thread_data} $lefty, $righty, $forum");
			exit;
		}

		&RequireVars("$vars_config{NonCGIPath}/$exact_path/forum_thread_data_$lefty.cgi");    #locks
	}

	return @{$forum_thread_data{$forum}->{$lefty}->{$righty}};
}


sub SafeGetThreadData {

	#like GetThreadData, only just loads the file into memory
	#doesn't return any data
	#won't die if there's no file
	my ($forum, $topic) = @_;

	die &Template($vars_wordlets_criterr{not_valid_topic}, {TOPIC => $topic, FORUM => $forum}) unless $topic =~ m/^(\d{4})(\d{2})$/;
	my ($lefty, $righty) = ($1, $2);

	&SetExactPath($forum);
	unless (exists $forum_thread_data{$forum}->{$lefty}) {
		if (!&FileExists("$vars_config{NonCGIPath}/$exact_path/forum_thread_data_$lefty.cgi")) {
			return;
		}

		&RequireVars("$vars_config{NonCGIPath}/$exact_path/forum_thread_data_$lefty.cgi");    #locks
	}

	return;
}


sub SafeGetThreadData2 {

	# Clone of SafeGetThreadData
	# Returns data but doesn't die
	# (for PNTF)
	my ($forum, $topic) = @_;

	die &Template($vars_wordlets_criterr{not_valid_topic}, {TOPIC => $topic, FORUM => $forum}) unless $topic =~ m/^(\d{4})(\d{2})$/;
	my ($lefty, $righty) = ($1, $2);

	&SetExactPath($forum);
	unless (exists $forum_thread_data{$forum}->{$lefty}) {
		if (!&FileExists("$vars_config{NonCGIPath}/$exact_path/forum_thread_data_$lefty.cgi")) {
			return;
		}

		&RequireVars("$vars_config{NonCGIPath}/$exact_path/forum_thread_data_$lefty.cgi");    #locks
	}

	return @{$forum_thread_data{$forum}->{$lefty}->{$righty}};
}

sub GetTotalTopicsPosts {
	my $forum = shift;

	my ($totalposts, $totaltopics);

	&SetExactPath($forum);

	opendir(DIR, "$vars_config{NonCGIPath}/$exact_path") or die &Template($vars_wordlets_criterr{cant_open}, {ERR => $!, THING => $exact_path});
	my @datafiles = grep(/^forum_thread_data_\d{4}\.cgi$/, readdir(DIR));
	closedir(DIR);

	foreach (@datafiles) {
		&RequireVars("$vars_config{NonCGIPath}/$exact_path/$_");    #locks
	}

	foreach my $thisentry (sort keys %{$forum_thread_data{$forum}}) {
		foreach my $entry (sort keys %{$forum_thread_data{$forum}->{$thisentry}}) {
			$forum_thread_data{$forum}->{$thisentry}->{$entry}[5] = 0
				unless $forum_thread_data{$forum}->{$thisentry}->{$entry}[5];
			$totaltopics++;
			$totalposts += $forum_thread_data{$forum}->{$thisentry}->{$entry}[5];
		}    #endforeach
	}    #endforeach

	return ($totalposts, $totaltopics);
}    #endsub


sub ClearMetaData {
	my $forum = shift;

	$exact_path = &SetExactPath($forum);

	opendir(DIR, "$vars_config{NonCGIPath}/$exact_path") or die &Template($vars_wordlets_criterr{cant_open}, {ERR => $!, THING => $exact_path});
	my @data = grep(/forum_thread_data/, readdir(DIR));
	closedir(DIR);

	foreach(@data) {
		&Unlink("$vars_config{NonCGIPath}/$exact_path/$_") or die &Template($vars_wordlets_criterr{bad_unlink}, {FILE => $_, OSERR => $!});
	}

	return;
}


sub NiceForumThreadsRebuild {
	my $forum = shift;

	my (%thistopics);

	&SetExactPath($forum);

	opendir(DIR, "$vars_config{NonCGIPath}/$exact_path") or die &Template($vars_wordlets_criterr{cant_open}, {ERR => $!, THING => "$vars_config{NonCGIPath}/$exact_path"});
	my @thisforum = readdir(DIR);
	my @datafiles = grep(/^forum_thread_data_\d{4}\.cgi$/, @thisforum);
	my @cgifiles  = grep(/^\d{6}\.cgi$/, @thisforum);
	closedir(DIR);

	if ((!&FileExists("$vars_config{NonCGIPath}/$exact_path/upgrade.txt")) && ($cgifiles[0] =~ m/\d{6}\.cgi/) && ($in{ubb} !~ m/(stats|submit_new_topic|submit_new_reply|poll)/)) {

		# no upgrade.txt -> no rebuild yet!
		&StandardHTML("$vars_wordlets_err{no_forum_thread_data_files} $forum (NOUPG2)");
		exit;
	}

	my $excounter = 0;
	foreach (@datafiles) {
		$excounter++;
		&RequireVars("$vars_config{NonCGIPath}/$exact_path/$_");    #locks!
	}

	if (($excounter < 1) && ($cgifiles[0] =~ m/^\d{6}\.cgi$/) && ($in{ubb} !~ m/(stats|submit_new_topic|submit_new_reply)/)) {

		# .cgi files but no forum_thread data -> no rebuild yet!
		&StandardHTML("$vars_wordlets_err{no_forum_thread_data_files} $forum (NOFTD)");
		exit;
	}

	my @forumfacts = &GetForumRecord($forum);

	foreach my $firstfour (keys %{$forum_thread_data{$forum}}) {
		foreach my $lasttwo (keys %{$forum_thread_data{$forum}->{$firstfour}}) {
			my @threaddata = @{$forum_thread_data{$forum}->{$firstfour}->{$lasttwo}};

			if(($forumfacts[15]) && ($forumfacts[15] eq 'abc')) {
				$thistopics{"$firstfour$lasttwo"} = lc($threaddata[3]);
			} else {
				$thistopics{"$firstfour$lasttwo"} = $threaddata[14];
			}

		}    #endforeach
	}    #endforeach

	my $refer = \%thistopics;

	return ($refer);

}    #endsub

sub ForumSanityCheck {
	my $forum = shift;

	my (%thistopics, $returnval);

	$returnval = 0;

	&SetExactPath($forum);

	opendir(DIR, "$vars_config{NonCGIPath}/$exact_path") or die &Template($vars_wordlets_criterr{cant_open}, {ERR => $!, THING => "$vars_config{NonCGIPath}/$exact_path"});
	my @thisforum = readdir(DIR);
	my @datafiles = grep(/^forum_thread_data_\d{4}\.cgi$/, @thisforum);
	my @cgifiles  = grep(/^\d{6}\.cgi$/, @thisforum);
	closedir(DIR);

	if (((scalar(@datafiles) < 1) && (scalar(@cgifiles) > 0)) || (!&FileExists("$vars_config{NonCGIPath}/$exact_path/upgrade.txt"))) {
		# .cgi files but no forum_thread data || no upgrade.txt -> no rebuild yet!
		$returnval = 1;
	} # end if

	return $returnval;
}    #endsub


sub GetForumTopics {
	my $forum = shift;

#	$filehandle->warn("GFT: I just got called.");

	if (exists $forum_threads->{$forum}) {
#		$filehandle->warn("GFT: Looks like I've got a copy, returning it");
		return $forum_threads->{$forum};
	}

	local (%forum_topics);    #use our own copy rather than make the required file global

	&SetExactPath($forum);
	my $full_path = "$vars_config{NonCGIPath}/$exact_path/forum_$forum.threads";

	unless (&FileExists($full_path)) {
#		$filehandle->warn("GFT: My .threads file doesn't exist, rebuilding");
		&GenerateDotThreadsFile($forum);
	} else {

		# string terminators will never bother us again!  BUAHAHAHA!
		my $result = eval {
			local $SIG{'__DIE__'} = sub { return; };
			local $SIG{'__WARN__'} = sub { return; };
			my $token = &OpenAndLock($full_path);
			do $full_path;
			&CloseAndUnlock($token);
		};

#		$filehandle->warn("GFT: The file existed and I tried to open it...");

		if($@ || !$result || !%forum_topics || (scalar(keys %forum_topics) < 1)) {	#if the eval erred
#			$filehandle->warn("GFT: But that failed");
#			$go_away->relock('EX');

			#my $uniq = &BackupFile($forum, "forum_$forum.threads", &OpenFileAsVar($full_path));
			#&AppendFileAsString("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/lock/rebuildlog_$forum.cgi", "Rebuilt($uniq): " . localtime() . "\n");
			my $this_topics = &NiceForumThreadsRebuild($forum);
#			$filehandle->warn("GFT: So let's regenerate it!");
			&UpdateForumTopics($forum, $this_topics);	# aka $forum_threads->{$forum} = $this_topics
#			$filehandle->warn("GFT: Okay, I just regenerated it.");
			#$go_away->relock('SH');
		} else {
#			$filehandle->warn("GFT: ... and it worked!");
			$forum_threads->{$forum} = \%forum_topics;
		}

	}

#	$filehandle->warn("GFT: Done with all that.  Let's clean up.");
#	$filehandle->warn("GFT: And awaaayyy we go!");
	return ($forum_threads->{$forum});
}

sub GenerateDotThreadsFile {
	my $forum = shift;
	my $this_topics = &NiceForumThreadsRebuild($forum);
	&UpdateForumTopics($forum, $this_topics);
}


sub WriteForumThreadData {
	my ($forum, $number) = @_;

	&SetExactPath($forum);

	my $string = qq!\n\$forum_thread_data{"$forum"}->{"$number"} = {\n!;

	THIS: foreach my $entry (sort keys %{$forum_thread_data{$forum}->{$number}}) {
		next THIS unless @{$forum_thread_data{$forum}->{$number}->{$entry}}[0] eq "A";
		$string .= qq!\t'$entry' => [!;
		my $thiscount = 0;
		foreach my $item (@{$forum_thread_data{$forum}->{$number}->{$entry}}) {
			chomp($item);
			$string .= qq!q~! . &SmallClean2($item) . q!~, !;
			$string .= qq!\n\t\t! if ($thiscount == 3);
			$thiscount == 3 ? $thiscount = 0 : $thiscount++;
		}    #endforeach
		$string .= qq!],\n!;
	}    #endforeach

	$string .= qq!}\;\n1\;\n\n\n!;

	#unlink("$vars_config{NonCGIPath}/$exact_path/forum_thread_data_$number.cgi") or die "$!";
	&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/forum_thread_data_$number.cgi", $string);

	return;
}

sub WriteAllForumThreadData {
	my $forum = shift;

	&SetExactPath($forum);

	foreach my $entry (sort keys %{$forum_thread_data{$forum}}) {
		next unless $entry =~ m/^\d{4}$/;    #jic
		&WriteForumThreadData($forum, $entry);
	}    #endforeach
}


sub UpdateForumThreadDataForSingleThreadAndWrite {
	my ($forum, $thread, $dataref) = @_;

	die &Template($vars_wordlets_criterr{unknown_thread_format}, {STRING => $thread}) unless $thread =~ m/^(\d{4})(\d{2})$/;
	my ($lefty, $righty) = ($1, $2);

	&SetExactPath($forum);

	my $fullpath = "$vars_config{NonCGIPath}/$exact_path";

	@data2 = @$dataref;

	&SafeGetThreadData2($forum, $thread);           #load it again, if it hasn't been retrieved
	&UpdateForumThreadDataForSingleThread($forum, $lefty, $righty, @data2);
	&WriteForumThreadData($forum, $lefty);

}    #endsub

sub UpdateForumThreadDataForSingleThread {
	my ($forum, $leftnum, $rightnum, @thread) = @_;

	die &Template($vars_wordlets_criterr{bad_aline}, {ALINE => $thread[0]}) unless $thread[0] =~ m/^A/;

	@Aline      = split (/\|\|/, shift (@thread));
	@firstZline = split (/\|\|/, shift (@thread));
	if ($thread[0]) {
		@lastZline = split (/\|\|/, pop (@thread));
	} else {
		@lastZline = @firstZline;
	}
	@thread = undef;

	foreach (0 .. 15) { $Aline[$_]      = "" unless $Aline[$_] ne '';      chomp $Aline[$_]; }
	foreach (0 .. 15) { $firstZline[$_] = "" unless $firstZline[$_] ne ''; chomp $firstZline[$_]; }
	foreach (0 .. 15) { $lastZline[$_]  = "" unless $lastZline[$_] ne '';  chomp $lastZline[$_]; }

	my $firstjul = &ConvertPostTimetoJulian($firstZline[3], $firstZline[4]);
	my $lastjul  = &ConvertPostTimetoJulian($lastZline[3],  $lastZline[4]);

	my $goodarray = [$Aline[0], $Aline[1], $Aline[3], $Aline[4],
	($firstZline[9]||1), $Aline[2], $firstZline[3], $firstZline[4],
	$firstjul, $Aline[8], $Aline[9], $lastZline[2],
	$lastZline[3], $lastZline[4], $lastjul, $lastZline[10],
	$lastZline[11], ($lastZline[9]||1), $Aline[10]];

	$forum_thread_data{$forum}->{$leftnum}->{$rightnum} = $goodarray;

	return;
}    #3ndsub


sub WriteHashToFile {    #writes the data from a hash to a file
	&WriteHashesToFile($_[0], [$_[1]], [$_[2]]);
	return;
}    #endsub

sub WriteHashesToFile {    #writes hasheS to a single file
	local (*FILE);
	my ($path, $nameref, $hashrefs) = @_;

	my(@hashes, @names);

	foreach my $name (@{$nameref}) {
		push(@names, "%" . $name);
	} # end foreach

	my $outcount = 0;
	foreach my $hash (@{$hashrefs}) {
		push(@hashes, $hash);
		$outcount++;
	} # end foreach

	&RequireCode("$vars_config{CGIPath}/ubb_lib_dumper.cgi");
	my $obj = Data::ThatWhichDumps->new(\@hashes, [@names]);

	my $hashes; scalar(@hashes) < 2 ? $hashes = 'hash' : $hashes = 'hashes';

	my $v = $obj->Dump;

	my $handle = $filehandle->open($hashes, 'writeonly', $path);
	$handle->truncate();
	$handle->print("$v\n1\;\n");
	$filehandle->close($handle);

	chmod(SIXSIXSIX, "$path") if $path !~ m/\.cgi$/;
	chmod(SEVENSEVENSEVEN, "$path") if $path =~ m/\.cgi$/;

	return;
}    #endsub

sub WriteFileAsHashKV {    #writes to a file using a key|value method
	local (*FILE);
	my ($path, $delimiter, $hashref) = @_;
	my %hash = %$hashref;


	my $countish;

	my $handle = $filehandle->open('file', 'writeonly', $path);
	$handle->truncate();
	foreach my $key (sort keys %hash) {
		next if $key eq "";
		$countish++;
		$handle->print("$key$delimiter$hash{$key}\n");
	}
	$filehandle->close($handle);
	chmod(SIXSIXSIX, "$path") if $path !~ m/\.cgi$/;
	chmod(SEVENSEVENSEVEN, "$path") if $path =~ m/\.cgi$/;

	return;
}    #endsub

sub WriteFileAsHashVK {    #writes to a file using a value|key method
	local (*FILE);
	my ($path, $delimiter, $hashref) = @_;
	my %hash = %$hashref;

	my $handle = $filehandle->open('file', 'writeonly', $path);
	$handle->truncate();
	foreach my $key (sort keys %hash) {
		$countish++;
		$handle->print("$hash{key}$delimiter$key\n");
	}
	$filehandle->close($handle);

	chmod(SIXSIXSIX, "$path") if $path !~ m/\.cgi$/;
	chmod(SEVENSEVENSEVEN, "$path") if $path =~ m/\.cgi$/;

	return;
}    #endsub

sub WriteFileAsArray {    #writes an array to a file
	local (*FILE);
	my ($path, @array) = @_;

	foreach(@array) { chomp; }

	my $handle = $filehandle->open('file', 'writeonly', $path);
	$handle->truncate();
	$handle->print(join("\n", @array) . "\n");
	$filehandle->close($handle);

	chmod(SIXSIXSIX, "$path") if $path !~ m/\.cgi$/;
	chmod(SEVENSEVENSEVEN, "$path") if $path =~ m/\.cgi$/;

	return;
}    #endsub

sub WriteFileAsString {    #writes a string to a file
	local (*FILE);
	my ($path, $string) = @_;

	my $handle = $filehandle->open('file', 'writeonly', $path);
	$handle->truncate();
	$handle->print($string);
	$filehandle->close($handle);

	chmod(SIXSIXSIX, "$path") if $path !~ m/\.cgi$/;
	chmod(SEVENSEVENSEVEN, "$path") if $path =~ m/\.cgi$/;

	return;
}    #endsub

sub AppendFileAsString {    #appends a string to a file
	local (*FILE);
	my ($path, $string) = @_;

	my $handle = $filehandle->open('file', 'writeappend', $path);
	$handle->print($string);
	$filehandle->close($handle);

	chmod(SIXSIXSIX, "$path") if $path !~ m/\.cgi$/;
	chmod(SEVENSEVENSEVEN, "$path") if $path =~ m/\.cgi$/;

	return;
}    #endsub

sub AppendFileAsArray {    #appends an array to a file
	local (*FILE);
	my ($path, @string) = @_;

	my $handle = $filehandle->open('file', 'writeappend', $path);
	foreach(@string) {
		chomp;
		$handle->print("$_\n");
	} # end foreach
	$filehandle->close($handle);

	chmod(SIXSIXSIX, "$path") if $path !~ m/\.cgi$/;
	chmod(SEVENSEVENSEVEN, "$path") if $path =~ m/\.cgi$/;

	return;
}    #endsub

sub sh_lock {
	flock(FILE, LOCK_SH) or die "Can't obtain shared lock: $!";
}    #end shared lock sr

sub lock {
	flock(FILE, LOCK_EX) or die "Can't obtain exclusive lock: $! ";
}    #end lock sr

sub unlock {
	flock(FILE, LOCK_UN) or die "Can't release lock: $!";
}    # end unlock sr

sub OpenAndLock {    #used to keep a lock on required files
	my $file   = shift;
#	my $token = $filehandle->open('file', 'readonly', $file);
	my $pretoken = &GeneratePasswordCore(16);
	my $token = *{$pretoken};
	open($token, "<$file");
	flock($token, LOCK_SH);
	return $token;
}    #endsub

sub SwitchToExclusive {    # switches an OpenAndLock token into an exclusive lock
	flock($_[0], LOCK_UN) or die "Can't remove lock: $!";
	flock($_[0], LOCK_EX) or die "Can't switch to exclusive lock: $!";
}    #endsub

sub CloseAndUnlock {
	my $token  = shift;
	#$filehandle->close($token);
	close($token);
}    #endsub

sub OpenFileToSTDOUT {
	local (*FILE);

	my $file   = shift;

	my $item;

	my $handle = $filehandle->open('file', 'readonly', $file);
	my $tempvar = $handle->readfile();
	$filehandle->close($handle);

	print $tempvar;

	return;
}    #endsub

sub OpenFileAsVar {
	push (@openedfiles, $_[0]);
	local (*FILE);
	local ($str);


	if (&FileExists($_[0])) {
		my $handle = $filehandle->open('file', 'readonly', $_[0]);
		$str = $handle->readfile();
		$filehandle->close($handle);
	} else {
		&CheckCachedFile($_[0]);
	}
	chomp($str);
	return ($str);
}

sub OpenFileAsString {    # :)
	return &OpenFileAsVar(@_);
}

sub OpenFileAsArray {
	push (@openedfiles, $_[0]);
	local (*FILE);
	local (@thisarray);


	if (&FileExists($_[0])) {
		my $handle = $filehandle->open('file', 'readonly', $_[0]);
		@thisarray = $handle->readfile_asarray();
		$filehandle->close($handle);
	} else {
		&CheckCachedFile($_[0]);
	}
	return (@thisarray);
}

sub OpenFileAsArray2 {
	push (@openedfiles, $_[0]);
	local (*FILE);

	my $handle = $filehandle->open('file', 'readonly', $_[0]);
	@thisarray = $handle->readfile_asarray();
	$filehandle->close($handle);

	return (@thisarray);
}

sub OpenFileAsHash {
	local (*FILE);

	my $path = shift;
	my $delim = shift;
	my $reversed = ($_[0] ? $_[0] : 0);
	my $delimiter = quotemeta($delim);

	my %hash;

	my $handle = $filehandle->open('file', 'readonly', $path);
	while(($_ = $handle->readline()) && (length($_) > 0)) {
		chomp;
		my ($left, $right) = split (/$delimiter/, $_);
		if(!$reversed) {
			next unless defined $left;
			$hash{$left} = $right;
		} else {
			next unless defined $right;
			$hash{$right} = $left;
		} # end if
	} # end while

	$filehandle->close($handle);

	my $hashref = \%hash;

	return $hashref;
}    #endsub

sub WriteMemberProfile {
	local (*FILE);
	my ($number, @profile) = @_;

	#$number is the profile number,
	#@profile is a chomped profile array

	if(!@profile) {
		&StandardHTML("$vars_wordlets_err{wrote_out_zero_profile} $number");
	} elsif(!$profile[0]) {
		&StandardHTML("$vars_wordlets_err{wrote_out_bad_profile} $number");
	}

	foreach(@profile) { chomp; }

	my $handle = $filehandle->open('member', 'writeonly', "$number.cgi");
	$handle->truncate();
	$handle->print(join("\n", @profile));
	$filehandle->close($handle);

	chmod(SEVENSEVENSEVEN, "$vars_config{MembersPath}/$number.cgi");

}    #endsub

sub WriteTopic {
	local (*FILE);
	my $forum = shift;
	my $topic = shift;

	unless ($topic =~ /^\d{6}$/) {
		&PostHackDetails("$vars_wordlets_err{hack_attempt_open_topic}",);
	}

	my @data = sort grep(/^(A|Z)/, @_);

	&SetExactPath($forum);

	foreach(@data) { chomp; }	# important :)

	if(!@data) {
		&StandardHTML("$vars_wordlets_err{wrote_out_zero_topic} (forum $forum, topic $topic)");
	} elsif(
		(!$data[0]) ||
		($data[0] !~ m/^A/) ||
		($data[1] !~ m/^Z/) ||
		($data[(scalar(@data) - 1)] !~ m/^Z/)
		) {
		&StandardHTML("$vars_wordlets_err{wrote_out_bad_topic} (forum $forum, topic $topic)");
	}

	my $handle = $filehandle->open('thread', 'writeonly', "$vars_config{NonCGIPath}/$exact_path/$topic.cgi");
	$handle->truncate();
	$handle->print(join("\n", @data));
	$filehandle->close($handle);

	return;
}


sub TopicCheck {
	my($f, $t) = @_;
	&SetExactPath($f);
	return &FileExists("$vars_config{NonCGIPath}/$exact_path/$t.cgi")
} # end TopicCheck


sub OpenTopic {

	# $_[0] : topic number
	# $_[1] : forum number
	local (*FILE);


	&SetExactPath($_[1]);

	unless ($_[0] =~ /^\d{6}$/) {
		&PostHackDetails("$vars_wordlets_err{hack_attempt_open_topic} ($_[0])");
	}

	die &Template($vars_wordlets_criterr{zero_sized_topic}, {TOPIC => $_[0], FORUM => $_[1]}) unless -s "$vars_config{NonCGIPath}/$exact_path/$_[0].cgi";

	# No file?  No topic - return nothing
	return() unless &FileExists("$vars_config{NonCGIPath}/$exact_path/$_[0].cgi");

	my $handle = $filehandle->open('thread', 'readonly', "$vars_config{NonCGIPath}/$exact_path/$_[0].cgi");
	my @topic_guts = sort grep(/^(A|Z)/, $handle->readfile_asarray());
	$filehandle->close($handle);

	if ((($topic_guts[0] !~ m/^A/) || ($topic_guts[1] !~ m/^Z/)) && ($in{ubb} ne "delete_topic")) {

		#no A-line means the thread is dead, no Z-line means it's MORE than dead!
		print "<pre><br />$vars_wordlets_err{thread_file_corrupt}<br />", "  $vars_wordlets{forum_column} $_[1], $vars_wordlets{topic_header} $_[0]  (<a href='$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic&f=$_[1]&t=$_[0]'>View</a>)", "<br /><a href='mailto:$vars_display{BBEmail}?Subject=", UBBCGI::escape("$vars_wordlets_err{thread_file_corrupt_email} ($vars_wordlets{forum_column} $_[1], $vars_wordlets{topic_header} $_[0])"), "&Body=", UBBCGI::escape("$vars_wordlets_err{thread_file_corrupt_body}\n$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic&f=$_[1]&t=$_[0]"), "'>$vars_wordlets_err{mail_an_admin}</a></pre>";
	}    #temporary troubleshooting code - if the thread is corrupt, offer to delete it

	#Some users managed to have living pre-Y2K UBBs with new threads, resulting
	#in malformated date strings.  This routine attempts to fix the string.
	#It's a kuldge, but it does the job for the time being.

	my @clean_topic_guts = ();

	foreach (@topic_guts) {

		my @cleanup = split (/\|\|/) if m/^Z/;    #only Z lines have dates
		unless (@cleanup) { push (@clean_topic_guts, $_); next; }    #so skip non-Z lines

		if($cleanup[3] =~ m/^(\d\d)\-(\d\d)\-(\d\d)$/) {
			if (($3 > 90) && ($3 < 150)) {	     #y2k+50!
				my $three = $3 + 1900;
				$cleanup[3] = "$1-$2-$three";
			} elsif ($3 < 90) {
				my $three = $3 + 2000;
				$cleanup[3] = "$1-$2-$three";
			}
		} # end if

		my $line = join ("||", @cleanup);
		push (@clean_topic_guts, $line);
	}    # end foreach

	@topic_guts       = @clean_topic_guts;
	@clean_topic_guts = undef;

	#CC Cleanup Code END

	return (@topic_guts);
}    # end OpenTopic


sub OpenThread { # like OpenTopic, only returns an arrayref instead of an array
	my $new_topic = [];
	my $c = 0;
	foreach (&OpenTopic(@_)) {
		push(@{ $new_topic->[$c] }, split(/\|\|/));
		$c++;
	} # end foreach
	return $new_topic;
} # end OpenThread


sub OpenProfile {
	local (@got_profile);

	# $_[0] : member profile number
	chomp($_[0]);    # just in case :)

	return unless $_[0];	# just don't bother if there's no number

	# thanks to Leshrac for the %member_profile hash idea!
	if ($member_profile{"$_[0]"}) {
		return @{$member_profile{"$_[0]"}};
	} else {
		# make sure no lf bumping is going on
		my $maxmemfields = 39;    #total fields permitted in member file

		# make sure input is a number
		if ($_[0] =~ m/^\d{8}$/) {
			if(!&FileExists("$vars_config{MembersPath}/$_[0].cgi")) {
				&StandardHTML("$vars_wordlets_err{no_member_number} '$_[0]'" . &Tracer);
			}

			my $handle = $filehandle->open('member', 'readonly', "$_[0].cgi");
			@got_profile = $handle->readfile_asarray();
			$filehandle->close($handle);
		} else {
			&StandardHTML("$vars_wordlets_err{no_member_number} '$_[0]'");
		} # end if


		if ((!@got_profile) || ($got_profile[0] eq '')) {
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			);
			&StandardHTML("$vars_wordlets_err{no_member_data} '$_[0]'");
		} # end if


		if ($#got_profile > $maxmemfields) {
			&PostHackDetails("$vars_wordlets_err{hack_attempt_member_file} ('$_[0]')");
		}

		$member_profile{"$_[0]"} = [@got_profile];
		return (@got_profile);
	}

}    # end Open Profile

sub OpenProfile2 {
	local (@got_profile);

	# $_[0] : member profile number
	chomp($_[0]);    # just in case :)

	return unless $_[0];	# just don't bother if there's no number

	# thanks to Leshrac for the %member_profile hash idea!
	if ($member_profile{"$_[0]"}) {
		return @{$member_profile{"$_[0]"}};
	} else {
		# make sure no lf bumping is going on
		my $maxmemfields = 39;    #total fields permitted in member file

		# make sure input is a number
		if ($_[0] =~ m/^\d{8}$/) {
			if(!&FileExists("$vars_config{MembersPath}/$_[0].cgi")) {
				return undef;
			}

			my $handle = $filehandle->open('member', 'readonly', "$_[0].cgi");
			@got_profile = $handle->readfile_asarray();
			$filehandle->close($handle);
		} # end if


		$member_profile{"$_[0]"} = [@got_profile];
		return (@got_profile);
	}

} # end OpenProfile2


# Yes, there IS a reason we're doing this now...
sub WriteNewMemberToMetaData {
	my($total_members, $user_name, $email, $next_number, $public_name) = @_;

	&WriteFileAsString("$vars_config{MembersPath}/membertotal.cgi", $total_members);
	&AppendFileAsString("$vars_config{MembersPath}/memberslist.cgi", "\n$user_name|!!|$next_number");
	&AppendFileAsString("$vars_config{MembersPath}/emailfile.cgi", "\n$email||$next_number\n");
	&WriteFileAsString("$vars_config{MembersPath}/last_number.cgi", "$next_number\n");

	# last approved member:
	unless ($vars_registration{ModerateRegs} eq 'ON') {
		&WriteFileAsString("$vars_config{MembersPath}/last_approved.cgi", "$next_number\n");
	}

	if ($pub_warning eq '') {
		# add new public name to list, assuming we can
		&AppendFileAsString("$vars_config{MembersPath}/public_names.cgi", "$public_name\n");
	}

} # end WriteNewMemberToMetaData

sub GetMembersListAsHash {
	return &OpenFileAsHash("$vars_config{MembersPath}/memberslist.cgi", "|!!|")
} # end GetMembersListAsHash

sub GetMembersListAsHashReversed {
	return &OpenFileAsHash("$vars_config{MembersPath}/memberslist.cgi", "|!!|", 1)
} # end GetMembersListAsHash

sub GetMemberListArray {	# returns NAMES ONLY
	return keys %{&GetMembersListAsHash};
} # end GetMemberListArray

sub GetMembersListAsArray {
	return &OpenFileAsArray("$vars_config{MembersPath}/memberslist.cgi");
} # end GetMembersListAsArray

sub GetPubNamesAsArray {
	return &OpenFileAsArray("$vars_config{MembersPath}/pub_names.cgi");
} # end GetPubNamesAsArray

sub GetEmailsListAsHash {
	return &OpenFileAsHash("$vars_config{MembersPath}/emailfile.cgi", "||")
} # end GetEmailsListAsHash

sub GetEmailsListAsHashReversed {
	return &OpenFileAsHash("$vars_config{MembersPath}/emailfile.cgi", "||", 1)
} # end GetEmailsListAsHash

sub GetEmailFileAsArray {
	return &OpenFileAsArray("$vars_config{MembersPath}/emailfile.cgi");
} # end GetEmailFileAsArray

sub GetMemberTotal {
	my $f = "$vars_config{MembersPath}/membertotal.cgi";
	if(&FileExists($f) ) {
		my $v = &OpenFileAsString($f);
		chomp($v);
		return $v;
	} else {
		my $mt = scalar(&GetMembersListAsArray);
		&WriteFileAsString($f, $mt);
		return $mt;
	} # end if
} # end GetMemberTotal

sub GetLastMemberNumber {
	if(&FileExists("$vars_config{MembersPath}/last_number.cgi")) {
		my $last_number = &OpenFileAsVar("$vars_config{MembersPath}/last_number.cgi");
		chomp($last_number);
		return $last_number;
	} else {
		return 0;
	} # end if
} # end GetLastMemberNumber

sub GetLastApprovedUser {
	my $last_number = &OpenFileAsVar("$vars_config{MembersPath}/last_approved.cgi");
	chomp($last_number);
	return $last_number;
} # end GetLastApprovedUser

sub UpdateMemberslist {
	&WriteFileAsArray("$vars_config{MembersPath}/memberslist.cgi", @{$_[0]});
} # end sub

sub UpdateEmailfile {
	&WriteFileAsArray("$vars_config{MembersPath}/emailfile.cgi", @{$_[0]});
} # end sub

sub UpdateMemberTotal {
	&WriteFileAsString("$vars_config{MembersPath}/membertotal.cgi", $_[0]);
} # end UpdateMemberTotal

sub UpdatePubNames {
	&WriteFileAsArray("$vars_config{MembersPath}/pub_names.cgi", @{$_[0]});
} # end UpdatePubNames

sub UpdateLastNumber {
	&WriteFileAsString("$vars_config{MembersPath}/last_number.cgi", "$_[0]\n");
} # end UpdateLastNumber

sub AppendPubNames {
	&AppendFileAsString("$vars_config{MembersPath}/public_names.cgi", "$_[0]\n");
} # end AppendPubNames

sub FileExists {
	# ... Don't.  Ask.
	-e $_[0];
} # end FileExists

sub DirExists {
	-d $_[0];
} # end DirExists

sub Unlink {
	$filehandle->force_lock;
	my $v = unlink($_[0]);
	$filehandle->force_unlock;
	return $v;
} # end Unlink

1 + 1 == 2;	# except for large values of 1
# $Id: ubb_lib_files.cgi,v 1.16 2002/04/30 18:19:05 cvscapps Exp $
