# Secondary library for UBB.classic

sub AssembleCats {
	local ($cat, $Dupe, @forline, $check, @catlist, $catter, $CountFormat, $uno, $one, $COrd, $CName, $CNum, $CatName, $CatNumber, $DIRPW, $DescLength);
	local (*FILE);
	local (*INDEX);

	my @theforums = &OpenForumsFile;
	my @Bforums   = @theforums;        #create backup
	my $Count     = 0;

	foreach $cat (@theforums) {
		@forline = split (/\|\^\|/, $cat);
		$Dupe = '';
		if ($forline[0] ne '') {
			foreach $check (@catlist) {
				chomp($check);

				if ($forline[0] eq "$check") {
					$Dupe = 'true';
				}
			}

			if ($Dupe ne 'true') {
				push (@catlist, $forline[0]);
			}

		}

	}

	foreach $catter (@catlist) {
		chomp($catter);
		$Count++;
		$CountFormat = &Do6Digit($Count);
		push (@GETCATS, "$CountFormat|^|$catter|^|$Count\n");
	}

	&WriteFileAsArray("$vars_config{NonCGIPath}/categories.file", @GETCATS);

	#my @GETCATS = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");

	#revise forums file to reflect cat numbers rather than cat names
	$Count = 0;
	foreach $uno (@theforums) {
		$CatNumber = "";
		@forline   = split (/\|\^\|/, $uno);
		$CatName   = $forline[0];

		if (@GETCATS) {
			CHECKCAT: foreach $one (@GETCATS) {
				($COrd, $CName, $CNum) = split (/\|\^\|/, $one);
				chomp($CNum);
				if ($CName eq "$CatName") {
					$CatNumber = "$CNum";
					last CHECKCAT;
				}
			}
			$forline[0] = $CatNumber;
		}

		my $NewPermLine = '';

		#check to make sure perm line is current

		chomp($forline[6]);

		if ($forline[6] eq 'yes') {
			$NewPermLine = "restrict&restrict";
		}
		if ($forline[6] eq 'private') {
			$NewPermLine = 'private';
			$forline[13] = 'yes';

			#generate private directory
			$DIRPW      = &GeneratePassword;
			$DescLength = length($forline[1]);
			$DIRPW .= "$DescLength";

			mkdir("$vars_config{NonCGIPath}/Forum$thisforum[8]/private-$DIRPW", 0777);
			chmod(0777, "$vars_config{NonCGIPath}/Forum$thisforum[8]/private-$DIRPW");

			&WriteFileAsString("$vars_config{NonCGIPath}/Forum$thisforum[8]/index.html", "");
			&WriteFileAsString("$vars_config{NonCGIPath}/Forum$thisforum[8]/private-$DIRPW/index.html", "");

		}

		if ($forline[6] eq 'partly') {
			$NewPermLine = 'restrict&allreg';
		}
		if ($forline[6] eq 'includenonreg') {
			$NewPermLine = 'all&all';
		}

		if ($forline[6] eq 'no') {
			$NewPermLine = 'allreg&allreg';
		}

		if ($NewPermLine ne '') {
			$forline[6] = $NewPermLine;
		}
		chomp($forline[11]);
		chomp($forline[12]);
		chomp($forline[13]);
		chomp($forline[14]);
		chomp($forline[8]);

		$theforums[$Count] = join ("|^|", @forline);
		$Count++;
	}

	#create backup first
	&WriteFileAsArray("$vars_config{VariablesPath}/forumsBACKUP.cgi", @Bforums);

	# write to forums file
	&WriteFileAsArray("$vars_config{VariablesPath}/vars_forums.cgi", @theforums);

}    #end AssembleCats

sub verify_id {
	my $username = shift;
	my $password = shift;

	local ($lcpw, $lcprofpw, $pn, @user_info, @profile_stuff);

	$profile_stuff[2] = &GetUserNumber($username);

	#did we find the username?
	if ($profile_stuff[2] eq '') {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{invalid_username}");
	}
	my @profile = &OpenProfile2($profile_stuff[2]);
	if(!@profile) {
		&StandardHTML($vars_wordlets_err{member_gone2});
	} # end if
	chomp($profile[1]);
	chomp($profile[8]);
	chomp($profile[15]);
	$lcpw     = lc($password);
	$lcprofpw = lc($profile[1]);

	if ($lcpw ne "$lcprofpw") {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{invalid_password}");
	}

	# grab displayed name
	chomp($profile[15]);
	chomp($profile[0]);
	chomp($profile[26]);
	$profile_stuff[0] = $profile[15];
	if ($profile_stuff[0] eq '') { $profile_stuff[0] = "$profile[0]"; }

	# grab topic view (days prune)
	chomp($profile[21]);
	$profile_stuff[1] = $profile[21];

	# does user have an approved registration?
	$profile_stuff[3] = $profile[26];
	$profile_stuff[4] = $profile[34]; # PNTF hidden value
	$profile_stuff[5] = (split(/\|/, $profile[38]))[2];	# hide avatars
	return (@profile_stuff);

}    #end verify_id


sub create_forum_summary {
	local (@topics, %forum_topics, *FILE);

	my $thisnumber = $_[0];    # the forum number
	my $start_point = $in{start_point};
	$start_point =~ s/\D//g;
	$start_point = 0 unless $start_point;
	my $end_point = $start_point + 200;

	@forum_info = &GetForumRecord($_[0]);
	$exact_path = "Forum$_[0]";
	if ($forum_info[6] =~ m/private/) {
		$exact_path .= "/private-$forum_info[7]";
	}

	chomp($forum_info[15]);    # <- sort option

	opendir(FILE, "$vars_config{NonCGIPath}/$exact_path") or die "$vars_wordlets_err{cant_find_directory}: $exact_path<p>$!</p>";
	@theforummsgs = readdir(FILE);
	closedir(FILE);

	my @forummsgs = grep(/^\d{6}\.cgi$/, @theforummsgs);
	my @datafiles = grep(/^forum_thread_data\.\d{4}$/, @theforummsgs);

	my %thistopics;
	if($start_point == 0) {
		%thistopics = ();
	} else {
		my $hashref = &GetForumTopics($thisnumber);
		%thistopics = %{$hashref};
	}

	unless (@forummsgs) {
		foreach ("forum_$_[0].threads", "lasttime.file", "lastnumber.file", @datafiles) {
			&Unlink("$vars_config{NonCGIPath}/$exact_path/$_");
		}
	}

	my $thiscount = scalar(@forummsgs);
	if($end_point > $thiscount) { $end_count = $thiscount; $end_count--; }
	@forummsgs_this = @forummsgs[$start_point .. $end_point];

	my $returnval;
	$returnval = $end_point unless(($start_point + 200) >= scalar(@forummsgs));

	if(!$start_point) {
		foreach (@datafiles) {
			&Unlink("$vars_config{NonCGIPath}/$exact_path/$_");
		}
	}

	OUTER: foreach my $file (@forummsgs_this) {
		next OUTER unless $file =~ m/^(\d{4})(\d{2})\.cgi$/;
		my ($leftnum, $rightnum);
		$leftnum  = $1;
		$rightnum = $2;

		my @thread = &OpenTopic("$1$2", $_[0]);
		&SafeGetThreadData2($thisnumber, "$1$2");
		&UpdateForumThreadDataForSingleThread($thisnumber, $leftnum, $rightnum, @thread);
	}

	&WriteAllForumThreadData($thisnumber);

	unless($returnval) {
		my $thisref = &NiceForumThreadsRebuild($thisnumber);
		&UpdateForumTopics($thisnumber, $thisref);
		&CreateLastTimeFiles($thisnumber);
		$returnval = "";
	}

	my $totaltopics = scalar(@forummsgs);

	return $returnval, $totaltopics;

}    # end create_forum_summary

# do not remove:
1;
# $Id: ubb_lib_2.cgi,v 1.8 2002/04/30 18:19:05 cvscapps Exp $
