# UBB.classic central library
# Copyright (C) 2002 Infopop Corporation

# Did you remember your library card?  Get one at http://www.infopop.com/ !

&InitImportantStuff;	# onload

sub InitImportantStuff {

	# REMEMBER, ALTERING THE POWERED-BY NOTICE IS A
	# VIOLATION OF THE UBB.CLASSIC LICENSE AGREEMENT, AND A FAIRLY
	# EASY ONE TO SPOT AT THAT.  THAT INCLUDES REMOVING OR
	# ALTERING THE VERSION NUMBER UNDER MOST CONDITIONS.
	# IF YOU'RE UNSURE, OR WOULD LIKE TO ASK PERMISSION
	# TO REMOVE OR ALTER THE POWERED-BY, PLEASE SPEAK
	# TO INFOPOP SUPPORT.

	# Thank you.

	# version data
	my $idstring = q!$Id: ubb_lib.cgi,v 1.47 2002/05/08 20:53:30 cvscapps Exp $!;
	$idstring =~ m/^\$Id: [\w\.]+\,v ([\d\.]+) /;
	$version_number = "0603000$1";
	$version        = "6.3.0<!-- $version_number -->"
			. "<!-- $idstring -->";
	$release_j      = "2452403";


	# HTML trademark characters
	$trademark = qq(<font style='font-size: 8px' size='1'><sup><b>TM</b></sup></font>);
	$trade = "";

# Can't turn these on until Netscape 4 is gone forever...
#	$trademark = "&trade;";
#	$trade = "&trade;";

	&InitImportantVars;
	&InitCustomTemplateDefs(&AmICustomOrNot);

	# PHP cache accelerator, courtesy Philipp Esselbach
	if($vars_config{EnableAccel} eq 'YES') {
		$ULTIMATEBB = "$vars_config{NonCGIURL}/ultimatebb.php";
	} else {
		$ULTIMATEBB = "$vars_config{CGIURL}/ultimatebb.cgi";
	} # end if


	if ($vars_display{showcopytype} eq 'image') {
		$InfopopCopyright = qq!<a href="http://www.infopop.com/landing/goto.php?a=ubb.classic"><img src="$vars_config{NonCGIURL}/powered_by2.gif" width="144" height="16" border="0" alt="Powered by Infopop Corporation" /></a>!;
	} else {
		$InfopopCopyright = qq!Powered by <a href="http://www.infopop.com/landing/goto.php?a=ubb.classic">Infopop Corporation</a>!;
	}
	$InfopopCopyright .= qq%\n\n<br />UBB.classic$trademark \n$version\n\n%;

	# attempt to define our charset
	$masterCharset = $vars_display{masterCharset};
	$masterCharset = "ISO-8859-1" unless $masterCharset;

	# weights: used for member ratings
	%weights = (
		0 => "0.15",
		1 => "0.05",
		2 => "0.08",
		3 => "0.12",
		4 => "0.25",
		5 => "0.35"
	);

	# For "this can never happen" errors...
	%vars_wordlets_criterr = %{&MakeCriticalWordlets};
}    #endsub

sub InitImportantVars {
	# Added search entries
	$vars_search{'page_limit'} = 50;	# hard coded
	$vars_search{'soft_limit'} = 200;	# hard coded
	$vars_search{'hard_limit'} = 300;	# hard coded
	$vars_search{'topic_index_limit'} = 200;	# hard coded
	$vars_search{'removelist_stock'} = q(it|the|as|a|an|will|for|of|but|in|there|could|should|would|can|be|is|are|to|was|with|because|how);
	$vars_search{'truncateat'} ||= 210;

	# Added vars_config entries
	$vars_config{'AdminLogging'} ||= 'YES';
	$vars_config{'EnableAccel'} ||= 'NO';

	# Added vars_registration entries
	$vars_registration{'allowHighBit'} ||= 'YES';
	$vars_registration{'bdate_field_use'} ||= 'OPT';

	# Added vars_misc entries
	$vars_misc{'stringLengthLimit'} ||= '180';
	$vars_misc{'runOnLimit'} ||= '30';
	$vars_misc{'ReverseIPBans'} ||= 'NO';
	$vars_misc{'ReverseEmailBans'} ||= 'NO';

	# Custom titles
	if(ref($vars_misc{custom_titles}) ne "HASH") {
		$vars_misc{custom_titles} = {
			0 => $vars_misc{JrMemberTitle},
			$vars_misc{MemberMinimum} => $vars_misc{MemberTitle},
		};
	} # end if

	# Added vars_display entries
	$vars_display{'PrintTopic'} ||= 'yes';
	$vars_display{'PopupHeight'} ||= '300';
	$vars_display{'masterCharset'} ||= 'ISO-8859-1';
	$vars_display{'RequireLoginPosts'} ||= 'NO';
	$vars_display{'PopupWidth'} ||= '550';
	$vars_display{'PreviewPost'} ||= 'yes';
	$vars_display{'ShowContactUsLink'} ||= "ON";
	$vars_display{'ShowHomepageLink'} ||= "ON";
	$vars_display{'UseAvatars'} ||= "no";
	$vars_display{'AvatarHeight'} ||= "48";
	$vars_display{'AvatarWidth'} ||= "48";
	$vars_display{'AvatarForceSize'} ||= "no";
	$vars_display{'AvatarFileExts'} ||= "\.(gif|jpg|png)";
	$vars_display{'AvatarRemoteFileExts'} ||= "\.(gif|jpg|png)";
	$vars_display{'AvatarPopupCols'} ||= 5;
	$vars_display{'AvatarPopupRows'} ||= 6;
	$vars_display{'AvatarPopupHeight'} ||= 560;
	$vars_display{'AvatarPopupWidth'} ||= 530;
	$vars_display{'PaginationType'} = "new";	# hard coded

	# Checked vars_email entries
    	$vars_email{'email_format'} ||= 'ascii';

	# Try to autofill missing email addresses
	$vars_config{CGIURL} =~ m!^(https?)\://([\w-\.]+)/!;
	my $probable_domain = $2;
	$probable_domain =~ s/^www\.//;
	my $user = ($vars_config{CGIURL} =~ m!^(https?)\://([\w-\.]+)/\~([\w_-]+)/! ? $3 : "webmaster");
	if($probable_domain && !$vars_display{'BBEmail'}) {
		$vars_display{'BBEmail'} = "$user\@$probable_domain";
	} # end if
	if($vars_display{'BBEmail'} && !$vars_registration{'RegsAdminEmail'}) {
		$vars_registration{'RegsAdminEmail'} = $vars_display{'BBEmail'};
	} # end if
	if($probable_domain && !$vars_registration{'RegsAdminEmail'}) {
		$vars_display{'RegsAdminEmail'} = "$user\@$probable_domain";
	} # end if
} # end InitImportantVars

sub InitCustomTemplateDefs {
#	print "<pre>I C T D :: '$_[0]'</pre><br />";
	if($_[0] == 0) {
		# Standard template set vars
		$vars_config{'jc'}->{'is'} = 0;				# 1
		$vars_config{'jc'}->{'no-br'} = '<br />';		# ''
		$vars_config{'jc'}->{'br'} = '';			# '<br />'
		$vars_config{'jc'}->{'regmemlinesep'} = "<br />";	# ' - '
		$vars_config{'jc'}->{'normalviewcolspan'} = 3;		# 2
		$vars_config{'jc'}->{'no-openparen'} = "(";		# ''
		$vars_config{'jc'}->{'no-closeparen'} = ")";		# ''
		$vars_config{'jc'}->{'ip-divider'} = '&nbsp;|&nbsp;';	# ' '
		$vars_config{'jc'}->{'no-b'} = '<b>';		# ''
		$vars_config{'jc'}->{'b'} = '';			# '<b>'
		$vars_config{'jc'}->{'no-b-close'} = '</b>';		# ''
		$vars_config{'jc'}->{'b-close'} = '';			# '</b>'
		$vars_config{'jc'}->{'no-space'} = ' ';			# ''
		$vars_config{'jc'}->{'no-nbsp'} = '&nbsp;';		# ''
		$vars_config{'jc'}->{'nbsp-space'} = '&nbsp;';		# ' '
		$vars_config{'jc'}->{'titlebarclass'} = '';
		$vars_config{'jc'}->{'topic_closed'} ='<br clear="all">';
	} elsif($_[0] == 1) {
		# Alternate template set vars
		$vars_config{'jc'}->{'is'} = 1;
		$vars_config{'jc'}->{'no-br'} = '';
		$vars_config{'jc'}->{'br'} = '<br />';
		$vars_config{'jc'}->{'regmemlinesep'} = " - ";
		$vars_config{'jc'}->{'normalviewcolspan'} = 2;
		$vars_config{'jc'}->{'no-openparen'} = "";
		$vars_config{'jc'}->{'no-closeparen'} = "";
		$vars_config{'jc'}->{'ip-divider'} = ' ';
		$vars_config{'jc'}->{'no-b'} = '';
		$vars_config{'jc'}->{'no-b-close'} = '';
		$vars_config{'jc'}->{'no-space'} = '';
		$vars_config{'jc'}->{'no-nbsp'} = '';
		$vars_config{'jc'}->{'nbsp-space'} = ' ';
		$vars_config{'jc'}->{'titlebarclass'} = 'class="titlebar"';
		$vars_config{'jc'}->{'topic_closed'} ='';
	} # end if
} # end InitCustomTemplateDefs

sub list_check {

	# $_[0]: user number of member you are checking

	local(%pm_ignore, %pm_buddy);

	# used to see if particular member
	# is on ignore or buddy list
	$_[0] = &Do8Digit($_[0]);
	my ($list_add);

	if (&FileExists("$vars_config{MembersPath}/pm_ignore/$user_number.cgi")) {
		&RequireVars("$vars_config{MembersPath}/pm_ignore/$user_number.cgi");
	} # end if

	if (&FileExists("$vars_config{MembersPath}/pm_buddy/$user_number.cgi")) {
		&RequireVars("$vars_config{MembersPath}/pm_buddy/$user_number.cgi");
	} # end if

	unless (exists($pm_ignore{$_[0]})) {
		$list_add = qq~<a href="javascript:ignore();">$vars_wordlets{ignore_user}</a>~;
	} else {
		$list_add = "$vars_wordlets{user_on_ignore}";
	} # end unless

	unless (exists($pm_buddy{$_[0]})) {
		if ($list_add ne '') { $list_add .= ' | '; }
		$list_add .= qq~<a href="javascript:buddy();">$vars_wordlets{make_buddy}</a>~;
	} else {
		if ($list_add ne '') { $list_add .= ' | '; }
		$list_add .= "$vars_wordlets{user_on_buddy}";
	} # end unless

	return ($list_add);
}    # end list check

sub get_public_name {
	return &GetPubName(@_);
}

sub get_rating {

	# %votes, %total, %avg, %weighted_avg should be prevously declared
	my $the_rating;
	my $this_member = &Do8Digit($_[0]);
	undef(%weighted_avg); # ...
	undef(%votes);

	if ((-s "$vars_config{MembersPath}/user_ratings/$this_member.cgi") && ($this_member ne '')) {
		do "$vars_config{MembersPath}/user_ratings/$this_member.cgi";
		$the_rating = $weighted_avg{total};
		$the_rating = &round_up($the_rating);
	} else {
		$the_rating = '';
	}
	return ($the_rating, $votes{total});
}    # end get_rating

sub round_up {
	my ($whole, $dec) = split (/\./, $_[0]);
	if ($dec > 49) { $whole++; }
	return ($whole);
}

sub Do2Decimal {
	$_[0] = sprintf("%3.2f", $_[0]);
	return ($_[0]);
}

sub user_access {
	my ($this_user_access);
	my ($f, @profile) = @_;

	my ($j, $perms) = split (/&/, $profile[4]);
	chomp($perms);
	my @permitted = split (/\,/, $perms);

	foreach (@permitted) {
		if ($_ eq "$f") {
			$this_user_access = 'true';
			last;
		} else {
			$this_user_access = 'false';
		}
	}

	if (!$this_user_access) {    #if the poor guy STILL isn't in...

		# check to see if forumpw cookie set:
		my $forumpw = cookie("forumpw$vars_config{Cookie_Number}");
		my %pwhash  = split (/\|\^\|/, $forumpw);

		my @foruminfo = GetForumRecord($f);

		# pw hash check
		if ((exists($pwhash{$f})) && ($pwhash{$f} eq $foruminfo[12])) {
			$this_user_access = "true";
		} else {
			$this_user_access = "false";
		}    #endunless
	}    #endif


	return ($this_user_access);
}    # end user_access

sub is_admin_or_mod {
	my ($Moderator, $mod_match, $is_one);

	my ($f, @profile) = @_;
	chomp($profile[8]);
	chomp($profile[0]);

	if ($profile[8] eq 'Administrator') {
		$is_one = 'true';
	} elsif ($profile[8] eq 'Moderator') {

		if ($f ne 'ALL') {

			# check to see if user is moderator of particular forum

			# check if moderator
			&RequireVars("$vars_config{VariablesPath}/vars_mods.cgi");

			$Moderator = ${ "Forum" . "$f" . "Moderator" };

			#split up Mod var
			my @mods = split (/\|\|\^\|\|/, $Moderator);

			my @mod_profile = ();
			foreach (@mods) {
				chomp($_);
				if (-s "$vars_config{MembersPath}/$_.cgi") {
					@mod_profile = &OpenProfile($_);
					chomp($mod_profile[0]);

					if ($mod_profile[0] eq $profile[0]) {
						$mod_match = 'true';
					} # end if
				} # end if
			} # end foreach

			if ($mod_match ne 'true') {
				$is_one = 'false';
			} else {
				$is_one = 'true';
			} # end if
		} else {
			# this is just to see if user is a mod of any forum
			$is_one = 'true';
		} # end if
	} else {
		$is_one = 'false';
	} # end if

	return ($is_one);
}    # is_admin_or_mod

sub boolean_is_admin_or_mod {
	my $r = &is_admin_or_mod(@_);
	return ($r eq "true" ? 1 : 0);
} # end boolean_is_admin_or_mod

sub Smilies {
	# Thanks to J.o.h for the original code for this,
	# and to LK for advising its use.

	# A nice little fix for a very annoying problem!  :D

	&RequireVars("$vars_config{VariablesPath}/vars_graemlins.cgi")
		unless exists $vars_graemlins->{'graems'};

	$_[0] = &CustomGraemlins($_[0]);

	return ($_[0]);
} # end Smilies


sub check_html {
	my @results = &check_html_core(@_);
	if(scalar(@results) > 0) {
		&StandardHTML($vars_wordlets_err{illegal_html_tag} . join(", ", @results));
		exit;
	} else {
		return;
	} # end if
}    # end check for script

sub check_html_boolean {
	my @results = &check_html_core(@_);
	return (scalar(@results) > 0 ? 1 : 0 );
} # end check_html_boolean

sub check_html_core {
	# Someone got the idea in their head a while ago that this entire
	# subroutine is here just to annoy them and prevent them from posting
	# HTML, and that they should just disable it so they can post.

	# That is WRONG.

	# This routine is here to FILTER DANGEROUS CONTENT.

	# If you are going to hack your board up, feel free to... but
	# DO NOT REMOVE *OR IN ANY WAY* CHANGE THIS ROUTINE,
	# OR ANYTHING THAT CALLS THIS ROUTINE

	# If you do so, there is a SIGNIFIGANT chance that someone will
	# try hacking your board, and they'll succeed.

	# LEAVE THIS ROUTINE ALONE.

	my $this = &EscapeFilter(shift);
	my @returnarray = ();
	#$this =~ s/<\?/\&lt\;?/gis;
	push(@returnarray, "Parenthesis in HTML tag") if ($this =~ /(<)([^>]*?)(\()/si);
	push(@returnarray, "PHP") 	if (($this =~ m/<\?php/si) || ($this =~ m/\&lt\;\?php/si));
	push(@returnarray, "SCRIPT") 	if ($this =~ /\<(\s*\/)?\s*SCRIPT.+?>/si);
	push(@returnarray, "EMBED") 	if ($this =~ /<\s*EMBED[\s\n\r]*?>/si);
	push(@returnarray, "NOSCRIPT") 	if ($this =~ /<\s*NOSCRIPT[\s\n\r]*?>/si);
	push(@returnarray, "NOEMBED") 	if ($this =~ /<\s*NOEMBED[\s\n\r]*?>/si);
	push(@returnarray, "NOFRAMES") 	if ($this =~ /<\s*NOFRAMES[\s\n\r]*?>/si);
	push(@returnarray, "OBJECT") 	if ($this =~ /<\s*OBJECT[\s\n\r]*?>/si);
	push(@returnarray, "IFRAME") 	if ($this =~ /<\s*IFRAME[\s\n\r]*?>/si);
	push(@returnarray, "FORM") 	if ($this =~ /<\s*FORM[\s\n\r]*?>/si);
	push(@returnarray, "XMP") 	if ($this =~ /<\s*XMP[\s\n\r]*?>/si);
	push(@returnarray, "APPLET") 	if ($this =~ /<\s*APPLET[\s\n\r]*?>/si);
	push(@returnarray, "BODY") 	if ($this =~ /<\s*BODY[\s\n\r]*?>/si);
	push(@returnarray, "HEAD") 	if ($this =~ /<\s*HEAD[\s\n\r]*?>/si);
	push(@returnarray, "HTML") 	if ($this =~ /<\s*HTML[\s\n\r]*?>/si);
	push(@returnarray, "ONLOAD") 	if ($this =~ /ONLOAD[\s\n\r]*=/si);
	push(@returnarray, "ONCLICK") 	if ($this =~ /ONCLICK[\s\n\r]*=/si);
	push(@returnarray, "MOUSEOVER") if ($this =~ /MOUSEOVER[\s\n\r]*=/si);
	push(@returnarray, "ONERROR") 	if ($this =~ /ONERROR[\s\n\r]*=/si);
	push(@returnarray, "COOKIE") 	if(($this =~ /\.cookie/si) || ($this =~ /cookie\s*\.\s*split/si));
	push(@returnarray, "GETCOOKIE") if ($this =~ /getcookie/si);
	push(@returnarray, "eval (") 	if ($this =~ /eval[\s\n\r]*\(/si);
        my($opencomment, $closecomment) = (0,0);
        while($_ =~ m/<\s*\!\s*-\s*?/gi) { $opencomment++; }
        while($_ =~ m/\s*-\s*?>/gi) { $closecomment++; }
	push(@returnarray, "&lt;--") if($opencomment > $closecomment);

	return @returnarray;
} # end check_html_core

sub Truncate {
	$vars_misc{stringLengthLimit} = 180 unless $vars_misc{stringLengthLimit};
	$_[0] =~ s/(\S{$vars_misc{stringLengthLimit}})/$1 /isg;
	return ($_[0]);
}

sub PipeCleaner {
	$_[0] =~ s/\|\|/&#0124;&#0124;/sg;
	return ($_[0]);
}

sub GetPubName {
	return undef unless &FileExists("$vars_config{MembersPath}/$_[0].cgi");

	my @user_p = &OpenProfile($_[0]);
	chomp($user_p[15]);
	chomp($user_p[0]);

	if ($user_p[15] eq '') { $user_p[15] = $user_p[0]; }
	return ($user_p[15]);
}    # get pub name


sub GetUserNumber {
	#local ($MatchName, $ThisProfileNumber);

	# $_[0] : Member Login Name

	# This method is nasty, but it has to be done.
	# 6.0 has some case sensitivity issues that 6.1 has to work around.
	my $GetNameClean = lc($_[0]);

	# ProfileNumber has been varsed, but still isn't used anywhere.  Why?

	if (exists $ProfileNumber{$GetNameClean}) {    # check if it's already found
		return $ProfileNumber{$GetNameClean};
	} else {
		unless ($memlistopen) {    # only open once
			my %ThisProfileNumber = %{&GetMembersListAsHash()};
			foreach my $key (keys %ThisProfileNumber) {
				next if $key eq "";
				$ProfileNumber{lc($key)} = $ThisProfileNumber{$key};
			} # end foreach
			%ThisProfileNumber = ();
			$memlistopen++; # When do we use this again?
		} # end unless

		return ($ProfileNumber{$GetNameClean});
	}    # end if

}    #end GetUserNumber


sub PostHackDetails {

	my @message = @_;
	my $called = &Tracer;

	my $hackstring = "\nHACK ATTEMPT DATE: $GotTime{LastLoginDT}\n$_[1]\nAttempt Details:\nEnvironment:\n";
	foreach (sort keys %ENV) { $hackstring .= "$_ \t $ENV{$_}\n"; }
	$hackstring .= "\nPassed to script:\n";
	foreach (sort keys %in) { $hackstring .= "$_ \t $in{$_}\n"; }
	$hackstring .= "\n\nTracer: $called\n";
	$hackstring .= "-=- " x 20;

	&AppendFileAsString("$vars_config{NonCGIPath}/hacklog.cgi", $hackstring);

	if($message[0] ne "nostandardhtml") {
		&StandardHTML(join("", @message));
	} # end if
} # end if

sub CheckBadChars {    # check for | , ;, .. or >< character hack attempts
	my $checkthis = shift;
	if ($checkthis =~ /(\||\;|<|>|\.\.|\*)/) {    #
		&PostHackDetails("$vars_wordlets_err{hack_attempt_bad_char} ($1)");
	}
	return 1;
}    # end SR

sub name_clean {
	$_[0] = &strip_lead_trail_space($_[0]);
	$_[0] =~ s/\s{2,}/ /g;
	$_[0] =~ s/</&lt;/g;
	$_[0] =~ s/>/&gt;/g;
	return ($_[0]);
}

sub CleanVar2 {
	$_[0] =~ s/!/\\!/g;
	return ($_[0]);
}

sub SmallClean {
	$_[0] =~ s/~/\\~/g;
	return ($_[0]);
}

sub SmallClean2 {    #like SmallClean only doesn't double-escape
	$_[0] = &SmallClean($_[0]);
	$_[0] =~ s/\\\\~/\\~/g;
	if ($_[0] =~ m/\\$/) { $_[0] .= ' '; }
	return $_[0];
}

sub SmallClean3 {	# Replaces calls to SmallClean when converted to WriteHash
	return $_[0];
} # end SmallClean3

sub ConvertReturns {
	$_[0] = &strip_lead_trail_space($_[0]);
	$_[0] =~ s/\n\r/<br \/>/ig;
	$_[0] =~ s/\n\r\n/<br \/><br \/>/ig;
	$_[0] =~ s/\n/<br \/>/ig;
	$_[0] =~ s/\r//g;
	$_[0] =~ s/<\!/< \!/ig;
	$_[0] =~ s/(<ul.*?>)(<br \/>)/$1/ig;
	return ($_[0]);
} # end ConvertReturns

sub UnConvertReturns {
	$_[0] =~ s/<p>/\n\n/isg;
	$_[0] =~ s/<br>/\n/isg;
	$_[0] =~ s/<br \/>/\n/isg;
	$_[0] =~ s/<\/p>//gi;
	return($_[0]);
} # end UnConvertReturns

sub LimitReturns {
	$_[0] =~ s/\s+$//;
	$_[0] =~ s/\n{2,}/\n/g;
	$_[0] =~ s/\r{2,}/\r/g;
	$_[0] =~ s/(\n\r){2,}/\n/g;
	return ($_[0]);
}

sub EliminateReturns {
	$_[0] =~ s/\s{2,}/ /g;
	$_[0] =~ s/[\n\r]//g;
	return ($_[0]);
}

sub OpenForumsFile {
	unless ($alltheforums[0]) {
		@alltheforums = &OpenFileAsArray("$vars_config{VariablesPath}/vars_forums.cgi");
	}
	my @forumsfile = grep(/\|\^\|/, @alltheforums);
	return (@forumsfile);
}

sub Do2Digit {
	return(sprintf ("%.2d", $_[0]));
}


sub Do6Digit {
	return(sprintf ("%.6d", $_[0]));
}


sub Do8Digit {
	return(sprintf ("%.8d", $_[0]));
}

sub GetCatName {

	# $_[0] : category number
	my($j, $CName, $CNum, $one, $ThisCatName);
	my @catlist = &GetCategoriesFile;

	FINDIT: foreach $one (@catlist) {
		($j, $CName, $CNum) = split (/\|\^\|/, $one);
		chomp($CNum);
		if ($CNum == $_[0]) { $ThisCatName = "$CName"; last FINDIT; }
	}
	return ($ThisCatName);
}

sub Validate {
	my $Redo = '';
	my $BadLine = "";

	foreach my $each (@_) {
		chomp($each);

		if ($each !~ /\|/) {
			if ($in{$each} eq '') {
				$Redo = 'true';
				if ($each =~ /custom/) {
					if ($each eq 'customfield1') { $each = $vars_registration{customfield1}; }
					if ($each eq 'customfield2') { $each = $vars_registration{customfield2}; }
					if ($each eq 'customfield3') { $each = $vars_registration{customfield3}; }
					if ($each eq 'customfield4') { $each = $vars_registration{customfield4}; }
				}
				$BadLine .= "$vars_wordlets_err{did_not_complete} $each<br />";
			}

		} else {

			# this is an AND list
			my @splitter = split (/\|/, $each);
			$ok = 'false';
			foreach $one (@splitter) {
				chomp($one);
				if ($in{$one}) { $ok = 'true'; }
			}

			if ($ok eq 'false') {
				$Redo = 'true';
				$BadLine .= "$vars_wordlets{missing_input_line} $each<br />";
			}

		}    #end single/OR
	}
	if ($Redo eq 'true') {
		if (($in{ubb} eq 'submit_registration') || ($in{ubb} eq 'edit_profile')) {

			#print qq%Content-type: text/html\n\n%;
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			);

		}
		&StandardHTML("$vars_wordlets_err{missing_fields_intro}<p>$BadLine</p>");
	}
}    #end validate sr

sub GetForumRecord {

	&RequireVars("$vars_config{VariablesPath}/vars_mods.cgi");

	# $_[0] : forum number
	return @{$vars_forums{$_[0]}} if exists $vars_forums{$_[0]};

	my @foru = &OpenForumsFile;
	foreach my $one (@foru) {
		chomp($one);
		my @check = split (/\|\^\|/, $one);
		$vars_forums{$check[8]} = \@check;
		my $mod = "Forum" . $check[8] . "Moderator"; $mod = $$mod;
		if(defined $mod) { $vars_forums{$check[8]}->[18] = $mod; }
	} # end if

	return (@{ $vars_forums{$_[0]} });
} # end GetForumRecord


sub GetEmails {
	my ($dos, $EmailHere, $MemNum, $EmailLine, @EmailList);
	my @theemails = &GetEmailFileAsArray;

	foreach $dos (@theemails) {
		($EmailHere, $MemNum) = split (/\|\|/, $dos);
		chomp($MemNum);
		$EmailLine = "$EmailHere??$MemNum";
		push (@EmailList, $EmailLine);
	}
	return (@EmailList);
}

# thanks to Cal for this patch, even if it DOES use map :)
sub GeneratePassword {
	return &GeneratePasswordCore(6);
}

sub GeneratePassword2 {
	return &GeneratePasswordCore(8);
}

sub GeneratePasswordCore {
	# New list to try and eliminate potential typos, i.e. 1 vs l, O vs 0
	my @digit = qw(A B C D E G H J K M N P R S T U V W X Y Z 2 3 4 5 6 7 8 9);
	srand(time);
	return join('', map{ $digit[rand(@digit)] }(1 .. $_[0]) );
}

sub hit_me {
	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie");
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter");
	}

	unless (&FileExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi")) {
		&WriteFileAsString("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi", "0");
	}

	my $handle = $filehandle->open('file', 'readwrite', "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}-dynamic.cgi");
	my $hits = $handle->readline();
	chomp($hits);
	$hits++;
	$handle->relock('EX');
	$handle->truncate();
	$handle->print($hits);
	$filehandle->close($handle);
}    # end hit_me

sub auto_url {
	my $check = shift;
	$check =~ s/(^|\s)(http:\/\/\S+)(\.|\,|\))?/$1<a href="$2" target="_blank">$2<\/a>$3/isg;
	$check =~ s/(^|\s)(https:\/\/\S+)(\.|\,|\))?/$1<a href="$2" target="_blank">$2<\/a>$3/isg;
	$check =~ s/(^|\s)(ftp:\/\/\S+)(\.|\,|\))?/$1<a href="$2" target="_blank">$2<\/a>$3/isg;
	$check =~ s/(^|\s)(www\.\S+)(\.|\,|\))?/$1<a href="http:\/\/$2" target="_blank">$2<\/a>$3/isg;

	return ($check);
}    # end auto_url

sub UBBCode {
	$_[0] =~ s/(\[URL|(^|\s)http:\/\/|(^|\s)www\.)(\S*?)([".]+?)(\]|\[\/URL\]|\s|$)/$1$4$5$6/isg;
	$_[0] =~ s/(\[URL|(^|\s)ftp:\/\/|(^|\s)ftp\.)(\S*?)([".]+?)(\]|\[\/URL\]|\s|$)/$1$4$5$6/isg;
	$_[0] =~ s/(\[URL|(^|\s)https:\/\/|(^|\s)www\.)(\S*?)([".]+?)(\]|\[\/URL\]|\s|$)/$1$4$5$6/isg;


	$_[0] = &auto_url($_[0]);

	unless ($_[0] =~ /\[\/.+]/) {
		return ($_[0]);
	}    # only process if there are ubbcode tags

	# Security - DO NOT REMOVE
	# Security - DO NOT REMOVE
	# Security - DO NOT REMOVE

	if ($_[0] =~ /\.cookie/i) {
		&StandardHTML("$vars_wordlets_err{illegal_html_tag} COOKIE");
		exit(0);
	}
	if ($_[0] =~ /ONERROR[\s\n\r]*=/si) {
		&StandardHTML("$vars_wordlets_err{illegal_html_tag} ONERROR");
		exit(0);
	}

	if ($_[0] =~ /getcookie/i) {
		&StandardHTML("$vars_wordlets_err{illegal_html_tag} GETCOOKIE");
		exit(0);
	}

	# workaround for IE bug - make sure that there's no about: in the URL
	if ($_[0] =~ m!\[url\]?=?.+?about:.+?\]?.?\[/url\]?!i) {
		&StandardHTML("$vars_wordlets_err{illegal_html_tag} about:");
		exit(0);
	}
	if ($_[0] =~ m!\[img\]?=?.+?about:.+?\[/img\]?!i) {
		&StandardHTML("$vars_wordlets_err{illegal_html_tag} about:");
		exit(0);
	}

	# Security - DO NOT REMOVE
	# Security - DO NOT REMOVE
	# Security - DO NOT REMOVE


	my $match = 1;

	# Kludge.  If you know of a better way to get this done, let me know...
	while($match != 0) {
		$match = 0;
		last unless $_[0] =~ m/\[.+\]/;
		$match++ if $_[0] =~ s/(\[URL\])(http|https|ftp)(:\/\/\S+?)(\[\/URL\])/&urlize("$2$3", "$2$3")/eisg;
		$match++ if $_[0] =~ s/(\[URL\])(\S+?)(\[\/URL\])/&urlize("http:\/\/$2", $2)/eisg;
		$match++ if $_[0] =~ s/(\[URL=)(http|https|ftp)(:\/\/\S+?)(\])(.+?)(\[\/URL\])/&urlize("$2$3", $5)/eisg;
		$match++ if $_[0] =~ s/(\[URL=)(\S+?)(\])(.+?)(\[\/URL\])/&urlize("http:\/\/$2", $4)/eisg;
		$match++ if $_[0] =~ s/(\[EMAIL\])(\S+\@\S+?)(\[\/EMAIL\])/&urlize("mailto:$2", $2)/eisg;
# Code tag processing moved to ubb_lib_posting:Undo and RedoCodeTag

		if ($_[1] eq 'ON') {
			$match++ if $_[0] =~ s/(\[IMG\])(\S+?)(\[\/IMG\])/&imageize($2)/eisg;
			$match++ if $_[0] =~ s/(\[IMAGE\])(\S+?)(\[\/IMAGE\])/&imageize($2)/eisg;
		}

		$match++ if $_[0] =~ s/(\[QUOTE\])(.+?)(\[\/QUOTE\])(\s|\n|\r)*/ <\/font><blockquote><font size="1" face="$vars_style{FontFace}">$vars_wordlets{ubbcode_quote}:<\/font><hr \/><font size="$vars_style{TextSize}" face="$vars_style{FontFace}">$2<\/font><hr \/><\/blockquote><font size="$vars_style{TextSize}" face="$vars_style{FontFace}">/isg;
		$match++ if $_[0] =~ s/(\[i\])(.+?)(\[\/i\])/<i>$2<\/i>/isg;
		$match++ if $_[0] =~ s/(\[b\])(.+?)(\[\/b\])/<b>$2<\/b>/isg;
		$match++ if $_[0] =~ s/(\[qb\])(.+?)(\[\/qb\])/<strong>$2<\/strong>/isg;
		$match++ if $_[0] =~ s/(\[list\])(.+?)\[\*\]\n?\r?(.+?)(\[\/list\])[\n\r\s]*/<\/font><ul type="square"><li><font size="$vars_style{TextSize}" face="$vars_style{FontFace}">$3<\/font><\/li><\/ul><font size="$vars_style{TextSize}" face="$vars_style{FontFace}">/isg;
		$match++ if $_[0] =~ s/(\[list=)(A|1)(\])(.+?)\[\*\]\n?\r?(.+?)(\[\/list\])[\n\r\s]*/<\/font><ol type="$2"><li><font size="$vars_style{TextSize}" face="$vars_style{FontFace}">$5<\/font><\/li><\/ol><font size="$vars_style{TextSize}" face="$vars_style{FontFace}">/isg;
		$match++ if $_[0] =~ s/\n?\r?(\[\*\])/<\/font><\/li><li><font size="$vars_style{TextSize}" face="$vars_style{FontFace}">/isg;
	} # end while

	return ($_[0]);
} # end while

sub urlize {
	my $orig = shift;
	my $wording = shift;
	my $string = &ImageChecker($orig, 1);
	if($string) {
		$returner = qq~<a href="$orig" target="_blank">$wording</a>~;
	} else {
		$returner = q![url= ! . $orig . q!]! . $wording . q![/url]!;
	} # end if
}    #endsub

sub imageize {
	my $orig = shift;
	my $string = &ImageChecker($orig);
	if($string) {
		$returner = qq~ <img src="$orig" alt=" - " />~;
	} else {
		$returner = q![img] ! . $orig . q! [/img]!;
	} # end if
}    #endsub

sub ImageChecker {
	my $string = shift;
	my $flag = shift;
	my $returner;
	my $uber = &EscapeFilter($string);
	if (&ImageSanityFilter($string, $flag) && &ImageSanityFilter($uber, $flag)) {
		$returner = $string;
	} else {
		$returner = "";
	}    #endif
	return ($returner);
}    #endsub

sub ImageSanityFilter {
	my $string = shift;
	my $count = 0;
	$count++ if(($string =~ m/(ultimatebb|cp)\.(cgi|php|php4)/i) && (!$_[0]));
	$count++ if $string =~ m/[\"\'\`]/;
	$count++ if $string =~ m/on(load|error|mouse)/i;
	$count++ if $string =~ m/document\.\w+/i;
	$count++ if $string =~ m/about:/i;
	$count++ if $string !~ m/^(http|ftp|https|mailto)/;
	if($count) {
		&PostHackDetails("nostandardhtml");
		return 0;
	} # end if

	return 1;
} # end ImageSanityFilter

sub EscapeFilter {
	my $line = shift;
	$line =~ s/(\&\#\d+)[^\;]/$1\;/g;	# fix broken ampersands
	my $that = UBBCGI::unescapeHTML(UBBCGI::unescape($line));
	my $these = undef;
	ECKS: while($that ne $these) {
		# loop 'til we can't loop no more...
		$these = $that;
		$that =~ s/(\&\#\d+)[^\;]/$1\;/g;
		$that = UBBCGI::unescapeHTML($that);
		$that = UBBCGI::unescape($that);
		$that =~ s/(\&\#\d+)[^\;]/$1\;/g;
		$that = UBBCGI::unescapeHTML($that);
		$that = UBBCGI::unescape($that);
	} # end while
	return $that;
} # end EscapeFilter

sub CensorCheck {
	my ($ThisWord, $wordlength, $replaceword);
	# Well LK, I tried to make it work, but it didn't... any ideas?  ;)
	my $WordCheck = shift; #UBBCGI::unescapeHTML(UBBCGI::unescape(shift));
	#my $WordCheck = shift;
	my @censored = split (/\s+/, $vars_misc{censorwords});
	if ($vars_misc{Censor} eq 'ON') {
		for (@censored) {
			if (m/({)(.*)(})/) {
				$ThisWord    = $2;
				$wordlength  = length($ThisWord);
				$replaceword = '*' x $wordlength . " ";
				$WordCheck =~ s/\b$ThisWord\b/$replaceword/isg;
			} else {
				$wordlength  = length($_);
				$replaceword = "*" x $wordlength;
				$WordCheck =~ s/$_/$replaceword/isg;
			}
		}
	}
	return ($WordCheck);
}    # end CensorCheck


sub ClearUserPostHistories {
	require "File/Path.pm";
	import File::Path;
	rmtree("$vars_config{MembersPath}/user_posts") if &DirExists("$vars_config{MembersPath}/user_posts");
	mkdir("$vars_config{MembersPath}/user_posts", SEVENSEVENSEVEN);
	chmod(SEVENSEVENSEVEN, "$vars_config{MembersPath}/user_posts");
}

sub ClearSummaryCache {
	opendir(FILE, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary");
	my @summs = readdir(FILE);
	closedir(FILE);

	foreach (@summs) {
		&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary/$_");
	}

	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
	}
	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary");
	}
}

sub ClearPNTFCache {
	opendir(FILE, "$vars_config{NonCGIPath}/cache-$cache_cookie/pntf");
	my @lids = readdir(FILE);
	closedir(FILE);

	foreach(@lids) {
		next if m/^now(_accel)?\.cgi$/;
		&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/pntf/$_");
	}
} # end ClearPNTFCache

sub ClearSummaryCacheCarefully {
	if($vars_display{CategoriesOnly} eq 'false') {
		&ClearSummaryCache; return;
	} # end if

	# If categories only on first page is being used, only nuke
	# the summary for that one category.
	# To be used only during post operations.

	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
	}
	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary");
	}

	my $category = shift;
	opendir(FILE, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary");
	my @summs = grep(/^summary.+html$/, readdir(FILE));
	closedir(FILE);

	if($category =~ m/^\d{1,}$/) {
		$category = "-$category";
	} else {
		$category = "";
	} # end if

	FILE: foreach my $file (@summs) {
		if($file =~ m/^summary$category\.html$/) {
			&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary/$file");
		} else {
			next FILE;
		} # end if
	} # end foreach
} # end

sub ClearMiscCache {
	opendir(FILE, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc");
	my @summs = readdir(FILE);
	closedir(FILE);

	foreach (@summs) {
		&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc/$_");
	}

	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
	}
	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/misc");
	}

	&ClearPNTFCache; # JIC
}

sub ClearForumPageCache {
	require "File/Path.pm";
	import File::Path;

	rmtree("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page") if &DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page");

	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
	}
	mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page", SEVENSEVENSEVEN);
	chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page");
}

sub ClearSingleForumPageCache {

	# $_[0] : $the path for the forum page to be removed from cache
	# $_[1] : forum number

	require "File/Path.pm";
	import File::Path;

	rmtree("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]") if &DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]");


	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
	}

	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$_[0]");
	}
}

sub ClearForumTopicsCache {
	require "File/Path.pm";
	import File::Path;

	rmtree("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums") if &DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums");

	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
	}

	mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums", SEVENSEVENSEVEN);
	chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums");
}

sub ClearSingleForumTopicsCache {
	require "File/Path.pm";
	import File::Path;

	# $_[0] : $the path for the forum for which topics are to be removed from cache
	rmtree("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$_[0]") if &DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$_[0]");

	unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
	}
	mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$_[0]", SEVENSEVENSEVEN);
	chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$_[0]");
}

sub GetModLine {
	&RequireVars("$vars_config{VariablesPath}/vars_mods.cgi");

	my ($Moderator, @mods, @mod_links, $mod_name, $mod_num, $mod_line, @mod_profile);

	$Moderator = ("Forum" . "$_[0]" . "Moderator");
	$Moderator = $$Moderator;

	if ($Moderator) {

		#split up Mod var
		@mods = split (/\|\|\^\|\|/, $Moderator);

		@mod_links = ();
		foreach (@mods) {
			chomp($_);

			if ((&FileExists("$vars_config{MembersPath}/$_.cgi")) && ($_ ne '')) {
				@mod_profile = &OpenProfile($_);
				chomp($mod_profile[15]);
				chomp($mod_profile[0]);
				if ($mod_profile[15] eq '') {
					$mod_profile[15] = "$mod_profile[0]";
				}

				$mod_line = qq!<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$_">$mod_profile[15]</a>!;
				push (@mod_links, $mod_line);
			}
		}    # if member exists!

		$Moderator = join (", ", @mod_links);
	} else {
		$Moderator = "$vars_wordlets{no_mods}";
	}
	return ($Moderator);
}    # end get mod line


sub illegal_name_check {	# broken - won't allow &#0000; codes...

	# thanks to ajmanlover for inspiring the high bit character regexes
	if (
	($_[0] =~ m/^[\s\#\!\|]/) ||
	($_[0] =~ m/[!"`\;~><]/) ||
	($_[0] =~ m/\|+/) ||
	($_[0] =~ m/\&(nbsp|amp|gt|lt)/) ||
	($_[0] =~ m/[\s\|]$/) ||
	($_[0] =~ m/\s{2,}/) ||
	($_[0] =~ m/__\w+__/)
	) {

		if (($in{ubb} eq 'submit_registration') || ($in{ubb} eq 'edit_profile')) {

			#print qq%Content-type: text/html\n\n%;
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			);

		}
		&StandardHTML("$vars_wordlets_err{bad_reg_chars}");
	}    # end name tripwire

	#the high-bit regexes are a little tricky, and require refinement....
	if (
	(($_[0] =~ m/[\x80-\xFF]/) && ($vars_registration{allowHighBit} ne "YES")) ||
	(($_[0] !~ m/^[a-zA-Z0-9\!\?\#\$\@\*\&\^\+\-\:\[\]\']/) && ($vars_registration{allowHighBit} ne "YES")) ||
	(($_[0] !~ m/[a-zA-Z0-9\!\?\#\$\@\*\&\^\+\-\:\[\]\'\.]$/) && ($vars_registration{allowHighBit} ne "YES")) ||
	($_[0] =~ m/[\x00-\x1f]/)
	) {

		if (($in{ubb} eq 'submit_registration') || ($in{ubb} eq 'edit_profile')) {

			#print qq%Content-type: text/html\n\n%;
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			);

		}
		&StandardHTML("$vars_wordlets_err{bad_reg_chars}");

	}
}

sub verify_id_num {

	# used for verifying all cookie user info
	my $un       = shift;
	my $pw       = shift;
	my $user_num = shift;
	chomp($user_num);
	my ($lcpw, $lc_un, $lc_pw_in, $lc_un_in);

	#do we have a user number?
	if (($user_num eq '') || ($user_num !~ /^\d{8}$/)) {
		&StandardHTML("$vars_wordlets_err{invalid_username}");
	}

	my @profile = &OpenProfile2("$user_num");
	if(!$profile[0]) {
		&StandardHTML($vars_wordlets_err{member_gone2});
	} # end if
	chomp($profile[0]);
	chomp($profile[1]);

	#lowercase everything
	$lcpw     = lc($profile[1]);
	$lc_un    = lc($profile[0]);
	chomp($lc_pw_in = lc($pw));	# jic
	chomp($lc_un_in = lc($un));

	# check password
	if ($lcpw ne "$lc_pw_in") {
		&StandardHTML(qq($vars_wordlets_err{invalid_password}));
	}

	# check username
	if ($lc_un ne "$lc_un_in") {
		&StandardHTML("$vars_wordlets_err{invalid_username}");
	}
	return (@profile);
}    #end verify_id_num


sub verify_id_num_2 {

	# verify_id_num_2 is the same as verify_id_num,
	# except that we need to print the header here if there
	# is a problem!

	# used for verifying all cookie user info
	my $un       = shift;
	my $pw       = shift;
	my $user_num = shift;
	chomp($user_num);
	my ($lcpw, $lc_un, $lc_pw_in, $lc_un_in);

	#do we have a user number?
	if (($user_num eq '') || ($user_num !~ /^\d{8}$/)) {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{invalid_username}");
	}

	my @profile = &OpenProfile2("$user_num");
	if(!$profile[0]) {
		&StandardHTML($vars_wordlets_err{member_gone2});
	} # end if
	chomp($profile[0]);
	chomp($profile[1]);

	#lowercase everything
	$lcpw     = lc($profile[1]);
	$lc_un    = lc($profile[0]);
	chomp($lc_pw_in = lc($pw));	# jic
	chomp($lc_un_in = lc($un));

	# check password
	if ($lcpw ne "$lc_pw_in") {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{invalid_password}");
	}

	# check username
	if ($lc_un ne "$lc_un_in") {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{invalid_username}");
	}
	return (@profile);
}    #end verify_id_num_2


sub check_email_bans {

	# parameter:
	# $_[0] : email

	my $checker = shift;

	my (@banlist, $banword, $banword2);

	if (&FileExists("$vars_config{NonCGIPath}/BanLists/EmailBan.cgi")) {
		@banlist = &OpenFileAsArray("$vars_config{NonCGIPath}/BanLists/EmailBan.cgi");
	} else {
		return;
	}

	if ($banlist[0]) {

		my $check = 0;
		CHECKBANLIST: foreach $word (@banlist) {
			chomp($word);
			$word = quotemeta($word);
			if ($checker =~ m/$word/i) {
				$check++;
				last CHECKBANLIST;
			}
		}    #endforeach

		$vars_misc{'ReverseEmailBans'} = "NO" unless $vars_misc{'ReverseEmailBans'};

		if (($check > 0) && ($vars_misc{'ReverseEmailBans'} ne "YES")) {
			if (($in{ubb} eq 'submit_registration') || ($in{ubb} eq 'edit_profile') || ($in{ubb} eq 'do_)lgin')) {

				#print qq%Content-type: text/html\n\n%;
				print header(
					-charset => "$masterCharset",
					-type    => "text/html",
				);
			}
			&StandardHTML("$vars_wordlets_err{banned_email}");
		} elsif (($check < 1) && ($vars_misc{'ReverseEmailBans'} eq "YES")) {

			if (($in{ubb} eq 'submit_registration') || ($in{ubb} eq 'edit_profile') || ($in{ubb} eq 'do_login')) {

				#print qq%Content-type: text/html\n\n%;
				print header(
					-charset => "$masterCharset",
					-type    => "text/html",
				);
			}
			&StandardHTML("$vars_wordlets_err{banned_email}");
		} else {
			return;    #ovbiously not banned
		}    #endif


	}    #if EmailBan list is not empty
}    # end check_email_bans


sub check_ip_bans {

	my (@ip_ban_list, $ip_number, $banword, $banword2);
	$ip_number = &GetIPAddress;

	# Check IP Ban List--
	if (&FileExists("$vars_config{NonCGIPath}/BanLists/IPBan.cgi")) {
		@ip_ban_list = &OpenFileAsArray("$vars_config{NonCGIPath}/BanLists/IPBan.cgi");
	} else {
		return;
	}

	if ($ip_ban_list[0]) {

		my $check = 0;
		CHECKBANLIST: foreach $word (@ip_ban_list) {
			chomp $word;
			$banword = quotemeta $word;
			if ($ip_number =~ m/^$banword/i) {

				#print "Banned!";
				$check++;
				last CHECKBANLIST;
			} else {

				#print "NOT banned! (";
			}
		}    #endforeach

		$vars_misc{'ReverseIPBans'} = "NO" unless $vars_misc{'ReverseIPBans'};

		if (($check > 0) && ($vars_misc{'ReverseIPBans'} ne "YES")) {
			if (($in{ubb} eq 'submit_registration') || ($in{ubb} eq 'edit_profile') || ($in{ubb} eq 'do_login')) {

				#print qq%Content-type: text/html\n\n%;
				print header(
					-charset => "$masterCharset",
					-type    => "text/html",
				);
			}
			&StandardHTML("$vars_wordlets_err{ip_banned} $ip_number");

		} elsif (($check < 1) && ($vars_misc{'ReverseIPBans'} eq "YES")) {
			if (($in{ubb} eq 'submit_registration') || ($in{ubb} eq 'edit_profile') || ($in{ubb} eq 'do_login')) {

				#print qq%Content-type: text/html\n\n%;
				print header(
					-charset => "$masterCharset",
					-type    => "text/html",
				);
			}
			&StandardHTML("$vars_wordlets_err{ip_banned} $ip_number");
		} else {
			return;
		}    #endif


	}    #if ip_ban_list is not empty
}    # end ip ban check


# another Cal patch
sub make_random_number {
	my @digit = (1..9);
	return( join( '', map{ $digit[int(rand(@digit))] }(1..6) ) );
} # end sub


sub check_private_access {
	my (@profile, $Moderator);
	&RequireVars("$vars_config{VariablesPath}/vars_mods.cgi");

	# since forum is private, user must be logged in

	# $_[0]: forum number
	# $_[1]: forum password (blank, if none)

	if ($username eq '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a></p>!);
	}

	# user is logged in, so get profile
	@profile = &verify_id_num($username, $password, $user_number);
	chomp($user_number);
	chomp($profile[8]);
	chomp($profile[4]);



	unless ($profile[8] eq 'Administrator') {

		if ($profile[8] eq 'Moderator') {

			$Moderator = ("Forum" . "$_[0]" . "Moderator");
			$Moderator = $$Moderator;

			$user_number = &Do8Digit($user_number);

			unless ($Moderator =~ /$user_number/) {

				# user is not moderator, so check for explicit permission
				#print "$Moderator ne $user_number";
				&check_explicit($profile[4], $_[0], $_[1]);
			}

		} else {
			&check_explicit($profile[4], $_[0], $_[1]);

		}
	}    # if not an admin

}    # end check private access


sub check_explicit {
	my ($j, $perms, @explicit, $access_rights, $forum_name, %pwhash, $forumpw);

	# one argument:
	# $_[0] : user permissions (from profile[4])
	# $_[1] : forum number
	# $_[2] : forum password (blank, if none)

	($j, $perms) = split (/&/, $_[0]);
	@explicit = split (/,/, $perms);

	foreach (@explicit) {
		chomp($_);
		if ($_[1] == $_) { $access_rights = 'true'; }
	}

	unless ($access_rights eq 'true') {

		if ($_[2] ne '') {

			# check to see if forumpw cookie set:
			$forumpw = cookie("forumpw$vars_config{Cookie_Number}");
			%pwhash  = split (/\|\^\|/, $forumpw);

			# pw hash check
			unless ((exists($pwhash{$_[1]})) && ($pwhash{$_[1]} eq "$_[2]")) {

				my @forum_line = &GetForumRecord($_[1]);
				$forum_name = $forum_line[1];
				&set_page_elements;
				&LoadTemplate("public_query_forum_pw");
				exit(0);

			}

		} else {
			&StandardHTML("$vars_wordlets_err{no_access}");
		}    # end if forum pw exists

	}    # end access right ne true

}    # end check_explicit sr


sub strip_lead_trail_space {
	$_[0] =~ s/^\s+//;
	$_[0] =~ s/\s+$//;
	return ($_[0]);
} # end

sub strip_lead_trail_whitespace {
	# like slt_space, but does newlines also
	$_[0] =~ s/^(\s|\n|\r)+//;
	$_[0] =~ s/(\s|\n|\r)+$//;
	return ($_[0]);
} # end

sub CustomTitle {
	my $title = shift;
	my $postnumber = shift;

	chomp($title);	# JICism
	chomp($postnumber);

	my $custom_title;

	if ($title eq "Administrator") {
		$custom_title = $vars_misc{AdminTitle};
	} elsif ($title eq "Moderator") {
		$custom_title = $vars_misc{ModeratorTitle};
	} elsif (($title eq "Member") || ($title eq "Junior Member")) {
		if(!$postnumber && ($postnumber != 0)) {
			# incorrect call -> return standard title
			$custom_title = $title;
		} # end if
		my $dex = 0;
		my @titles = sort {$a <=> $b} keys %{$vars_misc{custom_titles}};
		my $total = scalar(@titles) - 1;
		foreach my $num (@titles) {
			if($num > $postnumber) {
				$dex--;
				last;
			} elsif($num == $postnumber) {
				last;
			} # end if
			last if $dex == $total;
			$dex++;
		} # end foreach

		$custom_title = $vars_misc{custom_titles}->{$titles[$dex]};
	} # end if

	return $custom_title;
}    # end customer title sr

sub email_test {
	if (($_[0] =~ m/\s/) ||
	($_[0] !~ /\S+\@\S+\.\S+/) ||
	($_[0] =~ /^\./) ||
	($_[0] =~ /\.{2,}/) ||
	($_[0] =~ /\.$/) ||
	($_[0] =~ /\.\@/) ||
	($_[0] =~ /\@\./) ||
	($_[0] =~ /;/)) {
		return 1;
	} else {
		return 0;
	}
} # end email_test


sub build_mod_emails {
	&RequireVars("$vars_config{VariablesPath}/vars_mods.cgi");
	my ($Moderators, $mod_emails, @mods, @mod_profile, @mod_email);

	# $_[0] : forum number

	$Moderators = ("Forum" . "$_[0]" . "Moderator");
	$Moderators = $$Moderators;

	#split up Mod var
	@mods = split (/\|\|\^\|\|/, $Moderators);

	foreach (@mods) {
		if (-s "$vars_config{MembersPath}/$_.cgi") {
			@mod_profile = &OpenProfile($_);
			chomp($mod_profile[2]);
			push (@mod_email, $mod_profile[2]);
		}
	}

	# combine emails
	$Moderators = join (", ", @mod_email);

	return ($Moderators);

}


sub CheckCachedFile {
	return if $in{ubb} =~ m/prune/;    #if we're pruning, ignore the missing file
	my $file      = shift;
	my $cachepath = $vars_config{NonCGIPath} . "/cache";
	my $forumpath = $vars_config{NonCGIPath} . "/Forum";
	if ($file =~ m/^$cachepath/) {

		unless (&DirExists("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}")) {
			mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}", SEVENSEVENSEVEN);
			chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}");
		}    # cache pw without directory == screwy setup, so create

		unless (&DirExists("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}")) {
			&StandardHTML($vars_wordlets_err{cache_broken});
		}    # If it still didn't get created, our noncgi directory is screwy, so have user fix

	} elsif ($file =~ m!^$forumpath(\d+).*/(\d\d\d\d\d\d)\.cgi$!) {    #also check to see if this is a thread file
		&StandardHTML(&Template($vars_wordlets_criterr{check_cached_keelover}, { FORUM => $1, THREAD => $2 }))
	}    #endif

	return;
}    #end


sub CheckForExistingNames {
	my $input_name  = shift;    #lower case username
	my $printheader = shift;

	# make sure publicly displayed name is unique
	# and check login name against pub names

	foreach my $item (&GetMemberListArray) {
		chomp($item);
		next unless $item;
		$item2 = lc($item);

		if ($input_name eq $item2) {
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			    ) if $printheader;
			&StandardHTML("$vars_wordlets_err{dupe_name}");
		}
	}

	foreach my $duper (&GetPubNamesAsArray) {
		chomp($duper);
		next unless $duper;
		my $lc_it = lc($duper);

		if ($input_name eq $lc_it) {
			print header(
				-charset => "$masterCharset",
				-type    => "text/html",
			    ) if $printheader;
			&StandardHTML("$vars_wordlets_err{dupe_name_pdn}");
		}

	}

	return;
}    #endsub



sub CheckLength {

	#checks %in for bad lengths, truncates where nessecary
	my ($invalue, $formlength) = @_;
	return unless exists $in{$invalue};
	$in{$invalue} =~ s/[\x00-\x1f]//gsi;
	if (length($in{$invalue}) > $formlength) {
		$in{$invalue} = substr($in{$invalue}, 0, $formlength);
	}
}    #endsub


sub CheckLength2 {

	#checks a passed value for bad lengths, truncates where nessecary
	#doesn't filter lowbits
	my ($invalue, $formlength) = @_;
	if (length($invalue) > $formlength) {
		$invalue = substr($invalue, 0, $formlength);
	}

	return $invalue;
}    #endsub

sub CheckLengthOrDie {

	#checks %in for bad lengths, then dies if it's unexpected
	my ($invalue, $formlength) = @_;
	$formlength++;
	$in{$invalue} =~ s/[\x00-\x1f]//g;
	if (length($in{$invalue}) > $formlength) {
		my $errorstring = &Template($vars_wordlets_criterr{bad_form_length}, {
					INVALUE => $invalue,
					THISLENGTH => length($in{$invalue}),
					FORMLENGTH => $formlength,
					});
		&StandardHTML("$vars_wordlets_err{bad_input} <br />$errorstring");
		exit(0);
	}
}    #endsub


sub NeutralizeHTMLEntities {
	return UBBCGI::escapeHTML($_[0]);
}    #endsub

sub NeutralizeBackHTMLEntities {
	return UBBCGI::unescapeHTML($_[0]);
}    #endsub


sub CustomGraemlins { # new format
	my $string = shift;

	foreach my $item (keys %{$vars_graemlins->{'graems'}}) {
		my $short = %$vars_graemlins->{'graems'}->{$item};
		# /g isn't doing the right thing, soooo....
		while($string =~ s/(^|\W)\:\Q$short->{'trigger'}\E\:(\W|$)/$1 <img border="0" alt="[$short->{'text'}]" title="" src="graemlins\/$short->{'image'}" \/> $2/i) { next; }
	}    #endforeach

	foreach my $item (keys %{$vars_graemlins->{'origs'}}) {
		my $short = %$vars_graemlins->{'origs'}->{$item};
		while($string =~ s/(^|\W)\Q$short->{'trigger'}\E(\W|$)/$1 <img border="0" title="" alt="[$short->{'text'}]" src="$short->{'image'}" \/> $2/i) { next; }
	}    #endforeach

	return $string;
}    #endsub


sub GoodNiceTruncate {	# now with a brain!
	my ($string, $slength) = @_;

	return $string if (length($string) <= $slength);

	my @words = split(/\s+/, $string);
	my $returnstring;
	$slength -= 3;

	APPENDER: foreach my $word(@words) {
		$returnstring .= $word;
		if(length($returnstring) > $slength) {
			last APPENDER;
		} else {
			$returnstring .= " ";
		}
	} # end foreach

	if(join(" ", @words) ne $returnstring) {
		$returnstring .= "...";
	} # end if

	return $returnstring;
}    #end sub NiceTruncate


sub GetOrPost {
	my $expected = shift;
	die(&Template($vars_wordlets_criterr{bad_request_method}, { METHOD => $ENV{REQUEST_METHOD} })) unless $ENV{REQUEST_METHOD} =~ m/^(GET|POST|HEAD)$/;
	&StandardHTML($vars_wordlets_err{invalid_input}) unless $ENV{REQUEST_METHOD} eq $expected;
	return;
}    #endsub


sub Exit {	# oh hush.
	exit(0);
}

sub DoThatClearCacheThing {

	my ($thispath, $thread) = @_;

	if (&DirExists($thispath)) {
		opendir(DIR, "$thispath") or die &Template($vars_wordlets_criterr{cant_open}, {ERR => $!, THING => $thispath});
		my @removeus = grep(/^$thread/, readdir(DIR));
		closedir(DIR);
		foreach my $thisfile (@removeus) {
			&Unlink("$thispath/$thisfile");
		}    #endforeach
	}    #endif

	return;

}    #endsub

sub SetExactPath {
	my $forum      = shift;
#	print header. "EP4: $forum ($exact_path)<br />";
	return $exact_path if(($exact_path) && ($exact_path =~ m/Forum$forum([\D-]+|$)/));
	&GetForumRecord($forum) unless $vars_forums{$forum};
	$exact_path    = "Forum$forum";
	if ($vars_forums{$forum}->[6] =~ m/private/) {
#		print "EP4: $forum is private<br />";
		$exact_path .= "/private-$vars_forums{$forum}->[7]";
	} else {
#		print "EP4: $forum is NOT private<br />";
	} # end if
#	print "EP4: $forum: $exact_path<br />";
	return $exact_path;
}    #endsub

sub GetCategoriesFile {
	return @allthecategories if @allthecategories;
	@allthecategories = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");
	return @allthecategories;
}

sub LoadTemplate {
	my $fn = shift;

#	print header;

#	print "<pre>LT - $fn($template_html{'CURRENT'})" . &Tracer . "</pre>";

	my $abs = (defined($template_html{"CURRENT"}) ? "$template_html{CURRENT}/" : "" );

	# reload public_common for this particular style template
	if(($fn =~ m/^public/) && (join("", caller()) !~ m/LoadTemplate/)) {
		if($fn ne "public_common") {
			if($template_html{"PUBCOMMON"} ne $template_html{"CURRENT"}) {
				&LoadTemplate("public_common");
				&InitImportantStuff;
				&init_public_common;
				&set_page_elements;
			} # end if
		} # end if
	} # end if


	my $file = "$vars_config{NonCGIPath}/Templates/$fn.pl";
	my $file2 = "$vars_config{NonCGIPath}/Templates/$abs$fn.pl";

	if(&FileExists($file2) && $abs) {
		&RequireCode($file2);
	} elsif(&FileExists($file)) {
		&RequireCode($file);
	} else {
		&StandardHTML(&Template($vars_wordlets_criterr{bad_template_name}, { FN => $fn }));
	}
	return;
} #endsub

sub RequireCode {	# fakes a require()
	do $_[0]; die "$_[0]: $@" if $@;
} #endsub

sub RequireVars {	# fakes a require and locks the file
	my $token = &OpenAndLock($_[0]);
	do $_[0]; die "$_[0]: $@" if $@;
	&CloseAndUnlock($token);
} #endsub

sub LoadStyleTemplate {
	my $name = shift;

#	print header . "<pre>LST: Name: $name" . &Tracer . "</pre><br />";

	my $number = 1;
	if($name =~ m/^\d+$/) {
		die "LoadStyleTemplate no longer takes a number." . &Tracer;
	} # end if

	local(%vars_style);	# use our own copy rather than the global one

	if($name eq "transition") {
		if($vars_style_reference{"current_style"} =~ m/^forum_(\d+)$/) {
			my $n = quotemeta("|$1|");
			if($template_match{"trans_forums"} =~ m/$n/) {
				$name = $vars_style_reference{"current_style"};
			} # end if
		} # end if
	} # end if

	if(exists $template_match{$name}) {
		$number = $template_match{$name};
		$vars_style_reference{"current_style"} = $name;
	} else {
		$number = 1; # saroo?
	} # end if

#	print header . "<br />Num: $number ($template_match{$name})<br />";

	if(!$vars_style_reference{$number}) {
		&RequireVars("$vars_config{NonCGIPath}/styles/vars_style_$number.cgi");

		# set the new defaults
		$vars_style{"plain_old_regular_lock"} ||= "lock.gif";
		$vars_style{"print_topic_icon"} ||= "print_topic.gif";
		$vars_style{"pollbar_color"} ||= "#000000";
		$vars_style{"thisCharset"} ||= $vars_display{masterCharset};
		$vars_style{"BBPoll"} ||= "postpoll.gif";
		$vars_style{"PollVote"} ||= "votenow.gif";
		$vars_style{"PollResults"} ||= "voteresults.gif";
		$vars_style{"new_poll_folder"} ||= "poll_new.gif";
		$vars_style{"old_poll_locked_folder"} ||= "poll_old_locked.gif";
		$vars_style{"new_poll_locked_folder"} ||= "poll_new_locked.gif";
		$vars_style{"plain_old_regular_lock"} ||= "lock.gif";
		$vars_style{"old_poll_folder"} ||= "poll_old.gif";
		$vars_style{"ubbcode_url"} ||= "url.gif";
		$vars_style{"ubbcode_email_url"} ||=  "email_url.gif";
		$vars_style{"ubbcode_bold"} ||= "bold.gif";
		$vars_style{"ubbcode_italics"} ||= "italics.gif";
		$vars_style{"ubbcode_ubb_quote"} ||= "ubb_quote.gif";
		$vars_style{"ubbcode_code"} ||= "code.gif";
		$vars_style{"ubbcode_list_start"} ||= "list-start.gif";
		$vars_style{"ubbcode_list_item"} ||= "list-item.gif";
		$vars_style{"ubbcode_list_end"} ||= "list-end.gif";
		$vars_style{"ubbcode_image"} ||= "image.gif";

		$vars_style{"FontTag"} = qq(<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">);
		$vars_style{"SmallFontTag"} = qq(<font face="$vars_style{FontFace}" size="$vars_style{FDTextSize}">);
	} else {
		%vars_style = %{$vars_style_reference{$number}};
	} # end if
#	print header;

#	print "<hr />";

	# Now that we have a vars_style, let's switch HTML template sets...
	if($template_html{$name} ne $template_html{'CURRENT'}) {
#		die;
#		print qq!<big>-- $template_html{'CURRENT'} = $template_html{$name} --</big><br />!;
		$template_html{'CURRENT'} = $template_html{$name};
		&LoadTemplate("public_common");
		&InitImportantStuff;	#ubb_lib
		$MainButtonsLine = &MainButtonOptions;	# public_common
		&init_public_common;	#public_common
		&set_page_elements;	#public_common
	} else {
#		print qq!<big><b>+ $template_html{'CURRENT'} = $template_html{$name} +</b></big><br />!;
	} # end if

	$vars_style_reference{$number} = \%vars_style;

	return %vars_style;
}

sub LoadStyleTemplateRaw {
	my $number = shift;

	local(%vars_style);	# use our own copy rather than the global one

	if($vars_style_reference{$number}) {
		return %{$vars_style_reference{$number}};
	}

	&RequireVars("$vars_config{NonCGIPath}/styles/vars_style_$number.cgi");

	# set the new defaults
	$vars_style{"plain_old_regular_lock"} ||= "lock.gif";
	$vars_style{"print_topic_icon"} ||= "print_topic.gif";
	$vars_style{"pollbar_color"} ||= "#000000";
	$vars_style{"thisCharset"} ||= $vars_display{masterCharset};
	$vars_style{"BBPoll"} ||= "postpoll.gif";
	$vars_style{"PollVote"} ||= "votenow.gif";
	$vars_style{"PollResults"} ||= "voteresults.gif";
	$vars_style{"new_poll_folder"} ||= "poll_new.gif";
	$vars_style{"old_poll_locked_folder"} ||= "poll_old_locked.gif";
	$vars_style{"new_poll_locked_folder"} ||= "poll_new_locked.gif";
	$vars_style{"plain_old_regular_lock"} ||= "lock.gif";
	$vars_style{"old_poll_folder"} ||= "poll_old.gif";
	$vars_style{"ubbcode_url"} ||= "url.gif";
	$vars_style{"ubbcode_email_url"} ||=  "email_url.gif";
	$vars_style{"ubbcode_bold"} ||= "bold.gif";
	$vars_style{"ubbcode_italics"} ||= "italics.gif";
	$vars_style{"ubbcode_ubb_quote"} ||= "ubb_quote.gif";
	$vars_style{"ubbcode_code"} ||= "code.gif";
	$vars_style{"ubbcode_list_start"} ||= "list-start.gif";
	$vars_style{"ubbcode_list_item"} ||= "list-item.gif";
	$vars_style{"ubbcode_list_end"} ||= "list-end.gif";
	$vars_style{"ubbcode_image"} ||= "image.gif";
#	$vars_style{"special"} ||= 1;
#	$vars_style{"css_name"} ||= "";


	$vars_style{"FontTag"} = qq(<font face="$vars_style{FontFace}" size="$vars_style{TextSize}">);
	$vars_style{"SmallFontTag"} = qq(<font face="$vars_style{FontFace}" size="$vars_style{FDTextSize}">);

	$vars_style_reference{$number} = \%vars_style;

	return %vars_style;
} # end RAW

sub ServeFromCache {

	# if the cache is off and we have NOT generated a new page, return
	return if(($vars_misc{use_cache} eq "no") && (!$ThisHTML));

	# if we've generated a new page, print it and return
	if($ThisHTML) { print &FilterPNTF($ThisHTML); return; }

	my $filename = "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/$_[0]";

	my @r = stat($filename);
	if(@r) {
		if(($r[7] ne '') && ($r[7] > 0)) {
			if(($vars_pntf{Enabled} eq "yes") && ($vars_pntf{Mode} ne "hidden")) {
				# Yes, yes, I know.
				# It's ugly, but troubleshooting code has to work SOMEHOW....
				if( (!exists $in{ubb})
				    || (($in{ubb} ne '') || ($in{ubb} eq undef))
				    || ($in{ubb} eq "forum")
				    || ($in{ubb} eq "get_topic") ) {
					print &FilterPNTF(&OpenFileAsString($filename));
				} else {
					&OpenFileToSTDOUT($filename);
				} # end if
			} else {
				&OpenFileToSTDOUT($filename);
			} # end if
			exit(0);
		} else {
			&Unlink($filename) or die &Template($vars_wordlets_criterr{bad_unlink}, {FILE => $_[0], OSERR => $!});
			return;
		} # end if
	} else {
		return;
	} # end if

} #endsub

sub Tracer {
	my $string;
	my $i = 0;
	$i = 4 if(caller(0))[3] =~ /StandardHTML/i; # UBBCGI::Carp::die ->
	while(@_ = caller($i)) {		    # fatalsToBrowser ->
		my $file = $_[1];		    # StandardHTML2 -> Tracer
		$file =~ s!(.*)(\\|/)([^/\\]+)$!$3!;
		$string = "$vars_wordlets_criterr{backtrace} $file:$_[2] -> sub $_[3]<br />\n$string";
		$i++;
	}
	return $string . "\n";
} # end sub

sub DuplicateArrayAsHash {
	my %hash = map { $_ => $_ } @_;
	return %hash;
} # end sub


sub GetIPAddress {
	if($ENV{'REMOTE_ADDR'} eq "127.0.0.1") {
		if(($ENV{'HTTP_X_FORWARDED_FOR'} ne "") && ($ENV{'HTTP_X_FORWARDED_FOR'} ne "127.0.0.1")) {
			return $ENV{'HTTP_X_FORWARDED_FOR'};
		} # end if
	} # end if

	return $ENV{'REMOTE_ADDR'};
} # end GetIPAddress


sub Template { # Finally, a purpose!
	my($string, $hash) = @_;
	my $p = "%%";
	foreach my $before (keys %{ $hash }) {
		$string =~ s/$p$before$p/$hash->{$before}/gi;
	} # end foreach
	return $string;
} # end Template


sub FilterPNTF {
	my $string = shift;

	return $string if(($vars_pntf{Enabled} ne "yes") or ($vars_pntf{Mode} eq "hidden"));

	# Only find the first instance
	return $string
		unless $string =~ /<\?PHP pntfGetCacheFor(Summary|Forum)\('([^\']*)', "([^\"]*)", "([^\"]*)", "([^\"]*)"\) \?>/i;

	my($func, $options, $l, $r, $colspans) = ($1, $2, UBBCGI::unescape($3), UBBCGI::unescape($4), $5);

	my($replace, $fto);
	if($func eq "Summary") {
		if($options) {
			$fto = "9999_$options";
		} else {
			$fto = "9999";
		}

		$replace = &OpenTimedCachedFile("/pntf/$fto.cgi", ($vars_pntf{Prune} * 30)); # (time / 2 * 60)

		if(!$replace) {
			&LoadTemplate("public_pntf_summary");
			my $results = $PNTF->examine2_summary;
			$replace = &QuickSummary($vars_config{BBName}, "", $results, $colspans);
			$replace = &Template($replace, {
				SPANCOLOR => ($vars_pntf{Docked} eq "yes" ? $vars_style{CategoryStripColor} : $vars_style{TableColorStrip} ),
				SPANTCOLOR => ($vars_pntf{Docked} eq "yes" ? $vars_style{CategoryStripTextColor} : $vars_style{TableStripTextColor} ),
				});
			&WriteFileAsString("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/pntf/$fto.cgi", $replace);
		} # end if

	} elsif($func eq "Forum") {
		if($options =~ m/^\d+$/) {
			my $fto = sprintf("%04d1000_0000", $options);
			$replace = &OpenTimedCachedFile("/pntf/$fto.cgi", ($vars_pntf{Prune} * 30)); # (time / 2 * 60)

			if(!$replace) {
				&LoadTemplate("public_pntf_summary");
				my $results = $PNTF->examine2_forum($options);
				$replace = &QuickSummary((&GetForumRecord($options))[1], ";f=$options", $results, $colspans);
				$replace = &Template($replace, {
					SPANCOLOR => ($vars_pntf{Docked} eq "yes" ? $vars_style{CategoryStripColor} : $vars_style{TableColorStrip} ),
					SPANTCOLOR => ($vars_pntf{Docked} eq "yes" ? $vars_style{CategoryStripTextColor} : $vars_style{TableStripTextColor} ),
					});
				&WriteFileAsString("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/pntf/$fto.cgi", $replace);
			} # end if
		} # end if
	} # end if

	$string =~ s/<\?PHP pntfGetCacheFor(Summary|Forum)\('([^\']*)', "([^\"]*)", "([^\"]*)", "([^\"]*)"\) \?>/$l$replace$r/i;

	return $string;
} # end FilterPNTF


sub OpenTimedCachedFile {
	return undef if $vars_misc{use_cache} eq "no";
	my $file = "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}" . shift;
	my $timer = shift;

	my @schtat = stat($file);
	if(@schtat) {
		if(($schtat[9] + $timer) > time()) {
			return &OpenFileAsString($file);
		} else {
			&Unlink($file);
			return undef;
		} # end if
	} else {
		return undef;
	} # end if
} # end OpenTimedCachedFile


sub OpenTimedCachedTopic {
	return undef if $vars_misc{use_cache} eq "no";
	my $path = "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/ubb_files/forums/" . shift;
	my $topic = shift;
	my $fullpath = "$path/$topic.cgi";
	my $timer = shift;
	my $data = shift;

	$topic =~ m/(\d{6})/;
	my $raw_topic = $1;

	my @schtat = stat($fullpath);
	if(@schtat) {
		if(($schtat[9] + $timer) > time()) {
			return &OpenFileAsString($fullpath);
		} else {
			&DoThatClearCacheThing($path, $raw_topic);
			return undef;
		} # end if
	} else {
		return undef;
	} # end if
} # end OpenTimedCachedFile

sub flatten_hash {
	my $hash = shift;
	my @string;
	foreach(keys %{$hash}) {
		push(@string, qq~$_|^|$hash->{$_}~);
	} # end foreach
	return join("|!!|", @string);
} # end flatten_hash

sub unflatten_hash {
	my @vals = split(/\|\!\!\|/, shift);
	my %hash;
	foreach(@vals) {
		my @z = split(/\|\^\|/);
		$hash{$z[0]} = $z[1];
	} # end foreach
	return \%hash;
} # end unflatten_hash

sub paginate {
	my($pages, $current) = @_;

	my @r;
	if($pages < 10) {
		foreach(1 .. $pages) {
			push(@r, {$_ => $_});
		} # end if
		return @r;
	} # end if

	foreach(1 ..  3 ) { push(@r, {$_ => $_}); }

	my $bottom = $current + 3 ;
	my $top = $current +  3 ;

	if($bottom < 4 ) {
		push(@r, {"..." => round($pages / 2)});	# start or back
	} # end if

	if($top > $pages) {
		push(@r, {"..." => round($pages / 2)});	# start or back
	} # end if

	if(($bottom > 1) || ($top < $pages)) {
		# We're somewhere in the dotted region.
		my @x;
		foreach(( 3  + 1) .. ($pages - 3)) {
			if(($_ + 3 == $current) || ($_ + 2 == $current) || ($_ + 1 == $current) ||
			    ($_  == $current) || ($_ - 1 == $current) || ($_ - 2 == $current) || ($_ - 3 == $current)) {
				push(@x, {$_ => $_});
			} # end if
		} # end foreach
		my $start_point = (keys %{$x[0]})[0] +  3;
		my $end_point = (keys %{$x[-1]})[0];

		if(($current >= (( 3 + 1) * 2)) && ( (keys %{$r[-1]})[0] ne "..." )) {
			push(@r, {"..." => round(($start_point) / 2)});
		} # end if

		push(@r, @x);

		if((($current < ($pages - (( 3  * 2) + 1) ))) && ( (keys %{$r[-1]})[0] ne "..." )) {
			push(@r, {"..." => $end_point + round(($pages - $end_point) / 2) - 1});
		} # end if
	} # end if

	foreach(($pages - ( 3  - 1)) .. $pages) { push(@r, {$_ => $_}); }

	return @r;
} # end paginate

sub round {
	my($l, $r) = split(/\./, $_[0]);
	return(substr($r, 0, 1) > 5 ? $l + 1: $l);
} # end round

sub round_up_always {
	my($l, $r) = split(/\./, $_[0]);
	return(substr($r, 0, 3) > 0 ? $l + 1: $l);
} # end round_up_always

sub AmICustomOrNot {
#	print header;
#	print "<br />AICON: '$template_html{'CURRENT'}'<br />" . &Tracer;
	if($template_html{"CURRENT"} =~ m/^JC(Templates)?$/i) {
#		print "<pre><b>ONE!</b>" . &Tracer . "</pre><br />";
		return 1;
	} else {
#		print "<pre>ZERO!!" . &Tracer . "</pre><br />";
		return 0;
	} # end if

} # end AmICustomOrNot

# Critical Error Wordlets.
# These are not to be edited by mortal hands.  Keep out.

sub MakeCriticalWordlets {
return {
	backtrace		=> qq(Backtrace: ),
	general_insane	 	=> qq(This error message is impossible - it only occurs in extreme circumstances.  Please alert the board administration: ),
	bad_form_length 	=> qq[(Form value %%INVALUE%% is %%THISLENGTH%% characters. Must be under %%FORMLENGTH%%!)],
	bad_request_method 	=> qq(I don't know the request method %%METHOD%%),
	bad_template_name 	=> qq(I can't find template '%%FN%%'.),
	bad_unlink 		=> qq(I was unable to unlink %%FILE%%: %%OSERR%%),
	insane_serve_from_cache => qq(ServeFromCache ),
	coppa_agree_called 	=> qq(Something has called ubb_registration:coppa_agree, a routine no longer used.  Here, have a backtrace:),
	not_valid_topic 	=> qq(Invalid topic: '%%FORUM%%', '%%TOPIC%%'.),
	cant_open 		=> qq(%%ERR%% opening %%THING%%),
	zero_sized_topic 	=> qq(Tried to open zero-sized topic %%TOPIC%% in forum %%FORUM%%.),
	check_cached_keelover	=> qq(During a cached file check: Forum %%FORUM%%, Thread %%THREAD%% was not found),
	no_email_wordlet_filler => qq(Something went horribly wrong while I was trying to create the email wordlet file.  Here's the error: <br />),
	browser_lacks_understanding => qq(Your browser didn't seem to understand the request you made.),
	cant_reset_perms_on_profile => qq(Can't reset permissions on profile %%NUMBER%%: %%OSERR%%),
	get_thread_data_bad	=> qq[GetThreadData was passed an invalid topic (%%TOPIC%%) and forum (%%FORUM%%).],
	unknown_thread_format   => qq(I don't know how to handle topic format '%%STRING%%'),
	bad_aline 		=> qq(I don't know how to handle this A line: '%%ALINE%%'),
	old_perl		=> qq(Perl reports version $]!\n\nUBB.classic will not run under this version, it needs 5.004 or higher\n),
	before_the_world	=> qq(I can't process time before the world began!),
	old_syntax		=> qq(Redirecting you to where you wanted to go...),
	get_thread_data_baddie  => qq(GetThreadData won't try to open malformed topic number %%TOPIC%% in forum %%FORUM%%.),
	avatar_lib_gone		=> qq(The Avatar library could not be found or created.),
}; # end return
} # end MakeCriticalWordlets

sub EmailWordletFixer {
	# Who said it ever had to be elegant or good looking, eh? :)

	return q[
sub EmailWordletFiller {
	my %t = (
	q!BBNAME! => qq!$vars_config{BBName}!,
	q!TOPIC_SUBJECT! => qq!$in{topic_subject}!,
	q!FROM_PDN! => qq!$pubname!,
	q!TO_PDN! => qq!$pm_to_name!,
	q!MESSAGE_ASCII! => qq!$message_ascii!,
	q!MESSAGE_HTML! => qq!$message!,
	q!PM_URL! => qq!$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_pm&d=$in{d}&t=$in{t}!,
	q!ULTIMATEBB! => qq!$vars_config{CGIURL}/ultimatebb.cgi!,
	q!PUBLIC_NAME! => qq!$public_name!,
	q!USER_NAME! => qq!$user_name!,
	q!EMAIL_ADDRESS! => qq!$email!,
	q!NEXT_MEMBER_NUMBER! => qq!$next_number!,
	q!IS_COPPA! => qq!$in{kid}!,
	q!PROFILE_URL! => qq!$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$next_number!,
	q!CP! => qq!$vars_config{CGIURL}/cp.cgi!,
	q!PROFILE_UN! => qq!$this_profile[0]!,
	q!PROFILE_PW! => qq!$this_profile[1]!,
	q!THIS_SUBJECT! => qq!$this_subject_also!,
	q!THIS_FORUM_NAME! => qq!$this_forum[1]!,
	q!THAT_SUBJECT! => qq!$this_subject!,
	q!TOPIC_URL! => qq!$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic;f=$in{f};t=$in{t}!,
	q!USER_PASSWORD! => qq!$password!,
	q!MY_PROFILE_URL! => qq!$vars_config{CGIURL}/ultimatebb.cgi?ubb=my_profile!,
	q!WORDLET_PROFILE_LINK! => qq!$vars_wordlets{profile_link}!,
	q!COPPA_FORM_URL! => qq!$vars_config{CGIURL}/ultimate.cgi?ubb=show_coppa_form!,
	q!PRIVACY_URL! => qq!$vars_display{PrivacyURL}!,
	q!ADMIN_REG_EMAIL_ADDRESS! => qq!$vars_registration{RegsAdminEmail}!,
	q!USER_PROFILE_NAME! => qq!$user_profile[0]!,
	q!NEW_PASSWORD! => qq!$new_password!,
	q!IP_ADDRESS! => &GetIPAddress(),
	); # end

	my %new_mail_wordlets;
	foreach my $one (keys %vars_wordlets_email) {
		$new_mail_wordlets{$one} = &Template($vars_wordlets_email{$one}, \%t);
	} # end foreach

	return %new_mail_wordlets;
}
];
} # end if

sub DetermineDefaultTemplates {
	return "summary_page" unless $_[0];
	my $action = quotemeta("|$_[0]|");
	my($style, $html);
	my %types = (
		'search' => q^|get_daily|search|search_tng|^,
		'faq' => q^|faq|^,
		'email' => q^||^,
		'private_message' => q^|get_pm|sent_pms|private_message|submit_private_message|pm_prune|pm_delete|pm_reply|submit_pm_reply|ignore_list|buddy_list|do_ignore|do_buddy|update_ignore|update_buddy|^,
		'transition' => q^|lost_password|find_lost|forum_pw_check|do_login|logoff|login|^,
		'profile' => q^|clearcookies|markallread|rate_member|email|edit_my_profile|my_profile|my_rating_list|recent_user_posts|get_profile|edit_profile|^,
		'summary_page' => q^|print_topic|pntf|pntf_admin|^,
		'registration' => q^|agree|coppa_agree|check_age|register_page|underage_register_page|show_coppa_form|submit_registration|^,
		'ubb_code' => q^|ubb_code_page|^,
	);
	my $forumactions = q^|send_topic|forum|preview_post|poll|newtopic|submit_new_topic|get_topic|reply|submit_new_reply|get_ip|delete_topic|close_topic|open_topic|transfer|transfer_topic|next_topic|edit_post|submit_edit|^;

	foreach my $type (qw(search faq email private_message transition profile summary_page registration ubb_code)) {
		if($types{$type} =~ m/$action/) {
			return($type);
		} # endif
	} # end foreach

	if(($forumactions =~ m/$action/) && ($in{f})){
		if($in{f} =~ m/^\d+$/) {
			return("forum_$in{f}");
		} # end if
	} # end if

	return undef;
} # end DetermineDefaultTemplates


# Full package names prefixed so UE will see the names seperately
package UBB::CommonElements;

sub UBB::CommonElements::_random {    # random string (used to generate UNIQs)
	my $self = shift;

	my @array = ("a" .. "z", "A" .. "Z");
	my $string;
	foreach (1 .. $_[0]) {
		$string .= $array[int(rand(scalar(@array)))];
	}
	#my ($l, $s) = (caller(1))[3, 2];
	#$self->warn("$s($l) asked for a random.  Returning $string");
	return $string;
}    # end sub

sub UBB::CommonElements::warn {
	my $self = shift;
	if ($self->{DEBUG} > 0) {
		print STDERR join ("\n", @_) . "\n";
	}    # end if
	return;
}    # end warn

sub UBB::CommonElements::get_time {    # return minutes since epoch
	my $t = time;
	return (($t - ($t % 60)) / 60);
}    # end get_time

sub UBB::CommonElements::process_bang { # determines best error given a $!
	my $self = shift;
	my $error = shift;
	my $bang = shift;
	my $tracer = shift;

	my $string;

			     # Removed for public release
	my $backtrace =  ''; #qq( \n \nHere is the backtrace:\n$tracer);

	if($bang) {
		my $explain = "";
		if(($bang =~ m/no such device or address/i) || ($bang =~ m/bad file descriptor/i)) {
			$explain = "The file I was operating on has gone away!";
		} elsif($bang =~ m/quota exceeded/i) {
			$explain = "Disk space quota has been exceeded - I was unable to write a new file.\n\nPlease ask the administrator to obtain more disk space.";
		} elsif($bang =~ m/no space left/i) {
			$explain = "The disk is out of space - I was unable to write a new file.\n\nPlease ask the administrator to contact the web hosting provider.";
		} elsif($bang =~ m/permission denied/i) {
			$explain = "Permission was denied - please ask the administrator to check the permissions on that file/directory!";
		} elsif($bang =~ m/operation not permitted/i) {
			$explain = "The operating system said I may not perform that operation.  Perhaps I was denied permission?";
		} elsif($bang =~ m/no.* locks available/i) {
			$explain = "The operating system has run out of file locks to give me.\n\nPlease ask the administrator to contact the web hosting provider.";
		} elsif($bang =~ m/such file or directory/i) {
			$explain = "I was unable to find that file or directory.  Please check the paths.";
		} # end if

		if($explain) { $explain .= "\n\n" }
		$explain .= "The exact error returned by the operating system is:\n$bang";

		$string = qq($error \n \n$explain$backtrace);
	} else {

		$string = $error;
	} # endif

	die "$string\n";

} # end process_bang

package main;


# do not remove:
1;
# $Id: ubb_lib.cgi,v 1.47 2002/05/08 20:53:30 cvscapps Exp $
