# UBB.classic Get (View) Topic : Perl Code

&RequireVars("$vars_config{VariablesPath}/vars_mods.cgi");


sub get_topic {
	local (@forum_info, @this_forum);

	# $_[0] = forum number, $_[1] = topic number

	if (!$in{p}) {
		$in{p} = 1;
	} else {
		unless ($in{p} > 0) { &StandardHTML("$vars_wordlets_err{invalid_page_number}"); }
	}

	# is input topic valid
	unless ($_[1] =~ /^\d{6}$/) {
		&StandardHTML("$vars_wordlets_err{invalid_topic_number}");
	}

	# is input forum number valid
	unless ($_[0] =~ /^\d{1,}$/) {
		&StandardHTML("$vars_wordlets_err{invalid_forum_number}");
	}

	#get forum details
	@this_forum = &GetForumRecord($_[0]);

	# determine exact path & check permission if necessary
	my $permission = $this_forum[6];
	$exact_path = "Forum$_[0]";
	if ($permission =~ m/private/) {

		$exact_path .= "/private-$this_forum[7]";

		# does user have permission to enter?
		&check_private_access($_[0], $this_forum[12]);

	}

	# does topic exist?
	unless (&FileExists("$vars_config{NonCGIPath}/$exact_path/$_[1].cgi")) {
		&StandardHTML("$vars_wordlets_err{topic_doesnt_exist}");
	}

	my $thiscachefile = $_[1];
	if ($in{p} > 1) { $thiscachefile = "$_[1]-$in{p}"; }

	my $fn = "$thiscachefile.cgi";

	if((&GetThreadData($in{f}, $in{t}))[18] =~ m/^\w{12}$/) {
		# It's a poll
		my $s = &OpenTimedCachedTopic($exact_path, $thiscachefile, (30), [$in{f}, $in{t}, $in{p}]);
		if($s) { print $s; exit; }
	} else {
		&ServeFromCache("ubb_files/forums/$exact_path/$fn");
	} # end if

	# is the page available?

		# which forum number is this?
		my $this_forum = ("forum_" . "$_[0]");

		# get assigned style template!
		%vars_style = &LoadStyleTemplate($this_forum);

		$direct_to = qq!<base href="$vars_config{NonCGIURL}/" />!;

		&set_page_elements;

		$ContinueAt = 0;
		if (($in{p} =~ m/^\d{1,}$/)) { $ContinueAt = $in{p}; }

		my $ContinueAt2 = ($ContinueAt - 1) * $vars_display{HTMLDisplayMax};

		&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");

		#print "$_[0], $_[1], $ContinueAt2, $ContinueAt";

		&create_topic($_[0], $_[1], $ContinueAt2, $ContinueAt);
		&get_new_topic;


}    # end get_topic

sub get_new_topic {

	if ($in{p} > 1) { $_[1] = "$_[1]-$in{p}"; }
	&ServeFromCache("ubb_files/forums/$exact_path/$_[1].cgi");

}    # end get_new_topic

sub get_ip {
	local (@user_profile, @topic_file, @this_row, $this_user, $ip_number, $this_pub_name, $this_message);

	# f = forum number
	# t = topic number
	# reply_num = post number within topic

	# make sure we have someone logged in
	if ($username eq '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a></p>!);
	}

	# user must be an admin or mod
	#verify cookie id
	@user_profile = &verify_id_num($username, $password, $user_number);

	# make sure user is an admin or moderator of this forum
	my $is_one = &is_admin_or_mod($in{f}, @user_profile);
	if ($is_one ne 'true') {
		&StandardHTML($vars_wordlets_err{not_admin_or_mod});
	}

	unless ($in{f}) {
		&StandardHTML($vars_wordlets_err{no_forum_selected});
		exit(0);
	}

	# which forum number is this?
	my $this_forum = ("forum_" . "$in{f}");

	# get assigned style template!
	%vars_style = &LoadStyleTemplate($this_forum);

	$direct_to = qq!<base href="$vars_config{NonCGIURL}/" />!;

	&set_page_elements;

	# retrieve ip and post info

	#get topic file
	@topic_file = &OpenTopic("$in{t}", "$in{f}");

	foreach (@topic_file) {
		@this_row = split (/\|\|/, $_);
		if ($this_row[1] eq "$in{reply_num}") {
			$ip_number     = $this_row[7];
			$this_user     = $this_row[2];
			$this_pub_name = $this_row[10];
			chomp($this_pub_name);
			$this_message = $this_row[6];
		}
	}

	if ($this_pub_name eq '') { $this_pub_name = "$this_user"; }
	if ($ip_number eq '') {
		&StandardHTML("$vars_wordlets_err{cant_find_ip}");
	}

	&LoadTemplate("public_show_ip");
}    # end get_ip

sub next_topic {
	local (@this_forum, %forum_topics, $topic);

	#get forum details
	@this_forum = &GetForumRecord($in{f});

	&SetExactPath($in{f});

	my $thistopics = &GetForumTopics($in{f});
	%forum_topics = %{$thistopics};

	# sort the forum_topics hash

	my $next_topic = '';
	my $next       = '';

	if ($in{go} eq 'older') {

		# get older

		NEXTONE: foreach $topic (sort { $forum_topics{$b} <=> $forum_topics{$a} } keys %forum_topics) {

			if ($next eq 'true') {
				$next_topic = "$topic";
				last NEXTONE;
			}

			if ($topic == $in{t}) { $next = 'true'; }

		}    # end sort

	} else {

		# get newer

		NEXTONE: foreach $topic (sort { $forum_topics{$a} <=> $forum_topics{$b} } keys %forum_topics) {

			if ($next eq 'true') {
				$next_topic = "$topic";
				last NEXTONE;
			}

			if ($topic == $in{t}) { $next = 'true'; }

		}    # end sort

	}


	# deliver next topic
	if ($next_topic ne '') {
		&get_topic($in{f}, $next_topic);
	} else {
		%vars_style = &LoadStyleTemplate("transition");
		&set_page_elements;
		&Transition("$ULTIMATEBB?ubb=get_topic;f=$in{f};t=$in{t}", $vars_wordlets{no_next_topic}, $vars_wordlets{refering_topic});
		exit(0);
	}

}    # end next_topic

# DANGER: Do not remove the next line!
1;
# $Id: ubb_get_topic.cgi,v 1.8 2002/04/18 22:27:17 cvscapps Exp $
