# UBB Friend : Perl Code

&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");

# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");

# get assigned style template!
%vars_style = &LoadStyleTemplate($this_forum);

&set_page_elements;

&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");

sub send_topic {
	local (@this_forum, @this_topic, @stat_line);

	# make sure UBBFriend is allowed here
	if ($vars_email{UBBFriendUSE} eq 'OFF') {
		&StandardHTML("$vars_wordlets_err{ubb_friend_not_on}");
	}

	# are email features permitted?
	unless ($vars_email{UseEmail} eq 'ON') {
		&StandardHTML("$vars_wordlets_err{email_not_on}");
	}

	# is user banned?
	$ip_number = &GetIPAddress;
	&check_ip_bans;

	# make sure we have someone logged in
	if ($username eq '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a></p>!);
	}

	# grab forum
	@this_forum = &GetForumRecord($in{f});

	# not allowed to send private forums with UBB Friend!
	if ($this_forum[6] =~ m/private/) {
		&StandardHTML("$vars_wordlets_err{ubb_friend_private}");
	}

	# grab topic
	@this_topic = &OpenTopic($in{t}, $in{f});

	# FYI: OpenTopic also sets exact_path

	# grab topic stat line
	@stat_line = split (/\|\|/, $this_topic[0]);

	if ($in{send_it} eq 'true') {

		&send_to_friend;
		exit(0);

	}    # if we have all info to email topic

	# otherwise, let's give user the email form

	my $s = &EmailWordletFixer;
	eval($s);
	if(defined &EmailWordletFiller) {
		%vars_wordlets_email = &EmailWordletFiller();
	} else {
		&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
	} # end if

	$message = qq!
$vars_wordlets_email{ubb_friend_intro}

$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic;f=$in{f};t=$in{t}!;

	&LoadTemplate("public_ubb_friend");


}    # end send_topic

sub send_to_friend {
	local ($html_message);

	&GetOrPost('POST');

	&floodcheck;

	my @user_profile = &verify_id_num($username, $password, $user_number);
	my $user_email = $user_profile[2];
	chomp($user_email);

	# add name to message
	my $message = qq!
$vars_wordlets{author_from} $in{your_name}

$in{message}
!;

	# prepare HTML version of message
	my $message_html = &auto_url($message);
	$message_html = &ConvertReturns(&LimitReturns($message_html));

	# grab mail code
	&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");

	# validate form
	my @ValidateArray = ("message", "your_name", "subject", "email_to");
	&Validate(@ValidateArray);

	# test email format:
	if (&email_test($in{email_to})) { &StandardHTML("$vars_wordlets_err{email_invalid}"); }

	# take viewer back to topic
	%vars_style = &LoadStyleTemplate("transition");
	&set_page_elements;
	&Transition("$ULTIMATEBB?ubb=get_topic;f=$in{f};t=$in{t}", "$vars_wordlets{thanks_for_ubb_friend}", "$stat_line[4]");

	# set email template
	%vars_style = &LoadStyleTemplate("email");
	&set_page_elements;

	# is HTML format to be sent?
	if ($vars_email{email_format} ne 'ascii') {
		my $html_body = qq!<font face="$vars_style{FontFace}" size="$vars_style{TextSize}"><b>! . "$message_html" . qq!</b></font>!;

		$html_message = "$EmailHeader $html_body $Footer";
	} else {
		$html_message = '';
	}

	# in case only HTML format is to be sent:
	if ($vars_email{email_format} eq 'html') { $message = ''; }

	# reply to -> SENDER
	&ubb_mail_tng({
		'EmailTo' => $in{email_to},
		'EmailFrom' => $vars_display{BBEmail},
		'EmailReplyTo' => $user_email,
		'BCCList' => undef,
		'Subject' => $in{subject},
		'TextMessage' => $message,
		'HTMLMessage' => $html_message,
		'CCList' => undef,
	});


	exit(0);

}    # end send_to_friend



# DANGER: Do not remove the next line!
1;
# $Id: ubb_friend.cgi,v 1.5 2002/03/15 01:16:44 cvscapps Exp $