# UBB.classic Public Forum Summary Page : Perl Code

# get assigned style template!
%vars_style = &LoadStyleTemplate("summary_page");

&set_page_elements;

sub forum_summary {
	local ($file_name, $RegisteredMemberLine, @CATEGORIES, @sortedforums, @pntf_locations);
	local (*MEM);

	# get HTML bits for this page
	&LoadTemplate("public_forum_summary");

	$in{category} = "" unless exists $in{category};

	if (!$in{category}) {
		&ServeFromCache("ubb_files/summary/summary.html");
	} else {

		if ($vars_display{CategoriesOnly} ne 'false') {

			# if this is a category-only view & specific category is selected
			&ServeFromCache("ubb_files/summary/summary-$in{category}.html");
		}
	}

	# page is not available in cache, so we need to create it now

	# figure out PNTF stuff
	@pntf_locations = ("", "", "", "");
	$pntf_string = "";
	if(($vars_pntf{Enabled} eq "yes") && ($vars_pntf{Mode} ne "hidden")){

		my $fto = "";
		if((exists $in{category}) && ($in{category} =~ m/^\d+$/)) {
			$fto = "9999_" . $in{category};
		} else {
			$fto = "9999";
		} # end if

		if($fto) {

			my $TBT_escaped = UBBCGI::escape($TBT);
			my $TBB_escaped = UBBCGI::escape($TBB);

			if(($vars_pntf{Docked} eq "yes") && ($vars_pntf{TopBottom} eq "top")) {
				$pntf_locations[1] = qq(<?PHP pntfGetCacheForSummary('$in{category}', "", "", "%%COLSPANS%%") ?>);
			} elsif(($vars_pntf{Docked} eq "yes") && ($vars_pntf{TopBottom} eq "bottom")) {
				$pntf_locations[2] = qq(<?PHP pntfGetCacheForSummary('$in{category}', "", "", "%%COLSPANS%%") ?>);
			} elsif(($vars_pntf{Docked} eq "no") && ($vars_pntf{TopBottom} eq "top")) {
				$pntf_locations[0] = qq(<?PHP pntfGetCacheForSummary('$in{category}', "$TBT_escaped", "$TBB_escaped$vars_config{'jc'}->{'no-br'}", "%%COLSPANS%%") ?>);
			} elsif(($vars_pntf{Docked} eq "no") && ($vars_pntf{TopBottom} eq "bottom")) {
				$pntf_locations[3] = qq(<?PHP pntfGetCacheForSummary('$in{category}', "$vars_config{'jc'}->{'no-br'}$TBT_escaped", "$TBB_escaped", "%%COLSPANS%%") ?>);
			} else {
				$pntf_locations[0] = qq(<?PHP noLocation; ?>);
			} # end if
		} else {
			$pntf_locations[0] = qq(<?PHP noFTO; ?>);
		} # end if
	} # end if

	# do we have a categories file?
	unless (&FileExists("$vars_config{NonCGIPath}/categories.file")) {
		&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");
		&AssembleCats;
	}

	@CATEGORIES = &GetCategoriesFile;

	# exceptions
	if ($in{category}) { $vars_display{CategoriesOnly} = 'false'; }

	# sort the forums
	@sortedforums = &SortForums;    #returns @sortedforums

	# get top of page from public_common.pl
	$ThisHTML = $Header;

	# show registered members count?
	if ($vars_display{DisplayMemberTotal} eq 'true') {

		my $TotalMembers = &GetMemberTotal;

		$RegisteredMemberLine = qq~$vars_wordlets{reg_members_total} $TotalMembers~;
	}
	if ($vars_display{NewestMemberWelcome} eq 'yes') {
		my @newbie = &GetNewestMember;
		if ($newbie[0] ne '') {
			if ($RegisteredMemberLine ne '') { $RegisteredMemberLine .=$vars_config{'jc'}->{'regmemlinesep'}}
			$RegisteredMemberLine .= qq!$vars_wordlets{new_member_welcome} <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_profile;u=$newbie[1]"><span $vars_config{'jc'}->{'titlebarclass'};>$newbie[0]</span></a>!;
		}
	}


	my $colspans;

	# which view is it?
	if ($vars_display{CategoriesOnly} eq 'true') {
		$colspans = &CatOnlyView(@sortedforums);
	} else {
		$colspans = &NormalView(@sortedforums);
	}

	$ThisHTML = &Template($ThisHTML, {
		COLSPANS => $colspans,
		});

	# get bottom of page from public_common.pl
	$ThisHTML .= $Footer;

	if (!$in{category}) {
		$file_name = 'summary';
	} else {
		$file_name = "summary-$in{category}";

		unless ($in{category} > 0) {
			&StandardHTML("$vars_wordlets_err{invalid_category_number}");
		}

	}

	# print to file
	unless(&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary")) {
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie", 0777);
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files", 0777);
		mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary", 0777);
		chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie");
		chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files");
		chmod(0777, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary");
	}
	&WriteFileAsString("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/summary/$file_name.html", $ThisHTML);


	#display onscreen
	#print $ThisHTML;
	print &FilterPNTF($ThisHTML);
	exit(0);
}    # end forum_summary


# SUBROUTINES :

sub NormalView {
	my @forumlist = @_;

	local ($each, @thisforuminfo, $x, $GetHour, $GetMinute, $MilHour, $GetMonth, $GetYear, $GetDate);
	local ($LastTime, $LastDate, $AMpm, @lasttime, $LatestTime, $TheDate, $forumcategory, $thisforumcategory);
	local ($CategoryName, $ExactPath, @data, $TotalTopics, $TotalPosts, $ForumName, $Moderator, $ForumDesc);
	local ($JYear, $NewStuffIcon, $LPTime, $LPMonth, $LastPostJulian, $alt_color, $j, $ColSpan, $last_author);
	local ($long_last_subject, $last_subject, $msg_icon, $last_post_number, $msg_icon2);

	$ThisHTML .= &PageTop;             # some HTML
	$ThisHTML .= &Normal_Table_Top;    # more HTML

	$forumcategory = "";

	# determine colspan
	$ColSpan = $vars_config{'jc'}->{'normalviewcolspan'};
	if ($vars_display{ShowMods} eq 'yes')          { $ColSpan++; }
	if ($vars_display{ForumTotalOption} eq 'Both') {
		$ColSpan = $ColSpan + 2;
	} elsif ($vars_display{ForumTotalOption} eq 'Neither') {

		#we don't want to add one as it would be with the others
	} else {
		$ColSpan++;
	}

	for $each (@forumlist) {
		undef($msg_icon2);
		undef($msg_icon);

		@thisforuminfo = split (/\|\^\|/, $each);
		chomp($thisforuminfo[8]);
		$x = "$thisforuminfo[8]";

		$exact_path = "Forum$x";
		if ($thisforuminfo[6] =~ m/private/) { $exact_path .= "/private-$thisforuminfo[7]"; }

		undef($GetHour);
		undef($GetMinute);
		undef($MilHour);
		undef($TheDate);
		undef($LatestTime);


		if (($vars_display{CategoryView} eq 'yes') && ($thisforuminfo[0] ne "")) {
			$thisforumcategory = $thisforuminfo[0];

			if ($thisforumcategory ne $forumcategory) {

				$CategoryName = &GetCatName($thisforumcategory);

				# print category strip
				$ThisHTML .= &CategoryStrip;

			}
			$forumcategory = $thisforumcategory;
		}    # end if categoryview eq yes

		#  Get Forum Data from lastnumber.file(s)
		if (&FileExists("$vars_config{NonCGIPath}/$exact_path/lastnumber.file")) {
			@data = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

			foreach (0 .. 6) {
				if ($data[$_] ne "\n") { chomp $data[$_] }
				else { $data[$_] = "" }
			}

			$last_topic_number = $data[6];
			$TotalTopics       = $data[1];
			$TotalPosts        = $data[2];
			$last_subject      = $data[3];
			$long_last_subject = $last_subject;

			if (length($last_subject) > 25) {
				$last_subject = &GoodNiceTruncate($last_subject, 26);
			}

			$last_author      = $data[4];
			$msg_icon         = $data[5];
			$last_post_number = $data[6];

			if ($msg_icon ne '') {
				$msg_icon = qq!<img src="$vars_config{NonCGIURL}/icons/icon$msg_icon.gif" align="middle" border="0" alt="$vars_wordlets_img{alt_icon} $msg_icon" />&nbsp;!;
			} else {
				$msg_icon = qq!<img src="$vars_config{NonCGIURL}/icons/icon1.gif" align="middle" border="0" alt=" - " />&nbsp;!;
			}

			if ($last_author ne '') { $last_author = "$vars_config{'jc'}->{'no-openparen'}$last_author$vars_config{'jc'}->{'no-closeparen'}"; }

			# next-line the username if the subject is long
			if(length($last_subject) > 25) { $last_author = $vars_config{'jc'}->{'no-br'} . $last_author; }

			# make sure topic has not been deleted--
			unless (&FileExists("$vars_config{NonCGIPath}/$exact_path/$last_topic_number.cgi")) {
				$last_author  = '';
				$last_subject = '';
				$msg_icon     = '';
			}

		} else {
			$TotalTopics      = 0;
			$TotalPosts       = 0;
			$last_author      = '';
			$last_subject     = '';
			$msg_icon         = '';
			$last_post_number = '';
			$msg_icon2        = qq!<img src="$vars_config{NonCGIURL}/icons/icon1.gif" align="middle" border="0" alt="$vars_wordlets_img{alt_icon} 1" />&nbsp;!;
		}

		# don't show last message for private forums!
		if ($thisforuminfo[6] =~ m/private/) {
			$last_author  = '';
			$last_subject = '';
			$msg_icon     = '';
			$msg_icon2    = qq!<img src="$vars_config{NonCGIURL}/icons/icon1.gif" align="middle" border="0" alt="$vars_wordlets_img{alt_icon} 1" />&nbsp;!;
		}

		if ($TotalTopics eq '') { $TotalTopics = 0; }
		if ($TotalPosts eq '')  { $TotalPosts  = 0; }

		if ($TotalTopics > 0) {

			@lasttime = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lasttime.file");

			$LastDate = $lasttime[0];
			chomp($LastDate);
			$LastTime = $lasttime[1];
			chomp($LastTime);
			$LatestTime = &TimeFormat($LastTime);

			# grab mil hour, minutes for jtime indicators!
			($GetHour,   $GetMinute) = split (/:/, $LastTime);
			($GetMinute, $AMpm)      = split (/ /, $GetMinute);
			chomp($AMpm);
			($GetMonth, $GetDate, $GetYear) = split (/-/, $LastDate);
			chomp($GetMinute);
			$GetYear  = &Y2K($GetYear);
			$LastDate = ("$GetMonth" . "-" . "$GetDate" . "-" . "$GetYear");
			$TheDate  = &DateFormat($LastDate);

			$MilTime = &ConvertTo24Hour($GetHour, $GetMinute, $AMpm);

			($MilHour, $j) = split (":", $MilTime);

		} else {
			$GetMonth   = '';
			$GetDate    = '';
			$GetYear    = '';
			$LatestTime = '';
			$TheDate    = '';
			$msg_icon2  = '';
		}

		$ForumName = $thisforuminfo[1];

		$Moderator = &GetModLine("$x");

		$ForumDesc = $thisforuminfo[2];
		$ForumDesc =~ s/&quot\;/"/g;
		$ForumName =~ s/\/\\//g;

		if ($vars_display{ForumDescriptions} eq 'no') { $ForumDesc = ''; }

		#default light bulb to off
		$NewStuffIcon = qq!<img src=\"$vars_config{NonCGIURL}/$vars_style{forum_summ_on}" border="0" alt="$vars_wordlets_img{alt_js_oldfolder}" \/>!;

		if ($GetMonth ne '') {

			# Compare Last Login Time to Last Post Time..
			$LPMonth        = $GetMonth;
			$JYear          = &Y2K($GetYear);
			$LastPostJulian = &jday($LPMonth, $GetDate, $JYear);

			$LPTime = ("$MilHour" . "$GetMinute");

			$LastPostJulian = ($LastPostJulian + ($LPTime * 0.0001));


		} else {

			$LastPostJulian = '0';
		}    # end if/else month ne ''

		# what-ifs
		if (!$LatestTime) {
			$LatestTime = '&nbsp;';
		}
		if (!$Moderator) {
			$Moderator = '&nbsp;';
		}


		if ($thisforuminfo[6] eq 'none&none') {
			$TheDate      = "$vars_wordlets{read_only_forum}";
			$LatestTime   = '';
			$last_author  = '';
			$last_subject = '';
			$msg_icon     = '';
			if ($TotalTopics > 0) {
				$msg_icon2 = qq!<img src="$vars_config{NonCGIURL}/icons/icon1.gif" align="middle" border="0" alt="$vars_wordlets_img{alt_icon} 1" />&nbsp;!;
			}
		}

		$msg_icon2 = '&nbsp;' unless $msg_icon2;

		$ThisHTML .= &Normal_Table_Row;    # THE HTML TABLE ROW

	}

	$ThisHTML .= &PageBottom;

	return $ColSpan;
}    #end NormalView

sub SortForums {

	#this returns @sortforums, a sorted list based on display requirements

	local (%forum_order_list, %forum_name_list, %cat_list, %forum_line_list, @sorted_forums, @sortit, $key, @checkit, @forums, @sortforums, $sort, $cat_type, $j, $k);

	my @allforums = &OpenForumsFile;
	$sort = '';

	# make sure only open forums are listed
	foreach $j (@allforums) {
		chomp($j);
		@checkit = split (/\|\^\|/, $j);
		if ($checkit[3] eq 'On') {
			$forum_order_list{$checkit[8]} = "$checkit[14]";
			$forum_name_list{$checkit[8]}  = "$checkit[1]";
			$forum_line_list{$checkit[8]}  = "$j";

			# create cat list:
			if (($checkit[0]) && ($checkit[0] > 0)) { $cat_list{$checkit[8]} = "$checkit[0]"; }

		}    # end if forum is ON
	}    # end foreach allforums

	# sort forum list:
	@sorted_forums = sort { $forum_order_list{$a} <=> $forum_order_list{$b} } keys %forum_order_list;

	# sort based on requirements -> get @sortforums
	if ($in{category}) {

		foreach (@sorted_forums) {
			if ($in{category} eq "$cat_list{$_}") { push (@sortforums, $forum_line_list{$_}); }
		}


	} else {

		if ($vars_display{CategoryView} eq 'yes') {

			# for categories view--

			@sortit = sort(@CATEGORIES);

			my ($ThisCatNam, $ThisCatNumb);

			foreach $cat_type (@sortit) {
				($j, $ThisCatNam, $ThisCatNumb) = split (/\|\^\|/, $cat_type);
				chomp($ThisCatNumb);

				foreach $key (@sorted_forums) {

					if (exists($cat_list{$key})) {
						if ($cat_list{$key} eq "$ThisCatNumb") {
							push (@sortforums, $forum_line_list{$key});
						}    # end exists
					}    # end cat list key match

				}    # end foreach sorted forum

			}    # end foreach cat type

		} else {

			# for no categories view--

			foreach (@sorted_forums) {
				push (@sortforums, $forum_line_list{$_});
			}

		}    # end if/else category view

	}    # end if category-specific

	return (@sortforums);
}    # end sort forums

sub GetNewestMember {
	local ($last, @last, @newbie_profile);

	if (&FileExists("$vars_config{MembersPath}/last_approved.cgi")) {
		$last = &GetLastApprovedUser;
	} else {
		$last = &GetLastMemberNumber;
	}

	chomp($last);
	if ($last ne '') { $last = &Do8Digit($last); }
	if ((&FileExists("$vars_config{MembersPath}/$last.cgi")) && ($last ne '')) {
		@newbie_profile = &OpenProfile($last);
		chomp($newbie_profile[15]);
		chomp($newbie_profile[0]);

		if ($newbie_profile[15] eq '') {
			$newbie_profile[15] = "$newbie_profile[0]";
		}
		$last[0] = $newbie_profile[15];
		$last[1] = $last;
	}
	return (@last);
}

sub CatOnlyView {
	local (@cats, $cat_color, $cat_line, $cat_name, $cat_number, $cat_order, $forum_count, $k, @this_match);
	my @forum_list = @_;

	$ThisHTML .= &PageTop;          # some HTML
	$ThisHTML .= &Cat_Table_Top;    # more HTML

	#sort categories
	@cats = sort(@CATEGORIES);

	# set row color
	$cat_color = "$vars_style{AltColumnColor1}";

	foreach $cat_line (@cats) {
		($cat_order, $cat_name, $cat_number) = split (/\|\^\|/, $cat_line);
		chomp($cat_number);
		$forum_count = 0;

		#sift forums
		foreach $k (@forum_list) {
			if ($k =~ /^$cat_number\|/) {
				@this_match = split (/\|\^\|/, $k);
				if ($this_match[3] eq 'On') {
					$forum_count++;
				}
			}
		}

		if ($forum_count > 0) {

			$ThisHTML .= &Cat_Row;	#patch courtesy Cal
			$cat_color = ($cat_color eq $vars_style{AltColumnColor1})?$vars_style{AltColumnColor2}:$vars_style{AltColumnColor1};

		}
	}    #each cat
	$ThisHTML .= &Cat_Page_Bottom;

	return 2;
}    #end cat only view



# DANGER: Do not remove the next line!
1;
# $Id: ubb_forum_summary.cgi,v 1.13 2002/05/07 17:50:39 cvscapps Exp $
