# UBB.classic Registration Routines : Perl Code

# make sure we have a forum number
if ($in{f} !~ m/^\d{1,}$/) {
	%vars_style = &LoadStyleTemplate("transition");
	&StandardHTML($vars_wordlets_err{no_forum_selected});
}

# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");

# get assigned style template!
%vars_style = &LoadStyleTemplate($this_forum);

&set_page_elements;

&RequireVars("$vars_config{VariablesPath}/vars_mods.cgi");


sub forum_pw_check {
	local ($pw_line);

	# get forum record
	my @this_forum = &GetForumRecord($in{f});

	# validate:
	if ($in{forum_pw} eq '') {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{missing_fields_intro}<p>$vars_wordlets{missing_input_line} $vars_wordlets{forum_pw}</p>");
	}

	if (($in{forum_pw} eq "$this_forum[12]") && ($this_forum[12] ne '')) {

		my $this_line = ("$in{f}" . '|^|' . "$in{forum_pw}");
		my $forumpw   = cookie("forumpw$vars_config{Cookie_Number}");

		# append?
		if ($forumpw ne '') {
			$pw_line = ("$forumpw" . "|^|" . "$this_line");
		} else {
			$pw_line = $this_line;
		}

		# set cookie!
		my $forum_cookie = cookie(
			-name  => "forumpw$vars_config{Cookie_Number}",
			-value => [$pw_line],
			-path  => '/'
		);

		print header(
			-cookie  => [$forum_cookie],
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		# transport to forum
		%vars_style = &LoadStyleTemplate("transition");
		&set_page_elements;
		&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=$in{last};f=$in{f}", "$vars_wordlets{forum_pw_confirmed}", "$this_forum[1]");
		exit(0);

	} else {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&StandardHTML("$vars_wordlets_err{incorrect_forum_pw}");
		exit(0);
	}

}    # end forum_pw_check

sub get_forum {
	local ($poll_new, $poll_old, $pollid, $poll_link, @pntf_locations, $pntf_string, $last_julian, $GetMonth, $GetDate, $GetYear, @this_forum, $category, $permission, $cat_name, $mod, @mods, %topic_legend, %reply_legend, $topic_restrict, $reply_restrict, $forum_name, %topic_view, $DPJulian, @thefinalarray, %forum_topics, $topic, $one, @this_topic, $closed, $total_replies, $subject, $user_name, $msg_icon, $last_hyphen_date, $last_time, @rev_file, @last_post, $TheDate, $Breaker, $DateSize, $hot_icon, $new_topic_button, $key, $value, $Sections, $count, $j, $start_point, $array_stop, $total_good, $more_topics_wording, $Block, $starting, @topics, $Section, $topic_start_name, $cat_line1, $extra_pages, $topic_view_line, $topic_start_un, @user_profile);

	if ($in{f} !~ m/^\d+$/) { &StandardHTML("$vars_wordlets_err{no_forum_selected}"); }

	# get forum record
	@this_forum = &GetForumRecord($in{f});
	chomp($this_forum[15]);    # <- sort option (new)
	chomp($this_forum[16]) if $this_forum[16];    # <- new forum intro/announcement

	$this_forum[16] = "" unless $this_forum[16];

	if ($this_forum[1] eq '') {
		&StandardHTML("$vars_wordlets_err{no_such_forum}");
	}

	# determine path for the forum files
	$permission = $this_forum[6];
	$exact_path = "Forum$in{f}";
	if ($permission =~ m/private/) {

		$exact_path .= "/private-$this_forum[7]";

		# does user have permission to enter?
		&check_private_access($in{f}, $this_forum[12]);

	}

	# which topic view do they need-> $user_topic_view
	if (!$user_topic_view) { $user_topic_view = $vars_display{DaysPruneDefault}; }

	#is days prune being changed?
	if (exists $in{DaysPrune}) { $user_topic_view = "$in{DaysPrune}"; }

	# check for hardset (mulit-page forums)
	if (exists $in{hardset}) { $user_topic_view = $in{hardset}; }

	# if sorting alphabetically, no need to prune topic list!
	if ($this_forum[15] eq 'abc') { $user_topic_view = '1000'; }

	foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)) {
		$topic_view{$_} = '';
	}

	$user_topic_view = $vars_display{DaysPruneDefault} unless $user_topic_view;

	$topic_view{$user_topic_view} = 'selected="selected"';

	# get from cache, if it exists...
	my $extension = "";
	if(($in{start_point}) && ($in{start_point} =~ m/^\d{1,}$/)) {
		$extension = "_$in{start_point}";
	}
	&ServeFromCache("ubb_files/forum_page/$exact_path/forum$in{f}-$user_topic_view$extension.cgi");

	# else create the forum page
	$category   = $this_forum[0];
	$forum_name = $this_forum[1];
	$cat_name   = &GetCatName($category);

	# get mods for the forum
	$Moderator = &GetModLine("$in{f}");


	%topic_legend = (
		restrict => "$vars_wordlets{topic_permission_1}",
		allreg   => "$vars_wordlets{topic_permission_2}",
		all      => "$vars_wordlets{topic_permission_3}",
		none     => "$vars_wordlets{topic_permission_4}",
	);

	%reply_legend = (
		restrict => "$vars_wordlets{reply_permission_1}",
		allreg   => "$vars_wordlets{reply_permission_2}",
		all      => "$vars_wordlets{reply_permission_3}",
		none     => "$vars_wordlets{reply_permission_4}",
	);

	if ($permission eq 'private') {
		$reply_restrict = 'restrict';
		$topic_restrict = 'restrict';
	} elsif($permission =~ m/^private(.+)\&private(.+)$/) {
		$topic_restrict = $1;
		$reply_restrict = $2;
	} else {
		($topic_restrict, $reply_restrict) = split (/\&/, $permission);
	}

	if($this_forum[17] =~ m/^(\d+)$/) {
		my $num = $1;
		my $g = $vars_groups->_get_raw_group("pollgroup_$num");
		if(($g->{perms}->{create} ne "none") && ($vars_poll{Enabled} ne "off")) {
			$poll_link = qq!&nbsp;<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=poll;d=create;f=$in{f}"><img src="$vars_config{NonCGIURL}/$vars_style{BBPoll}" alt="$vars_wordlets_poll{new_poll}" border="0" /></a>&nbsp;!;
		} # end if
	} # end if polling field

	$poll_new = ($poll_link ? qq!<img src="$vars_config{NonCGIURL}/$vars_style{new_poll_folder}" border="0" alt="$vars_wordlets{new_topic}" />! : "");
	$poll_old = ($poll_link ? qq!<img src="$vars_config{NonCGIURL}/$vars_style{old_poll_folder}" border="0" alt="$vars_wordlets{old_topic}" />! : "");

	$new_topic_button = qq!<a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=newtopic;f=$in{f}">
	<img src="$vars_config{NonCGIURL}/$vars_style{BBTopic}"  border="0" alt="$vars_wordlets{post_new_topic}" /></a>!;

	if ($topic_restrict eq 'none') { $new_topic_button = ''; }

	# get HTML bits for this page
	&LoadTemplate("public_forum_page");
	$ThisHTML = $Header;


	&GetDateTime;

	if ($user_topic_view eq '1000') {
		$DPJulian = 0;
	} else {
		$DPJulian = $GotTime{LastLoginJulianDATE} - $user_topic_view;
	}

	my $thistopics = &GetForumTopics($in{f});
	%forum_topics = %{$thistopics};

	# adjust for topic view
	$count = 0;
	while (($key, $value) = each(%forum_topics)) {
		if(($value >= $DPJulian) or ($this_forum[15] eq "abc")) {
			$count++;
		} else {
			delete($forum_topics{$key});
		}
	}

	# sort the hash
	if ($this_forum[15] eq 'abc') {
		@topics = sort { $forum_topics{$a} cmp $forum_topics{$b} } keys %forum_topics;
	} else {
		@topics = sort { $forum_topics{$b} <=> $forum_topics{$a} } keys %forum_topics;
	}

	# limit page-view based on cp settings
	unless (($vars_display{ForumDisplayMax} eq '') || ($vars_display{ForumDisplayMax} eq 'NONE')) {

		$total_good = $count - 1;

		$Sections = int($count / $vars_display{ForumDisplayMax});
		if ($count % $vars_display{ForumDisplayMax}) { $Sections++; }

		$in{start_point} = 0 unless $in{start_point};

		$start_point = $in{start_point};
		$array_stop = $start_point + $vars_display{ForumDisplayMax} - 1;

		if($vars_display{PaginationType} eq "new") {
			my $current_section = ($in{start_point} != 0 ? int($in{start_point} / $vars_display{ForumDisplayMax}) + 1 : 1);
			my @pages = &paginate($Sections, $current_section);

			foreach my $h (@pages) {
				my($page, $goesto) = each(%{$h});
				if($page eq $current_section) {
					$more_topics_wording .= qq($page );
				} else {
					my $title = ($page eq "..." ? qq~ title="$vars_wordlets{page} $goesto"~ : "");
					my $starting = $vars_display{ForumDisplayMax} * ($goesto - 1);
					$more_topics_wording .= qq(<a href="$ULTIMATEBB?ubb=forum;f=$in{f};)
						. qq(hardset=$user_topic_view;start_point=$starting"$title>$page</a> );
				} # end if
			} # end foreach
		} else {
			if (!$in{start_point}) {
				$start_point = 0;
				$array_stop  = $vars_display{ForumDisplayMax} - 1;
				if ($total_good <= $array_stop) {
					$more_topics_wording = '';
					$array_stop          = $total_good;
				} else {

					for ($Section = 0; $Section <= $Sections; $Section++) {
						$starting = $Section * $vars_display{ForumDisplayMax};

						$Block = $Section + 1;
						if ($Block == 1) {
							$more_topics_wording .= qq($Block );
						} else {
							$more_topics_wording .= qq(<a href="$ULTIMATEBB?ubb=forum;f=$in{f};hardset=$user_topic_view;start_point=$starting">$Block</a> );
						}
					}
				}
			} else {
				$start_point = $in{start_point};
				$array_stop  = $start_point + $vars_display{ForumDisplayMax};
				$array_stop--;

				if ($total_good <= $array_stop) {
					$array_stop = $total_good;
				}
				for ($Section = 0; $Section <= $Sections; $Section++) {
					$starting = $Section * $vars_display{ForumDisplayMax};

					$Block = $Section + 1;
					if ($start_point == $starting) {
						$more_topics_wording .= qq($Block );
					} else {
						$more_topics_wording .= qq(<a href="$ULTIMATEBB?ubb=forum;f=$in{f};hardset=$user_topic_view;start_point=$starting">$Block</a> );
					}
				} # end for
			} # end if
		} # end if

		if ($more_topics_wording ne '') {
			$more_topics_wording = ("$vars_wordlets{page}: $more_topics_wording");
		}

		@topics = @topics[$start_point .. $array_stop];

	}    # end forumdisplaymax section

	# topic view line:

	if ($this_forum[15] ne 'abc') {	# form tags moved into template
		$topic_view_line = qq!
<input type="hidden" name="ubb" value="forum" />
<input type="hidden" name="f" value="$in{f}" />
<select name="DaysPrune">
	<option value="1" $topic_view{1}>$vars_wordlets{show_topics_from_last} $vars_wordlets{day}</option>
	<option value="2" $topic_view{2}>$vars_wordlets{show_topics_from_last} 2 $vars_wordlets{days}</option>
	<option value="5" $topic_view{5}>$vars_wordlets{show_topics_from_last} 5 $vars_wordlets{days}</option>
	<option value="10" $topic_view{10}>$vars_wordlets{show_topics_from_last} 10 $vars_wordlets{days}</option>
	<option value="20" $topic_view{20}>$vars_wordlets{show_topics_from_last} 20 $vars_wordlets{days}</option>
	<option value="30" $topic_view{30}>$vars_wordlets{show_topics_from_last} 30 $vars_wordlets{days}</option>
	<option value="45" $topic_view{45}>$vars_wordlets{show_topics_from_last} 45 $vars_wordlets{days}</option>
	<option value="60" $topic_view{60}>$vars_wordlets{show_topics_from_last} 60 $vars_wordlets{days}</option>
	<option value="75" $topic_view{75}>$vars_wordlets{show_topics_from_last} 75 $vars_wordlets{days}</option>
	<option value="100" $topic_view{100}>$vars_wordlets{show_topics_from_last} 100 $vars_wordlets{days}</option>
	<option value="365" $topic_view{365}>$vars_wordlets{show_topics_from_last} $vars_wordlets{year}</option>
	<option value="1000" $topic_view{1000}>$vars_wordlets{show_all_topics}</option>
</select>
<input type="submit" name="submit" value="$vars_wordlets{click_go}" class="buttons" />
!;
	}

	@pntf_locations = ("", "", "", "");
	$pntf_string = "";
	if(($vars_pntf{Enabled} eq "yes") && ($vars_pntf{Mode} ne "hidden")) {

		my $fto = sprintf("%04d1000_0000", $in{f});

		my $TBT_escaped = UBBCGI::escape($TBT);
		my $TBB_escaped = UBBCGI::escape($TBB);

		if(($vars_pntf{Docked} eq "yes") && ($vars_pntf{TopBottom} eq "top")) {
			$pntf_locations[1] = qq(<?PHP pntfGetCacheForForum('$in{f}', "", "", "6") ?>);
		} elsif(($vars_pntf{Docked} eq "yes") && ($vars_pntf{TopBottom} eq "bottom")) {
			$pntf_locations[2] = qq(<?PHP pntfGetCacheForForum('$in{f}', "", "", "6") ?>);
		} elsif(($vars_pntf{Docked} eq "no") && ($vars_pntf{TopBottom} eq "top")) {
			$pntf_locations[0] = qq(<?PHP pntfGetCacheForForum('$in{f}', "$TBT_escaped", "$TBB_escaped<br />", "1") ?>);
		} elsif(($vars_pntf{Docked} eq "no") && ($vars_pntf{TopBottom} eq "bottom")) {
			$pntf_locations[3] = qq(<?PHP pntfGetCacheForForum('$in{f}', "$vars_config{'jc'}->{'no-br'}$TBT_escaped", "$TBB_escaped", "1") ?>);
		} else {
			$pntf_locations[0] = qq(<?PHP noLocation() ?>);
		} # end if
	} # end if

	$ThisHTML .= &page_top;              # some HTML
	$ThisHTML .= &topic_table_header;    # table top HTML

	# loop through topics now

	EACHTOPIC: foreach $one (@topics) {
		next unless $one =~ m/^\d{6}$/;
		undef($hot_icon);

		#0 	A, 		X/N, 		Username, 	Topic
		#4	firsticon, 	replies, 	first date, 	first time
		#8	firstjulian,	pubname, 	usernumber, 	lastname
		#12	lastdate,	lasttime, 	lastjulian, 	lastpubname
		#16	lastnumber, 	lasticon, 	pollid

		my @this_topic_data = &GetThreadData($in{f}, $one);

		$closed = $this_topic_data[1];    # if X->closed
		if ($closed =~ /X/) {
			$closed = 'X';
		} else {
			$closed = 'N';
		}

		$topic_start_un   = "";
		$topic_start_name = "";

		$total_replies    = $this_topic_data[5];
		$total_replies    = 0 unless $total_replies;
		$subject          = $this_topic_data[3];
		$user_name        = $this_topic_data[2];
		$msg_icon         = $this_topic_data[4];
		$topic_start_name = $this_topic_data[9] if $this_topic_data[9];      # this is new
		$topic_start_un   = $this_topic_data[10] if $this_topic_data[10];    # this is new
		$pollid = $this_topic_data[18];

		# localized
		$last_julian = $this_topic_data[14];

		# get user number if not available
		if (!$topic_start_un) { $topic_start_un = &GetUserNumber($user_name); }


		# get latest public name for topic starter!
		if ($topic_start_un) {
			if (-s "$vars_config{MembersPath}/$topic_start_un.cgi") {
				@user_profile = &OpenProfile($topic_start_un);
				chomp($user_profile[15]);
				chomp($user_profile[0]);

				#print "$user_name ($topic_start_name) -> $topic_start_un\n";
				if ($user_profile[15] eq '') {
					$topic_start_name = $user_profile[0];
				} else {
					$topic_start_name = $user_profile[15];
				}
			}
		} else {

			if ($topic_start_name eq '') {
				$topic_start_name = $user_name;
			}
		}

		$last_hyphen_date = $this_topic_data[12];

		# format time
		$last_time = &TimeFormat($this_topic_data[13]);

		# format date
		($GetMonth, $GetDate, $GetYear) = split (/-/, $last_hyphen_date);
		$GetYear          = &Y2K($GetYear);
		$last_hyphen_date = ("$GetMonth" . "-" . "$GetDate" . "-" . "$GetYear");

		$TheDate = &DateFormat($last_hyphen_date);

		# set msg icon
		if (!$msg_icon) { $msg_icon = '1'; }
		chomp($msg_icon);
		unless (&FileExists("$vars_config{NonCGIPath}/icons/icon$msg_icon.gif")) {
			$msg_icon = '1';
		}

		# get fiery?
		$hot_icon = 'no';
		if ($vars_display{HotIcons} eq 'ON') {
			if ($total_replies > $vars_display{HotCount}) {
				$hot_icon = 'yes';
			}
		}


		# multipage display - idea by Howard, basic code by Mark Badolato
		# Revised code based on OpenTopic concept paginator courtesy Brett Harris :)
		my $total_posts = $total_replies + 1;
		$extra_pages = '';    # reset var
		unless ($vars_display{HTMLDisplayMax} eq 'NONE') {
			my $page_total = int($total_posts / $vars_display{HTMLDisplayMax});
			if ($total_posts % $vars_display{HTMLDisplayMax}) { $page_total++; }

			if ($page_total > 1) {
				$extra_pages = qq( <font face="$vars_style{FontFace}" size="1"> $vars_wordlets{pages}: );
				if($vars_display{'PaginationType'} eq "new") {
					foreach my $pa (&paginate($page_total, 1)) {
						my($name, $number) = each(%{$pa});
						$extra_pages .= qq(<a href="$ULTIMATEBB?ubb=get_topic;f=$in{f};t=$one;p=$number">$name</a> );
					} # end foreach
				} else {
					for (1 .. $page_total) {
						$extra_pages .= qq(<a href="$ULTIMATEBB?ubb=get_topic;f=$in{f};t=$one;p=$_">$_</a> );
					}
				} # end if
				$extra_pages .= '</font>';
			}
		}    # end multi-page display section

		# if alphabetical sort, need to reset the $forum_topics entry to j date/time
#		$forum_topics{$one} = $this_topic_data[14];

		$ThisHTML .= &topic_row;

	}

	$ThisHTML .= &page_bottom;    # some HTML
	$ThisHTML .= $Footer;
#	moved below...
#	print "$ThisHTML";

	$in{start_point} = "" unless $in{start_point};
	#if ($in{start_point} eq '') {

		# do we need to create directory?

		unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page")) {
			mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page", SEVENSEVENSEVEN);
			chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page");
		}

		unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$exact_path")) {
			if ($permission =~ m/private/) {
				unless (&DirExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/Forum$in{f}")) {
					mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/Forum$in{f}", SEVENSEVENSEVEN);
					chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/Forum$in{f}");
				}
			}

			mkdir("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$exact_path", SEVENSEVENSEVEN);
			chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$exact_path");
		}

		# print to cache!
		&WriteFileAsString("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forum_page/$exact_path/forum$in{f}-$user_topic_view$extension.cgi", $ThisHTML);


	print &FilterPNTF($ThisHTML);

	exit(0);
}    # end get_forum

# DANGER: Do not remove the next line!
1;
# $Id: ubb_forum.cgi,v 1.16 2002/05/02 23:41:29 cvscapps Exp $
