# UBB.classic New Topic Routines : Perl Code

&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");

unless ($in{f}) {
	&StandardHTML($vars_wordlets_err{no_forum_selected});
	exit(0);
}

# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");
# get assigned style template!
%vars_style = &LoadStyleTemplate($this_forum);

&set_page_elements;

sub edit_post {
	local ($email_notify, @this_topic, @stat_line, @post_line, @post_info, @user_profile, $permission, @this_forum, $delete_warning, $warning_words, $message, $is_one, $is_admin_mod, $this_subject, $icon_field, $close_option, $profile_number, $show_sig, $sigcheck, $permit_delete, $category, $cat_name, $cat_line1, $ubb_code_buttons, $is_html, $is_ubb, $ubb_images_wording);

	# make sure we have someone logged in
	if ($username eq '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<br /> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a>!);
	}

	if((!$in{reply_num}) || ($in{reply_num} !~ m/^\d{6}$/)) {
		&PostHackDetails($vars_wordlets_err{hack_no_replynumber});
	} # end if

	# get forum info
	@this_forum = &GetForumRecord($in{f});

	if ($this_forum[6] eq 'private') {
		$reply_restrict = "restrict";
	} elsif($this_forum[6] =~ m/^private(.+)\&private(.+)$/) {
		$reply_restrict = $2;
	} else {
		($j, $reply_restrict) = split (/\&/, $this_forum[6]);
	}

	if (($username) && ($reply_restrict eq 'none') &&
	    (&is_admin_or_mod($in{f}, &verify_id_num($username, $password, $user_number)) ne 'true'))
	    {
		&StandardHTML("$vars_wordlets_err{no_one_can_post}");
	} # end if

	# if forum is private, make sure user has access
	if ($this_forum[6] =~ m/private/) { &check_private_access($in{f}, $this_forum[12]); }

	# grab topic
	@this_topic = &OpenTopic($in{t}, $in{f});

	# grab topic stat line
	@stat_line = split (/\|\|/, $this_topic[0]);

	# find particular post within topic
	@post_line = grep(/^Z\|\|$in{reply_num}\|\|/, @this_topic);
	@post_info = split (/\|\|/, $post_line[0]);

	# get profile for poster to confirm identity
	if ($post_info[8] eq 'reg') {
		if ($post_info[11] ne '') {
			$profile_number = $post_info[11];
		} else {
			$profile_number = &GetUserNumber($post_info[2]);
			if ($profile_number eq '') { $profile_number = 'NONE'; }
		}

		#@post_user = &OpenProfile($profile_number);
	} else {
		$profile_number = 'NONE';
	}


	# permission to edit?

	if (($user_number == $profile_number) && ($vars_misc{EditOption} ne 'OFF') && ($stat_line[1] !~ /X/i)) {
		$permission = 'true';
	}

	# if not poster, need to be admin or forum moderator...
	#verify cookie id
	@user_profile = &verify_id_num($username, $password, $user_number);

	# make sure user is an admin or moderator of this forum
	$is_one = &is_admin_or_mod($in{f}, @user_profile);

	if ($is_one eq 'true') { $permission = 'true'; }

	if ($permission ne 'true') { &StandardHTML("$vars_wordlets_err{not_admin_or_mod}"); }

	# is editor an admin or mod of this forum?
	chomp($user_profile[8]);
	if ($is_one eq 'true') { $is_admin_mod = 'true'; }

	# can user delete?
	if ($vars_misc{EditOption} ne 'ON') {

		if ($is_one eq 'true') { $permit_delete = 'true'; }

	} else {

		$permit_delete = 'true';

	}

	# grab category
	if ($vars_display{CategoryView} eq 'yes') {

		$category = $this_forum[0];
		$cat_name = &GetCatName($category);

		$cat_line1 = qq!
&nbsp;
&#187;  <a href="$ULTIMATEBB?&category=$category">
<b>$cat_name</b></a>
!;
	} else {
		$cat_line1 = '';
	}


	# ok, this person has permission to edit!

	($html_allowed, $ubb_allowed, $is_ubb, $is_html, $ubb_images_wording) = &CheckCoding("$this_forum[4]", "$this_forum[5]", "$this_forum[10]");

	# -> is_html, is_ubb, ubb_images_wording

	if ($this_forum[5] eq 'is') {
		$ubb_code_buttons = &instant_ubb_code;
	} else {
		$ubb_code_buttons = "$is_ubb";
	}

	if(($post_info[1] eq "000000") && (($vars_email{UseEmail} eq 'ON') && (($username ne '') || ($vars_display{RequireLoginPosts} eq "NO")))) {
		$email_notify = ($stat_line[1] =~ m/N/
			? qq(<input type="checkbox" id="email_notification" name="email_notification" value="yes" checked="checked" /> $vars_wordlets{email_notify} <br />)
			: qq(<input type="checkbox" id="email_notification" name="email_notification" value="yes" /> $vars_wordlets{email_notify} <br />) )
	} # end if

	# prepare the post for display
	$message = $post_info[6];

	# remove signature, if this is an old format post
	chomp($post_info[12]);
	if ($post_info[12] eq '') {
		$message =~ s/------------------(.*)//isg;    # old sig standard
	}

	$message = &prep_for_edit("$message", "$this_forum[5]", "$this_forum[10]");

	# Finally!  :)
	##### Removal of the edited notice moved to prep_for_edit

	# check for ability to delete post
	if ($vars_misc{EditOption} eq 'NODELETE') {
		$delete_warning = qq%$vars_wordlets{edit_without_delete}%;
	} else {
		$delete_warning = qq%$vars_wordlets{edit_with_delete}%;
	}

	if ($in{reply_num} eq '000000') {
		$warning_words = qq!$vars_wordlets{warn_delete_entire_topic}!;
		$this_subject  = $stat_line[4];
		$this_subject =~ s/&#0124;/\|/sg;
	}

	if ($vars_display{AllowIcons} eq 'TRUE') {
		$icon_field = &create_icon_field("$post_info[9]");
	}

	# disable smilies?
	$disable_smilies = qq(<br /><input type="checkbox" id="disable_smilies" name="disable_smilies" value="yes" /> $vars_wordlets{disable_smilies});

	# show signature?
	if (($vars_display{AllowSignature} eq 'YES') && ($username ne '') && ($profile_number ne 'NONE')) {
		if ($post_info[12] eq 'yes') { $sigcheck = 'checked="checked"'; }
		$show_sig = qq(<input type="checkbox" name="Signature" id="Signature" value="yes" $sigcheck /> $vars_wordlets{show_signature}<br />);
	}

	# allow closing of topic?
	# only admins or mods can close topics
	if (($username ne '') && ($stat_line[1] !~ /X/i)) {
		if ($user_profile[0] eq '') {
			@user_profile = &verify_id_num($username, $password, $user_number);
		}
		my $is_one = &is_admin_or_mod($in{f}, @user_profile);

		if ($is_one eq "true") {
			$close_option = qq(<br /><input type="checkbox" id="close_topic" name="close_topic" value="yes" /> <b>$vars_wordlets{close_topic}</b>);
		}
	}

	# pull in instant smilie/ubb code javascript
	$direct_to = $instant_jscript;
	&set_page_elements;
	&LoadTemplate("public_edit_post");

}    # end edit_post sr

sub submit_edit {
	local (@this_topic, @stat_line, @post_user, @post_line, @post_info, @user_profile, $permission, @this_forum, $delete_warning, $warning_words, $message, $is_admin_mod, $this_subject, $icon_field, $post_total, $profile_number);

	&GetOrPost('POST');

	# make sure we have someone logged in
	if ($username eq '') {
		&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<p> <a href="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</a></p>!);
	}

	# get forum details
	@this_forum = &GetForumRecord($in{f});

	# lock down
	my $lockhandler = new UBB::FileHandler(\%vars_config, "topic_lock_$in{f}");
	$lockhandler->force_lock;

	# grab topic
	@this_topic = &OpenTopic($in{t}, $in{f});

	# this also sets $exact_path

	$post_total = @this_topic;
	$post_total--;


	# grab topic stat line
	@stat_line = split (/\|\|/, $this_topic[0]);

	# find particular post within topic
	@post_line = grep(/^Z\|\|$in{reply_num}\|\|/, @this_topic);
	@post_info = split (/\|\|/, $post_line[0]);

	# get profile for poster to confirm identity
	if ($post_info[8] eq 'reg') {
		if ($post_info[11] ne '') {
			$profile_number = $post_info[11];
		} else {
			$profile_number = &GetUserNumber($post_info[2]);
			if ($profile_number eq '') { $profile_number = 'NONE'; }
		}

		# @post_user = &OpenProfile($profile_number);
	} else {
		$profile_number = 'NONE';
	}

	# permission to edit?

	if (($user_number == $profile_number) && ($vars_misc{EditOption} ne 'OFF') && ($stat_line[1] !~ /X/i)) {
		$permission = 'true';
		if (($vars_misc{EditOption} eq 'NODELETE') && ($in{delete_post} eq 'yes')) {
			$permission = '';
		}

	}

	# if not poster, need to be admin or forum moderator...
	#verify cookie id
	@user_profile = &verify_id_num($username, $password, $user_number);

	# make sure user is an admin or moderator of this forum
	my $is_one = &is_admin_or_mod($in{f}, @user_profile);

	if ($is_one eq 'true') { $permission = 'true'; }

	if ($permission ne 'true') { &StandardHTML("$vars_wordlets_err{not_admin_or_mod}"); }

	# request to delete?
	if ($in{delete_post} eq 'yes') {

		&perform_delete($lockhandler);

	} else {

		# simple edit
		&perform_edit($lockhandler);

	}

}    # end submit_edit

sub perform_delete {

	local (@user_posts, @updated_topic, $update_threads_file, @rev_topic);

	&GetOrPost('POST');

	# lock down
	my $lockhandler = shift;

	# get lastnumber.file info
	@last_numbers = &grab_last_numbers;

	chomp($last_numbers[0]);
	chomp($last_numbers[1]);
	chomp($last_numbers[2]);
	chomp($last_numbers[3]);
	chomp($last_numbers[4]);
	chomp($last_numbers[5]);
	chomp($last_numbers[6]);

	if ($in{reply_num} eq '000000') {

		my $pollid = (split(/\|\|/, (&OpenTopic($in{t}, $in{f}))[0]))[10];
		chomp($pollid);

		# delete topic file
		&Unlink("$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");

		#delete HTML file for topic
		#unlink ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");

		my $thispath = qq($vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path);
		&DoThatClearCacheThing($thispath, $in{t});

		# If this is a poll, nuke the datafile
		if($pollid =~ m/^\w{12}$/) {
			&Unlink("$vars_config{NonCGIPath}/Polls/$pollid.cgi");
		} # end if

		# update threads file
		&unlink_topic_from_forum_summary($in{f}, $in{t});
		&CreateLastTimeFiles($in{f});

		$lockhandler = undef;

		# clear cache
		&ClearSummaryCacheCarefully((&GetForumRecord($in{f}))[0]);
		&ClearSingleForumPageCache($exact_path, $in{f});

		# transition
		%vars_style = &LoadStyleTemplate("transition");
		&set_page_elements;
		&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum;f=$in{f}", "$vars_wordlets{thanks_for_topic_delete}", "$this_forum[1]");
		exit(0);
	} else {

		# only delete particular post within topic

		# adjust reply total & stat_line
		$stat_line[2] = scalar(@this_topic) - 3;  #three, not 2 - yet to delete

		# adjust @this_topic
		$this_topic[0] = join ("||", @stat_line);


		# remove post from topic file
		foreach (@this_topic) {
			unless ($_ =~ /^Z\|\|$in{reply_num}\|\|/) {
				push (@updated_topic, $_);
			}
		}

		# update topic file
		&WriteTopic($in{f}, $in{t}, @updated_topic);

		# update lastnumber.file
		&UpdateForumThreadDataForSingleThreadAndWrite($in{f}, $in{t}, \@updated_topic);
		&CreateLastTimeFiles($in{f});

		# delete HTML file for topic - it will be recreated when needed
		my $thispath = qq($vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path);
		&DoThatClearCacheThing($thispath, $in{t});


		# update user_posts file
		# need to do this when deleting single posts w/in topics

		@user_posts = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$profile_number.cgi");

		foreach (@user_posts) {
			chomp($_);
			unless ($_ =~ m/^\d{8}\|$in{f}\|$in{t}\|$in{reply_num}|\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/) { push (@updated_posts, $_); }
		}

		# update user_posts file
		&WriteFileAsArray("$vars_config{MembersPath}/user_posts/$profile_number.cgi", @updated_posts);

		$lockhandler = undef;

		# clear cache
		&ClearSummaryCacheCarefully((&GetForumRecord($in{f}))[0]);
		&ClearSingleForumPageCache($exact_path, $in{f});

		# transition
		%vars_style = &LoadStyleTemplate("transition");
		&set_page_elements;
		&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic;f=$in{f};t=$in{t}", "$vars_wordlets{thanks_for_post_delete}", "$stat_line[4]");
		exit(0);
	}


}    # end perform_delete



sub perform_edit {
	local ($count, $message, $ip_number, @post_data, $edit_date, @last_numbers);

	&GetOrPost('POST');

	my $lockhandler = shift;

	# clean up edited post
	$message = &cook_post($in{message}, $in{f}, $in{disable_smilies});

	# append edit note to the message
	if ($vars_misc{EditWording} eq 'yes') {
		&GetDateTime;

		$edit_date = join(", ", &DateFormat2($GotTime{HyphenDate}, $GotTime{Time}));

		$message .= qq(<br /> <br /> <small>[ $edit_date: $vars_wordlets{edit_wording} $pubname ]</small>);


	}    # end "edited by" message

	# post icons idea provided by KOMBAT03...
	unless ($in{msg_icon} =~ m/^\d+?$/) { $in{msg_icon} = '1'; }
	unless(&FileExists("$vars_config{NonCGIPath}/icons/icon$in{msg_icon}.gif")) {
		$in{msg_icon} = '1';
	}

	# is user banned?
	$ip_number = &GetIPAddress;
	&check_ip_bans;

	if((!$in{reply_num}) || ($in{reply_num} !~ m/^\d{6}$/)) {
		&PostHackDetails($vars_wordlets_err{hack_no_replynumber});
	} # end if

	# topic subject checks, if this is the first post
	if ($in{reply_num} eq "000000") {

		# require english letter/number in subject?
		if (($in{topic_subject} !~ /[a-zA-Z0-9]/) && ($vars_misc{EnglishSubjectCheck} eq 'ON')) {
			&StandardHTML("$vars_wordlets_err{subject_deficient}");
		}

		&CheckLength("topic_subject", 85);

		# check for HTML tags in subject
		if (($in{topic_subject} =~ /<.+>/) || ($in{topic_subject} =~ /</)) {
			&StandardHTML("$vars_wordlets_err{subject_with_html}");
		}

		$vars_misc{runOnLimit} = 30 unless $vars_misc{runOnLimit};

		# other subject checks/clean-ups
		if ($in{topic_subject} =~ /\S{$vars_misc{runOnLimit}}/) {
			&StandardHTML("$vars_wordlets_err{subject_with_runontext} : $in{topic_subject}");
		}    #test before trying to expand special characters

		$in{topic_subject} = &FixSubjectEncoding($in{topic_subject});

		# censor check the subject
		$in{topic_subject} = &CensorCheck("$in{topic_subject}");

		my $copy = &strip_lead_trail_space(&EscapeFilter($in{topic_subject}));
		if(length($copy) < 1) { &StandardHTML("$vars_wordlets_err{subject_deficient}"); }

		if($in{email_notification} ne "yes") {
			$stat_line[1] =~ s/N//g;
		} elsif(($in{email_notification} eq "yes") && ($stat_line[1] !~ m/N/)) {
			$stat_line[1] .= "N";
		} # end if

		# need to update stat_line
		$stat_line[4] = $in{topic_subject};
		$stat_line[6] = $in{msg_icon};

	}    # end stat_line changes

	# close topic?
	# only admins or mods can close topics
	if ($in{close_topic} eq 'yes') {
		if ($user_profile[0] eq '') {
			@user_profile = &verify_id_num($username, $password, $user_number);
		}
		my $is_one = &is_admin_or_mod($in{f}, @user_profile);
		if ($is_one eq 'true') { $stat_line[1] .= 'X'; }
	}

	foreach (@stat_line) {chomp}

	$stat_line[2] = scalar(@this_topic) - 2;

	# update stat line
	$this_topic[0] = join ("||", @stat_line);

	#chomp($this_topic[0]);
	#$this_topic[0] .= "\n";

	# update post in topic file
	$count = 0;
	foreach (@this_topic) {
		if ($_ =~ /^Z\|\|$in{reply_num}\|\|/) {
			@post_data = split (/\|\|/, $_);
			$post_data[9]  = $in{msg_icon};
			$post_data[6]  = $message;
			$post_data[12] = $in{Signature};
			chomp($post_data[7], $post_data[8], $post_data[10], $post_data[11]);
			$this_topic[$count] = join ("||", @post_data);
		}
		chomp($this_topic[$count]);
		$this_topic[$count] .= "\n";
		$count++;
	}

	&WriteTopic($in{f}, $in{t}, @this_topic);
	&UpdateForumThreadDataForSingleThreadAndWrite($in{f}, $in{t}, \@this_topic);

	# delete HTML file for topic - it will be recreated when needed
	#unlink ("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");

	my $thispath = qq($vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path);
	&DoThatClearCacheThing($thispath, $in{t});



	# update lastnumber.file, if necessary
	@last_numbers = &grab_last_numbers;

	chomp($last_numbers[0]);
	chomp($last_numbers[1]);
	chomp($last_numbers[2]);
	chomp($last_numbers[3]);
	chomp($last_numbers[4]);
	chomp($last_numbers[5]);
	chomp($last_numbers[6]);

	if ($last_numbers[6] eq $in{t}) {

		if ($in{reply_num} eq '000000') {
			$last_numbers[3] = $in{topic_subject}; #&GoodNiceTruncate($in{topic_subject}, 26);
		}

		# is this the last post in the topic- if so, update icon
		my @rev_topic = reverse(@this_topic);
		my @last_post = split (/\|\|/, $rev_topic[0]);
		if ($last_post[1] == $in{reply_num}) {
			$last_numbers[5] = $in{msg_icon};
		}

		#need to update lastnumbers file then
		&WriteFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file", @last_numbers);

		# clear cache
		&ClearSummaryCacheCarefully((&GetForumRecord($in{f}))[0]);

	}    # end lastnumbers check

	$lockhandler = undef;

	if ($in{reply_num} eq "000000") {
		&ClearSingleForumPageCache($exact_path, $in{f});
	}

	print header;

	my $last_page_extra = "";
	if(($vars_display{HTMLDisplayMax} > 0) && ($vars_display{ReverseThreads} eq "FALSE")) {
		my $fraction = 1 / $vars_display{HTMLDisplayMax};
		my $outer = $fraction;
		foreach(@this_topic) {
			next if $_ !~ m/^Z/;
			next unless m/^Z\|\|(\d+)\|\|/;
			my $this = $1;
			$outer += $fraction;
			last if $this eq $in{reply_num};
		} # end if
		my $page = &round_up_always($outer);
#		$page++ if(int($page / $vars_display{HTMLDisplayMax}) eq ($page / $vars_display{HTMLDisplayMax}));

		if($page > 1) {
			$last_page_extra = ";p=$page";
		} # end if
		$last_page_extra .= "#$in{reply_num}";
	} # end if


	# transition
	%vars_style = &LoadStyleTemplate("transition");
	&set_page_elements;
	&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic;f=$in{f};t=$in{t}$last_page_extra", "$vars_wordlets{thanks_for_edit}", "$stat_line[4]");

	exit(0);
}    # end perform_edit sr

# DANGER: Do not remove the next line!
1;
# $Id: ubb_edit_post.cgi,v 1.10 2002/05/03 18:27:33 cvscapps Exp $
