# Control Panel - Routines for viewing/setting wordlets

sub view_wordlets {
	local ($var, %wordlets_fill);

	# $_[0]: wordlet parameter

	if ($_[0] eq 'wordlets') {

		%wordlets_fill = %vars_wordlets;

		$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_wordlets">
<INPUT TYPE="HIDDEN" NAME="type" VALUE="$_[0]">
%;
		$CurrentTab = qq%$vars_wordlets_cp{primary_wordlets}%;

		# note: the wordlets are already required... no need to grab them

		&CPHeader;
		&CPFooter;
		&CPTop;
		&LoadTemplate("cp_set_wordlets");
		&CPBottom;


	} elsif ($_[0] eq 'wordlets_err') {

		%wordlets_fill = %vars_wordlets_err;

		$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_wordlets">
<INPUT TYPE="HIDDEN" NAME="type" VALUE="$_[0]">
%;
		$CurrentTab = qq%$vars_wordlets_cp{error_wordlets}%;

		# note: the wordlets are already required... no need to grab them

		&CPHeader;
		&CPFooter;
		&CPTop;
		&LoadTemplate("cp_set_wordlets");
		&CPBottom;
	}

	elsif ($_[0] eq 'wordlets_cp') {

		%wordlets_fill = %vars_wordlets_cp;

		$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_wordlets">
<INPUT TYPE="HIDDEN" NAME="type" VALUE="$_[0]">
%;
		$CurrentTab = qq%$vars_wordlets_cp{cp_wordlets}%;

		# note: the wordlets are already required... no need to grab them

		&CPHeader;
		&CPFooter;
		&CPTop;
		&LoadTemplate("cp_set_wordlets");
		&CPBottom;
	}

	elsif ($_[0] eq 'wordlets_img') {

		%wordlets_fill = %vars_wordlets_img;

		$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_wordlets">
<INPUT TYPE="HIDDEN" NAME="type" VALUE="$_[0]">
%;
		$CurrentTab = qq%$vars_wordlets_cp{img_wordlets}%;

		# note: the wordlets are already required... no need to grab them

		&CPHeader;
		&CPFooter;
		&CPTop;
		&LoadTemplate("cp_set_wordlets");
		&CPBottom;
	}

	elsif ($_[0] eq 'wordlets_date') {

		%wordlets_fill = %vars_wordlets_date;

		$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_wordlets">
<INPUT TYPE="HIDDEN" NAME="type" VALUE="$_[0]">
%;
		$CurrentTab = qq%$vars_wordlets_cp{date_wordlets}%;

		# note: the wordlets are already required... no need to grab them

		&CPHeader;
		&CPFooter;
		&CPTop;
		&LoadTemplate("cp_set_wordlets");
		&CPBottom;

	}

	elsif ($_[0] eq 'wordlets_email') {

		&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");
		%wordlets_fill = %vars_wordlets_email;

		$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_wordlets">
<INPUT TYPE="HIDDEN" NAME="type" VALUE="$_[0]">
%;
		$CurrentTab = qq%$vars_wordlets_cp{email_wordlets}%;

		&CPHeader;
		&CPFooter;
		&CPTop;
		&LoadTemplate("cp_set_wordlets");
		&CPBottom;
	}

	elsif ($_[0] eq 'wordlets_poll') {

		&RequireVars("$vars_config{VariablesPath}/vars_wordlets_poll.cgi");
		%wordlets_fill = %vars_wordlets_poll;

		$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_wordlets">
<INPUT TYPE="HIDDEN" NAME="type" VALUE="$_[0]">
%;
		$CurrentTab = qq%$vars_wordlets_cp{poll_wordlets}%;


		&CPHeader;
		&CPFooter;
		&CPTop;
		&LoadTemplate("cp_set_wordlets");
		&CPBottom;
	}

	elsif ($_[0] eq 'wordlets_pntf') {

		&RequireVars("$vars_config{VariablesPath}/vars_wordlets_pntf.cgi");
		%wordlets_fill = %vars_wordlets_pntf;

		$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_wordlets">
<INPUT TYPE="HIDDEN" NAME="type" VALUE="$_[0]">
%;
		$CurrentTab = qq%$vars_wordlets_cp{pntf_wordlets}%;

		&CPHeader;
		&CPFooter;
		&CPTop;
		&LoadTemplate("cp_set_wordlets");
		&CPBottom;
	} else {

		&StandardHTML("Action not permitted.");
	}

}    # end view_wordlets

sub set_wordlets {
	local ($key, %update_wordlets);


	if ($in{type} eq 'wordlets') {
		%update_wordlets = %vars_wordlets;
	} elsif ($in{type} eq 'wordlets_err') {
		%update_wordlets = %vars_wordlets_err;
	} elsif ($in{type} eq 'wordlets_cp') {
		%update_wordlets = %vars_wordlets_cp;
	} elsif ($in{type} eq 'wordlets_date') {
		%update_wordlets = %vars_wordlets_date;
	} elsif ($in{type} eq 'wordlets_img') {
		%update_wordlets = %vars_wordlets_img;
	} elsif ($in{type} eq 'wordlets_pntf') {
		&RequireVars("$vars_config{VariablesPath}/vars_wordlets_pntf.cgi");
		%update_wordlets = %vars_wordlets_pntf;
	} elsif ($in{type} eq 'wordlets_poll') {
		&RequireVars("$vars_config{VariablesPath}/vars_wordlets_poll.cgi");
		%update_wordlets = %vars_wordlets_poll;
	} elsif ($in{type} eq 'wordlets_email') {
		&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");
		%update_wordlets = %vars_wordlets_email;
	} else {
		&StandardHTML("Action not permitted.");
	}

	# validate and prep value
	foreach $key (keys %update_wordlets) {

		if ($in{$key} eq '') {
			&StandardHTML("$vars_wordlets_err{empty_form_field}: $key");
		}

		# strip begin/trailing white space
		$in{$key} =~ s/^\s+//;
		$in{$key} =~ s/\s+$//;

		#$in{$key} = &SmallClean2($in{$key});
		# no need - WHTF does all the work

		$update_wordlets{$key} = $in{$key};

	}    # validate all wordlets keys

	# update wordlets file!
	&WriteHashToFile("$vars_config{VariablesPath}/vars_$in{type}.cgi", "vars_$in{type}", \%update_wordlets);

	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;
	&ClearSummaryCache;
	&ClearMiscCache;

	&cp_confirm("Wordlets Updated");



}    # end set_wordlets


# Danger- do not remove the following line!
1;
# $Id: cp_wordlets.cgi,v 1.4 2002/02/14 23:38:55 cvscapps Exp $