# Control Panel - Routines for setting, managing users

sub user_settings {
	local ($private_forum_options, @forums, $one, @this_one);

	&clean_search_files;

	# need to compile list of private forums
	@forums = &OpenForumsFile;

	# start line...
	$private_forum_options = '';

	foreach $one (@forums) {
		@this_one = split (/\|\^\|/, $one);
		if ($this_one[6] =~ m/private/) {
			$private_forum_options .= qq!<option value="$this_one[8]">$this_one[1]</option>!;
		}
	}    # each forum loop

	&AppendAdminLog($username, $status, "Viewed Member Search Intro", "Succeeded", "");


	$Hiddens = qq!
	<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="search_members2">
	!;
	$CurrentTab = qq%$vars_wordlets_cp{search_users_header}%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_user_search_form");
	&CPBottom;

}    # end user_settings


sub clean_search_files {
	local (*FILE);
	local ($j, $dfile, $dfiledate, @searchies, $fn);
	opendir(FILE, "$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/user_search");
	@dailies = readdir(FILE);
	closedir(FILE);

	foreach (@dailies) {
		push (@searchies, $_) if (m/^\d+\-\d+\-.+\.cgi$/);
	}
	foreach $dfile (@searchies) {
		$dfile =~ m/^(\d+)\-\d+\-.+\.cgi$/;
		$dfiledate = $1 + 1;    # delete if 1 days old
		my @thistime = split (/-/, $GotTime{SearchJulian});

		if ($dfiledate < $thistime[0]) {
			&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/user_search/$dfile");
		}
	}

}    # end clean_search_files


sub update_members {
	local (%user_change, %user_delete, $key, $j, $user_number, $delete, @updated_mems, @updated_emails, $one, $delete_count, @mod_profile, $perms, $new_perms, $forums);

	$delete_count = 0;
	foreach $key (keys %in) {

		if ($key =~ /Admin/i) {
			($j, $user_number) = split (/::/, $key);
			$user_change{$user_number} .= "$in{$key}";
		}

		if ($key =~ /Write/i) {
			($j, $user_number) = split (/::/, $key);
			$user_change{$user_number} .= "$in{$key}";
		}

		if ($key =~ /Delete/i) {
			$delete = 'true';
			$delete_count++;
			($j, $user_number) = split (/::/, $key);
			$user_change{$user_number} .= "$in{$key}";
		}

	}    # end %in loop

	# create user_delete hash, if any are being deleted
	if ($delete eq 'true') {

		&GetSearchParams($in{record});
		# creates %searchparams, %params, %memberslist, @memlist, $loops, $loopcount, $memcount, $left, $matches

		foreach $key (keys %user_change) {

			if ($user_change{$key} =~ /D/i) {
				$user_delete{$key} = 'Y';
				delete($user_change{$key});
				&Unlink("$vars_config{MembersPath}/$key.cgi") or die "$! while trying to delete profile '$key'";
				delete $memberslist{$key};	# memberslist = searchparams file
				if(&FileExists("$vars_config{MembersPath}/$key.cgi")) {
					&Unlink("$vars_config{MembersPath}/$key.cgi") or die "$! while trying to delete profile '$key'";
				}
				if(&FileExists("$vars_config{MembersPath}/$key.cgi")) {
					die("I encountered an error while deleting this member file: $vars_config{MembersPath}/$key.cgi");
				} # end if
			}

		}    # end user_change hash loop

		# will need to update memberslist and emailfile
		my @the_members = &GetMembersListAsArray;
		my @the_emails = &GetEmailFileAsArray;
		my $member_total = &GetMemberTotal;

		$member_total = $member_total - $delete_count;

		# amend memberslist
		MEMBERCHECK: foreach $one (@the_members) {
			chomp($one);
			foreach $key (keys %user_delete) {
				if ($one =~ /$key$/) {
					next MEMBERCHECK;
				}
			}
			push (@updated_mems, $one);
		}


		# amend emailfile
		EMAILCHECK: foreach $one (@the_emails) {
			chomp($one);
			foreach $key (keys %user_delete) {
				if ($one =~ /$key$/) {
					next EMAILCHECK;
				}
			}
			push (@updated_emails, $one);
		}

		&UpdateMemberslist(\@updated_mems);
		&UpdateEmailfile(\@updated_emails);
		&UpdateMemberTotal($member_total);

		&SaveSearchParams($in{record});

#		&WriteFileAsArray("$vars_config{MembersPath}/memberslist.cgi", @updated_mems);
#		&WriteFileAsArray("$vars_config{MembersPath}/emailfile.cgi", @updated_emails);
#		&WriteFileAsString("$vars_config{MembersPath}/membertotal.cgi", $member_total);

	}    # if delete = true

	# update files not being deleted now
	foreach $key (keys %user_change) {
		undef($new_perms);
		@mod_profile = &OpenProfile($key);
		chomp($mod_profile[4]);
		chomp($mod_profile[8]);

		($perms, $forums) = split (/&/, $mod_profile[4]);

		if ($user_change{$key} =~ /A/i) {
			$mod_profile[8] = 'Administrator';
			$new_perms .= 'Admin';
		} else {
			$mod_profile[8] = &determine_status;
		}

		if ($user_change{$key} =~ /W/i) { $new_perms .= 'Write'; }

		$mod_profile[4] = ("$new_perms" . "&" . "$forums");

		&WriteMemberProfile($key, @mod_profile);

	}    # end user_change loop

	# clear cache
	&ClearSummaryCache;
	&ClearForumTopicsCache;

	&AppendAdminLog($username, $status, "Submitted Changes to Member List", "Succeeded", "", 1);    #don't log the %in line - too much data

	&cp_confirm("Members Updated", "<b>Do not use your back button to return.  Use this link instead:", "Return to Results", "$vars_config{CGIURL}/cp.cgi?ubb=show_user_search_results;record=$in{record};start_point=$in{start_point}");
	exit(0);

}    # end update_members sr


sub determine_status {
	local (@mods_list, $status);
	@mods_list = &OpenFileAsArray("$vars_config{VariablesPath}/vars_mods.cgi");
	undef($mod);
	foreach $j (@mods_list) {
		if ($j =~ /$key/) {
			$status = 'Moderator';
		}
	}

	if ($status ne 'Moderator') {
		&RequireVars("$vars_config{VariablesPath}/vars_misc.cgi");
		chomp($mod_profile[7]);
		if ($mod_profile[7] < $vars_misc{MemberMinimum}) {
			$status = 'Junior Member';
		} else {
			$status = 'Member';
		}
	}
	return ($status);
}    # end determine_status

sub get_profile_for_admin {
	local ($poll_write_check, $write_lock_check, @user_profile, $chompee, $count, $user_public_name, $user_status, %select_list, $days, $mm_yes, $mm_no, $ev_yes, $ev_no, $Signature, @explicit, $j, $perms, @mods, $mod, $Moderator, $is_mod, @forum_line, %forum_names, %forum_status, %forum_rights, $key, $overall_rating, %vars_style, $pm_yes, $pm_no, $pm_notify_yes, $pm_notify_no, $lock_check, $total_votes, $pm_lock_check);

	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
	&RequireVars("$vars_config{VariablesPath}/vars_registration.cgi");
	&RequireVars("$vars_config{VariablesPath}/vars_misc.cgi");

	# get requested profile
	@user_profile = &OpenProfile($in{u});
	$count        = 0;
	foreach $chompee (@user_profile) {
		chomp($user_profile[$count]);
		$count++;
	}

	# set custom status title
	&RequireVars("$vars_config{VariablesPath}/vars_misc.cgi");
	$user_status = &CustomTitle($user_profile[8], $user_profile[7]);

	# set public_name
	if ($user_profile[15] eq '') {
		$user_public_name = $user_profile[0];
	} else {
		$user_public_name = $user_profile[15];
	}

	# calibrate topic view
	&RequireVars("$vars_config{VariablesPath}/vars_display.cgi");
	$days = $user_profile[21];
	if ($days eq '') { $days = $vars_display{DaysPruneDefault}; }

	foreach (qw(1 2 5 10 20 30 45 60 75 100 365 1000)) {
		$select_list{$_} = '';
	}
	$select_list{$days} = "SELECTED";

	# calibrate mass mail
	$mm_yes = '';
	$mm_no  = '';
	if ($user_profile[14] eq "yes") { $mm_yes = "CHECKED"; }
	else { $mm_no = "CHECKED"; }

	# calibrate user ratings
	$ratings_yes = '';
	$ratings_no  = '';
	if ($user_profile[25] eq 'no') { $ratings_no = 'CHECKED'; }
	else { $ratings_yes = 'CHECKED'; }

	# calibrate email view mail
	if ($user_profile[11] eq "yes") { $ev_yes = "CHECKED"; }
	else { $ev_no = "CHECKED"; }

	# calibrate pm option
	if ($user_profile[27] eq 'no') { $pm_no = 'CHECKED'; $pm_yes = ''; }
	else { $pm_yes = 'CHECKED'; $pm_no = ''; }

	# calibrate pm notify option
	if ($user_profile[28] eq 'no') { $pm_notify_no = 'CHECKED'; $pm_notify_yes = ''; }
	else { $pm_notify_yes = 'CHECKED'; $pm_notify_no = ''; }

	# get user rating?
	if ($vars_display{user_ratings} ne 'off') {
		($overall_rating, $total_votes) = &get_rating($in{u});
	}
	if ($overall_rating ne '') {
		$overall_rating = ("user_ratings_" . "$overall_rating");
	}
	&RequireVars("$vars_config{NonCGIPath}/styles/vars_style_1.cgi");

	# convert signature
	$Signature = &reverse_ubb_code("$user_profile[12]");
	$Signature =~ s/<p>/\n\r\n/isg;
	$Signature =~ s/<br>/\n/isg;
	$Signature =~ s/<br \/>/\n/isg;

	# prepare forum permissions array, if not an admin
	if ($user_profile[8] ne "Administrator") {

		# get user perms
		($j, $perms) = split (/&/, $user_profile[4]);
		@explicit = split (/,/, $perms);

		# sort forums
		my @forums     = &OpenForumsFile;
		my @sortfor    = sort(@forums);
		my @sortforums = reverse(@sortfor);

		# find restricted forum
		for (@sortforums) {
			@forum_line = split (/\|\^\|/, $_);
			if ($forum_line[6] =~m/private/) {
				$forum_names{$forum_line[8]}  = $forum_line[1];
				$forum_status{$forum_line[8]} = "Private";
			} elsif ($forum_line[6] =~ /restrict/) {
				$forum_names{$forum_line[8]}  = $forum_line[1];
				$forum_status{$forum_line[8]} = "Posting Restrictions";
			} else {

				# don't add to hashes
			}
		}

		# we have all forums with restrictions now
		foreach $key (keys %forum_names) {

			if ($user_profile[8] eq 'Moderator') {

				&RequireVars("$vars_config{VariablesPath}/vars_mods.cgi");

				$Moderator = ("Forum" . "$key" . "Moderator");
				$Moderator = $$Moderator;
				@mods      = split (/\|\|\^\|\|/, $Moderator);

				undef($is_mod);
				foreach $mod (@mods) {
					if ($mod =~ /\|\^\|$key/) {
						$is_mod = "true";
					}
				}

				if ($is_mod eq "true") {
					$forum_rights{$key} = "$vars_misc{ModeratorTitle}";
				} else {
					&check_explicit_perm;
				}

			} else {

				&check_explicit_perm;

			}


			unless ($forum_rights{$key} ne "") {
				$forum_rights{$key} = qq!\n<INPUT TYPE="CHECKBOX" NAME="explicit:$key" VALUE="yes"> $vars_wordlets_cp{grant_permission}\n!;
			}

		}    # hash loop



	}    # if not an admin

	# do profile lock check
	$lock_check = '';
	if ($user_profile[24]) {
		$lock_check = 'CHECKED' if ($user_profile[24] eq 'yes');
	} else {
		$lock_check = '';
	}

	# do pm lock check
	$pm_lock_check = '';
	if ($user_profile[29]) {
		$pm_lock_check = 'CHECKED' if ($user_profile[29] eq 'no');
	} else {
		$pm_lock_check = '';
	}

	$write_lock_check = '';
	if ($user_profile[29]) {
		$write_lock_check = 'CHECKED' if ($user_profile[4] !~ m/Write/);
	} else {
		$write_lock_check = '';
	}

	$poll_lock_check = '';
	if ($user_profile[36]) {
		$poll_lock_check = 'CHECKED' if ($user_profile[36] == 1);
	} else {
		$poll_lock_check = '';
	}

	if (($user_profile[8] eq 'Administrator') || ($user_profile[8] eq 'Moderator')) {
		$user_profile[1] = 'Admin and Moderator Passwords Are Not Viewable';
	}


	&AppendAdminLog($username, $status, "Viewed Profile for $user_profile[0] ($user_profile[8])", "Succeeded", "");


	# display profile info
	$Hiddens = qq!
	<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="edit_profile">
	<INPUT TYPE="HIDDEN" NAME="u" VALUE="$in{u}">
	!;
	$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=user_settings">$vars_wordlets_cp{search_users_header}</A> &gt;&gt; $vars_wordlets_cp{edit_profile}%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_edit_profile");
	&CPBottom;
}    # end get_profile_for_admin


sub check_explicit_perm {
	foreach (@explicit) {
		chomp($_);
		if ($key == $_) {
			$forum_rights{$key} = qq!<INPUT TYPE="CHECKBOX" NAME="explicit:$key" VALUE="yes" CHECKED> $vars_wordlets_cp{grant_permission}\n!;
		}
	}
}    # end check_explicit sr

sub edit_profile {
	local ($key, $sig, $sig_html, $chompee, $count, @user_profile, $j, $f, $perm, @explicit, $new_explicit, $grant_user_title);
	local (*FILE);

	# nuke the profile if we were told to
	if($in{"deleteuser"} eq "1") {
		my(@ml, @el);
		my($m, $e);
		foreach(&GetMembersListAsArray) { $m++; push(@ml, $_) unless $_ =~ m/$in{u}/; }
		foreach(&GetEmailFileAsArray) { $e++; push(@el, $_) unless $_ =~ m/$in{u}/; }
		&Unlink("$vars_config{MembersPath}/$in{u}.cgi");
		&Unlink("$vars_config{MembersPath}/user_posts/$in{u}.cgi");
		&UpdateMemberslist(\@ml);
		&UpdateEmailfile(\@el);
		&UpdateMemberTotal(&GetMemberTotal - 1);
		&ClearForumTopicsCache;
		&AppendAdminLog($username, $status, "Deleted Profile For $user_profile[0] ($user_profile[8])", "Succeeded", "");
#		die scalar(@ml) . " " . scalar(@el) . " -$m- -$e-";
		cp_confirm("Member Profile Deleted", undef, undef, undef);
	} # end if

	# clean up, validate, & ensure that this profile can be updated
	foreach $key (keys %in) {
		next if $key eq "dub_me";

		# rem HTML and unclosed tags
		$in{$key} =~ s/<.*?>//sg;
		$in{$key} =~ s/</&lt;/sg;
		unless ($key eq "signature") {
			$in{$key} =~ s/\s+/ /sg;
			$in{$key} =~ s/"/&quot\;/sg;
		}
	}    # foreach key


	# validate
	my @VA = ("u");

	if ($vars_registration{location_field_use} eq 'REQ')   { push (@VA, "location"); }
	if ($vars_registration{occupation_field_use} eq 'REQ') { push (@VA, "occupation"); }
	if ($vars_registration{picture_field_use} eq 'REQ')    { push (@VA, "picture"); }
	if ($vars_registration{homepage_field_use} eq 'REQ')   { push (@VA, "homepage"); }
	if ($vars_registration{interests_field_use} eq 'REQ')  { push (@VA, "interests"); }
	if ($vars_registration{signature_field_use} eq 'REQ')  { push (@VA, "signature"); }
	if ($vars_registration{icq_field_use} eq 'REQ')        { push (@VA, "icq"); }
	if ($vars_registration{aim_field_use} eq 'REQ')        { push (@VA, "aim"); }


	if (($vars_registration{custom1_field_use} eq 'REQ') && ($vars_registration{customfield1} ne '')) { push (@VA, "customfield1"); }
	if (($vars_registration{custom2_field_use} eq 'REQ') && ($vars_registration{customfield2} ne '')) { push (@VA, "customfield2"); }
	if (($vars_registration{custom3_field_use} eq 'REQ') && ($vars_registration{customfield3} ne '')) { push (@VA, "customfield3"); }
	if (($vars_registration{custom4_field_use} eq 'REQ') && ($vars_registration{customfield4} ne '')) { push (@VA, "customfield4"); }

	&Validate(@VA);

	# get user profile
	@user_profile = &OpenProfile($in{u});
	$count        = 0;
	foreach $chompee (@user_profile) {
		chomp($user_profile[$count]);
		$count++;
	}

	# add explicit permissions?
	my $wascoppa;

	if(!$in{adminify} && $user_profile[4] =~ m/Admin/) {
		@mod_profile = @user_profile;
		$user_profile[4] =~ s/Admin//g;
		$user_profile[8] = &determine_status;
	} elsif($in{adminify}) {
		@mod_profile = @user_profile;
		$user_profile[4] =~ s/Admin//g;
		$user_profile[4] = "Admin$user_profile[4]";
		$user_profile[8] = "Administrator";
	} # end if

	if ($user_profile[8] ne 'Administrator') {
		foreach $key (keys %in) {
			if (($key =~ /explicit/) && ($in{$key} eq 'yes')) {
				($j, $f) = split (":", $key);
				chomp($f);
				push (@explicit, $f);
			}
		}    # foreach key

		# assemble user permissions line
		my ($perm, $coppa) = split ("&", $user_profile[4]);
		$wascoppa++ if $coppa =~ m/COPPA/;

		$new_explicit = join (",", @explicit);

		$user_profile[4] = ("$perm" . "&" . "$new_explicit");
	}    # if not an admin/ end explicit array build


	# adjust write permissions
	($perm, $new_explicit) = split ("&", $user_profile[4]);
	if($in{allow_write} eq "no") {
		$perm =~ s/Write//g;
	} else {
		$perm =~ s/Write//g;
		$perm .= "Write";
	}
	$user_profile[4] = $perm . "&" . $new_explicit;

	# now COPPAize them
	my $not_valid = &IsValidDate($in{bday_year}, $in{bday_month}, $in{bday_day});
	if(!$not_valid) {
		my $age = 0;
		my $diff = $GotTime{JSYear} - $in{bday_year};
		if($diff == 13) {
			# There are exactly 13 years between now and then, so let's
			# do more comparisons to figure it all out

			# Adjust the number of days between now and then
			my @years = ($in{bday_year} .. $GotTime{JSYear});
			my $addleap; foreach my $year (@years) { $addleap += &YearIsLeap($year) }
			my $adjusted = 4744 + $addleap; # it's really 4745, but we subtract
							# one to allow today to be their birthday

			# now actually do the math
			my $bday = &jday($in{bday_month}, $in{bday_day}, $in{bday_year});
			my $daysold = ($GotTime{LastLoginJulianDATE} - $bday) - $adjusted;

			if($daysold < 0) {
				$age = 1;
			} else {
				$age = 0;
		}
		} elsif($diff > 13) {
			$age = 0;
		} else {
			$age = 1;
		} # end if

		if($age) {
			$user_profile[4] .= "COPPA";
		} # end if

		$user_profile[32] = sprintf("%04d%02d%02d", $in{bday_year}, $in{bday_month}, $in{bday_day});
		$user_profile[32] .= "|" . $in{bday_public};


	} else {
		$user_profile[32] = "|$in{bday_public}";
	} # end if

	# prep sig - prevent HTML, strip returns, do UBB Code
	$sig_html = $in{signature};
	if ($vars_display{AllowSignatureImage} eq 'no') {
		$ubb_code_images = 'no';
	} else {
		$ubb_code_images = 'yes';
	}

	$sig_html =~ s/(<IMG +SRC)(.*?)(>)//isg;

	# do graemlins--
	if ($ubb_code_images eq "yes") {
		$sig_html = &Smilies($sig_html);
	}

	# UBB Code-ify (if allowed)
	$sig_html = &UBBCode($sig_html, $ubb_code_images);

	#convert newlines/carriage returns to <br> and <p> html tags
	$sig_html = &PipeCleaner($sig_html);
	$sig_html = &CheckLength2(&ConvertReturns(&LimitReturns($sig_html)), 2500);

	# don't allow HTML SCRIPT TAGS
	&check_html($sig_html);


	# We will have to clean the custom title here
	$grant_user_title = &CensorCheck($in{dub_me});

	# remove leading/trainling whitespace
	$grant_user_title = &strip_lead_trail_whitespace($grant_user_title);
	&check_html($grant_user_title);

	if ($in{allow_pm} eq '') { $in{allow_pm} = 'yes'; }

	my $poll_permission = ($in{allow_poll} eq "no" ? 1 : 0);
	my $pntf_hidden = ($in{pntf_hidden} eq "1" ? 1 : 0 );

	&RequireCode("$vars_config{CGIPath}/ubb_lib_misc.cgi");

	# now, avatars...
	my $avatar_url = "";
	my($avlock, $avban, $oldavhide) = (0,0,0);
	$avlock = ($in{avlock} ? 1 : 0 );
	$avban = ($in{avban} ? 1 : 0 );
	my $avhide = $in{avatar_hidden};  if(!defined $in{avatar_hidden}) { $avhide = $oldavhide; }
	unless($avban) {
		my $url = strip_lead_trail_whitespace($in{avurl});
		my $nc = quotemeta($vars_config{NonCGIURL});
		$url =~ s!^$nc/+?!!;
		$url =~ s!^/+!/!;
		if($url && !check_html_boolean($url)) {
			if($url !~ m!https?://!) {
				$avatar_url = $url if -e "$vars_config{NonCGIPath}/$url";
			} elsif($url =~ m!https?://!) {
				# We intentionally do NOT perform the same uberfiltering on
				# custom URLs via the control panel.  Admins can usually
				# be trusted, after all.
				$avatar_url = $url; # if &avatar_remote_url_filter($url);
			} # end if
		} # end if
	} # end if

	# update registration file
	$user_profile[3]  = qq!$in{homepage}!;
	$user_profile[5]  = qq!$in{occupation}!;
	$user_profile[6]  = qq!$in{location}!;
	$user_profile[9]  = qq!$in{interests}!;
	$user_profile[11] = qq!$in{EmailView}!;
	$user_profile[12] = qq!$sig_html!;
	$user_profile[13] = qq!$in{icq}!;
	$user_profile[14] = qq!$in{AllowMassMail}!;
	$user_profile[16] = qq!$in{customfield1}!;
	$user_profile[17] = qq!$in{customfield2}!;
	$user_profile[18] = qq!$in{customfield3}!;
	$user_profile[19] = qq!$in{customfield4}!;
	$user_profile[20] = qq!$in{picture}!;
	$user_profile[21] = qq!$in{DaysPrune}!;
	$user_profile[22] = qq!$in{aim}!;
	$user_profile[23] = qq!$public_name|^|$admin_number|^|$GotTime{HyphenDate}!;
	$user_profile[24] = qq!$in{lock_profile}!;
	$user_profile[25] = qq!$in{user_ratings}!;
	$user_profile[27] = qq!$in{private_message}!;
	$user_profile[28] = qq!$in{private_message_notify}!;
	$user_profile[29] = qq!$in{allow_pm}!;
	$user_profile[31] = qq!$grant_user_title!;
	$user_profile[34] = qq!$pntf_hidden!;
	$user_profile[36] = qq!$poll_permission!;
	$user_profile[37] = qq!$avatar_url!;
	$user_profile[38] = qq!$avlock|$avban|$avhide!;

	&WriteMemberProfile($in{u}, @user_profile);

	# clear cache
	&ClearForumTopicsCache;

	&AppendAdminLog($username, $status, "Edited Profile For $user_profile[0] ($user_profile[8])", "Succeeded", "");


	# onscreen confirm
	&cp_confirm("Profile Updated", "The member's profile has been updated.", "View Profile", "$vars_config{CGIURL}/cp.cgi?ubb=get_profile_for_admin&u=$in{u}");
	exit(0);

}    # end edit_profile

sub new_members {
	local (@new_members, $total_members, @user_profile, $match, $j, $un, $current, $more, $previous);

	# need to access user titles
	&RequireVars("$vars_config{VariablesPath}/vars_misc.cgi");

	# grab members file
	@new_members = reverse(&GetMembersListAsArray);

	# total member count
	$total_members = @new_members;

	# truncate list, if necessary (only want last 50)
	if ($total_members > 50) { @new_members = @new_members[0 .. 49]; }

	&AppendAdminLog($username, $status, "Viewed New Member List", "Succeeded", "");


	$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=user_settings">$vars_wordlets_cp{search_users_header}</A> &gt;&gt; $vars_wordlets_cp{new_members}%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_new_members");
	&CPBottom;

}    # end new_members

sub reg_moderation {
	local (@the_q, @total_q, $alt_color, $q_count, $match, $deleted);
	undef($alt_color);
	undef($deleted);

	# grab the queue
	@total_q = &OpenFileAsArray("$vars_config{MembersPath}/moderation_q.cgi");

	my %q_dupes;
	my $total = 0;
	# make sure all profiles are still valid
	foreach (@total_q) {
		chomp($_);
		$_ = &strip_lead_trail_space($_);
		next unless $_;
		if (-s "$vars_config{MembersPath}/$_.cgi") {
			#push (@the_q, $_);
			$q_dupes{$_}++;
			$total++;
		} else {
			$deleted = 'true';
		}
	}
	# make sure we have only one entry for each number
	@the_q = sort keys %q_dupes;

	# if any were not valid- republish queue
	if ($deleted eq 'true') {

		# print updated_q
		&WriteFileAsArray("$vars_config{MembersPath}/moderation_q.cgi", @the_q);
	}


	# total in the queue
	$q_count = $total;

	# limit to no more than 50 matches per page

	if (($in{start_point} eq '') || ($in{start_point} == 0)) {

		if ($q_count <= 50) {
			$current  = '';
			$more     = '';
			$previous = '';
		} else {

			@the_q    = @the_q[0 .. 49];
			$more     = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=reg_moderation&start_point=50">&gt;&gt;</A>!;
			$previous = "";
			$current  = "$vars_wordlets_cp{additional_members}";
		}

	} else {

		# make sure startpoint input is a number!
		unless ($in{start_point} >= 0) {
			&StandardHTML("$vars_wordlets_err{start_point_number}");
		}

		my $end_point = $in{start_point} + 49;
		my $back      = $in{start_point} - 50;

		if ($q_count <= ($end_point + 1)) {
			$end_point = $q_count - 1;
			$more      = '';
			$previous  = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=reg_moderation&start_point=$back">&lt;&lt;</A>!;

		} else {

			my $next = $in{start_point} + 50;
			$more     = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=reg_moderation&start_point=$next">&gt;&gt;</A>!;
			$previous = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=reg_moderation&start_point=$back">&lt;&lt;</A>!;

		}

		@the_q   = @the_q[$in{start_point} .. $end_point];
		$current = "$vars_wordlets_cp{additional_members}";
	}

	&AppendAdminLog($username, $status, "Viewed Moderation Queue", "Succeeded", "");


	$Hiddens    = qq!\n<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="update_q">\n!;
	$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=user_settings">$vars_wordlets_cp{search_users_header}</A> &gt;&gt; $vars_wordlets_cp{registration_q}%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_registration_q");
	&CPBottom;

}    # end reg_moderation


sub update_q {
	local ($attached, $key, $j, %queue, $un, @the_q, @this_profile, $perms, $explicit, $remove, $sendto, $subject, $from, $html_body, @updated_q, $message, $HTMLMessage, $last_approved);
	local (*FILE);

	&RequireVars("$vars_config{VariablesPath}/vars_email.cgi");
	&RequireVars("$vars_config{VariablesPath}/vars_registration.cgi");
	&RequireVars("$vars_config{VariablesPath}/vars_display.cgi");
	&RequireVars("$vars_config{VariablesPath}/vars_template_match.cgi");
	&LoadTemplate("public_common");

	undef(%queue);

	# set email template
	%vars_style = &LoadStyleTemplate("email");

	&set_page_elements;

	# assemble queue action list
	foreach $key (keys %in) {
		if ($key =~ /^Q/) {
			($j, $un) = split (/:/, $key);
			unless ($in{$key} eq 'K') {
				$queue{$un} = $in{$key};
			}
		}
	}    # end %in loop


	# update member files
	QMAN: foreach $key (keys %queue) {
		undef(%vars_wordlets_email);
		undef($message);
		undef($HTMLMessage);
		@this_profile = &OpenProfile($key);

		if ($queue{$key} eq 'A') {
			$last_approved = $key;
			($perms, $explicit) = split ("&", $this_profile[4]);
			$perms .= "Write";
			$this_profile[4]  = ($perms . "&" . $explicit);
			$this_profile[26] = '';
			&WriteMemberProfile($key, @this_profile);
		} elsif ($queue{$key} eq 'D') {
			($perms, $explicit) = split ("&", $this_profile[4]);
			$perms =~ s/Write//g;
			$this_profile[4]  = ($perms . "&" . $explicit);
			$this_profile[26] = '';
			&WriteMemberProfile($key, @this_profile);
		}    # only need to update changed members

		# send email to registrant!

		if ($vars_email{UseEmail} eq 'ON') {

			$attached = "Members notified by email.  The registration email address will receive copies of the approval / decline mails.";

			&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");

			$sendto = "$this_profile[2]";
			chomp($sendto);

			#make sure email is valid format:
			if (($sendto =~ m/\s/) || ($sendto !~ /\S+\@\S+\.\S+/) || ($sendto =~ /^\./) || ($sendto =~ /\.$/) || ($sendto =~ /\.\@/) || ($sendto =~ /\@\./) || ($sendto =~ /;/)) {
				next QMAN;
			}

			$from = "$vars_registration{RegsAdminEmail}";

			if ($vars_registration{RegsAdminEmail} eq '') {
				$from = $vars_display{BBName};
			}

			$subject = "$vars_wordlets_email{mod_queue_decision} $vars_config{BBName}";

			do "$vars_config{VariablesPath}/vars_wordlets_email.cgi";


			my $s = &EmailWordletFixer;
			eval($s);
			if(defined &EmailWordletFiller) {
				%vars_wordlets_email = &EmailWordletFiller();
			} else {
				&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
			} # end if


			$subject = "$vars_wordlets_email{mod_queue_decision} $vars_config{BBName}";

			if ($queue{$key} eq 'A') {

				$message = "$vars_wordlets_email{mod_queue_approve}";

				$html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{mod_queue_approve_html}" . qq!</FONT>!;

			} else {

				$message = "$vars_wordlets_email{mod_queue_decline}";

				$html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$vars_wordlets_email{mod_queue_decline_html}" . qq!</FONT>!;

			}


			# is HTML format to be sent?
			if ($vars_email{email_format} ne 'ascii') {
				$HTMLMessage = "$EmailHeader $html_body $Footer";
			} else {
				$HTMLMessage = '';
			}

			# in case only HTML format is to be sent:
			if ($vars_email{email_format} eq 'html') {
				$message = '';
			}

			my $bcc_if = "";
			if($vars_registration{OnRegsNotifyAdmin} eq "ON") {
				$bcc_if = $from;
			} # end if

			&ubb_mail_tng({
				'EmailTo' => $sendto,
				'EmailFrom' => $from,
				'EmailReplyTo' => $from,
				'BCCList' => $bcc_if,
				'Subject' => $subject,
				'TextMessage' => $message,
				'HTMLMessage' => $HTMLMessage,
				'CCList' => undef,
			});


		} else {
			$attached = qq(Note: Email functions are off.  The approved and declined users were NOT mailed.);
		}    # if email is activated



	}    # end loop through the queue

	# grab queue file
	@the_q = &OpenFileAsArray("$vars_config{MembersPath}/moderation_q.cgi");

	foreach $j (@the_q) {
		chomp($j);
		undef($remove);

		if(!exists $queue{$j}) {
			push(@updated_q, $j);
		} # end if
	}

	# print last_approved file
	if ($last_approved ne '') {
		&WriteFileAsString("$vars_config{MembersPath}/last_approved.cgi", "$last_approved\n");

		&ClearSummaryCache;
	}

	# print updated_q
	&WriteFileAsArray("$vars_config{MembersPath}/moderation_q.cgi", @updated_q);

	&AppendAdminLog($username, $status, "Updated Moderation Queue", "Succeeded", "");


	# onscreen display
	&cp_confirm("Registration Queue Updated!", $attached);
	exit(0);
}    # end update_q sr



sub search_members2 {

	#part one
	local (%memberslist, %emailslist, %searchparams, %params, @memlist, $loops, $loopcount, $memcount, $left, $matches);

	#&clean_search_files;

	$matches = 0;

	my $beforetime = time();

	$| = 1;

	&ParseSearchParams;    #get %searchparams and %params

	# Go straight to the profile if they're just searching for one number
	if(($searchparams{'skipprocess'} == 1) && ($in{user_number} =~ m/^\d+$/) && (!$searchparams{'dontsearch'})) {
		$in{u} = sprintf("%08d", $in{user_number});
		&get_profile_for_admin;
		exit;
	} # end if

	my $inline;

	%memberslist = &GetMemberListAsHash;

	if ($searchparams{'dontsearch'}) {

		$divisor  = $in{'refresher'};
		@memlist  = sort keys %memberslist;
		$memcount = scalar(@memlist);
		$loops    = $memcount / $divisor;

		my $right;
		($left, $right) = split (/\./, $loops);
		$left++;

		my $message = "<b>1</b> refresh remaining.";

		$search_file_name = $GotTime{SearchJulian};

		$loopcount = 0;

		&SaveSearchParams($search_file_name);

		$in{"record"} = $search_file_name;
		&show_user_search_results;

#		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=show_user_search_results&record=$search_file_name&refresher=$divisor",
#		"Search complete.  Please standby while we compile the search results.",
#		"Searching Members", "Finishing Search...");

	}    #endif


	#if we have a user name
	if ($searchparams{'user'} ne '') {
		foreach my $item (keys %memberslist) {
			if ($memberslist{$item} !~ m/$searchparams{'user'}/gi) {
				delete $memberslist{$item};
			}
		}
	}

	#here's where things get tricky - emailfile is HUGE, so only load it if we need to.
	if ($searchparams{'email'} ne '') {
		%emailslist = &GetEmailListAsHash;
		foreach my $item (keys %emailslist) {
			if ($emailslist{$item} !~ m/$searchparams{'email'}/gi) {
				delete $memberslist{$item};
				delete $emailslist{$item};
			}
		}
	}

	#%memberslist now contains all users who have matched so far.
	#print "Total: ", scalar(keys %memberslist), "\n\n";# my $junk =<STDIN>;

	#Save the members list here and refresh.
	#It will then be picked up so the member files can be parsed.
	#If none of the other member fields were searched, the member files don't need to
	#be parsed, and the results are displayed instaed.
	my $divisor = $in{'refresher'};    #X at a time

	@memlist  = sort keys %memberslist;
	$memcount = scalar(@memlist);
	$loops    = $memcount / $divisor;

	my $right;
	($left, $right) = split (/\./, $loops);
	$left++;
	my $message;
	if ($loops > 1) {
		my $remaining = $left;
		$remaining++ unless $searchparams{'skipprocess'};

		$message = "<b>$remaining</b> refreshes remaining.";
	} else {

		$message = "<b>2</b> refreshes remaining." unless $searchparams{'skipprocess'};
		$message = "<b>1</b> refresh remaining." if $searchparams{'skipprocess'};
	}

	$search_file_name = $GotTime{SearchJulian};

	$loopcount = 0;

	&SaveSearchParams($search_file_name);

	if ($searchparams{'skipprocess'} != 1) {
		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=continue_user_search&record=$search_file_name&refresher=$in{'refresher'}",
		"Please standby while we continue the search.  $message",
		"Searching Members", "Continuing Search...");
	} else {
		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=show_user_search_results&record=$search_file_name&refresher=$divisor",
		"Search complete.  Please standby while we compile the search results.",
		"Searching Members", "Finishing Search...");
	}


	exit(0);


}    #end search_members2



sub ParseSearchParams {

	%params = (
		'canwrite'  => '',    #has write permissions
		'lpostmath' => '',
		'regmath'   => '',
		'bdaymath'  => '',
	);


	%searchparams = (
		'skipprocess' => "",       #don't search for 'nothing'
		'permiss'     => "",       #search permissions
		'useregexes'  => "0",      #if 1, quotemetas searchparms, which disabled perl metacharacters - user can not toggle from the interface - dangerous
		'sortresults' => "num",    #shows results by either name or num - user can not toggle from the interface - future feature
	);

	$searchparams{'dname'} = $in{'displayname'};

	if ($in{'regmath'} ne "None") {
		if (($in{regdate_year} =~ m/^\d{4}$/) && ($in{regdate_month} =~ m/^\d{1,2}$/) && ($in{regdate_day} =~ m/^\d{1,2}$/)) {
			$searchparams{'regdate'} = sprintf("%04d", $in{regdate_year})
					 . sprintf("%02d", $in{regdate_month})
					 . sprintf("%02d", $in{regdate_day});
		} # end unless
	} # end if

	if ($in{'lpostmath'} ne "None") {
		if (($in{lastpost_year} =~ m/^\d{4}$/) && ($in{lastpost_month} =~ m/^\d{1,2}$/) && ($in{lastpost_day} =~ m/^\d{1,2}$/)) {
			$searchparams{'lastpost'} = sprintf("%04d", $in{lastpost_year})
					 . sprintf("%02d", $in{lastpost_month})
					 . sprintf("%02d", $in{lastpost_day});
		} # end unless
	} # end if

	if(!exists $in{'bday_null'}) {
		if ($in{'bdaymath'} ne "None") {
			if (($in{bday_year} =~ m/^\d{4}$/) && ($in{bday_month} =~ m/^\d{1,2}$/) && ($in{bday_day} =~ m/^\d{1,2}$/)) {
				$searchparams{'bday'} = sprintf("%04d", $in{bday_year})
					 	. sprintf("%02d", $in{bday_month})
					 	. sprintf("%02d", $in{bday_day});
			} # end unless
		} # end if
	} # end if

	$searchparams{'number'}     = $in{'user_number'};
	$searchparams{'user'}       = $in{'login_name'};
	$searchparams{'email'}      = $in{'email'};
	$searchparams{'pemail'}     = $in{'pemail'};
	$searchparams{'posts'}      = $in{'num_posts'};
	$searchparams{'lpostip'}    = $in{'lpostip'};
	$searchparams{'regip'}      = $in{'regip'};
	$searchparams{'nobday'}     = $in{'bday_null'};
	$searchparams{'currentposts'} = $in{'currentposts'};
	$searchparams{'status'}     = '' if ($in{'user_status'} eq "None");
	$searchparams{'status'}     = 'Administrator' if ($in{'user_status'} eq "Admin");
	$searchparams{'status'}     = 'Moderator' if ($in{'user_status'} eq "Mod");
	$searchparams{'dontsearch'} = $in{'ViewEntire'} if $in{'ViewEntire'};

	$params{'privforum'} = '' if ($in{'private_forum'} eq "None");
	$params{'privforum'} = $in{'private_forum'} if ($in{'private_forum'} =~ m/^\d\d*$/);
	$params{'COPPA'}     = 'YES' if ($in{'user_status'} eq "COPPA");
	$params{'postmath'}  = $in{'postsmath'};
	$params{'canwrite'}  = $in{'canpost'}   unless $in{'canpost'} eq "None";
	$params{'regmath'}   = $in{'regmath'}   unless $in{'regmath'} eq "None";
	$params{'lpostmath'} = $in{'lpostmath'} unless $in{'lpostmath'} eq "None";
	if(!$searchparams{'nobday'}) {
		$params{'bdaymath'}  = $in{'bdaymath'}  unless $in{'bdaymath'} eq "None";
	}

	if (($params{'COPPA'}) || ($params{'privforum'}) || ($params{'canwrite'})) {    # || ($searchparams{''}) || ($searchparams{''}) || ($searchparams{''})) {
		$searchparams{'permiss'} = '1';
	}    #endif


	if (($params{'canwrite'} eq "") &&    #if none of the extended options (other than email)
	    ($params{'privforum'} eq "") &&                                                                                                                                                                                     #are selected, just go straight to the results screen
	    ($searchparams{'posts'} eq "") && ($searchparams{'status'} eq "") &&
	    ($searchparams{'permiss'} eq "") && ($searchparams{'lastpost'} eq "") &&
	    ($searchparams{'dname'} eq "") && ($searchparams{'regdate'} eq "") &&
	    ($params{'bdaymath'} eq "") && ($searchparams{'regip'} eq "") &&
	    ($searchparams{'lpostip'} eq "") && ($searchparams{'pemail'} eq "") &&
	    ($searchparams{'nobday'} eq "") && ($searchparams{'currentposts'} !~ m/^(yes|no)$/)
		)
	{

		$searchparams{'skipprocess'} = 1; # if $searchparams{'number'} =~ m/^\d{1,}$/;
	}

	#Regexes are off by default and can NOT be toggled by the admin...
	#Too much funky stuff can happen with them on,
	#not to mention what would happen with email addresses...
	if ($searchparams{'useregexes'} != 1) {
		foreach (keys %searchparams) {
			chomp($searchparams{$_} = quotemeta(&strip_lead_trail_space($searchparams{$_})));
		}    #endforeach
	}    #endif

	foreach (keys %params) {
		chomp($params{$_} = quotemeta(&strip_lead_trail_space($params{$_})));
	}    #endforeach

}    #end ParseSearchParams


# Legacy routines predating FileHandle/FileHandler
sub GetMemberListAsHash { return %{&GetMembersListAsHashReversed(@_)}; }
sub GetEmailListAsHash { return %{&GetEmailsListAsHashReversed(@_)}; }


sub GetSearchParams {
	my $path = shift;

	my $cachedir = "$vars_config{'NonCGIPath'}/";
	$cachedir .= "cache-$vars_config{'cache_pw'}/ubb_files";

	my $spams = &OpenFileAsHash("$cachedir/user_search/$path-searchparams.cgi", "||");
	my $pams  = &OpenFileAsHash("$cachedir/user_search/$path-params.cgi",       "||");
	my $memz  = &OpenFileAsHash("$cachedir/user_search/$path-memberslist.cgi",  "||");

	%searchparams = %$spams;
	%params       = %$pams;
	%memberslist  = %$memz;

	@memlist = OpenFileAsArray("$cachedir/user_search/$path-memlist.cgi");
	foreach (@memlist) { chomp; }

	($loops, $loopcount, $memcount, $left, $matches) = &OpenFileAsArray("$cachedir/user_search/$path-data.cgi");
	chomp($loops);
	chomp($loopcount);
	chomp($memcount);
	chomp($left);
	chomp($matches);

}

sub SaveSearchParams {
	my $path = shift;

	#needs %searchparams %params @memlist $loops $loopcount $memcount
	#all of those are use vared.

	my $cachedir = "$vars_config{'NonCGIPath'}/";
	$cachedir .= "cache-$vars_config{'cache_pw'}/ubb_files";

	unless (&DirExists("$cachedir/user_search")) {
		mkdir("$cachedir/user_search", 0777) or die $!;
		chmod(0777, "$cachedir/user_search") or die $!;
	}

	&WriteFileAsHashKV("$cachedir/user_search/$path-searchparams.cgi", "||", \%searchparams);
	&WriteFileAsHashKV("$cachedir/user_search/$path-params.cgi",       "||", \%params);
	&WriteFileAsHashKV("$cachedir/user_search/$path-memberslist.cgi",  "||", \%memberslist);
	&WriteFileAsArray("$cachedir/user_search/$path-memlist.cgi", @memlist);
	&WriteFileAsString("$cachedir/user_search/$path-data.cgi",   "$loops\n$loopcount\n$memcount\n$left\n$matches\n");

}    #endsub



sub continue_user_search {
	local (%memberslist, %emailslist, %searchparams, %params, @memlist, $loops, $loopcount, $memcount, $matches);

	my $search_file_name = $in{'record'};
	$search_file_name =~ m/^[-\d]+$/ or die;

	&GetSearchParams($search_file_name);

	my $divisor = $in{'refresher'};    #X at a time

	my $from = ($loopcount * $divisor);
	my $to   = ((($loopcount + 1) * $divisor) - 1);
	$to = ($memcount - 1) if $to > $memcount;
	my @thismemlist = @memlist[$from .. $to];
	my $loopcount2  = $loopcount + 1;
	my $to2         = $to + 1;

	#now that we've gotten the list as small as it can be, start opening profiles
	CHECKER: foreach my $user (@thismemlist) {

#		print header;
#		print "<pre>$user\n";

#		print "USer number: $user <br />";
		my @profile = &OpenProfileForMemsearch($user);

		# @profile contains fields 0,4,7,8,10,15,31,33,34,35
		# username, Writeline, # of posts, status, regdate, displayname, lastpost, bdate, regip, pemail
		if ($searchparams{'status'} ne "") {	#print "1";
			my $returned = &SearchForStatus($profile[3]);
			&CheckReturn($returned, $user);
		}

		if ($searchparams{'permiss'} ne "") {	#print "2";
			next CHECKER unless exists $memberslist{$user};
			my $returned = &SearchForPermiss($profile[1]);
			&CheckReturn($returned, $user);
		}

		if ($searchparams{'posts'} ne "") {	#print "3";
			next CHECKER unless exists $memberslist{$user};
			my $returned = &SearchForPosts($profile[2]);
			&CheckReturn($returned, $user);
		}

		if ($searchparams{'regdate'} ne "") {	#print "4";
			next CHECKER unless exists $memberslist{$user};
			my $returned = &SearchForRegdate($profile[4]);
			&CheckReturn($returned, $user);
		}

		if ($searchparams{'dname'} ne "") {	#print "5";
			next CHECKER unless exists $memberslist{$user};
			my $returned = &SearchForDisplayName($profile[5]);
			&CheckReturn($returned, $user);
		}

		if ($searchparams{'lastpost'} ne "") {	#print "6";
			next CHECKER unless exists $memberslist{$user};
			my $returned = &SearchForLastPost($profile[6]);
			&CheckReturn($returned, $user);
		}

		if($searchparams{'nobday'} ne "") {	# print "7.5"
			next CHECKER unless exists $memberslist{$user};
			my $returned = ( ($profile[7] =~ m/^(\d{8})\|(yes|no)$/) ? 1 : 2);
			&CheckReturnFALSE($returned, $user);
		} elsif($searchparams{'bday'} ne "") {	#print "7";
			next CHECKER unless exists $memberslist{$user};
			my $returned = &SearchForBirthDate($profile[7]);
			&CheckReturn($returned, $user);
		}

		if ($searchparams{'regip'} ne "") {	#print "8";
			next CHECKER unless exists $memberslist{$user};
			my $returned = &SearchForIP($profile[8], $searchparams{'regip'});
			&CheckReturn($returned, $user);
		}

		if ($searchparams{'lpostip'} ne "") {	#print "9";
			next CHECKER unless exists $memberslist{$user};
			my @line = split(/\|/, $profile[6]);
			my $returned = &SearchForIP($line[4], $searchparams{'lpostip'});
			&CheckReturn($returned, $user);
		}

		if ($searchparams{'pemail'} ne "") {	#print "10";
			next CHECKER unless exists $memberslist{$user};
			my $returned = &SearchForEmail($profile[9]);
			&CheckReturn($returned, $user);
		}

		if ($searchparams{'currentposts'} ne "none") {
			next CHECKER unless exists $memberslist{$user};
			my $tf = &FileExists("$vars_config{MembersPath}/user_posts/$user.cgi");
			if($searchparams{'currentposts'} eq "yes") {
				if($tf) {
					&CheckReturn(1, $user);
				} else {
					&CheckReturn(2, $user);
				} # end if
			} elsif($searchparams{'currentposts'} eq "no") {
				if(!$tf) {
					&CheckReturn(1, $user);
				} else {
					&CheckReturn(2, $user);
				} # end if
			} else {
				&CheckReturn(1, $user);
			} # end if
		} # end if

		$matches++ if exists $memberslist{$user};
		# print "\n</pre>";
	}    #endforeach
	$loopcount++;

	&SaveSearchParams($search_file_name);



	if ($left > $loopcount) {
		$theurl = "$vars_config{CGIURL}/cp.cgi?ubb=continue_user_search&record=$search_file_name&continue=$loopcount&refresher=$divisor";
	} else {
		$theurl = "$vars_config{CGIURL}/cp.cgi?ubb=show_user_search_results&record=$search_file_name&refresher=$divisor";
	}

	my $remaining = $left - $loopcount2;
	$remaining++;

	my $string;

	$string = "We just searched members <b>$from</b> through <b>$to2</b> of <b>$memcount</b> in this search." . " So far, <b>$matches</b> matches have been found.<p>Please standby while we" . " continue the search.  <b>$remaining</b> refreshes remain.</p>"          if $remaining > 1;
	$string = "We just searched members <b>$from</b> through <b>$to2</b> of <b>$memcount</b> in this search." . " We found <b>$matches</b> matches.<p>Please standby while we" . " compile the search results." if $remaining == 1;

	&cp_transition($theurl, $string, "Searching Members", "Continuing Search...");

}    #end...



sub CheckReturn {
	my $results = shift;
	my $user    = shift;
	return unless exists $memberslist{$user};

	if ($results == 1) {    #match
		    #noop
	} elsif ($results == 2) {    #did not match
		delete $memberslist{$user};
		delete $emailslist{$user} if %emailslist;
	} else {    #unexpected result
		die "Got $results, expected 1 or 2 from $user!";
	}
	return;
}    #end CheckReturn

sub CheckReturnFALSE {
	# Does the opposite of CheckReturn - makes sure that the value is 2, not 1
	my $results = shift;
	my $user    = shift;
	return unless exists $memberslist{$user};

	if ($results == 2) {    #did not match (good)
		    #noop
	} elsif ($results == 1) {    #did match (bad)
		delete $memberslist{$user};
		delete $emailslist{$user} if %emailslist;
	} else {    #unexpected result
		die "Got $results, expected 1 or 2 from $user!";
	}
	return;
}    #end CheckReturnFALSE

sub OpenProfileForMemsearch {    #returns only a few fields, and does NOT cache the file!
	my $number = shift;
	my @profile = &OpenFileAsArray2("$vars_config{MembersPath}/$number.cgi");
	foreach (@profile) {chomp}
	return (@profile[0, 4, 7, 8, 10, 15, 30, 32, 33, 34]);
}

sub SearchForEmail {
	# Parental email, in particular
	my $field = shift;
	my $expected = $searchparams{'pemail'};
	my $match = 2;

	return 1 if($field =~ m/$searchparams{'pemail'}/);
	return $match;
}

sub SearchForStatus {
	my $field    = shift;
	my $expected = $searchparams{'status'};
	my $match    = 2;

	if ($field eq $expected) { $match = '1'; }
	elsif ($field ne $expected) { $match = '2'; }

	return $match;
}

sub SearchForIP {
	my $field = shift;
	my $what = shift;
	my $match = 2;

	# Don't match invalid IPs
	return $match unless $field =~ m/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
	return $match unless $what =~ m/^[\d\.\\]+$/;

	return 1 if $field =~ m/$what/;
	return $match;
}

sub SearchForPermiss {
	my $field = shift;
	my ($canwrite, $private) = split (/\&/, $field);
	if (!$canwrite) { $canwrite = $field; }
	my ($privateers, $COPPA, @privates);
	if ($private) {

		if ($private =~ m/COPPA/) {
			$COPPA = $private;
		} elsif ($private !~ m/COPPA/) {
			$privateers = $private;
		}
	}    #Aiiieee!

	if ($privateers) {
		@privates = split (/\,/, $privateers);
	}

	my $match = 1;    #2 == no match
	my $add   = 0;

	if ($params{'privforum'}) {
		$add++;
		PRIVCHECK: foreach my $one (@privates) {
			next PRIVCHECK if $one !~ m/\d/;
			if ($one == $params{'privforum'}) {
				$match += 1;
				last PRIVCHECK;
			}
		}
	}

	if ($params{'COPPA'}) {
		$add++;
		if ($COPPA) {    #need to do it this way, as we don't know if we have COPPA or not
			if ($COPPA =~ m/COPPA/) {
				$match += 1;
			} else {
				$match -= 1;
			}
		}
	}

	if ($params{'canwrite'} ne "None") {
		$add++;
		if ($params{'canwrite'} eq "NO") {
			if ($canwrite !~ m/Write/) {
				$match += 1;
			} else {
				$match -= 1;
			}
		} elsif ($params{'canwrite'} eq "YES") {

			if ($canwrite =~ m/Write/) {
				$match += 1;
			} else {
				$match -= 1;
			}
		}
	}

	if ($match >= $add) { $match = 1; }
	else { $match = 2; }
	return $match;
}


sub SearchForPosts {
	my $field = shift;
	if (!$field) { $field = 0; }
	if ($field !~ m/^\d+$/) { return 2; }
	my $match = 2;

	if ($params{'postmath'} eq "GT") {
		if ($field > $searchparams{'posts'}) {
			$match = 1;
		}
	} elsif ($params{'postmath'} eq "EQ") {

		if ($field == $searchparams{'posts'}) {
			$match = 1;
		}
	} elsif ($params{'postmath'} eq "LT") {
		if ($field < $searchparams{'posts'}) {
			$match = 1;
		}
	}

	return $match;
}


sub SearchForRegdate {
	my $field = shift;
	my $match = 2;
	if (!$field) { $field = "06-30-1998" }    #date of adding registred date to UBB profiles
	return $match if $field !~ m/^[\d\-]+$/;
	return $match if $field !~ m/^(\d\d)\-(\d\d)\-(\d\d\d\d)$/;
	$field = "$3$1$2";

	my $regdate = $searchparams{'regdate'};    #the regdate was already properly formatted

	$regdate =~ s/-//g;
	$field   =~ s/-//g;
	if ($params{'regmath'} eq "GT") {
		if ($field > $regdate) {
			$match = 1;
		}
	} elsif ($params{'regmath'} eq "EQ") {

		if ($field == $regdate) {
			$match = 1;
		}
	} elsif ($params{'regmath'} eq "LT") {
		if ($field < $regdate) {
			$match = 1;
		}
	} else {
		return 2;
	}    #no math == no search

	return $match;
}


sub SearchForDisplayName {
	my $field = shift;
	my $match = 2;
	return $match unless $field;    #no display name == nothing to search

	if ($field =~ m/$searchparams{'dname'}/gi) {
		$match = 1;
	}

	return $match;
}

sub SearchForBirthDate {
	my $field = shift;
	my $match = 2;
	$field =~ s/\|.+$//;

	#die;

	my $lastdate = $searchparams{'bday'};    #the birth date was already properly formatted

	return $match if !$field;                    #no field means no bdate

	$lastdate =~ s/-//g;
	$field    =~ s/-//g;
	if ($params{'bdaymath'} eq "GT") {
		if ($field > $lastdate) {
			$match = 1;
		}
	} elsif ($params{'bdaymath'} eq "EQ") {

		if ($field == $lastdate) {
			$match = 1;
		}
	} elsif ($params{'bdaymath'} eq "LT") {
		if ($field < $lastdate) {
			$match = 1;
		}
	} else {
		return 2;
	}    #no math == no search

	return $match;
}

sub SearchForLastPost {
	my $field = shift;
	my $match = 2;

	#die;

	my $lastdate = $searchparams{'lastpost'};    #the lastdate was already properly formatted

	return $match if !$field;                    #no field means no posts

	$lastdate =~ s/-//g;
	$field    =~ s/-//g;
	if ($params{'lpostmath'} eq "GT") {
		if ($field > $lastdate) {
			$match = 1;
		}
	} elsif ($params{'lpostmath'} eq "EQ") {

		if ($field == $lastdate) {
			$match = 1;
		}
	} elsif ($params{'lpostmath'} eq "LT") {
		if ($field < $lastdate) {
			$match = 1;
		}
	} else {
		return 2;
	}    #no math == no search

	return $match;
}



sub show_user_search_results {
	local (%memberslist, %emailslist, %searchparams, %params, @memlist, $loops, $loopcount, $memcount, $profile_index, $alt_color, $match, @matches, @user_profile, $title, $admin_yes, $admin_no, $write_yes, $write_no, $start, $end, $total, @the_members, $one, $j, $member, $profile_opened, $bad, @search_file, $clean_name, $arraycount, $search_count, $search_email, $member_number, @searchfile, $line, @sort_mems, $thenum, $thename, $theemail, @the_emails, @sort_emails, $this_email_row, $this_email, $status_type, $more, $previous, $current, $search_record, $sp, $ep);

	#goodness, Ted!

	my $search_file_name = $in{'record'};
	$search_file_name =~ m/^[-\d]+$/ or die;
	$search_record = $search_file_name;

	&GetSearchParams($search_file_name);

	if ($searchparams{'sortresults'} eq "num") {
		foreach (sort keys %memberslist) {
			push (@matches, $_);
		}
	} elsif ($searchparams{'sortresults'} eq "name") {
		my %ml2;

		foreach (keys %memberslist) {
			$ml2{$memberslist{$_}} = $_;
		}
		foreach (sort keys %ml2) {
			push (@matches, $ml2{$_});
		}
	} else {
		die "Invalid search result sort method '$searchparams{sortresults}'";
	}

	$search_count = @matches;

	my $page_limit  = 50;
	my $array_limit = $page_limit - 1;

	$current = "$vars_wordlets_cp{additional_members}";


	if (($in{start_point} eq '') || ($in{start_point} == 0)) {

		if ($search_count <= $page_limit) {
			$current  = '';
			$more     = '';
			$previous = '';
			$ep       = $search_count;
			if ($ep > 0) { $sp = '1' }
			else { $sp = '0' }
		} else {
			@matches  = @matches[0 .. $array_limit];
			$more     = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=show_user_search_results&start_point=$page_limit&record=$search_record">&#187;&#187;</A>!;
			$previous = '';
			$sp       = '1';
			$ep       = $page_limit;
		}

	} else {

		# make sure startpoint input is a number!
		unless (($in{start_point} >= 0) && ($in{start_point} =~ m/^\d*$/)) {
			StandardHTML("$vars_wordlets_err{start_point_number}");
		}

		my $end_point = $in{start_point} + $array_limit;
		my $back      = $in{start_point} - $page_limit;

		if ($search_count <= ($end_point + 1)) {
			$end_point = $search_count - 1;
			$more      = "";
			$previous  = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=show_user_search_results&record=$search_record&start_point=$back">&#171;&#171;</A>!;
			$sp        = $in{start_point} + 1;
			$ep        = $search_count;

		} else {

			my $next = $in{start_point} + $page_limit;
			$more     = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=show_user_search_results&record=$search_record&start_point=$next">&#187;&#187;</A>!;
			$previous = qq!<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=show_user_search_results&record=$search_record&start_point=$back">&#171;&#171;</A>!;

			$sp = $in{start_point} + 1;
			$ep = $sp + $array_limit;
		}

		@matches = @matches[$in{start_point} .. $end_point];

	}

	my $dumpedstats;
	foreach (sort keys %searchparams) {
		$dumpedstats .= "$_ -> '$searchparams{$_}'\; ";
	}

	foreach (sort keys %params) {
		$dumpedstats .= "$_ -> '$params{$_}'\; ";
	}
	$dumpedstats .= "  Search Results from $search_file_name.";

	&AppendAdminLog($username, $status, "Viewed Member Search Results: $dumpedstats", "Succeeded", "");


	if(scalar(@matches) < 1) {
		&StandardHTML($vars_wordlets_cp{user_search_no_results});
	}

	$Hiddens = qq!
	<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="update_members">
	!;
	$CurrentTab = qq%<A HREF="$vars_config{CGIURL}/cp.cgi?ubb=user_settings">$vars_wordlets_cp{search_users_header}</A>%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_user_search_results");
	&CPBottom;
	exit(0);

}



sub recent_user_posts_for_admin {
	local (@user_profile, $count, $user_public_name, @posts, @rev_posts, $total, $f, $t, $r, @this_topic, @stat_line, @this_forum, $counter, %ExactPath);

	# get user profile
	# get requested profile
	@user_profile = &OpenProfile($in{u});
	my $count = 0;
	foreach $chompee (@user_profile) {
		chomp($user_profile[$count]);
		$count++;
	}

	# set public_name
	if ($user_profile[15] eq '') {
		$user_public_name = $user_profile[0];
	} else {
		$user_public_name = $user_profile[15];
	}

	# grab user posts record
	if (&FileExists("$vars_config{MembersPath}/user_posts/$in{u}.cgi")) {
		@posts = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$in{u}.cgi");
	}

	# sort newest to oldest
	@rev_posts = reverse sort (@posts);

	# limit to last 50 posts
	$total = @rev_posts;

	$counter = 0;

	$CurrentTab = qq%User Posts: $user_public_name (number $in{u})%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_user_posts");
	&CPBottom;

	exit;

}    # end recent user posts


sub user_titles_intro {
	# just bootstrap the template
	&LoadTemplate("cp_user_titles");
	$Hiddens = qq!<input type="hidden" name="ubb" value="user_titles_update" />!;
	$CurrentTab = qq%User Custom Titles%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&user_titles_html;
	&CPBottom;
	exit;
} # end user_title_intro

sub user_titles_update {

	my @ValidateArray = qw( ModeratorTitle MemberMinimum UnregTitle AdminTitle );
	&Validate(@ValidateArray);

	my @mins = sort user_title_key_sort grep(/^minimum::/, keys %in);

	foreach my $min (@mins) {
		my($l, $r) = split(/::/, $min);

		$in{$min} = &strip_lead_trail_space($in{$min});
		$in{"title::$r"} = &strip_lead_trail_space($in{"title::$r"});

		delete $in{$min} if(($in{$min} eq '') || ($in{"title::$r"} eq ''));
		delete $in{"title::$r"} if(($in{$min} eq '') || ($in{"title::$r"} eq ''));
	} # end foreach

	my @ttls = sort user_title_key_sort grep(/^title::/, keys %in);

	if(scalar(@ttls) < 2) {
		&StandardHTML("You must define at least two levels.");
	} # end if

	my $title_hash = {};
	foreach my $title (@ttls) {
		my($l, $r) = split(/::/, $title);
		$title_hash->{$in{"minimum::$r"}} = $in{$title};
	} # end foreach

	if(!exists $title_hash->{"0"}) {
		&StandardHTML("One member level must start at zero posts.");
	} # end if

	my $dex = 0;
	my @titles = sort {$a <=> $b} keys %{$title_hash};
	my $total = scalar(@titles);
	foreach my $num (@titles) {
		last if $dex == $total;
		if($num > $in{MemberMinimum}) {
			$dex--;
			last;
		} elsif($num == $in{MemberMinimum}) {
			last;
		} # end if
		$dex++;
	} # end foreach
	my $member_title = $title_hash->{$titles[$dex]};

	my %vars_misc_new = (
		%vars_misc,
		AdminTitle => &strip_lead_trail_space($in{AdminTitle}),
		ModeratorTitle => &strip_lead_trail_space($in{ModeratorTitle}),
		MemberMinimum => &strip_lead_trail_space($in{MemberMinimum}),
		JrMemberTitle => $title_hash->{"0"},
		MemberTitle => $member_title,
		custom_titles => $title_hash,
	);

	$vars_wordlets{unregistered} = &strip_lead_trail_space($in{UnregTitle});

	&WriteHashToFile("$vars_config{VariablesPath}/vars_misc.cgi", "vars_misc", \%vars_misc_new);
	%vars_misc = %vars_misc_new;

	&WriteHashToFile("$vars_config{VariablesPath}/vars_wordlets.cgi", "vars_wordlets", \%vars_wordlets);

#	use Data::Dumper;
#	die Dumper(\@titles);
	&cp_confirm("User Titles Updated");
} # end user_titles_update

sub user_title_key_sort {
	my($j, $m) = split(/::/, $a);
	my($k, $n) = split(/::/, $b);
	return $m <=> $n;
} # end sub


# Danger- do not remove the following line!
1;
# $Id: cp_users.cgi,v 1.19 2002/04/30 18:19:05 cvscapps Exp $
