# UBB.classic user groups bits

sub group_edit_add {
	print header;

	&GetForumRecord(0); # load vars_forums

	my @Validate = qw(vote_perm create_perm group act group_name);
	&Validate(@Verify);

	my @cl = grep(/^create_group_/, keys(%in));
	my @vl = grep(/^vote_group_/, keys(%in));
	my(@createlist, @votelist);

	if(@cl) {
		foreach my $one (@cl) {
			next unless $one =~ m/^create_group_(\w+)$/;
			push(@createlist, $1);
		} # end foreach
	} # end if
	if(@vl) {
		foreach my $one (@vl) {
			next unless $one =~ m/^vote_group_(\w+)$/;
			push(@votelist, $1);
		} # end foreach
	} # end if

	my $replacement = {
		perms => {
			create => $in{create_perm},
			vote => $in{vote_perm}
		},
		authlists => {
			create => { u => [], l => [@createlist] },
			vote => { u => [], l => [@votelist] }
		},
		defaultaction => "allow",
		name => $in{group_name}
	};

	my $num = 0;
	if($in{group} !~ m/^pollgroup_(\d+)$/) {
		ITER: foreach my $n (1 .. 100) {
			if(!exists $vars_groups->{GROUPS}->{polling}->{"pollgroup_$n"}) {
				$num = $n;
				last ITER;
			} # end
		} # end foreach
	} else {
		$num = $1;
	} # end if

	# I'm a bad boy for violating encapsulation...
	if($in{deleter} eq "true") {
		# Now undo all the work we just did :)
		delete($vars_groups->{GROUPS}->{polling}->{"pollgroup_$num"});
	} else {
		$vars_groups->{GROUPS}->{polling}->{"pollgroup_$num"} = $replacement;
	} # end if
	$vars_groups->write_groups;

	# Okay, time to update vars_forums...

	my @list_of_forums = split(/\,/, $in{forumselection});

	my @new_vars_forums;
	foreach my $f (sort {$a <=> $b} keys %vars_forums) {
		my $changed = 0;
		if($vars_forums{$f}->[17] == $num) {
			# clear it first
			$vars_forums{$f}->[17] = "";
			$changed++;
		} # end if

		if($in{deleter} ne "true") {
			# Dont' reassign if we're deleting this group
			my $is_selected = 0;
			foreach my $one (@list_of_forums) {
				if($f == $one) { $is_selected = 1; last; }
			} # end foreach

			if($is_selected) {
				$changed++;
				$vars_forums{$f}->[17] = $num
			} # end if

		} # end if deleter

		if($changed) {
			$exact_path = &SetExactPath($f);
			&ClearSingleForumTopicsCache($exact_path);
			&ClearSingleForumPageCache($exact_path, $f);
		} # end if

		push(@new_vars_forums, join("|^|", @{ $vars_forums{$f} }));
	} # end foreach

	&WriteFileAsArray("$vars_config{VariablesPath}/vars_forums.cgi", @new_vars_forums);

	&ClearSummaryCache;

	&cp_confirm("Group Settings Updated", undef, "Polling Settings", "$vars_config{CGIURL}/cp.cgi?ubb=vars_poll");
} # end group_edit_add

19 + 28 == 47;
# $Id: cp_user_groups.cgi,v 1.5 2002/04/18 22:27:17 cvscapps Exp $
