# Control panel - datafile containing upgrade data

sub c_u_d_GetNewWordlets {

#	local(%new_wordlets, %new_wordlets_cp, %new_wordlets_err, %new_wordlets_img, %new_wordlets_date);

	&RequireCode("$vars_config{CGIPath}/cp_new_wordlets.cgi");
	&c_n_w_GetNewWordlets;

	my %update;

	foreach my $thisk (sort keys %$new_wordlets) {
		$update{'primary'}->{$thisk} = $new_wordlets->{$thisk};
	} #endforeach

	foreach my $thisk (sort keys %$new_wordlets_cp) {
		$update{'cp'}->{$thisk} = $new_wordlets_cp->{$thisk};
	} #endforeach

	foreach my $thisk (sort keys %$new_wordlets_date) {
		$update{'date'}->{$thisk} = $new_wordlets_date->{$thisk};
	} #endforeach

	foreach my $thisk (sort keys %$new_wordlets_err) {
		$update{'err'}->{$thisk} = $new_wordlets_err->{$thisk};
	} #endforeach

	foreach my $thisk (sort keys %$new_wordlets_img) {
		$update{'img'}->{$thisk} = $new_wordlets_img->{$thisk};
	} #endforeach

	foreach my $thisk (sort keys %$new_wordlets_email) {
		$update{'email'}->{$thisk} = $new_wordlets_email->{$thisk};
	} #endforeach

	foreach my $thisk (sort keys %$new_wordlets_pntf) {
		$update{'pntf'}->{$thisk} = $new_wordlets_pntf->{$thisk};
	} #endforeach

	foreach my $thisk (sort keys %$new_wordlets_poll) {
		$update{'poll'}->{$thisk} = $new_wordlets_poll->{$thisk};
	} #endforeach

	return (\%update);
}    #endsub c_u_d_GetNewWordlets

sub c_u_d_6090_ForumSanityCheck {

	my %blank = ();

	my @foru = &OpenForumsFile;

	foreach $one (@foru) {
		my $forum = (split(/\|\^\|/, $one))[8];
		$exact_path = &SetExactPath($forum);

		if(!&DirExists("$vars_config{NonCGIPath}/Forum$forum")) {
			mkdir("$vars_config{NonCGIPath}/Forum$forum", SEVENSEVENSEVEN) or die "$forum: $!";
		}
		if(!&DirExists("$vars_config{NonCGIPath}/$exact_path")) {
			mkdir("$vars_config{NonCGIPath}/exact_path", SEVENSEVENSEVEN) or die "$forum: $!";
		}

		# if we just did a normal sanity check, there will be no .threads file - DON'T NUKE IT!
		if($_[0] ne 'after_sanity') {
			if(!&FileExists("$vars_config{NonCGIPath}/$exact_path/forum_$forum.threads")) {
				&WriteHashToFile("$vars_config{NonCGIPath}/$exact_path/forum_$forum.threads", "forum_topics", \%blank);
				&WriteHashToFile("$vars_config{NonCGIPath}/$exact_path/forum_thread_data_0000.cgi", "forum_thread_data", \%blank);
			} # end if
		} # end if
		if(!&FileExists("$vars_config{NonCGIPath}/$exact_path/index.html")) {
			&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/index.html", "&nbsp;");
		}
		#if(!-d "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/backups") {
		#	mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/backups", SEVENSEVENSEVEN);
		#}
		#if(!-d "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/backups/Forum$forum") {
		#	mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/backups/Forum$forum", SEVENSEVENSEVEN);
		#}
	} #end

	use File::Path;
	rmtree("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/backups")

} #end

sub c_u_d_6090_CheckForPhilippsAccelerator {
	if(&FileExists("$vars_config{VariablesPath}/vars_do_accel.cgi")) {
		# UBB Accelerator - courtesy Philipp Esselbach (philipp@ntcompatible.com)
		&Unlink("$vars_config{NonCGIPath}/vars_config.inc.php")
		&RequireCode("$vars_config{VariablesPath}/vars_display.cgi");
		&RequireCode("$vars_config{VariablesPath}/vars_misc.cgi");
		&RequireCode("$vars_config{CGIPath}/cp_ubbacc.cgi");
		&do_prepare;
	}
} # end c_u_d_6090_CheckForPhilippsAccelerator

sub c_u_d_6090_MakeLockDirectory {
	mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/lock", SEVENSEVENSEVEN);
	chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/lock");
} # end c_u_d_6090_MakeLockDirectory

sub c_u_d_6090_PrepareCustomGraemlins {
	&RequireVars("$vars_config{VariablesPath}/vars_wordlets_img.cgi");
	if (&FileExists("$vars_config{VariablesPath}/vars_graemlins.cgi")) {
		&RequireVars("$vars_config{VariablesPath}/vars_graemlins.cgi");
	}

	if ((!$vars_graemlins) || (($vars_graemlins{custgraems} == 0) && (exists $vars_wordlets_img{graemlin_smile}))) {

		$vars_graemlins = {
			'origs' => {
				'01_smile' => {
					'trigger' => ':)',
					'image'   => 'smile.gif',
					'text'    => $vars_wordlets_img{graemlin_smile},
				},
				'02_frown' => {
					'trigger' => ':(',
					'image'   => 'frown.gif',
					'text'    => $vars_wordlets_img{graemlin_frown},
				},
				'03_redface' => {
					'trigger' => ':o',
					'image'   => 'redface.gif',
					'text'    => $vars_wordlets_img{graemlin_embarrassed},
				},
				'04_biggrin' => {
					'trigger' => ':D',
					'image'   => 'biggrin.gif',
					'text'    => $vars_wordlets_img{graemlin_big_grin},
				},
				'05_wink' => {
					'trigger' => ';)',
					'image'   => 'wink.gif',
					'text'    => $vars_wordlets_img{graemlin_wink},
				},
				'06_tongue' => {
					'trigger' => ':p',
					'image'   => 'tongue.gif',
					'text'    => $vars_wordlets_img{graemlin_razz},
				},
				'07_cool' => {
					'trigger' => ':cool:',
					'image'   => 'cool.gif',
					'text'    => $vars_wordlets_img{graemlin_cool},
				},
				'08_rolleyes' => {
					'trigger' => ':rolleyes:',
					'image'   => 'rolleyes.gif',
					'text'    => $vars_wordlets_img{graemlin_roll_eyes},
				},
				'09_mad' => {
					'trigger' => ':mad:',
					'image'   => 'mad.gif',
					'text'    => $vars_wordlets_img{graemlin_mad},
				},
				'10_eek' => {
					'trigger' => ':eek:',
					'image'   => 'eek.gif',
					'text'    => $vars_wordlets_img{graemlin_eek},
				},
				'11_confused' => {
					'trigger' => ':confused:',
					'image'   => 'confused.gif',
					'text'    => $vars_wordlets_img{graemlin_confused},
				},
			},
			'custgraems' => '0',
			'graems'     => {},
		};

		foreach my $one (qw(graemlin_big_grin graemlin_confused graemlin_cool graemlin_eek graemlin_embarrassed graemlin_frown graemlin_mad graemlin_razz graemlin_roll_eyes graemlin_smile graemlin_wink)) {
			delete $vars_wordlets_img{$one};
		}

		&WriteHashToFile("$vars_config{VariablesPath}/vars_wordlets_img.cgi", "vars_wordlets_img", \%vars_wordlets_img);

		&RequireCode("$vars_config{CGIPath}/cp_graemlins.cgi");
		&c_g_WriteVarsGraemlins;

	}    #endif

	return;

}    #endsub c_u_d_6100_PrepareCustomGraemlins


sub c_u_d_6090_MakeUpgradeDataToFoolBrokenInitialSetup {
	my @foru = &OpenForumsFile;

	foreach $one (@foru) {
		my $forum = (split(/\|\^\|/, $one))[8];
		$exact_path = &SetExactPath($forum);

		&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/upgrade.txt", "Placeholder.\n");
		if(!&FileExists("$vars_config{NonCGIPath}/$exact_path/index.html")) {
			&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/index.html", "&nbsp;");
		}
		&WriteFileAsString("$vars_config{NonCGIPath}/$exact_path/forum_thread_data_0000.cgi", '%forum_thread_data = ( 0000 => {} );');
	} #end
} # end c_u_d_6090_MakeUpgradeDataToFoolBrokenInitialSetup

sub c_u_d_6190_MakeUserGroupFile {

my $s = q~
package UBB::SecurityGroups;
sub UBB::SecurityGroups::_load_groups {
	my $self = shift; $self->{GROUPS} = {
		polling => {
			pollgroup_1 => {
				name => "Default Group",
				defaultaction => 'allow',
				perms => {
					create => 'all',
					vote => 'all',
				},
				authlists => {
					create => {
						u => [],
						l => [],
					},
					vote => {
						u => [],
						l => [],
					},
				},
			},
		},
		defined_groups => {
		},
		forums => {
		},
	} # end
} # end sub
1;
~;

	my $dn = "$vars_config{MembersPath}/user_groups";
	mkdir($dn, SEVENSEVENSEVEN);
	chmod(SEVENSEVENSEVEN, $dn);

	if(!&FileExists("$dn/groups.cgi")) {
		&WriteFileAsString("$dn/groups.cgi", $s);
	} # end if

	chmod(SEVENSEVENSEVEN, "$dn/groups.cgi");

} # end c_u_d_6190_MakeUserGroupFile

sub c_u_d_6290_CheckAvatarDir {

	if(!&DirExists("$vars_config{NonCGIPath}/Avatars")) {
		mkdir("$vars_config{NonCGIPath}/Avatars", SEVENSEVENSEVEN);
	} # end if
	if(!&DirExists("$vars_config{NonCGIPath}/Avatars")) {
		&StandardHTML("I could not create the Avatars directory within the NonCGI directory.  Please check file permissions on the NonCGI directory.");
	} # end if

	chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/Avatars");
	chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/Avatars/ot_avatars_lib.js");
	&Unlink("$vars_config{NonCGIPath}/Avatars/ot_avatars_lib.js");
	&WriteFileAsString("$vars_config{NonCGIPath}/Avatars/index.html", "");
	&WriteFileAsString("$vars_config{NonCGIPath}/Avatars/ot_avatars_lib.js", q~
// OpenTopic(tm) Avatar Library
// Original by Michael Farris, Jonmark Weber, Brian Lenz
// Ported to UBB.classic(tm) by Charles Capps.

//  parse querystring, set up globals: query_params, AVATAR, start_with

parse_query_params(unescape(window.location.search.substring(1)));

	if (query_params.avatar_url){
		var AVATAR=query_params.avatar_url;
	}else {	var AVATAR='';
	}

	if (query_params.start_with != null){
		var start_with = query_params.start_with;
	} else {
		var start_with=1;
	}

function parse_query_params (querystring_string) { // parses querystring pairs and adds to query_params Obj

	query_params = new Object();// this will be global

	var query_pairs = querystring_string.split('&');
	for (var i=0;i<query_pairs.length; i++){
		name_value = query_pairs[i].split('=');
		query_params[name_value[0]] = name_value[1];
	}
	var mquery_pairs = querystring_string.split(';');
	for (var i=0;i<mquery_pairs.length; i++){
		name_value = mquery_pairs[i].split('=');
		query_params[name_value[0]] = name_value[1];
	}
}//end fn



function draw_table (is_cp) { // render table

avatar_extension = avatar_extension.replace('.',''); // strip the . out

html_output = "<table>";

image_number = (start_with*1);// force type to number

for (var i=0; i<avatar_columns*avatar_rows; i++) {
	if (i%avatar_columns==0 ){
		html_output += "\n<tr>\n";
	}

	if (image_number <= avatar_number){
		html_output += draw_td_cell(image_number);
		image_number++;
	}else { // finish out blank td cells to end of avatar grid as needed
		html_output += '<td>&nbsp;</td>';
	}

	if ((i+1)%avatar_columns==0){
		html_output += "</tr>\n";
	}
}

	html_output += "</table>\n";

	var calcval = (avatar_width + 16) * avatar_columns;

	html_output += '<table width="' + calcval + '"><tr><td class="ot_avatar_page" align="left">';// start table for prev next links

	if (start_with >1 ){
		var previous_start_with = (start_with-(avatar_columns*avatar_rows));
		if(previous_start_with < 1){
			previous_start_with = 1;
		}
		html_output += '<a href="javascript:avatar_display_next_page(' + previous_start_with + ', \'' + is_cp + '\');">' + avatar_label_previous + '</a>';
	} else {
		html_output += "&nbsp;";
	}
		html_output += "</td>\n<td class=\"ot_avatar_page\" align='right'>";


	if (image_number < avatar_number){
		html_output += '<a href="javascript:avatar_display_next_page(' + image_number + ', \'' + is_cp + '\')">' + avatar_label_next + '</a>';
	} else {
		html_output += "&nbsp;";
	}

	html_output += '</td></tr></table>';

return html_output;

}// end fn


function avatar_display_next_page (new_start_with, is_cp){
		var new_location = window.location.protocol + '//' + window.location.hostname + window.location.pathname + '?ubb=avatar_select;avatar_url=' + MM_findObj('selected_avatar').src +';start_with=' + new_start_with + is_cp;
		location.replace(new_location);
}// end fn




function draw_td_cell (avatar_count) {
 if (avatar_count < avatar_number){
    var td_html  = '<td class="ot_avatar_page">';
	td_html += '<a href="javascript:switch_avatar_img(' + avatar_count + ')">';
	td_html += '<img src="' + avatar_path + '/';
	td_html += avatar_list[avatar_count] + '"';
	td_html += ' height="' + avatar_height + '"';
	td_html += ' width="' + avatar_width + '" border="0"';
	td_html += ' class="borderimage">'
	td_html += '</a></td>' + "\n";
 } else {
     var td_html = '<td class="ot_avatar_page">&nbsp;</td>';
 }
return (td_html);
}// end fn

function switch_avatar_img (which_avatar){
	var avatar_image = MM_findObj('selected_avatar');
	avatar_image.src = (avatar_path + '/' + avatar_list[which_avatar]);
	MM_showHideLayers('avatar_status_msg','','hide');
}

function setdefaults() {
	alert("I can't be called.  Go away.");
	return false;

//	var avatar_image = MM_findObj('selected_avatar');
//
//	if(AVATAR.indexOf('http://') > -1){ // only load if it is an URL
//	 	avatar_image.src = AVATAR;
//	} else {
//		avatar_image.src = 'http://boards.infopop.net/infopop/blank.gif';
//			MM_showHideLayers('avatar_status_msg','','show');
//	}
//
//	for (var i=0; i<= document.images.length; i++) { // load custom URL to form if it exists
//		if ((avatar_image.src).indexOf(avatar_path) == -1)  { //
//			if ((document.images[i].src).indexOf('/infopop/blank.gif') < 0) { // load preview value if not the IP blank.gif
//				document.forms.avatar_select_form.custom_avatar.value = document.images[i].src;
//			}
//			return;
//		}
//	}// end for
}// end function

function show_avatar_status () {// change message if there is no avatar selected
	if(AVATAR.indexOf('http://') > -1){
	 	return(avatar_status);
	} else {
		return(avatar_status_none);
	}
}// end function


function changeparent () { // load image and src value into parent form
			var avatar_image = MM_findObj('selected_avatar');
			parent.opener.document.PROFILE.avurl.value = avatar_image.src;
			if (document.images){
				parent.opener.document.images['avimg'].src = avatar_image.src;
			}
			self.close();
}// end function

function noavatar () { // load image and src value into parent form
			parent.opener.document.PROFILE.avurl.value = "";
			if (document.images){
				parent.opener.document.images['avimg'].src = parent.opener.document.PROFILE.avurl_blank.value;
			}
			self.close();
}// end function




function MM_findObj (n, d) { //v4.01
  var p,i,x;  if(!d) d=document; if((p=n.indexOf("?"))>0&&parent.frames.length) {
    d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
  if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
  for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=MM_findObj(n,d.layers[i].document);
  if(!x && d.getElementById) x=d.getElementById(n); return x;
}

function MM_showHideLayers () { //v3.0
	return false;

  var i,p,v,obj,args=MM_showHideLayers.arguments;
  for (i=0; i<(args.length-2); i+=3) if ((obj=MM_findObj(args[i]))!=null) { v=args[i+2];
    if (obj.style) { obj=obj.style; v=(v=='show')?'visible':(v='hide')?'hidden':v; }
    obj.visibility=v; }
}
~);

	if(!&FileExists("$vars_config{NonCGIPath}/Avatars/ot_avatars_lib.js")) {
		&StandardHTML("I was unable to write the ot_avatars_lib.js file within the NonCGI/Avatars directory.  Please check permissions.");
	} # end if
} # end c_u_d_6290_CheckAvatarDir

sub c_u_d_AdditionalTasks {

	#will contain additional upgrade tasks and checks in the future
	&c_u_d_6090_PrepareCustomGraemlins;
	&c_u_d_6090_ForumSanityCheck(@_);
	&c_u_d_6090_CheckForPhilippsAccelerator;
	&c_u_d_6090_MakeLockDirectory;
	&c_u_d_6190_MakeUserGroupFile;
	&c_u_d_6290_CheckAvatarDir;
	if($_[0] eq 'initial') {
		&c_u_d_6090_MakeUpgradeDataToFoolBrokenInitialSetup;
	}
	return;
}    #endsub c_u_d_AdditionalTasks

1;   # must retutn 'true' for Perl - leave this line alone!
# $Id: cp_upgrade_data.cgi,v 1.10 2002/05/07 17:50:39 cvscapps Exp $