# Control panel - functions for the "Upgrade Button" feature

sub c_u_SanityCheck {

	############### check our cache-pw directory
	unless (exists($vars_config{cache_pw})) {
		$vars_config{cache_pw} = &GeneratePassword2;
		mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}");
	}    #no cache-pw == a screwed up demo or another odd config

	unless (&DirExists("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}")) {

		#$vars_config{cache_pw} = &GeneratePassword2;
		mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}");
		&WriteHashToFile("$vars_config{VariablesPath}/vars_config.cgi", "vars_config", \%vars_config);
	}    #cache pw without directory == screwy setup, so create

	unless (&DirExists("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}")) {
		&StandardHTML(qq%Error:<P>The cache-$vars_config{cache_pw} directory does not exist or could not be created.  Please reset permissions on your noncgi directory then attempt to perform this procedure again.%);
	}    # If it still didn't get created, our noncgi directory is screwy, so have user fix

	if (!&DirExists("$vars_config{NonCGIPath}/graemlins")) {
		mkdir("$vars_config{NonCGIPath}/graemlins", SEVENSEVENSEVEN) or die $!;
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/graemlins");
	}
	if (!&DirExists("$vars_config{NonCGIPath}/Polls")) {
		mkdir("$vars_config{NonCGIPath}/Polls", SEVENSEVENSEVEN) or die $!;
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/Polls");
	}
	if (!&DirExists("$vars_config{NonCGIPath}/Avatars")) {
		mkdir("$vars_config{NonCGIPath}/Avatars", SEVENSEVENSEVEN) or die $!;
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/Avatars");
	}
	if (!&DirExists("$vars_config{NonCGIPath}/searchlogs")) {
		mkdir("$vars_config{NonCGIPath}/searchlogs", SEVENSEVENSEVEN) or die $!;
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/searchlogs");
	}
	if (!&DirExists("$vars_config{NonCGIPath}/styles/importexport")) {
		mkdir("$vars_config{NonCGIPath}/styles/importexport", SEVENSEVENSEVEN) or die $!;
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/styles/importexport");
	}

	if (!&DirExists("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/ubb_files")) {
		mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/ubb_files", SEVENSEVENSEVEN) or die $!;
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/ubb_files");
	}
	if (!&DirExists("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index")) {
		mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index", SEVENSEVENSEVEN) or die $!;
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index");
	}

	############### make sure our vars_files can be written to
	opendir(CGIDIR, "$vars_config{VariablesPath}") or die $!;
	my @files = readdir(CGIDIR);
	closedir(CGIDIR);

	my @varsfiles = grep(/^vars_.+\.cgi$/, @files);
	foreach (@varsfiles) {
		my $filename = "$vars_config{VariablesPath}/$_";
		unless (-f $filename && -s $filename && -w $filename) {
			&StandardHTML(qq%Error:<p>Variable file lacks proper permissions.  Please reset permissions on $filename</p>%);
		}
	}

	# Display the rebuild notice
	my @for = &OpenForumsFile;
	@check = split (/\|\^\|/, $for[0]);
	my $rebuilder = &ForumSanityCheck("$check[8]");

	my $returnmsg;
	if ($rebuilder) {
		$returnmsg = "Remember to Rebuild Forum Stat Files!  Your board will not operate until you complete that process!";
	}

	foreach my $entry (@for) {
		my @click = split (/\|\^\|/, $entry);
		&SetExactPath($click[8]);
		&Unlink("$vars_config{NonCGIPath}/$exact_path/forum_$click[8].threads");
	}    #endforeach

	return $returnmsg;

}    #endsub c_u_SanityCheck


sub c_u_DoUpgrade {
	my $message = &c_u_SanityCheck;

	&ClearSummaryCache;
	&ClearForumPageCache;
	&ClearForumTopicsCache;
	&ClearMiscCache;

	my $filename = "$vars_config{CGIPath}/cp_upgrade_data.cgi";
	unless (-f $filename && -s $filename) {
		&StandardHTML(qq%Error:<p>Could not find the upgrade data file.  Please ensure you uploaded the file correctly: $filename</p>%);
	}

	&RequireCode("$vars_config{CGIPath}/cp_upgrade_data.cgi");

	&c_u_UpdateWordlets;
	&c_u_d_AdditionalTasks('after_sanity');

	&c_u_UpdateVarsVersions;

	&cp_confirm("Upgrade Complete!", $message, "Control Panel Home", "$vars_config{CGIURL}/cp.cgi?");

	return;
}    #endsub c_u_DoUpgrade



sub c_u_UpdateWordlets {
	my $updateref = &c_u_d_GetNewWordlets;

	foreach my $set (keys %$updateref) {
		my (%req, $fileplus, $ext);
		my $newordlets = $updateref->{$set};

		if ($set eq "primary") {
			$fileplus = ".cgi";
			%req      = %vars_wordlets;
			$ext      = "";
		} else {
			$fileplus = "_" . $set . ".cgi";
			%req      = %vars_wordlets_cp if $set eq "cp";
			%req      = %vars_wordlets_date if $set eq "date";
			%req      = %vars_wordlets_err if $set eq "err";
			%req      = %vars_wordlets_img if $set eq "img";
			%req      = %vars_wordlets_pntf if $set eq "pntf";
			%req      = %vars_wordlets_poll if $set eq "poll";
			%req      = %vars_wordlets_email if $set eq "email";
			$ext      = "_" . $set;
		}    #endif

		my $filename = "$vars_config{VariablesPath}/vars_wordlets$fileplus";

		foreach my $thatwordlet (keys %req) {
			if(((!defined $req{$thatwordlet}) || ($req{$thatwordlet} eq '')) && (defined $newordlets->{$thiswordlet}->{'new'})) {
				$req{$thiswordlet} = $newordlets->{$thiswordlet}->{'new'};
			} # end if
		} # end foreach

		foreach my $thiswordlet (keys %$newordlets) {
			if((!exists $req{$thiswordlet}) || ($req{$thiswordlet} eq '')) {
				$req{$thiswordlet} = $newordlets->{$thiswordlet}->{'new'} if defined $newordlets->{$thiswordlet}->{'new'};
			}    #endif
		}    #endforeach

		&WriteHashToFile($filename, "vars_wordlets$ext", \%req);

	}    #endforeach

}    #endsub c_u_UpdateWordlets

sub c_u_UpdateVarsVersions {

	local(%vars_versions);

	if(&FileExists("$vars_config{VariablesPath}/vars_versions.cgi")) {
		&RequireVars("$vars_config{VariablesPath}/vars_versions.cgi");
		push(@{$vars_versions{$version}}, $GotTime{LastLoginJulian});
		$vars_versions{'upgrades'}->{$version}++;
		if($vars_versions{'ThisVersion'} ne $version) {
			$vars_versions{'LastVersion'} = $vars_versions{'ThisVersion'};
			$vars_versions{'ThisVersion'} = $version;
		}

	} else {
		%vars_versions = (
			'upgrades' => {
				"$version" => '1',
				},
			'ThisVersion' => "$version",
		);
		push(@{$vars_versions{$version}}, $GotTime{LastLoginJulian});
	}

	my $outstring;

	$outstring = qq~\%vars_versions = (\n~;
	$outstring .= qq~\t'upgrades' => {\n~;
	foreach(sort keys %{$vars_versions{'upgrades'}}) {
		$outstring .= qq~\t\t'$_' => '$vars_versions{upgrades}->{$_}',\n~;
	}
	$outstring .= qq~\t},\n\n~;

	foreach(sort keys %vars_versions) {
		next if m/^(upgrades|ThisVersion|LastVersion)$/;
		#print "!!$_!!";
		$outstring .= qq~\t'$_' => [~;
		foreach my $z (sort @{$vars_versions{$_}}) {
			$outstring .= qq~'$z', ~;
		}
		$outstring .= qq~],\n~;
	}
	$outstring .= qq~\n\t'ThisVersion' => '$vars_versions{ThisVersion}',~;
	$outstring .= qq~\n\t'LastVersion' => '$vars_versions{LastVersion}',~;
	$outstring .= qq~\n)\;\n\n1\;~;

	&WriteFileAsString("$vars_config{VariablesPath}/vars_versions.cgi", $outstring);
}

sub c_u_Intro {
	$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="run_upgrade">
!;
	$CurrentTab = qq%Upgrade Your UBB.classic$trademark%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_upgrade_intro");
	&CPBottom;
	exit(0);
}    #endsub c_u_Intro


1;   # must retutn 'true' for Perl - leave this line alone!
# $Id: cp_upgrade.cgi,v 1.11 2002/04/18 22:27:17 cvscapps Exp $
