# Control Panel - Routines for setting, managing styles

sub cp_styles_get_master_lists {
return qw(
BGColor TextColor LinkColor ActiveLinkColor VisitedLinkColor
TableBorderColor TableStripTextColor TableColorStrip TimeColor
AltColumnColor1 AltColumnColor2 CategoryStripColor
CategoryStripTextColor CopyrightTextColor
BBTitleFontColor hr_color FontFace TableWidth
TextSize FDTextSize  BBTitle BBTopic
BBReply search_graphic profilegif edit_icon
reply_with_quote_icon homepage_icon forum_summ_on
forum_summ_off table_border_display new_topic_folder
old_topic_folder hot_new_topic_folder hot_old_topic_folder
old_locked_folder new_locked_folder plain_old_regular_lock
ubb_friend ubb_friend_mini close_topic open_topic
move_topic delete_topic prev_topic next_topic priv_message
user_ratings_1 user_ratings_2 user_ratings_3 user_ratings_4
user_ratings_5 mailgif thisCharset print_topic_icon BBPoll
old_poll_folder new_poll_folder old_poll_locked_folder
new_poll_locked_folder PollVote PollResults pollbar_color
ubbcode_url ubbcode_email_url ubbcode_bold ubbcode_italics
ubbcode_ubb_quote ubbcode_code ubbcode_list_start
ubbcode_list_item ubbcode_list_end ubbcode_image
);
} # end sub

sub cp_styles_optional_lists {
	return qw(
PageBackground
);
} # end sub

sub set_new_template {
	local ($LastOne, $j, $lastnum);
	local (*FILE);

	# assign number to template
	my @temps     = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");
	my @reverseit = reverse(@temps);
	$LastOne = $reverseit[0];
	chomp($LastOne);
	($j, $lastnum) = split (/\|\^\|/, $LastOne);
	$ThisTemplateNumber = $lastnum + 1;

	# set/clean the vars ------------
	my $Header        = &SmallClean3($in{Header});
	my $Footer        = &SmallClean3($in{Footer});
	my $HeaderInsert  = &SmallClean3($in{HeaderInsert});
	my $html_extra    = &SmallClean3($in{html_extra});
	my $body_extra    = &SmallClean3($in{body_extra});
	my $language_meta = &SmallClean3($in{language_meta});

	# limit/eliminate/convert returns in some fields
	$HeaderInsert  = &LimitReturns($HeaderInsert);
	$Header        = &LimitReturns($Header);
	$Footer        = &LimitReturns($Footer);
	$html_extra    = &EliminateReturns($html_extra);
	$body_extra    = &EliminateReturns($body_extra);
	$language_meta = &EliminateReturns($language_meta);

	$CurrentTab = qq%$vars_wordlets_cp{style_settings}%;
	&CPHeader;
	&CPFooter;

	#validate
	my @list = &cp_styles_get_master_lists;
	&Validate(@list);
	my @that = qw(TemplateName);
	&Validate(@that);
	push(@list, &cp_styles_optional_lists);

	# another check on name
	if (($in{TemplateName} =~ /\|\^\|/)) {
		&StandardHTML(qq%Your template name can not contain: |^|%);
	}

	# write to file!
	my %new_vars_style = (
		Header                 => qq~$Header~,
		Footer                 => qq~$Footer~,
		HeaderInsert           => qq~$HeaderInsert~,
		html_extra             => qq~$html_extra~,
		body_extra             => qq~$body_extra~,
	);

	$new_vars_style{special} = $in{special};
	$new_vars_style{cssname} = $in{cssname};
	if($in{CSS} && &FileExists("$vars_config{NonCGIPath}/$in{cssname}")) {
		&WriteFileAsString("$vars_config{NonCGIPath}/$in{cssname}", $in{CSS});
	} # end if

	foreach my $one (@list) {
		$new_vars_style{$one} = $in{$one};
	} # end foreach

	if($in{special} == 1) {
		my @fields = sort {$a cmp $b} grep(/^jc_/, keys %in);
		my @fields2 = sort {$a cmp $b} grep(/^customgraphic_/, keys %in);
		foreach my $one (@fields, @fields2) {
			$new_vars_style{$one} = $in{$one};
		} # end foreach
	} # end if

	&WriteHashToFile("$vars_config{NonCGIPath}/styles/vars_style_$ThisTemplateNumber.cgi", "vars_style", \%new_vars_style);

	# update style sets file!
	&AppendFileAsString("$vars_config{VariablesPath}/vars_style_sets.cgi", qq!$in{TemplateName}|^|$ThisTemplateNumber\n!);

	#display template list page
	&cp_confirm("Style Template Created", undef, "Style Settings", "$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list");
	exit(0);

}    # end set new template

sub add_style_template {

	my $this = $_[0];
	$this ||= 1;

	$Hiddens = qq%<INPUT TYPE=HIDDEN NAME=ubb VALUE=set_new_template>%;

	$CurrentTab = qq%<A HREF=$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list>$vars_wordlets_cp{style_settings}</A> &#187; Add New Template%;

	# get standard settings to use as placeholders in form!
	%vars_style = &LoadStyleTemplateRaw($this);

	local($namer);
	if($_[1]) {
		$namer = "Copy of $_[1]";
		if($vars_style{"special"} == 1) {
			if(&FileExists("$vars_config{NonCGIPath}/$vars_style{cssname}")) {
				my $old = $vars_style{cssname};
				$vars_style{cssname} =~ s/\.css$//;
				$vars_style{cssname} .= "_" . $GotTime{CurrentEpoch} . ".css";
				&WriteFileAsString("$vars_config{NonCGIPath}/$vars_style{cssname}", &OpenFileAsString("$vars_config{NonCGIPath}/$old"));
			} # end if
		} # end if
	} # end if

	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_add_new_template");
	&CPBottom;

}    # add_style_template


sub view_style {
	local (@availstyles, $name, $num, $ThisName, $ThisNumber, $File, $DeleteWording);

	#retrieve template info
	@availstyles = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

	FINDIT: foreach (@availstyles) {
		($name, $num) = split (/\|\^\|/, $_);
		chomp($num);
		if ($num eq $in{template_choice}) {
			$ThisName   = $name;
			$ThisNumber = $num;
			last FINDIT;
		}
	}

	if($in{cloner} eq "clone") {
		&add_style_template($ThisNumber, $ThisName);
		exit;
	} # end if

	# delete wording!
	if ($in{template_choice} ne '1') {

		# we can't allow the standard template to be deleted
		$DeleteWording = qq!<INPUT TYPE=CHECKBOX NAME=delete VALUE=yes>&nbsp;&nbsp; Delete this style template? (check if desired)
!;
	} else {
		$DeleteWording = qq!Note: You may not delete the Standard Template.!;
	}

	$Hiddens = qq%<INPUT TYPE=HIDDEN NAME=ubb VALUE=set_vars_style>
<INPUT TYPE=HIDDEN NAME=template_choice VALUE=$ThisNumber>
%;

	$CurrentTab = qq%<A HREF=$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list>$vars_wordlets_cp{style_settings}</A> &#187; Template: $ThisName%;

	# grab proper style settings!
	%vars_style = &LoadStyleTemplateRaw($ThisNumber);
	#&RequireVars($vars_config{NonCGIPath}/styles/vars_style_$ThisNumber.cgi);

	&SetDefaults("vars_style");

	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_vars_style");
	&CPBottom;
}    #end view_vars

sub view_style_templates {
	local ($name, $num, $TemplateChoices);
	$Hiddens = qq%<INPUT TYPE=HIDDEN NAME=ubb VALUE=vars_style>%;

	my @template_list = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

	# assemble TemplateChoices

	$TemplateChoices = qq!<SELECT NAME=template_choice>!;


	foreach (@template_list) {
		($name, $num) = split (/\|\^\|/, $_);
		chomp($num);
		$TemplateChoices .= qq!<OPTION VALUE=$num>$name</OPTION>!;
	}

	$TemplateChoices .= qq!</SELECT>!;


	$CurrentTab = qq%$vars_wordlets_cp{"style_settings"}%;


	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_vars_template_list");
	&CPBottom;
}    #end view_style_templates



sub set_vars_style {
	local (*FILE);
	local ($j, $number, @revised,, $key);
	my $TemplateNumber = $in{template_choice};

	# set/clean the vars ------------
	my $Header        = &SmallClean3($in{Header});
	my $Footer        = &SmallClean3($in{Footer});
	my $HeaderInsert  = &SmallClean3($in{HeaderInsert});
	my $html_extra    = &SmallClean3($in{html_extra});
	my $body_extra    = &SmallClean3($in{body_extra});
	my $language_meta = &SmallClean3($in{language_meta});

	# limit/eliminate/convert returns in some fields
	$HeaderInsert  = &LimitReturns($HeaderInsert);
	$Header        = &LimitReturns($Header);
	$Footer        = &LimitReturns($Footer);
	$html_extra    = &EliminateReturns($html_extra);
	$body_extra    = &EliminateReturns($body_extra);
	$language_meta = &EliminateReturns($language_meta);

	$CurrentTab = qq%$vars_wordlets_cp{style_settings}%;
	&CPHeader;
	&CPFooter;

	# delete it?
	if ($in{delete} eq "yes") {

		# change template match file
		&RequireVars("$vars_config{VariablesPath}/vars_template_match.cgi");
		foreach $key (keys %template_match) {

			if ($template_match{$key} == $TemplateNumber) { $template_match{$key} = '1'; }

		}

		# print updated hash

		&WriteHashesToFile("$vars_config{VariablesPath}/vars_template_match.cgi", ["template_match", "template_html"], [\%template_match, \%template_html]);


		my @temp_list = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

		foreach (@temp_list) {
			($j, $number) = split (/\|\^\|/, $_);
			chomp($number);
			unless ($number eq $TemplateNumber) {
				push (@revised, $_);
			}
		}

		&WriteFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi", @revised);

		# delete old template
		&Unlink("$vars_config{NonCGIPath}/styles/vars_style_$TemplateNumber.cgi");

		# Confirm
		&cp_confirm("Style Template Deleted", undef, "Style Settings", "$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list");
		#&view_style_templates;
		exit(0);
	}    # end delete option


	#validate
	my @list = &cp_styles_get_master_lists;
	&Validate(@list);
	push(@list, &cp_styles_optional_lists);

	# write to file!
	my %new_vars_style = (
		Header                 => $Header,
		Footer                 => $Footer,
		HeaderInsert           => $HeaderInsert,
		html_extra             => $html_extra,
		body_extra             => $body_extra,
	);

	foreach my $one (@list) {
		$new_vars_style{$one} = $in{$one};
	} # end foreach

	$new_vars_style{special} = $in{special};
	$new_vars_style{cssname} = $in{cssname};
	if($in{CSS} && &FileExists("$vars_config{NonCGIPath}/$in{cssname}")) {
		&WriteFileAsString("$vars_config{NonCGIPath}/$in{cssname}", $in{CSS});
	} # end if

	if($in{special} == 1) {
		my @fields = sort {$a cmp $b} grep(/^jc_/, keys %in);
		my @fields2 = sort {$a cmp $b} grep(/^customgraphic_/, keys %in);
		foreach my $one (@fields, @fields2) {
			$new_vars_style{$one} = $in{$one};
		} # end foreach
	} # end if

	&WriteHashToFile("$vars_config{NonCGIPath}/styles/vars_style_$TemplateNumber.cgi", "vars_style", \%new_vars_style);

	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;
	&ClearSummaryCache;
	&ClearMiscCache;

	# display tempate page
	&cp_confirm("Style Template Set", undef, "Style Settings", "$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list");
	exit(0);

}    #end set_vars_style

sub templates_advanced {
	local (@templates, $key, $j, $k, $uno, $num, $Type, @thisforum);

	$Hiddens = qq%
<INPUT TYPE=HIDDEN NAME=ubb VALUE=set_advanced_templates>
<INPUT TYPE=HIDDEN NAME=type VALUE=misc>
%;

	$CurrentTab = qq%<A HREF=$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list>$vars_wordlets_cp{style_settings}</A> &gt;&gt; Template Associations%;
	&CPHeader;
	&CPFooter;

	# get template list
	@templates = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

	@valid_html = &determine_html_templates;

	&RequireVars("$vars_config{VariablesPath}/vars_template_match.cgi");

	&CPTop;
	&LoadTemplate("cp_templates_advanced");
	&CPBottom;


}    # end templates_advanced


sub templates_advanced_forums {
	local (@templates, $key, $j, $k, $uno, $num, $Type, @all_forums, @this_forum, $this_template, $temp_num);

	$Hiddens = qq%
<INPUT TYPE=HIDDEN NAME=ubb VALUE=set_advanced_templates>
<INPUT TYPE=HIDDEN NAME=type VALUE=forums>
%;

	$CurrentTab = qq%<A HREF=$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list>$vars_wordlets_cp{style_settings}</A> &gt;&gt; Template Associations%;
	&CPHeader;
	&CPFooter;

	@all_forums = &OpenForumsFile;

	# get template list
	@templates = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

	@valid_html = &determine_html_templates;

	&RequireVars("$vars_config{VariablesPath}/vars_template_match.cgi");

	&CPTop;
	&LoadTemplate("cp_templates_advanced_f");
	&CPBottom;


}    # end templates_advanced_forums

sub determine_html_templates {
	my $bp = "$vars_config{NonCGIPath}/Templates";
	opendir(TE, $bp) or die "$! opening $bp";
	my @files = readdir(TE);
	closedir(TE);

	my @candidates;
	foreach my $one (@files) {
		next if $one =~ m/^\./;
		push(@candidates, $one) if(-d "$bp/$one" && -f "$bp/$one/public_common.pl");
	} # end foreach

	return "Standard", sort {$a cmp $b} @candidates;
} # end determine_html_templates

sub set_advanced_templates {

	local (*FILE);
	local ($key, @this_forum, $ft);

	&RequireVars("$vars_config{VariablesPath}/vars_template_match.cgi");

	if ($_[0] eq "misc") {
		$template_match{registration} = $in{registration};
		$template_match{search}       = $in{search};
		$template_match{transition}   = $in{transition};
		$template_match{summary_page} = $in{summary_page};
		$template_match{profile}      = $in{profile};
		$template_match{ubb_code}     = $in{ubb_code};
		$template_match{faq}          = $in{faq};
		$template_match{email}        = $in{email};
		if (!$in{private_message}) {
			$in{private_message} = '1';
		}
		$template_match{private_message} = $in{private_message};

	} else {
		# do forums
		foreach $key (keys %in) {
			if ($key =~ /^forum_\d+$/) { $template_match{$key} = $in{$key}; }
		}

	}    # end if/else misc

	# make sure all forums are accounted for
	&GetForumRecord(0);
	foreach my $f (keys %vars_forums) {
		my $ft = "forum_$f";
		unless (exists($template_match{$ft}) && defined($template_match{$ft})) {
			$template_match{$ft} = '1';
		}
		unless (exists($template_html{$ft}) && defined($template_html{$ft})) {
			$template_html{$ft} = undef;	# .............
		}
	} # end foreach

	foreach my $one (grep(/_html$/, keys %in)) {
		my $two = $one;
		$two =~ s!_html$!!;
		$template_html{$two} = ($in{$one} eq "Standard" ? undef : $in{$one});
	} # end foreach

	my @z = grep(/^forum_\d+_trans$/, keys %in);
	my %trans;
	if(scalar(@z) > 0) {
		%trans = ();
	} else {
		%trans = map { $_ => 1 } grep(/^\d+$/, split(/\|/, $template_match{"trans_forums"}));
	} # end if
	foreach my $three (@z) {
		if($three =~ m/forum_(\d+)_trans/) {
			$trans{$1}++;
		} # end foreach
	} # end foreach
	$template_match{"trans_forums"} = "|" . join("|", keys %trans) . "|";

	# print updated hash
	&WriteHashesToFile("$vars_config{VariablesPath}/vars_template_match.cgi", ["template_match", "template_html"], [\%template_match, \%template_html]);

	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;
	&ClearSummaryCache;
	&ClearMiscCache;

	# view advanced template controls
	&cp_confirm("Template Assignments Updated");

}    # end set_adv templates

sub export_template {
	if(!$in{d}) {

		# reuse of code GOOD.
		my @template_list = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");

		# assemble TemplateChoices

		my $TemplateChoices = qq!<select name="template_choice">!;


		foreach (@template_list) {
			($name, $num) = split (/\|\^\|/, $_);
			chomp($num);
			$TemplateChoices .= qq!<option value="$num">$name</option>!;
		}

		$TemplateChoices .= qq!</select>!;


		$Hiddens = qq%
<input type="hidden" name="ubb" value="export_template" />
<input type="hidden" name="d" value="export" />
%;

		$CurrentTab = qq%Template Export%;
		&CPHeader;
		&CPFooter;
		&CPTop;
		&LoadTemplate("cp_templates_export");
		&export_intro($TemplateChoices);
		&CPBottom;

	} elsif($in{d} eq 'export') {
		my $name = &strip_lead_trail_space($in{exportname});
		$name =~ s/\.cgi$//;
		$name =~ s/\W//g;
		if(!&DirExists("$vars_config{NonCGIPath}/styles/importexport")) {
			mkdir("$vars_config{NonCGIPath}/styles/importexport", 0777);
		} # end if
		if(&FileExists("$vars_config{NonCGIPath}/styles/importexport/$name.cgi")) {
			&StandardHTML("The name you selected, $name, is already in use.  Please select another.");
		} # end if

		my $ncgi = quotemeta($vars_config{NonCGIURL});
		my $cgi = quotemeta($vars_config{CGIURL});

		%vars_style = &LoadStyleTemplateRaw($in{template_choice});

		foreach my $key (keys %vars_style) {
			$vars_style{$key} = &strip_lead_trail_whitespace($vars_style{$key});
			$vars_style{$key} =~ s/$ncgi/\%\%NONCGIURL\%\%/gis;
			$vars_style{$key} =~ s/$cgi/\%\%CGIURL\%\%/gis;
		} # end foreach

		&WriteHashToFile("$vars_config{NonCGIPath}/styles/importexport/$name.cgi", "vars_style_import", \%vars_style);
		&cp_confirm("Template Exported", "Export complete.  The file has been saved as /styles/importexport/$name.cgi in your NonCGI directory.", "Style Settings", "$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list");
		exit;
	} else {
		die "Can't dispatch a '$in{d}'";
	} # end if
} # end export_template

sub import_template {
	if(!$in{d}) {
		$Hiddens = qq%
<input type="hidden" name="ubb" value="import_template" />
<input type="hidden" name="d" value="import" />
%;

		if(!&DirExists("$vars_config{NonCGIPath}/styles/importexport")) {
			&StandardHTML("Sorry, you have no templates to import.  (The /styles/importexport directory is missing.)");
		} # end if

		opendir(DR, "$vars_config{NonCGIPath}/styles/importexport") or die $!;
		my @fns = grep(/^[\w_-]+\.cgi$/, readdir(DR));
		closedir(DR);

		if(!@fns) {
			&StandardHTML("There are no templates in the /styles/importexport directory.");
		} # end if

		my @files;
		foreach my $file(@fns) {
			my @stats = stat("$vars_config{NonCGIPath}/styles/importexport/$file");
			push(@files, { name => $file, updatetime => join(", ", &DateFormat2(&ConvertUnixEpochToPostTime($stats[9]))) });
		} # end foreach

		$CurrentTab = qq%Template Export%;
		&CPHeader;
		&CPFooter;
		&CPTop;
		&LoadTemplate("cp_templates_import");
		&import_intro(@files);
		&CPBottom;
	} elsif($in{d} eq "import") {
		if(!$in{file}) {
			&StandardHTML("You must select a file to import.");
		} # end if
		if(!$in{given}) {
			&StandardHTML("You must give the Template a name.");
		} # end if

		die "No.\n" unless $in{file} =~ m/^[\w_-]+\.cgi$/;

		local(%vars_style_import);
		&RequireVars("$vars_config{NonCGIPath}/styles/importexport/$in{file}");

		my %vars_style_new;
		foreach my $k (keys %vars_style_import) {
			$vars_style_new{$k} = &Template($vars_style_import{$k}, { CGIURL => $vars_config{CGIURL}, NONCGIURL => $vars_config{NonCGIURL} });
		} # end foreach

		my @templatelist = &OpenFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi");
		my $maxnum = 2;
		foreach my $line (@templatelist) {
			chomp($line);
			my($name, $num) = split(/\|\^\|/, $line);
			$maxnum = $num + 1 if $num >= $maxnum;
		} # end foreach

		my $thisname = "vars_style_$maxnum.cgi";

		if(&FileExists("$vars_config{NonCGIPath}/styles/$thisname")) {
			&StandardHTML("Won't overwrite $thisname with a new copy.")
		} # end if

		&WriteHashToFile("$vars_config{NonCGIPath}/styles/$thisname", "vars_style", \%vars_style_new);

		push(@templatelist, "$in{given}|^|$maxnum");
		&WriteFileAsArray("$vars_config{VariablesPath}/vars_style_sets.cgi", @templatelist);

		&cp_confirm("Style Imported", undef, "Style Settings", "$vars_config{CGIURL}/cp.cgi?ubb=vars_style_temp_list");

	} else {
		die "Can't dispatch a '$in{d}'";
	} # end if
} # end import_template

# Danger- do not remove the following line!
1;
# $Id: cp_styles.cgi,v 1.14 2002/05/02 23:41:29 cvscapps Exp $
