# Control Panel - Routines for Pruning Posts

sub prune {

	&AppendAdminLog($username, $status, "Viewed Prune Intro", "Succeeded", "");


	$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="prune_option">
%;
	$CurrentTab = qq%$vars_wordlets_cp{prune_option}%;

	# note: the wordlets are already required... no need to grab them

	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_prune_intro");
	&CPBottom;

}    # end prune sr

sub prune_by {
	local ($forum_options, @forums, @user_profile, @forum_info, $all_forums);

	if ($in{prune_option} eq 'USER') {
		$all_forums = qq!<OPTION VALUE="ALL"> All Forums!;
	}

	# get user profile if a mod...
	if ($status eq 'Moderator') {
		@user_profile = &verify_id_num($username, $password, $admin_number);
		$all_forums = '';
	}

	# forum options
	@forums = &OpenForumsFile;
	foreach (@forums) {

		@forum_info = split (/\|\^\|/, $_);

		if ($status ne 'Administrator') {

			$is_forum_mod = &is_admin_or_mod($forum_info[8], @user_profile);
			if ($is_forum_mod eq 'true') {
				$forum_options .= qq!
<OPTION VALUE="$forum_info[8]">$forum_info[1]</OPTION>
!;
			}

		} else {
			$forum_options .= qq!
<OPTION VALUE="$forum_info[8]">$forum_info[1]</OPTION>
!;

		}

	}

	&AppendAdminLog($username, $status, "Selected Prune Type", "Succeeded", "$in{prune_option}");


	# template
	$Hiddens = qq%
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="prune_request">
<INPUT TYPE="HIDDEN" NAME="prune_option" VALUE="$in{prune_option}">
%;
	$CurrentTab = qq%$vars_wordlets_cp{prune_request}%;

	# determine template
	($in{prune_option} eq "DATE") ? ($get_file = "cp_prune_by_date") : ($get_file = "cp_prune_by_user");

	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate($get_file);
	&CPBottom;

}    # end prune_by


sub prune_by_date_request {
	local (%forum_topics, @this_forum, @user_profile, $user_perm, $key, $value, $int_value, $prune_cutoff, @prunes, @this_topic, $topic_starter, $days_old, $stat_line);

	# validate
	my @ValidateArray = ("prune_forum", "prune_days");
	&Validate(@ValidateArray);

	# grab forum record
	@this_forum = &GetForumRecord($in{prune_forum});

	# set exact_path
	if ($this_forum[6] =~ m/private/) {
		$exact_path = "Forum$in{prune_forum}/private-$this_forum[7]";
	} else {
		$exact_path = "Forum$in{prune_forum}";
	}

	# grab user profile
	@user_profile = &verify_id_num($username, $password, $admin_number);

	# make sure user has authority
	$user_perm = &is_admin_or_mod($in{prune_forum}, @user_profile);
	unless ($user_perm eq "true") {
		&StandardHTML("$vars_wordlets_err{no_permission}");
	}

	# grab forum threads file
	my $this_forum_topics = &GetForumTopics($in{prune_forum});
	%forum_topics = %$this_forum_topics;

	# today's Jules date: $GotTime{LastLoginJulianDATE}
	# prune date:
	$prune_cutoff = $GotTime{LastLoginJulianDATE} - $in{prune_days};

	#print "Performing prune: $GotTime{LastLoginJulianDATE} - $in{prune_days}";

	my %forum_topics_reversed;
	while (my ($x_key, $x_value) = each(%forum_topics)) { $forum_topics_reversed{$x_value} = $x_key; }

	# collect prunable topics
	foreach my $key (sort keys %forum_topics_reversed) {
		my $value = $key;
		$int_value = int($value);    #print "<pre>\n$value?</pre>";
		if ($int_value <= $prune_cutoff) {
			push (@prunes, $forum_topics_reversed{$key});

			#	print "<pre>\t$int_value < $prune_cutoff\n</pre>";
		} else {

			#	print "<pre>$int_value => $prune_cutoff\n</pre>";
		}
	}


	&AppendAdminLog($username, $status, "Viewed Prune by Date for Forum $in{prune_forum}", "Succeeded", "Pruned up to: $prune_cutoff");


	# template
	$Hiddens = qq%
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="prune_submit">
<INPUT TYPE="HIDDEN" NAME="prune_option" VALUE="$in{prune_option}">
<INPUT TYPE="HIDDEN" NAME="prune_forum" VALUE="$in{prune_forum}">
%;
	$CurrentTab = qq%$vars_wordlets_cp{prune_request}%;

	# note: the wordlets are already required... no need to grab them

	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_prune_submit");
	&CPBottom;


}    # end prune_by_date_request

sub prune_submit {
	if ($in{prune_option} eq 'USER') {
		&new_prune_user_submit;
	} else {
		&prune_date_submit;
	}
}    # end prune submit sr

sub prune_date_submit {
	local (@this_forum, @user_profile, $user_perm, $key, $value, @prunes, @this_topic, $stat_line, $topic_posts, $redo_last_time, @data);

	# validate
	my @ValidateArray = ("prune_forum");
	&Validate(@ValidateArray);

	# grab forum record
	@this_forum = &GetForumRecord($in{prune_forum});

	# set exact_path
	&SetExactPath($in{prune_forum});

	# grab user profile
	@user_profile = &verify_id_num($username, $password, $admin_number);

	# make sure user has authority
	$user_perm = &is_admin_or_mod($in{prune_forum}, @user_profile);

	unless ($user_perm eq "true") {
		&StandardHTML("$vars_wordlets_err{no_permission}");
	}

	if(!exists $in{record}) {
		while (($key, $value) = each(%in)) {
			if ($value eq "prune") { push (@prunes, $key); }
		}    #end %in loop

		if(scalar(@prunes) > 25) {
			my $randomfile = "prune-date-" . &GeneratePassword;
			&WriteFileAsArray("$vars_config{NonCGIPath}/$exact_path/$randomfile.cgi", @prunes);
			$in{record} = $randomfile;
		}

	} else {
		die unless $in{record} =~ m/^prune-date-(\w+)$/;
		@prunes = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/$in{record}.cgi");
	}

	my $start_point = $in{start} + 0;
	my $end_point = $start_point + 25;
	my $laster = 0;
	my $scalarpunes = scalar(@prunes);
	if($end_point >= $scalarpunes) {
		$end_point = $scalarpunes - 1;
		$laster = 1;
	}

	@prunes = @prunes[$start_point .. $end_point];


	# iterate thru pruned topics
	&PerformRealPrune($in{prune_forum}, @prunes);

	print "</font></pre>";

	if(!$laster) {
		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=prune_refresh&prune_forum=$in{prune_forum}&prune_option=DATE&record=$in{record}&start=$end_point",
		"Pruning forum $in{prune_forum} - please standby.  <br />We just pruned <b>$start_point</b> of <b>$scalarpunes</b> topics in this prune.<p>Please wait!</p>",
		"Prune in Progress",
		"Continuing Prune...");
	} else {
		&CreateLastTimeFiles($in{prune_forum});                 #write lasttime/lastnumber files

		# clear cache
		&ClearSingleForumPageCache($exact_path, $in{prune_forum});
		&ClearSummaryCache;

		&AppendAdminLog($username, $status, "Pruned $data[1] Threads from Forum $in{prune_forum}", "Succeeded", "");

		if($in{record}) {
			&Unlink("$vars_config{NonCGIPath}/$exact_path/$in{record}.cgi")
				or die "Prune succeeded, but unable to delete tempfile: $!";
		}

		# confirm onscreen
		&cp_confirm("Prune Complete", "You should rebuild the search index.");
		exit(0);
	}

}    # end prune_submit


sub PerformRealPrune {
	my($forum, @topics) = @_;
	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
	&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");

	&SetExactPath($forum);

	my $refe = &GetForumTopics($forum);
	%forum_topics = %{$refe};

	foreach (@topics) {
		chomp;
		next unless m/^\d{6}$/;

		my $pollid = (&GetThreadData($in{prune_forum}, $_))[18];
		if($pollid =~ m/^\w{12}$/) {
			&Unlink("$vars_config{NonCGIPath}/Polls/$pollid.cgi");
		} # end if

		# delete topic file
		&Unlink("$vars_config{NonCGIPath}/$exact_path/$_.cgi");

		&nice_unlink_topic_from_forum_summary($in{prune_forum}, $_);

		# delete topic HTML file
		#unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$_.cgi");
		my $thispath = qq($vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path);
		&DoThatClearCacheThing($thispath, $_);
	}    # end loop thru topics to prune

	&UpdateForumTopics($in{prune_forum}, \%forum_topics);    #write the new .threads file
	&WriteAllForumThreadData($in{prune_forum});              #write our new forum_thread_data files

	return();
} #endsub

sub new_prune_user_submit {
	local(*FILE);

	my @ValidateArray = ("prune_forum", "prune_reg_user");
	&Validate(@ValidateArray);

	# grab user profile
	@user_profile = &verify_id_num($username, $password, $admin_number);

	# make sure user has authority
	$user_perm = &is_admin_or_mod($in{prune_forum}, @user_profile);

	unless ($user_perm eq "true") {
		&StandardHTML("$vars_wordlets_err{no_permission}");
	}

	@user_posts = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$in{prune_reg_user}.cgi");
	foreach (@user_posts) { chomp; }

	# date|forum|topic|reply|ip
	# 19990327|6|000083|000043|10.0.0.150

	my %pruner = ();

	unless($in{record}) {
		foreach(keys %in) {
			if($in{$_} eq "prune") {
				my($a, $b, $c, $d, $e) = split(/\|/, $_);
				push(@{$pruner{$b}{$c}}, $d);
			} #endif
		} #endforeach
	} #endunless


	my($storage, $forums_to_prune, $threads_to_prune, $messages_to_prune) = "";

	$storage .=  "\%pruner = (\n";
	L1: foreach my $a (sort keys %pruner) {
		$storage .=  "    '$a' => {\n";
		L2: foreach my $b (sort keys %{$pruner{$a}}) {
			$storage .=  "\t'$b' => [\n";
			L3: foreach my $c (sort @{$pruner{$a}{$b}}) {
				$storage .=  "\t    '$c',\n";
				#if($c eq "000000") {
				#	$storage .=  "\t    ],\n";
				#	next L2;
				#} #endif
				$messages_to_prune += 1;
			} #endforeach
			$storage .=  "\t    ],\n";
			$threads_to_prune += 1;
		} #endforeach
		$storage .=  "    },\n\n";
		$forums_to_prune += 1;
	} #endforeach
	$storage .= <<THISTHING;
'messages_to_prune' => '$messages_to_prune',
'threads_to_prune' => '$threads_to_prune',
'forums_to_prune' => '$forums_to_prune',
THISTHING
	$storage .=  ");\n1;\n\n";

	my $fn = &GeneratePassword;
	&WriteFileAsString("$vars_config{NonCGIPath}/cache-$cache_cookie/user-prune-$fn.cgi", $storage);

	&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=prune_user_refresh&record=$fn&forum_start=0&thread_start=0&prune_reg_user=$in{prune_reg_user}",
	"In this prune, there are about <b>$messages_to_prune</b> messages in <b>$forums_to_prune</b> forums.  <br />We will now begin the prune process.  This may take some time.  <p>Please wait!</p>",
	"Prune by User",
	"Starting Prune...",
	"3",
	);

} #endsub

sub ContinueUserPrune {
	local(*FILE, %pruner);

	&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");
	&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");

	die unless $in{record} =~ m/^[A-Za-z0-9]+$/;
	&RequireVars("$vars_config{NonCGIPath}/cache-$cache_cookie/user-prune-$in{record}.cgi");

	my $messages_to_prune = $pruner{'messages_to_prune'};   delete $pruner{'messages_to_prune'};
	my $threads_to_prune = $pruner{'threads_to_prune'};     delete $pruner{'threads_to_prune'};
	my $forums_to_prune =  $pruner{'forums_to_prune'};      delete $pruner{'forums_to_prune'};


	my $forum_start = $in{forum_start};
	my $thread_start = $in{thread_start};

	die unless $forum_start =~ m/^\d+?$/;
	die unless $thread_start =~ m/^\d+?$/;

	my $forum_number = (sort { $a <=> $b } keys %pruner)[$forum_start];

	my @threads = sort keys %{$pruner{$forum_number}};

	#only handle 50 at a time
	my $counter = scalar(@threads);
	my $end_point = $thread_start + 50;
	my $endthisforum = 0;
	if($end_point > $counter) { $end_point = $counter; $endthisforum = 1; }

	my @prunees = @threads[$thread_start .. $end_point];

	&SetExactPath($forum_number);

	my $refe = &GetForumTopics($forum_number);
	%forum_topics = %{$refe};

	my($deletedposts, $deletedthreads) = (0, 0);

	my %deleter;

	foreach my $thread (@prunees) {
		next unless $thread =~ m/^\d{6}$/;
		if(&FileExists("$vars_config{NonCGIPath}/$exact_path/$thread.cgi")) {

			my @thisarray = @{$pruner{$forum_number}->{$thread}};
			my $isfirst = 0;
			foreach my $item (@thisarray) { if($item eq "000000") { $isfirst++; } }
			if($isfirst > 0) {
			#if this is the first post, blow away the thread
				&Unlink("$vars_config{NonCGIPath}/$exact_path/$thread.cgi") or die "$! deleting $thread!";
				&nice_unlink_topic_from_forum_summary($forum_number, $thread);

				my $thispath = qq($vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path);
				&DoThatClearCacheThing($thispath, $thread);

				foreach my $thisval (@thisarray) {
					$deleter{"$forum_number|$thread|$thisval"} = 1;
				}
				$deletedthreads += 1;
			} else {
			#otherwise, open the thread and start seeking
				my @topic;
				my $regex = join("|", @thisarray);

				&SafeGetThreadData2($forum_number, $thread);

				foreach my $line (&OpenTopic($thread, $forum_number)) {
					chomp $line;
					if($line =~ m/^Z\|\|($regex)\|\|/) {
						$deleter{"$forum_number|$thread|$1"} = 1;
					} else {
						foreach my $thisval (@thisarray) {
							$deleter{"$forum_number|$thread|$thisval"} = 1;
						}
						push(@topic, $line)
					} #endif
				} #endforeach

				&WriteTopic($forum_number, $thread, @topic);
				$thread =~ m/^(\d{4})(\d{2})$/;
				my($lefty, $righty) = ($1, $2);
				&UpdateForumThreadDataForSingleThread($forum_number, $lefty, $righty, @topic);
			} #endif
		} else {
			foreach my $thisval (@{$pruner{$forum_number}->{$thread}}) {
				$deleter{"$forum_number|$thread|$thisval"} = 1;
			}
		} #endif
	} #endforeach

	&UpdateForumTopics($forum_number, \%forum_topics);    #write the new .threads file
	&WriteAllForumThreadData($forum_number);              #write our new forum_thread_data files

	&AppendFileAsArray("$vars_config{NonCGIPath}/cache-$cache_cookie/user-prune-removals-$in{record}.cgi", keys %deleter);

	my @array = &OpenFileAsArray("$vars_config{NonCGIPath}/cache-$cache_cookie/user-prune-removals-$in{record}.cgi");
	foreach my $thisentry (@array) {
		chomp $thisentry;
		$deleter{$thisentry} = 1;
	}
	my $total_so_far = scalar(keys %deleter);

	&WriteFileAsArray("$vars_config{NonCGIPath}/cache-$cache_cookie/user-prune-removals-$in{record}.cgi", keys %deleter);

	my $forums_string = join("</b>, <b>", (sort { $a <=> $b } keys %pruner));

	if(!$endthisforum) {
		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=prune_user_refresh&record=$in{record}&forum_start=$forum_start&thread_start=$end_point&prune_reg_user=$in{prune_reg_user}",
		"We have marked about <b>$messages_to_prune</b> posts in forums <b>$forums_string</b> <br />So far, we have processed <b>$total_so_far</b> posts.  Currently processing forum <b>$forum_number</b>.<p>Please wait!</p>",
		"Prune by User",
		"Continuing Prune...",
		"3",
		);
	} else {

		&CreateLastTimeFiles($forum_number);
		&ClearSingleForumPageCache($exact_path, $forum_number);

		my $newforum = $forum_start + 1;
		if($newforum >= scalar(keys %pruner)) {
			&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=prune_user_history&record=$in{record}&prune_reg_user=$in{prune_reg_user}",
			"The prune has been completed.  We will now update the user's post history.<p>Please wait!</p>",
			"Prune by User",
			"Continuing Prune...",
			"3",
			);
		}
		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=prune_user_refresh&record=$in{record}&forum_start=$newforum&thread_start=0&prune_reg_user=$in{prune_reg_user}",
		"We have marked about <b>$messages_to_prune</b> posts in forums <b>$forums_string</b> <br />So far, we have processed <b>$total_so_far</b> posts.  Currently processing forum <b>$forum_number</b>.<p>Please wait!</p>",
		"Prune by User",
		"Continuing Prune...",
		"3",
		);
	} #endif

} #endsub


sub PruneUserHistory {
	local(*FILE);

	die unless $in{record} =~ m/^[A-Za-z0-9]+$/;
	die unless $in{prune_reg_user} =~ m/^\d{8}$/;

	my @user_posts = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$in{prune_reg_user}.cgi");
	my @removals = &OpenFileAsArray("$vars_config{NonCGIPath}/cache-$cache_cookie/user-prune-removals-$in{record}.cgi");

	my %hash;
	foreach my $item (@user_posts) {
		chomp $item;
		my(@a) = split(/\|/, $item);
		my $thisitem = "$a[1]|$a[2]|$a[3]";
		$hash{$thisitem} = $item;
	} #endforeach

	foreach my $remove (@removals) {
		chomp $remove;
		delete $hash{$remove};
	}

	@user_posts = values %hash;

	&WriteFileAsArray("$vars_config{MembersPath}/user_posts/$in{prune_reg_user}.cgi", @user_posts);

	&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/user-prune-$in{record}.cgi") or die $!;
	&Unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/user-prune-removals-$in{record}.cgi") or die $!;

	&cp_confirm("Prune by User Complete", "You should rebuild the search index.");

} #endsub




sub prune_by_user_request {
	local (@this_forum, @user_profile, $user_perm, $user_number, @all_posts, @prunes, @this_topic, $topic_starter, $stat_line, $f, $t, $r, @req_profile, $reply_num, $reply_line, %exact_path, @forumfacts, $forum_line);

	# validate
	my @ValidateArray = ("prune_forum", "prune_reg_user");
	&Validate(@ValidateArray);

	# grab forum record
	@this_forum = &GetForumRecord($in{prune_forum});

	# grab user profile
	@user_profile = &verify_id_num($username, $password, $admin_number);

	# make sure user has authority
	$user_perm = &is_admin_or_mod($in{prune_forum}, @user_profile);
	unless ($user_perm eq "true") {
		&StandardHTML("$vars_wordlets_err{no_permission}");
	}

	$user_number = &Do8Digit($in{prune_reg_user});

	# get profile name
	@req_profile = &OpenProfile($user_number);
	$member_name = $req_profile[15];
	chomp($member_name);
	if ($member_name eq '') { $member_name = $req_profile[0]; }
	chomp($member_name);

	# get user's posts
	if (&FileExists("$vars_config{MembersPath}/user_posts/$user_number.cgi")) {
		@all_posts = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$user_number.cgi");
	}

	foreach (@all_posts) {chomp}

	# grep array
	if ($in{prune_forum} eq 'ALL') {
		@prunes     = @all_posts;
		$forum_line = 'ALL';
	} else {

		#@prunes = grep(/^\d{8}\|$in{prune_forum}\|/, @all_posts);

		foreach (@all_posts) {
			chomp;
			m/^(\d{8})\|(\d{1,})\|(\d{6})\|(\d{6})|\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
			push (@prunes, "$1|$2|$3|$4|$5") if $2 == $in{prune_forum};
		}

		$forum_line = qq~<A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum&f=$in{prune_forum}">$this_forum[1]</A>~;

	}


	# template
	$Hiddens = qq%
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="prune_submit">
<INPUT TYPE="HIDDEN" NAME="prune_option" VALUE="$in{prune_option}">
<INPUT TYPE="HIDDEN" NAME="prune_forum" VALUE="$in{prune_forum}">
<INPUT TYPE="HIDDEN" NAME="prune_reg_user" VALUE="$user_number">
%;
	$CurrentTab = qq%$vars_wordlets_cp{prune_request}%;

	# note: the wordlets are already required... no need to grab them

	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_prune_u_submit");
	&CPBottom;


}    # end prune_by_user_request
     # Danger- do not remove the following line!
1;
# $Id: cp_prune.cgi,v 1.8 2002/04/30 18:19:05 cvscapps Exp $