# Control panel - central library

sub Validate {
	local ($each);
	local (@splitter);
	local ($Redo);
	local ($BadLine);
	my $Redo = '';

	my @v = @_;

	foreach $each (@v) {
		chomp($each);

		if ($each !~ /\|/) {
			if ($in{$each} eq '') {
				$Redo = 'true';
				$BadLine .= "You did not complete: $each<BR>";
			}

		} else {

			#this is an AND list
			@splitter = split (/\|/, $each);
			$ok = "false";
			foreach $one (@splitter) {
				chomp($one);
				if ($in{$one}) { $ok = 'true'; }
			}

			if ($ok eq 'false') {
				$Redo = 'true';
				$BadLine .= "You must complete one of: $each<BR>";
			}


		}    #end single/OR
	}
	if ($Redo eq 'true') {
		&StandardHTML(qq%You did not complete all required fields.<P>$BadLine%);
	}

}    #end validate

sub CheckPermission_CP {

	# verify that user is an admin!
	$admin_number = &GetUserNumber($username);

	my @profile = &OpenProfile("$admin_number");
	chomp($profile[1]);
	chomp($profile[8]);
	chomp($profile[15]);
	chomp($profile[0]);

	#$public_name = $profile[15];
	if ($public_name eq "") {
		$public_name = $profile[0];
	}

	if (($profile[8] ne 'Administrator') && ($profile[8] ne 'Moderator')) {
		print qq%Content-type: text/html\n\n%;
		&AppendAdminLog($username, $status, "Log In", "Failed", "User is NOT an Admin or Mod");
		&StandardHTML("Sorry, you are not an administrator or moderator, so you may not gain access to the control panel.");
	}

	#return status
	&AppendAdminLog($username, $status, "Log In", "Succeeded", "User is a $profile[8]");
	$status = $profile[8];
}

sub StandardHTML {
	my $Text = shift;
	$CurrentTab = "FYI";
	&CPHeader;
	&CPFooter;
	&CPTop;
	$callers = "";#&Tracer;
	print qq!<P><CENTER>
<table border="0" width="95%">
<TR><TD><font face="verdana, arial" size="2">
<B>$Text</B>
<br />
<br />&#187; Use your browser's back button to return.
</font></TD></TR></TABLE></CENTER><P>!;
	&CPBottom;
	exit(0);
}


sub StandardHTML2 {
	if((caller(2))[0] =~ m/^UBB::FileHandle/) {
		&StandardHTML3(@_);
	}
	my $Text = shift;
	$CurrentTab = "Error";
	&CPHeader;
	&CPFooter;
	&CPTop;
	$callers = "";#&Tracer;
	print qq!<CENTER>
<table border="0" width="95%">
<TR><TD><font face="verdana, arial" size="2">
An error has occured:<br />
</font><pre><b>$Text</b></pre></TD></TR></TABLE></CENTER><P>!;
	&CPBottom;
	exit(0);
}


sub StandardHTML3 {
	print header(
		-charset => "$masterCharset",
		-type    => "text/html",
	);

	my $Text = join("", @_);
	$CurrentTab = "Fatal Error";
	&CPHeader;
	&CPFooter;
	&CPTop;
	$callers = "";#&Tracer;
	print qq!<CENTER>
<table border="0" width="95%">
<TR><TD><font face="verdana, arial" size="2">
An unexpected fatal error has occured:<br />
</font><pre><b>$Text</b></pre></TD></TR></TABLE></CENTER><P>!;
	&CPBottom;
	exit(0);
}


sub SetDefaults {

	if ($_[0] eq "vars_display") {

		#test to see if this vars file has been populated yet
		unless (exists $vars_display{AllowSignature}) {
			$vars_display{DaysPruneDefault}    = "20";
			$vars_display{CategoryView}        = "no";
			$vars_display{CategoriesOnly}      = "false";
			$vars_display{ShowPrivacyLink}     = "OFF";
			$vars_display{ForumDescriptions}   = "yes";
			$vars_display{ContactLinkType}     = "Email";
			$vars_display{showcopytype}        = "image";
			$vars_display{AllowSignature}      = "YES";
			$vars_display{AllowSignatureImage} = "no";
			$vars_display{ForumTotalOption}    = "Posts";
			$vars_display{ReverseThreads}      = "FALSE";
			$vars_display{DisplayMemberTotal}  = "true";
			$vars_display{NewestMemberWelcome} = "yes";
			$vars_display{AllowIcons}          = "TRUE";
			$vars_display{InlineFrame}         = "TRUE";
			$vars_display{ForumDisplayMax}     = "40";
			$vars_display{HTMLDisplayMax}      = "40";
			$vars_display{HotIcons}            = "ON";
			$vars_display{HotCount}            = "15";
			$vars_display{MembersOnlyAccess}   = "NO";
			$vars_display{author_location}     = "yes";
			$vars_display{author_post_total}   = "yes";
			$vars_display{author_reg_date}     = "yes";
			$vars_display{ShowMods}            = "yes";
			$vars_display{homepage_icon_link}  = "yes";
			$vars_display{EmailBlock}          = "OFF";
		}


		if ($vars_display{author_location} eq 'yes')   { $author_location_select   = 'CHECKED'; }
		if ($vars_display{author_post_total} eq 'yes') { $author_post_total_select = 'CHECKED'; }
		if ($vars_display{author_reg_date} eq 'yes')   { $author_reg_date_select   = 'CHECKED'; }

		if ($vars_display{user_ratings} eq '') { $vars_display{user_ratings} = 'feature_top'; }

	}    #end vars_display default


	if ($_[0] eq 'vars_email') {

		if ($vars_email{SMTPEmail} eq '') {
			$vars_email{UseEmail}     = 'ON';
			$vars_email{UBBFriendUSE} = 'ON';
			$vars_email{SMTPEmail}    = 'Off';
			$vars_email{email_format} = 'html';
		}

		if ($vars_email{SendMailLocation} eq '') {

			# look for sendmail location in usual spots--
			if (&FileExists("/usr/bin/sendmail")) {
				$vars_email{SendMailLocation} = '/usr/bin/sendmail';
			} elsif (&FileExists("/usr/sbin/sendmail")) {
				$vars_email{SendMailLocation} = '/usr/sbin/sendmail';
			} elsif (&FileExists("/usr/lib/sendmail")) {
				$vars_email{SendMailLocation} = '/usr/lib/sendmail';
			} else {
				$vars_email{SendMailLocation} = '';
			}
		}    #unless sendmail blank
	}    #end vars_email default

	if ($_[0] eq 'vars_time') {
		unless (exists $vars_time{DateFormat}) {
			$vars_time{DateFormat}     = 'US';
			$vars_time{TimeZone}       = 'ET';
			$vars_time{TimeZoneOffset} = '0';
			$vars_time{TimeFormat}     = 'AMPM';
		}
	}    #end vars_time default

	if ($_[0] eq 'vars_pm') {
		unless (exists $vars_pm{ubb_code}) {
			$vars_pm{ubb_code} = 'on';
			$vars_pm{html}     = 'off';
			$vars_pm{feature}  = 'on';
		}
	}    #end vars_pm default

	if ($_[0] eq 'vars_registration') {
		unless (exists($vars_registration{DisplayRegistration})) {
			$vars_registration{location_field_use}   = 'OPT';
			$vars_registration{occupation_field_use} = 'OPT';
			$vars_registration{interests_field_use}  = 'OPT';
			$vars_registration{picture_field_use}    = 'DEL';
			$vars_registration{icq_field_use}        = 'OPT';
			$vars_registration{aim_field_use}        = 'OPT';
			$vars_registration{homepage_field_use}   = 'OPT';
			$vars_registration{signature_field_use}  = 'OPT';
			$vars_registration{EmailVerify}          = 'OFF';
			$vars_registration{EmailCheck}           = 'false';
			$vars_registration{COPPACheck}           = 'ON';
			$vars_registration{COPPAType}            = 'COPPADenied';
			$vars_registration{ModerateRegs}         = 'OFF';
			$vars_registration{OnRegsNotifyAdmin}    = 'COPPA';
			$vars_registration{SuspendRegister}      = 'false';
			$vars_registration{allowHighBit}         = 'YES';
			$vars_registration{DisplayRegistration}  = 'YES';
			$vars_registration{BBRules}              = q~Considering the real-time nature of this message board, it is impossible for us to review messages or confirm the validity of information posted.  Please remember that we do not actively monitor the contents of posted messages and are not responsible for any messages posted. We do not vouch for or warrant the accuracy, completeness or usefulness of any message, and are not responsible for the contents of any message. The messages express the views of the author of the message, not necessarily the views of this BB or any entity associated with this BB. Any user who feels that a posted message is objectionable is encouraged to contact us immediately by email.  We have the ability to remove objectionable messages and we will make every effort to do so, within a reasonable time frame, if we determine that removal is necessary.  This is a manual process, however, so please realize that we may not be able to remove or edit particular messages immediately.

You agree, through your use of this service, that you will not use this BB to post any material which is knowingly false and/or defamatory, inaccurate, abusive, vulgar, hateful, harassing, obscene, profane, sexually oriented, threatening, invasive of a person's privacy, or otherwise violative of any law. You agree not to post any copyrighted material unless the copyrighted material is owned by you.

Although we do not and cannot review the messages posted and are not responsible for the content of any of these messages, we reserve the right to delete any message for any reason whatsoever. You remain solely responsible for the content of your messages, and you agree to indemnify and hold us harmless with respect to any claim based upon transmission of your message(s).

We reserve the right to reveal your identity (or whatever information we know about you) in the event of a complaint or legal action arising from any message posted by you.~;
		}
	}    #end vars_registration default


	if ($_[0] eq 'vars_search') {
		unless (exists $vars_search{AllowSearch}) {
			$vars_search{AllowSearch}      = 'TRUE';
			$vars_search{AllowTotalSearch} = 'TRUE';
			$vars_search{IndexMethod}      = 'ONEFILE';
		}
	}    #end vars_search default

	if ($_[0] eq 'vars_misc') {
		unless (exists $vars_misc{ReplyQuote}) {
			$vars_misc{ReplyQuote}          = 'YES';
			$vars_misc{BBStatus}            = 'ON';
			$vars_misc{BBClosedMessage}     = 'Sorry, this message board is temporarily closed while we do some routine maintenance.';
			$vars_misc{MemberMinimum}       = '31';
			$vars_misc{AdminTitle}          = 'Administrator';
			$vars_misc{ModeratorTitle}      = 'Moderator';
			$vars_misc{MemberTitle}         = 'Member';
			$vars_misc{JrMemberTitle}       = 'Junior Member';
			$vars_misc{Censor}              = 'ON';
			$vars_misc{EditOption}          = 'ON';
			$vars_misc{EditWording}         = 'yes';
			$vars_misc{IP}                  = 'LOGONLY';
			$vars_misc{EnglishSubjectCheck} = 'ON';
			$vars_misc{FloodCheck}          = 'ON';
			$vars_misc{FloodCheckSpan}      = '30';
			$vars_misc{edit_public_names}   = 'YES';
			$vars_misc{BBStatus}            = 'ON';
			$vars_misc{use_cache}           = 'yes';
		}

		if ($vars_misc{use_cache} eq '') { $vars_misc{use_cache} = 'yes'; }

	}    #end vars_misc default


	if ($_[0] eq 'vars_config') {

	}    #end vars_config default


	if ($_[0] eq 'vars_style') {
		unless (exists($vars_style{ubb_friend_mini})) {
			$vars_style{ubb_friend_mini} = "ubb_friend_mini.gif";
		}
		unless (exists $vars_style{user_ratings_3}) {
			$vars_style{BGColor}                = '#FFFFFF';
			$vars_style{TextColor}              = '#000000';
			$vars_style{LinkColor}              = '#333333';
			$vars_style{VisitedLinkColor}       = '#330099';
			$vars_style{ActiveLinkColor}        = '#5d7790';
			$vars_style{TableBorderColor}       = '#000000';
			$vars_style{TableStripTextColor}    = '#FFFFFF';
			$vars_style{TableColorStrip}        = '#5d7790';
			$vars_style{TimeColor}              = '#333333';
			$vars_style{AltColumnColor1}        = '#f7f7f7';
			$vars_style{AltColumnColor2}        = '#dedfdf';
			$vars_style{CategoryStripColor}     = '#d0783f';
			$vars_style{CategoryStripTextColor} = '#FFFFFF';
			$vars_style{CopyrightTextColor}     = '#5d7790';
			$vars_style{BBTitleFontColor}       = '#5d7790';
			$vars_style{hr_color}               = '#000000';
			$vars_style{FontFace}               = 'Arial, Helvetica, sans-serif';
			$vars_style{TableWidth}             = '95%';
			$vars_style{TextSize}               = '2';
			$vars_style{FDTextSize}             = '1';
			$vars_style{BBTitle}                = 'bbtitle.gif';
			$vars_style{BBTopic}                = 'topic_ot.gif';
			$vars_style{BBReply}                = 'reply_ot.gif';
			$vars_style{search_graphic}         = 'searchhead.gif';
			$vars_style{profilegif}             = 'profile_ubb6.gif';
			$vars_style{edit_icon}              = 'edit_ubb6.gif';
			$vars_style{reply_with_quote_icon}  = 'quote_ubb6.gif';
			$vars_style{homepage_icon}          = 'homepage.gif';
			$vars_style{mailgif}                = 'email_ubb6.gif';
			$vars_style{forum_summ_on}          = 'on.gif';
			$vars_style{forum_summ_off}         = 'off.gif';
			$vars_style{new_topic_folder}       = 'closedb.gif';
			$vars_style{old_topic_folder}       = 'closed.gif';
			$vars_style{hot_new_topic_folder}   = 'hotclosedb.gif';
			$vars_style{hot_old_topic_folder}   = 'hotclosed.gif';
			$vars_style{old_locked_folder}      = 'yellockfolder.gif';
			$vars_style{new_locked_folder}      = 'redlockfolder.gif';
			$vars_style{plain_old_regular_lock} = 'lock.gif';
			$vars_style{ubb_friend}             = 'ubbfriend.gif';
			$vars_style{ubb_friend_mini}        = 'ubb_friend_mini.gif';
			$vars_style{close_topic}            = 'close_topic.gif';
			$vars_style{open_topic}             = "open_topic.gif";
			$vars_style{move_topic}             = "move_topic.gif";
			$vars_style{delete_topic}           = "delete_topic.gif";
			$vars_style{prev_topic}             = "prev_topic.gif";
			$vars_style{next_topic}             = "next_topic.gif";
			$vars_style{priv_message}           = "priv_message.gif";
			$vars_style{user_ratings_1}         = "user_ratings_1.gif";
			$vars_style{user_ratings_2}         = "user_ratings_2.gif";
			$vars_style{user_ratings_3}         = "user_ratings_3.gif";
			$vars_style{user_ratings_4}         = "user_ratings_4.gif";
			$vars_style{user_ratings_5}         = "user_ratings_5.gif";
		}
	}    #end vars_style default


}    #end setdefaults

sub view_vars {
	local (@forums, @check, @mods, $Moderator, $x, $REQ, $DEL, $OPT);
	local ($author_location_select, $author_reg_date_select, $author_post_total_select, @user_profile, @display_name, @blank);

	$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="set_vars_$_[0]">%;

	my $file = ( $_[0] eq "avatar" ? "display" : $_[0] );

	#retrieve current vars
	&RequireVars("$vars_config{VariablesPath}/vars_$file.cgi");

	# if these settings have not been set before,
	# let's give UBBer some direction :)
	&SetDefaults("vars_$file");

	&InitImportantStuff;

	#if doing mods, need to get forum file
	if ($_[0] eq 'mods') { @forums = &OpenForumsFile; }

	# Set the page title
	if ($_[0] eq 'display')         { $CurrentTab = qq%$vars_wordlets_cp{display_settings}%; }
	elsif ($_[0] eq 'email')        { $CurrentTab = qq%$vars_wordlets_cp{email_settings}%; }
	elsif ($_[0] eq 'avatar')       { $CurrentTab = qq%$vars_wordlets_cp{avatar_settings}%; }
	elsif ($_[0] eq 'registration') { $CurrentTab = qq%$vars_wordlets_cp{registration_settings}%; }
	elsif ($_[0] eq 'config')       { $CurrentTab = qq%$vars_wordlets_cp{config_settings}%; }
	elsif ($_[0] eq 'mods')         { $CurrentTab = qq%$vars_wordlets_cp{moderator_settings}%; }
	elsif ($_[0] eq 'misc')         { $CurrentTab = qq%$vars_wordlets_cp{misc_settings}%; }
	elsif ($_[0] eq 'pm')           { $CurrentTab = qq%$vars_wordlets_cp{pm_settings}%; }
	elsif ($_[0] eq 'pntf')         { $CurrentTab = qq%$vars_wordlets_cp{pntf_settings}%; }
	elsif ($_[0] eq 'poll')         { $CurrentTab = qq%Polling Settings%; }
	elsif ($_[0] eq 'search')       { $CurrentTab = qq%$vars_wordlets_cp{search_settings}%; }
	else {
		$CurrentTab = qq%$vars_wordlets_cp{time_settings}%;
	}

	&AppendAdminLog($username, $status, "Viewed Variables", "Succeeded", "$_[0]");


	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_vars_$_[0]");
	&CPBottom;
}    #end view_vars


sub RemoveDupes {
	local ($unomas, $dupe, $duper);
	my @dupecheckthis = @_;
	my @goodones      = ();

	foreach $unomas (@dupecheckthis) {
		if ($unomas ne '') {
			chomp($unomas);
			$dupe = 'no';

			foreach $duper (@goodones) {
				if ($unomas eq "$duper") { $dupe = 'yes'; }
			}
			if ($dupe ne 'yes') { push (@goodones, $unomas); }

		}
	}
	return (@goodones);
}

sub cp_entry_page {
	local ($cache_hits, $dynamic_hits, @the_members, @forums, $forum_total, $member_count, $bb_status, $monthly_hits);

	# get member count
	$member_count = &GetMemberTotal;

	# get forum count
	@forums      = &OpenForumsFile;
	$forum_total = @forums;

	# get page views for month
	if (&FileExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi")) {
		$monthly_hits = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}.cgi");
		chomp($monthly_hits);
	} else {
		$monthly_hits = 0;
	}

	# get page views for month - DYNAMIC
	if (&FileExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}-dynamic.cgi")) {
		$dynamic_hits = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}-dynamic.cgi");
		chomp($dynamic_hits);
	} else {
		$dynamic_hits = 0;
	}

	# get page views for month - CACHED
	if (&FileExists("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}-cache.cgi")) {
		$cache_hits = &OpenFileAsVar("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/counter/$GotTime{JSYear}-$GotTime{mon}-cache.cgi");
		chomp($cache_hits);
	} else {
		$cache_hits = 0;
	}

	# is forum open?
	local ($toggle_link);
	&RequireVars("$vars_config{VariablesPath}/vars_misc.cgi");
	if ($vars_misc{BBStatus} eq 'ON') {
		$bb_status   = 'OPEN';
		$toggle_link = qq!<a href="$vars_config{CGIURL}/cp.cgi?ubb=toggle_off">Close Board</a>!;
	} else {
		$bb_status   = 'CLOSED';
		$toggle_link = qq!<a href="$vars_config{CGIURL}/cp.cgi?ubb=toggle_on">Open Board</a>!;
	}

	$CurrentTab = qq%Welcome to the UBB.classic$trade Control Panel!%;
	&CPHeader;
	&CPFooter;

	&CPTop;
	&LoadTemplate("cp_entry");
	&CPBottom;

}    # end entry page


sub QueryLogin {

	#query user for identification!
	local ($new_admin_wording);

	# have any members been created yet?
	my $lastnum = &GetLastMemberNumber;
	$lastnum = $lastnum + 0;
	if ($lastnum == 0) {
		unless (&FileExists("$vars_config{MembersPath}/memberslist.cgi")) {
			$new_admin_wording = qq~<P>Important Note: you need to create a new administrator account in order to access your UBB.classic control panel.  Please set up your admin profile by <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=register_page" target=_new>clicking here</A>.  After you are done, return to this page and login!~;
		}
	} else {
		$new_admin_wording = '';

	}

	$Hiddens    = qq!<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="entry">!;
	$CurrentTab = qq!Login Request!;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_query_admin");
	&CPBottom;

	exit(0);
}

sub set_vars_pm {
	local (*FILE);
	local ($ubb_code_images, $welcome_message);

	$CurrentTab = qq%$vars_wordlets_cp{pm_settings}%;
	&CPHeader;
	&CPFooter;

	#validate
	my @ValidateArray = ("html", "ubb_code", "feature");
	&Validate(@ValidateArray);


	# clean welcome
	if ($in{welcome_pm_message} ne '') {
		$welcome_message = &SmallClean2($in{welcome_pm_message});

		## IF HTML is not allowed, render HTML useless
		if ($in{html} eq 'off') {
			$welcome_message =~ s/</&lt;/g;
			$welcome_message =~ s/>/&gt;/g;
		} else {

			# don't allow HTML SCRIPT TAGS
			&check_html($welcome_message);
		}

		$welcome_message = &Smilies($welcome_message);

		# UBB Code-ify
		if ($in{ubb_code} ne 'off') {
			if ($in{ubb_code} eq 'on') {
				$ubb_code_images = 'ON';
			} else {
				$ubb_code_images = 'OFF';
			}
			$welcome_message = &UBBCode("$welcome_message", "$ubb_code_images");
		}    #end if UBB Code allowed

		# convert newlines/carriage returns to <br> and <p> html tags
		$welcome_message = &ConvertReturns("$welcome_message");
		$welcome_message = &PipeCleaner("$welcome_message");
	} else {
		$welcome_message = '';
	}

	# write to file!

	my %new_vars_pm = (
		%vars_pm,
		feature            => "$in{feature}",
		welcome_pm_message => "$welcome_message",
		ubb_code           => "$in{ubb_code}",
		html               => "$in{html}",
		welcome_pm         => "$in{welcome_pm}",
	);

	&WriteHashToFile("$vars_config{VariablesPath}/vars_pm.cgi", "vars_pm", \%new_vars_pm);

	# clear cache
	&ClearForumTopicsCache;

	&AppendAdminLog($username, $status, "Submitted PM Vars", "Succeeded", "", 1);


	&cp_confirm("$vars_wordlets_cp{pm_settings} Updated");
	exit(0);

}    #end set_vars_pm

sub set_vars_display {
	local (*FILE);

	$CurrentTab = qq%$vars_wordlets_cp{display_settings}%;
	&CPHeader;
	&CPFooter;

	#validate
	my @ValidateArray = qw(ShowHomepageLink ShowContactUsLink
	PopupWidth PopupHeight HomePageURL MyHomePage BBEmail ContactLinkType
	DaysPruneDefault ShowMods CategoryView CategoriesOnly ForumDescriptions
	ForumDisplayMax HTMLDisplayMax NewestMemberWelcome homepage_icon_link
	AllowSignature HotIcons user_ratings DisplayMemberTotal PreviewPost);

	if($in{ShowPrivacyLink} eq "ON") {
		push(@ValidateArray, "PrivacyURL");
	} # end if

	&Validate(@ValidateArray);

	# set/clean the vars ------------
	my $HomePageURL         = &SmallClean3($in{HomePageURL});
	my $PrivacyURL          = &SmallClean3($in{PrivacyURL});
	my $MyHomePage          = &SmallClean3($in{MyHomePage});
	my $BBEmail             = &SmallClean3($in{BBEmail});
	my $ContactURL          = &SmallClean3($in{ContactURL});
	my $YourCopyrightNotice = &SmallClean3($in{YourCopyrightNotice});

	# limit/eliminate/convert returns in some fields
	$YourCopyrightNotice = &EliminateReturns($YourCopyrightNotice);
	$BBEmail             = &EliminateReturns($BBEmail);

	# clean forum_intro
	#my $forum_intro = &SmallClean($in{forum_intro});
	my $forum_intro = &ConvertReturns($in{forum_intro});
	# $forum_intro = &Smilies($forum_intro);

	# idiot-proof
	if ($in{CategoriesOnly} eq "true") {
		$in{CategoryView} = "yes";
	}

	# write to file!
	my %vars_display_new = (
		%vars_display,
		'HomePageURL'         => $HomePageURL,
		'PrivacyURL'          => $PrivacyURL,
		'MyHomePage'          => $MyHomePage,
		'BBEmail'             => $BBEmail,
		'ContactURL'          => $ContactURL,
		'forum_intro'         => $forum_intro,
		'ContactLinkType'     => $in{ContactLinkType},
		'DaysPruneDefault'    => $in{DaysPruneDefault},
		'YourCopyrightNotice' => $YourCopyrightNotice,
		'CategoryView'        => $in{CategoryView},
		'CategoriesOnly'      => $in{CategoriesOnly},
		'ForumDescriptions'   => $in{ForumDescriptions},
		'ShowPrivacyLink'     => $in{ShowPrivacyLink},
		'showcopytype'        => $in{showcopytype},
		'AllowSignature'      => $in{AllowSignature},
		'AllowSignatureImage' => $in{AllowSignatureImage},
		'ForumTotalOption'    => $in{ForumTotalOption},
		'ReverseThreads'      => $in{ReverseThreads},
		'DisplayMemberTotal'  => $in{DisplayMemberTotal},
		'NewestMemberWelcome' => $in{NewestMemberWelcome},
		'AllowIcons'          => $in{AllowIcons},
		'InlineFrame'         => $in{InlineFrame},
		'ForumDisplayMax'     => $in{ForumDisplayMax},
		'HTMLDisplayMax'      => $in{HTMLDisplayMax},
		'HotIcons'            => $in{HotIcons},
		'HotCount'            => $in{HotCount},
		'MembersOnlyAccess'   => $in{MembersOnlyAccess},
		'author_location'     => $in{author_location},
		'author_reg_date'     => $in{author_reg_date},
		'author_post_total'   => $in{author_post_total},
		'ShowMods'            => $in{ShowMods},
		'user_ratings'        => $in{user_ratings},
		'homepage_icon_link'  => $in{homepage_icon_link},
		'EmailBlock'          => $in{EmailBlock},
		'masterCharset'       => $in{masterCharset},
		'RequireLoginPosts'   => $in{RequireLoginPosts},
		'PrintTopic' 	      => $in{PrintTopic},
		'PreviewPost'	      => $in{PreviewPost},
		'PopupHeight'	      => $in{PopupHeight},
		'PopupWidth'	      => $in{PopupWidth},
		'ShowHomepageLink'    => $in{ShowHomepageLink},
		'ShowContactUsLink'   => $in{ShowContactUsLink},
	);

	&WriteHashToFile("$vars_config{VariablesPath}/vars_display.cgi", "vars_display", \%vars_display_new);

	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;
	&ClearSummaryCache;
	&ClearMiscCache;

	&CheckAccel;

	&AppendAdminLog($username, $status, "Submitted Display Vars", "Succeeded", "", 1);


	&cp_confirm("Display Settings Updated");
	exit(0);

}    #end set_vars_display


sub set_vars_avatar {
	local (*FILE);

	$CurrentTab = qq%$vars_wordlets_cp{avatar_settings}%;
	&CPHeader;
	&CPFooter;

	#validate
	my @ValidateArray = qw(UseAvatars AvatarForceSize AvatarHeight AvatarWidth
	AvatarFileExts AvatarPopupCols AvatarPopupRows AvatarPopupHeight AvatarPopupWidth
	AvatarRemoteFileExts);

	&Validate(@ValidateArray);

	my %vars_display_new = (
		%vars_display,
		'UseAvatars'		=> $in{UseAvatars},
		'AvatarForceSize'	=> $in{AvatarForceSize},
		'AvatarHeight'		=> $in{AvatarHeight},
		'AvatarWidth'		=> $in{AvatarWidth},
		'AvatarFileExts'	=> '\.(' . join("|", split(/[\s\.]+/, &strip_lead_trail_space($in{AvatarFileExts}))) . ")",
		'AvatarPopupCols'	=> $in{AvatarPopupCols},
		'AvatarPopupRows'	=> $in{AvatarPopupRows},
		'AvatarPopupHeight'	=> $in{AvatarPopupHeight},
		'AvatarPopupWidth'	=> $in{AvatarPopupWidth},
		'AvatarRemoteFileExts'  => '\.(' . join("|", split(/[\s\.]+/, &strip_lead_trail_space($in{AvatarRemoteFileExts}))) . ")",
		'AvatarIntroText'	=> &strip_lead_trail_whitespace($in{AvatarIntroText}),
	);

	# Breaking encapsulation?  Bad Charles!  Go to your room!
	my @avatar_allow = map { s/^av_allow_(.+)$/$1/; $_; } grep(/^av_allow/, keys %in);
	my @avatar_custom = map { s/^av_custom_(.+)$/$1/; $_; } grep(/^av_custom/, keys %in);
	$vars_groups->{GROUPS}->{"avatars"}->{"perms"}->{"use"} = \@avatar_allow;
	$vars_groups->{GROUPS}->{"avatars"}->{"perms"}->{"custom"} = \@avatar_custom;
	$vars_groups->write_groups();

	&WriteHashToFile("$vars_config{VariablesPath}/vars_display.cgi", "vars_display", \%vars_display_new);


	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;
	&ClearSummaryCache;
	&ClearMiscCache;

	&CheckAccel;

	&AppendAdminLog($username, $status, "Submitted Avatar Vars", "Succeeded", "", 1);

	&cp_confirm("Avatar Settings Updated");
	exit(0);
} # end set_vars_avatar

sub CheckAccel {
	if((&FileExists("$vars_config{NonCGIPath}/ultimatebb.php")) && ($vars_config{EnableAccel} ne 'NO')) {
		# UBB Accelerator - courtesy Philipp Esselbach (philipp@ntcompatible.com)
		&Unlink("$vars_config{NonCGIPath}/vars_config.inc.php")
		&RequireCode("$vars_config{VariablesPath}/vars_display.cgi");
		&RequireCode("$vars_config{VariablesPath}/vars_misc.cgi");
		&RequireCode("$vars_config{CGIPath}/cp_ubbacc.cgi");
		&do_prepare;
	}
} # end CheckAccel

sub logout {
	&AppendAdminLog($username, $status, "Logged Out", "Succeeded", "");

	my $cookie = cookie(
		-name    => "ubbadmin$vars_config{Cookie_Number}",
		-value   => [$username, $password, $status],
		-path    => '/',
		-expires => '-1d'
	);
	print header(-cookie => $cookie);

	$username = '';
	&LoadTemplate("cp_common");
	$CurrentTab   = qq%Login%;
	$LoginWording = qq%<FONT COLOR="Navy">&#187;</FONT> Not logged in! <FONT COLOR="Navy">&#171;</FONT>%;
	&CPHeader;
	&CPFooter;
	&QueryLogin;
	exit(0);
}

sub set_vars_email {
	local (*FILE);

	$CurrentTab = qq%$vars_wordlets_cp{email_settings}%;
	&CPHeader;
	&CPFooter;

	# bug spray
	&CheckBadChars("$in{SendMailLocation} $in{EmailServer}");    # check for invalid chars

	#validate
	my @ValidateArray = ("UseEmail", "SMTPEmail", "UBBFriendUSE", "email_format");
	&Validate(@ValidateArray);

	#also check--
	unless($in{UseEmail} eq "OFF") {
		if (($in{SMTPEmail} eq 'Off') && ($in{SendMailLocation} eq '')) {
			&StandardHTML("Error!<P>You must provide a SendMail Location if you are using SendMail. Use you browser's back button to add.");
		}
		if (($in{SMTPEmail} eq 'On') && ($in{EmailServer} eq '')) {
			&StandardHTML("Error!<P>You must provide an SMTP Server Name if you are using SMTP Email. Use you browser's back button to add.");
		}
	} #endunless

	# set/clean the vars ------------
	my $SendMailLocation = &SmallClean3(&strip_lead_trail_space($in{SendMailLocation}));
	my $EmailServer      = &SmallClean3(&strip_lead_trail_space($in{EmailServer}));

	# write to file!

	my %vars_email_new = (
		%vars_email,
		'UseEmail'         => "$in{UseEmail}",
		'SMTPEmail'        => "$in{SMTPEmail}",
		'SendMailLocation' => $SendMailLocation,
		'EmailServer'      => $EmailServer,
		'email_format'     => "$in{email_format}",
		'UBBFriendUSE'     => "$in{UBBFriendUSE}",
	);

	&WriteHashToFile("$vars_config{VariablesPath}/vars_email.cgi", "vars_email", \%vars_email_new);

	&AppendAdminLog($username, $status, "Submitted Email Vars", "Succeeded", "", 1);


	# clear cache
	&ClearForumTopicsCache;
	&cp_confirm("Email Settings Updated");
	exit(0);

}    #end set_vars_email

sub set_vars_time {
	local (*FILE);

	$CurrentTab = qq%$vars_wordlets_cp{time_settings}%;
	&CPHeader;
	&CPFooter;

	# bug spray
	&CheckBadChars("$in{TimeZone} $in{TimeZoneOffset}");    # check for invalid chars

	#validate
	my @ValidateArray = ("DateFormat", "TimeFormat");
	&Validate(@ValidateArray);

	# set/clean the vars ------------
	my $TimeZone       = &SmallClean3($in{TimeZone});
	my $TimeZoneOffset = &SmallClean3($in{TimeZoneOffset});

	# write to file!

	my %vars_time_new = (
		%vars_time,
		'TimeZone'       => $TimeZone,
		'TimeZoneOffset' => $TimeZoneOffset,
		'DateFormat'     => "$in{DateFormat}",
		'TimeFormat'     => "$in{TimeFormat}",
	);

	&WriteHashToFile("$vars_config{VariablesPath}/vars_time.cgi", "vars_time", \%vars_time_new);

	&AppendAdminLog($username, $status, "Submitted Time Vars", "Succeeded", "", 1);


	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;
	&ClearSummaryCache;

	&cp_confirm("Time Settings Updated");
	exit(0);

}    #end set_vars_time


sub set_vars_pntf {
	$CurrentTab = qq%Recent Visitors Settings%;
	&CPHeader;
	&CPFooter;

	#validate
	&Validate(qw(Enabled Mode TopBottom Docked CountOnly NameLimit Timeout ForumListCutoff TopicListCutoff KeepRecord));

	my $prune =	(exists($in{Prune}) ? &SmallClean3($in{Prune}) : 0 );
	my $import =	(exists($in{Import}) ? &SmallClean3($in{Import}) : 0 );
	my $uniqs =	(exists($in{UNIQIDsPerIP}) ? &SmallClean3($in{UNIQIDsPerIP}) : 15 );
	my $timeout =	(exists($in{Timeout}) ? &SmallClean3($in{Timeout}) : 0 );
	my $fcut =	(exists($in{ForumListCutoff}) ? &SmallClean3($in{ForumListCutoff}) : 0 );
	my $tcut =	(exists($in{TopicListCutoff}) ? &SmallClean3($in{TopicListCutoff}) : 0 );
	my $users =	(exists($in{UsersToList}) ? &SmallClean3($in{UsersToList}) : 0 );
	my $namel =	(exists($in{NameLimit}) ? &SmallClean3($in{NameLimit}) : 0 );

	# write to file!
	my %vars_pntf_new = (
		%vars_pntf,
		Enabled => $in{Enabled},
		Mode => $in{Mode},
		Timeout => &SmallClean3($in{Timeout}),
		Prune => $prune,
		Import => $import,
		UNIQIDsPerIP => $uniqs,
		ForumListCutoff => $fcut,
		TopicListCutoff => $tcut,
		KeepRecord => $in{KeepRecord},
		UsersToList => $users,
		TopBottom => $in{TopBottom},
		Docked => $in{Docked},
		CountOnly => $in{CountOnly},
		NameLimit => $namel,
		LastSeen => $in{LastSeen},
	);

	&WriteHashToFile("$vars_config{VariablesPath}/vars_pntf.cgi", "vars_pntf", \%vars_pntf_new);

	&AppendAdminLog($username, $status, "Submitted PNTF Vars", "Succeeded", "", 1);


	if($in{ResetPNTF} eq "yes") {
		&Unlink("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/pntf/now.cgi");
		&Unlink("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/pntf/now_accel.cgi");
	} # end if

	if($in{ResetRecord} eq "yes") {
		&RequireCode("ubb_lib_pntf.cgi");
		&RequireCode("ubb_lib_dumper.cgi");
		import Data::ThatWhichDumps;

		$PNTF = UBB::PNTF->new(\%vars_config, UBB::FileHandler->new(\%vars_config, "pntf"), \%vars_pntf_new);
		$PNTF->load();
		$PNTF->reset_record();
		$PNTF->write();	# closes the file
		$PNTF = undef;
	} # end if

	# clear cache
	&ClearForumPageCache;
	&ClearSummaryCache;
	&ClearPNTFCache;

	&cp_confirm("Recent Visitors Settings Updated");
	exit(0);

}    #end set_vars_pntf



sub set_vars_poll {
	$CurrentTab = qq%Polling Settings%;
	&CPHeader;
	&CPFooter;

	#validate
	my @ValidateArray = ("Enabled");
	&Validate(@ValidateArray);

	# write to file!

	my %vars_poll_new = (
		%vars_poll,
		'Enabled'       => $in{Enabled},
	);

	&WriteHashToFile("$vars_config{VariablesPath}/vars_poll.cgi", "vars_poll", \%vars_poll_new);

	&AppendAdminLog($username, $status, "Submitted Poll Vars", "Succeeded", "", 1);

	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;

	&cp_confirm("Polling Settings Updated");
	exit(0);

}    #end set_vars_poll



sub set_vars_registration {
	local (*FILE);

	$CurrentTab = qq%$vars_wordlets_cp{registration_settings}%;
	&CPHeader;
	&CPFooter;

	#validate
	my @ValidateArray = ("BBRules", "EmailVerify", "EmailCheck", "COPPACheck", "COPPAType", "ModerateRegs", "OnRegsNotifyAdmin", "SuspendRegister", "allowHighBit", "DisplayRegistration", "RegsAdminEmail", "bdate_field_use");
	&Validate(@ValidateArray);

	# set/clean the vars ------------
	my $RegsAdminEmail    = &SmallClean3($in{RegsAdminEmail});
	my $BBRules           = &SmallClean3($in{BBRules});
	my $COPPAWording      = &SmallClean3($in{COPPAWording});
	my $COPPAInstructions = &SmallClean3($in{COPPAInstructions});
	my $CustomField1      = &SmallClean3($in{customfield1});
	my $CustomField2      = &SmallClean3($in{customfield2});
	my $CustomField3      = &SmallClean3($in{customfield3});
	my $CustomField4      = &SmallClean3($in{customfield4});

	# limit/eliminate/convert returns in some fields
	$BBRules           = &LimitReturns($BBRules);
	$COPPAWording      = &LimitReturns($COPPAWording);
	$COPPAInstructions = &LimitReturns($COPPAInstructions);
	$RegsAdminEmail    = &EliminateReturns($RegsAdminEmail);


	# write to file!
	my %vars_registration_new = (
		%vars_registration,
		'location_field_use'   => "$in{location_field_use}",
		'occupation_field_use' => "$in{occupation_field_use}",
		'picture_field_use'    => "$in{picture_field_use}",
		'homepage_field_use'   => "$in{homepage_field_use}",
		'interests_field_use'  => "$in{interests_field_use}",
		'custom1_field_use'    => "$in{custom1_field_use}",
		'custom2_field_use'    => "$in{custom2_field_use}",
		'custom3_field_use'    => "$in{custom3_field_use}",
		'custom4_field_use'    => "$in{custom4_field_use}",
		'customfield1'         => $CustomField1,
		'customfield2'         => $CustomField2,
		'customfield3'         => $CustomField3,
		'customfield4'         => $CustomField4,
		'icq_field_use'        => "$in{icq_field_use}",
		'aim_field_use'        => "$in{aim_field_use}",
		'signature_field_use'  => "$in{signature_field_use}",
		'bdate_field_use'      => "$in{bdate_field_use}",
		'EmailVerify'          => "$in{EmailVerify}",
		'EmailCheck'           => "$in{EmailCheck}",
		'COPPACheck'           => "$in{COPPACheck}",
		'COPPAType'            => "$in{COPPAType}",
		'ModerateRegs'         => "$in{ModerateRegs}",
		'OnRegsNotifyAdmin'    => "$in{OnRegsNotifyAdmin}",
		'SuspendRegister'      => "$in{SuspendRegister}",
		'allowHighBit'         => "$in{allowHighBit}",
		'DisplayRegistration'  => "$in{DisplayRegistration}",
		'RegsAdminEmail'       => $RegsAdminEmail,
		'BBRules'              => $BBRules,
		'COPPAWording'         => $COPPAWording,
		'COPPAInstructions'    => $COPPAInstructions,
	);

	&WriteHashToFile("$vars_config{VariablesPath}/vars_registration.cgi", "vars_registration", \%vars_registration_new);



	&AppendAdminLog($username, $status, "Submitted Registration Vars", "Succeeded", "", 1);


	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;
	&ClearSummaryCache;

	&cp_confirm("Registration Settings Updated");
	exit(0);

}    #end set_vars_registration

sub set_vars_search {
	local (*FILE);

	$CurrentTab = qq%$vars_wordlets_cp{search_settings}%;
	&CPHeader;
	&CPFooter;

	#validate
	my @ValidateArray = ("AllowSearch", "AllowTotalSearch", "IndexMethod", "removelist", "truncateat");
	&Validate(@ValidateArray);

	# write to file!

	my %jlist;
	foreach my $word (split(/[\s\n\r]+/, $in{removelist})) {
		$word =~ s/[^a-zA-Z0-9\x7E-\xFF]//g;
		$jlist{lc($word)}++;
	} # end foreach
	my $joinlist = join("|", sort keys %jlist);

	my %vars_search_new = (
		%vars_search,
		'AllowSearch'      => $in{AllowSearch},
		'AllowTotalSearch' => $in{AllowTotalSearch},
		'IndexMethod'      => $in{IndexMethod},
		'removelist'	   => $joinlist,
		'truncateat'	   => $in{truncateat},
	);

	&WriteHashToFile("$vars_config{VariablesPath}/vars_search.cgi", "vars_search", \%vars_search_new);


	&AppendAdminLog($username, $status, "Submitted Search Vars", "Succeeded", "", 1);


	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;
	&ClearSummaryCache;

	&cp_confirm("Search Settings Updated", "Please remember to update your search index if you have changed your settings.", "Return", "$vars_config{CGIURL}/cp.cgi?ubb=vars_search");
	exit(0);

}    #end set_vars_search

sub set_vars_misc {
	local (*FILE);

	$CurrentTab = qq%$vars_wordlets_cp{misc_settings}%;
	&CPHeader;
	&CPFooter;

	#validate
	my @ValidateArray = ("BBStatus", "BBClosedMessage", "Censor", "EditOption", "IP", "EnglishSubjectCheck", "edit_public_names", "FloodCheck", "use_cache", "FloodCheckSpan", "EditWording");
	&Validate(@ValidateArray);

	# set/clean the vars ------------
	my $FloodCheckSpan    = &SmallClean3($in{FloodCheckSpan});
	my $runOnLimit        = &SmallClean3($in{runOnLimit});
	my $stringLengthLimit = &SmallClean3($in{stringLengthLimit});
	my $censorwords       = &SmallClean3($in{censorwords});
	my $BBClosedMessage   = &SmallClean3($in{BBClosedMessage});
#	my $AdminTitle        = &LimitReturns($in{AdminTitle});
#	my $ModeratorTitle    = &LimitReturns($in{ModeratorTitle});
#	my $MemberTitle       = &LimitReturns($in{MemberTitle});
#	my $JrMemberTitle     = &LimitReturns($in{JrMemberTitle});
#	$MemberTitle     = &SmallClean3($MemberTitle);
#	$JrMemberTitle   = &SmallClean3($JrMemberTitle);
#	$AdminTitle      = &SmallClean3($AdminTitle);
#	$ModeratorTitle  = &SmallClean3($ModeratorTitle);
	$BBClosedMessage = &LimitReturns($BBClosedMessage);
	$censorwords     = &LimitReturns($censorwords);


	#check censor words for parentheses!
	$censorwords =~ s/\s+/ /g;
	if ($censorwords =~ m/(\,|\(|\)|\]|\[|\||\\|\?|\*)/) {
		&StandardHTML("We cannot process this request because you have a censor word list that includes at least one illegal character.  You may not use any of the following characters in your censor word list:<P><center>, &nbsp; ( &nbsp; ) &nbsp; [ &nbsp; ] &nbsp; | &nbsp; \\ &nbsp; ? &nbsp; *</center>");
	}

	# write to file!

	my %vars_misc_new = (
		%vars_misc,
		'ReplyQuote'          => $in{ReplyQuote},
		'BBStatus'            => $in{BBStatus},
		'BBClosedMessage'     => $BBClosedMessage,
		'censorwords'         => $censorwords,
		'Censor'              => $in{Censor},
		'EditOption'          => $in{EditOption},
		'EditWording'         => $in{EditWording},
		'IP'                  => $in{IP},
		'EnglishSubjectCheck' => $in{EnglishSubjectCheck},
		'edit_public_names'   => $in{edit_public_names},
		'FloodCheck'          => $in{FloodCheck},
		'use_cache'           => $in{use_cache},
		'FloodCheckSpan'      => $FloodCheckSpan,
		'runOnLimit'          => $runOnLimit,
		'stringLengthLimit'   => $stringLengthLimit,
		'ReverseIPBans'       => $in{ReverseIPBans},
		'ReverseEmailBans'    => $in{ReverseEmailBans},
	);

	&WriteHashToFile("$vars_config{VariablesPath}/vars_misc.cgi", "vars_misc", \%vars_misc_new);


	%vars_misc = %vars_misc_new;

	&AppendAdminLog($username, $status, "Submitted Misc Vars", "Succeeded", "", 1);

	&CheckAccel;

	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;
	&ClearSummaryCache;
	&ClearMiscCache;

	&cp_confirm("Miscellaneous Settings Updated");
	exit(0);

}    #end set_vars_misc

sub set_vars_config {
	local (*FILE);

	$CurrentTab = qq%$vars_wordlets_cp{config_settings}%;
	&CPHeader;
	&CPFooter;


	# bug spray
	&CheckBadChars("$in{CGIPath} $in{NonCGIPath} $in{MembersPath} $in{VariablesPath} $in{CGIURL} $in{NonCGIURL}");    # check for invalid chars

	#validate
	my @ValidateArray = ("CGIURL", "NonCGIURL", "CGIPath", "NonCGIPath", "MembersPath", "VariablesPath", "BBName");
	&Validate(@ValidateArray);

	# set/clean the vars ------------
	my $CGIURL        = &CleanVar2($in{CGIURL});
	my $NonCGIURL     = &CleanVar2($in{NonCGIURL});
	my $CGIPath       = &CleanVar2($in{CGIPath});
	my $NonCGIPath    = &CleanVar2($in{NonCGIPath});
	my $MembersPath   = &CleanVar2($in{MembersPath});
	my $VariablesPath = &CleanVar2($in{VariablesPath});
	my $BBName        = &SmallClean3($in{BBName});

	# limit/eliminate/convert returns in some fields
	$BBName = &LimitReturns($BBName);

	# this one is important, let's make sure new paths are valid!

	if ((-f "$CGIPath/vars_pathlock.cgi") || (-f "$vars_config{CGIPath}/vars_pathlock.cgi")) {
		my $address = &OpenFileAsVar("$vars_config{CGIPath}/vars_pathlock.cgi");
		if ($address =~ m/.+\@.+\.+/) {
			chomp $address;

			&RequireVars("vars_email.cgi");
			&RequireVars("vars_wordlets_email.cgi");
			&RequireCode("ubb_lib_mail.cgi");

			$this_message = $vars_wordlets_email{'pathlock'};
			$this_subj    = $vars_wordlets_email{'pathlock_subj'};

			my $inline;
			foreach my $key (keys %in) {
				next if $key =~ m/(password|forum_pw|passw)/i;
				$inline .= "$key = $in{$key}\n";
			}    #endforeach

			$in{email_type} = "text";
			&ubb_mail_tng({
				'EmailTo' => $address,
				'EmailFrom' => $address,
				'EmailReplyTo' => $address,
				'BCCList' => undef,
				'Subject' => "$this_subj: $vars_config{BBTitle}",
				'TextMessage' => "$this_message $inline",
				'HTMLMessage' => undef,
				'CCList' => undef,
			});

		}
		&AppendAdminLog($username, $status, "Submitted Config Vars", "Failed", "Paths are locked!");
		&StandardHTML(qq%Error:<p>The server administrator has locked the paths.  You may not submit Configuration Settings.</p>%);
		exit(0);
	}

	# make sure the info is pointing to the right places :)
	unless (&FileExists("$CGIPath/cp.cgi")) {
		&StandardHTML(qq%Error:<P>Your new CGI Directory Path is not correct. [There may be other errors, as well.]%);
	}
	unless (&FileExists("$NonCGIPath/on.gif")) {
		&StandardHTML(qq%Error:<P>Your new UBB NonCGI Directory Path is not correct. You would also receive this error if you forgot to upload the on.gif file into your UBB NonCGI directory.  [There may be other errors, as well.]%);
	}

	unless (&DirExists("$NonCGIPath/Templates")) {
		&StandardHTML(qq%Error:<P>We cannot find your Templates directory!  This means that either the NonCGI absolute path you entered is not correct, or that the Templates directory is not where it is supposed to be.  We cannot proceed with changes until this is corrected.  [There may be other errors, as well.]%);
	}
	unless (&FileExists("$MembersPath/emailfile.cgi")) {
		&StandardHTML(qq%Error:<P>Your Members Directory Path is not correct. We looked for the standard emailfile.cgi file but could not find it in the path that you specified!  [There may be other errors, as well.]%);
	}

	$in{AdminLogging} = "YES" unless $in{AdminLogging};
	$in{EnableAccel} = "NO" unless $in{EnableAccel};
	$in{EnableAccel} = "NO" unless &FileExists("$vars_config{NonCGIPath}/ultimatebb.php");

	# need to set cache pw? (for beta testers only)--
	# Reinstated by CC
	unless (exists($vars_config{cache_pw})) {
		$vars_config{cache_pw} = &GeneratePassword2;
		mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}");
	}    # No cache pw == first submit, so create

	unless (&DirExists("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}")) {
		$vars_config{cache_pw} = &GeneratePassword2;
		mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}");
	}    # cache pw without directory == screwy setup, so create


	unless (&DirExists("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}")) {
		&StandardHTML(qq%Error:<P>The cache-$vars_config{cache_pw} directory does not exist or could not be created.  Please reset permissions on your noncgi directory then submit Configuration Settings again.  [There may be other errors, as well.]%);
	}    # If it still didn't get created, our noncgi directory is screwy, so have user fix

	unless(&DirExists("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/ubb_files")) {
		mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/ubb_files", SEVENSEVENSEVEN) or die "$! creating ubb_files";
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/ubb_files");
	}

	unless(&DirExists("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index")) {
		mkdir("$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index", SEVENSEVENSEVEN) or die "$! creating ubb_files";
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index");
	}

	# write to file!

	$vars_config{Cookie_Number} = $GotTime{LastLoginJulian} unless $vars_config{Cookie_Number};

	delete $vars_config{"jc"};

	my %vars_config_new = (
		%vars_config,
		'CGIURL'        => $CGIURL,
		'NonCGIURL'     => $NonCGIURL,
		'CGIPath'       => $CGIPath,
		'NonCGIPath'    => $NonCGIPath,
		'MembersPath'   => $MembersPath,
		'VariablesPath' => $VariablesPath,
		'cache_pw'      => $vars_config{cache_pw},
		'Cookie_Number' => $vars_config{Cookie_Number},
		'BBName'        => $BBName,
		'AdminLogging'  => $in{AdminLogging},
		'EnableAccel'	=> $in{EnableAccel},
	);

	%vars_config = %vars_config_new;

	&WriteHashToFile("$vars_config{VariablesPath}/vars_config.cgi", "vars_config", \%vars_config_new);


	my $checkadminlogging = "";
	if (($in{AdminLogging} eq "NO") && ($vars_config{'AdminLogging'} ne "NO")) {
		$checkadminlogging = "  NOTE: Admin Logging has now been turned OFF!";
	}

	&AppendAdminLog($username, $status, "Submitted Config Vars$checkadminlogging", "Succeeded", "");


	# clear cache
	&ClearForumTopicsCache;
	&ClearForumPageCache;
	&ClearSummaryCache;
	&ClearMiscCache;

	&CheckAccel;

	&cp_confirm("Configuration Settings Updated");
	exit(0);
}    #end set_vars_config

sub cp_confirm {
	my ($go_to);

	#$_[0]: title
	#$_[1]: details
	#$_[2]: back_to title
	#$_[3]: back_to URL

	if(!$_[3]) {
		my $cgiurl = quotemeta($vars_config{CGIURL});
		if($ENV{HTTP_REFERER} =~ m/^$cgiurl\/cp.cgi(\?.+)$/) {
			my $back = $1;
			$back =~ s/r=(\w{6})/"r=" . &GeneratePasswordCore(6)/gei;
			my $go = $vars_config{CGIURL} . "/cp.cgi";
			$go_to = qq(&#187; <a href="$go$back">Return</a>) unless
				(($back =~ m/search|add|edit/i) || ($in{ubb} =~ m/add|edit|do_/))
		} # end if
	} # end if

#	&StandardHTML("Done?  $_[3]");

	if (($_[3] ne '') && ($_[2] ne '') && !$go_to) {
		$go_to = qq~&#187; <A HREF="$_[3]">$_[2]</A>~;
	} elsif(!$_[2] && !$_[3] && !$go_to) {
		$go_to = qq~&#187 <a href="$vars_config{CGIURL}/cp.cgi">Control Panel Home</a>~;
	} # end if

	$CurrentTab = qq%$_[0]%;

	&CPHeader;
	&CPFooter;
	&CPTop;
	print qq~
<center>
<TABLE WIDTH="95%" BORDER='0'>
<TR><TD>
<FONT size="2" face="Verdana, Arial">
<B>$_[0]</b>
<p>$_[1]</p>
<p><b>$go_to</b></p>
</FONT>
</TD></TR></TABLE></center>
~;
	&CPBottom;
	exit(0);
}    # end cp_confirm



sub cp_transition {

	# $_[0]: URL to forward to
	# $_[1]: Message to display
	# $_[2]: Tab
	# $_[3]: New by CC: Message for URL
	# $_[4]: New by CC: Time
	$_[4] = "3" unless $_[4];
	$_[3] = $_[0] unless $_[3];
	$direct_to = qq!<meta http-equiv="refresh" content="$_[4];URL=$_[0]">! unless $_[4] < 0;

	$CurrentTab = qq%$_[2]%;

	&CPHeader;
	&CPFooter;
	&CPTop_nomenu;
	print qq!
<center>
<TABLE WIDTH="95%" BORDER='0'>
<TR><TD>
<FONT size="2" face="Verdana, Arial">
$_[1]<P><b><A HREF="$_[0]">$_[3]</A>
</b>
</FONT>
</TD></TR></TABLE></center>
!;
	&CPBottom;
	exit(0);
}    # end cp_transition

sub board_on {

	if ($vars_misc{BBStatus} =~ /^(.+) - (.+)$/) { $vars_misc{BBStatus} = $2 }

	# reset- turning board on
	else { $vars_misc{BBStatus} = 'ON'; }

	# print updated hash
	&WriteHashToFile("$vars_config{VariablesPath}/vars_misc.cgi", "vars_misc", \%vars_misc);


}    # end board on

sub board_off {

	my $was_status = $vars_misc{BBStatus};

	if ($vars_misc{BBStatus} =~ /^(.+) - (.+)$/) { $was_status = $2 }
	$vars_misc{BBStatus} = "OFF - $was_status";

	# print updated hash
	&WriteHashToFile("$vars_config{VariablesPath}/vars_misc.cgi", "vars_misc", \%vars_misc);

}    # end board off


sub toggle {

	if ($in{ubb} =~ m/(on)/) {
		$vars_misc{BBStatus} = "ON";
		&WriteHashToFile("$vars_config{VariablesPath}/vars_misc.cgi", "vars_misc", \%vars_misc);
		&CheckAccel;
		&cp_transition("$vars_config{CGIURL}/cp.cgi",
		"Thank you!  Your board has been turned $1.  Stand by...",
		"Board Status Toggled",
		"Returning to Control Panel Entry Page...");
	} elsif ($in{ubb} =~ m/(off)/) {
		$vars_misc{BBStatus} = "OFF";
		&WriteHashToFile("$vars_config{VariablesPath}/vars_misc.cgi", "vars_misc", \%vars_misc);
		&CheckAccel;
		&cp_transition("$vars_config{CGIURL}/cp.cgi",
		"Thank you!  Your board has been turned $1.  Stand by...",
		"Board Status Toggled",
		"Returning to Control Panel Entry Page...");
	} else {
		&StandardHTML("You've confused my poor little mind!");
	}
}


sub AppendAdminLog {

	if (($vars_config{'AdminLogging'} eq "NO") && (!&FileExists("$vars_config{CGIPath}/vars_pathlock.cgi"))) {
		return;
	}

	&RequireCode("ubb_lib_time.cgi");
	&GetDateTime;


	my ($username,     #username passed
	    $statline,     #Administrator/Moderator
	    $logstring,    #string to log to file
	    $failed,       #'Failure' if failed, 'Success' if succeeded
	    $reason,       #Reason for failure
	    $skipinline) = @_;    #if passed, do NOT log %in
	my ($inline);
	my $timestamp = $GotTime{JSYear} . $GotTime{mon} . $GotTime{mday} . "." . $GotTime{hour} . $GotTime{min} . $GotTime{sec};


	$logstring = "Unknown Action ($in{ubb})!" unless $logstring;
	$failed = "Failed (but did not specify \$failed line to AppendAdminLog)" unless $failed;
	$reason   = "(No reason given!)"   unless $reason;
	$username = "(No username given!)" unless $username;
	$statline = "(No statline given!)" unless $statline;

	unless ($skipinline) {
		foreach my $key (keys %in) {
			next if $key =~ m/(password|forum_pw|passw)/i;
			$inline .= "$key=" . UBBCGI::escape($in{$key}) . "&";
		}    #endforeach
	}
	else {
		$inline = "Inline Skipped!";
	}    #endunless


	my $appender = <<HERE;
--- START $timestamp
$username
$ENV{REMOTE_ADDR}|~|$ENV{REMOTE_HOST}|~|$ENV{X_FORWARDED_FOR}
$statline
$logstring
$failed
$reason
$inline
--- END $timestamp\n
HERE
	&AppendFileAsString("$vars_config{NonCGIPath}/BanLists/adminlog.cgi", $appender);


}    #end AppendAdminLog



sub verify_id_4_cpanel {
	my $username = shift;
	my $password = shift;

	local ($lcpw, $lcprofpw, $pn, @user_info, @profile_stuff);

	$profile_stuff[2] = &GetUserNumber($username);

	#did we find the username?
	if ($profile_stuff[2] eq '') {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&AppendAdminLog($username, "", "Log In", "Failed", "No such user");
		$callish = "";#&Tracer;
		&StandardHTML("$vars_wordlets_err{invalid_username} ($callish)");
	}
	my @profile = &OpenProfile($profile_stuff[2]);
	chomp($profile[1]);
	chomp($profile[8]);
	chomp($profile[15]);
	$lcpw     = lc($password);
	$lcprofpw = lc($profile[1]);

	if ($lcpw ne "$lcprofpw") {

		#print qq%Content-type: text/html\n\n%;
		print header(
			-charset => "$masterCharset",
			-type    => "text/html",
		);

		&AppendAdminLog($username, $profile[8], "Log In", "Failed", "Wrong password: $password");
		&StandardHTML("$vars_wordlets_err{invalid_password}");
	}

	# grab displayed name
	chomp($profile[15]);
	chomp($profile[0]);
	chomp($profile[26]);
	$profile_stuff[0] = $profile[15];
	if ($profile_stuff[0] eq '') { $profile_stuff[0] = "$profile[0]"; }

	# grab topic view (days prune)
	chomp($profile[21]);
	$profile_stuff[1] = $profile[21];

	# does user have an approved registration?
	$profile_stuff[3] = $profile[26];
	return (@profile_stuff);
}    #end verify_id

sub CheckUndonePolls {

	my $dir = "$vars_config{NonCGIPath}/Polls";
	opendir(DIR, $dir) or &StandardHTML( &Template( $vars_wordlets_criterr{cant_open}, {ERR => $!, THING => $dir} ) );
	my @polls = grep(/^\w{12}\.cgi$/, readdir(DIR));

	closedir(DIR);

	&RequireCode("ubb_poll.cgi");

	my @checks;
	foreach my $one (@polls) {
		my($pollid, $j) = split(/\./, $one);
		if(&poll_load($pollid)) {
			if($poll->{$pollid}->{topic} !~ m/^\d{6}$/) {
				push(@checks, $one);
			} else {
				undef($poll->{$pollid});
			} # end if
		} # end if
	} # end foreach

	foreach my $checker (@checks) {
		my $fn = "$dir/$checker";
		my @item = stat($fn);
		if($item[9] < (time() - (30 * 60))) {
			# Delete any poll data file that is over
			# half an hour old and has no topic
			# assigned
			&Unlink($fn);
		} # end if
	} # end foreach

} # end sub


1;
# $Id: cp_lib.cgi,v 1.20 2002/04/18 22:27:17 cvscapps Exp $
