# Control Panel - Routines for indexing

&RequireCode("$vars_config{CGIPath}/ubb_lib_posting.cgi");
&RequireVars("$vars_config{VariablesPath}/vars_misc.cgi");


sub rebuild_members {

	$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="do_rebuild_members">
	%;
	$CurrentTab = qq%$vars_wordlets_cp{rebuild_members}%;

	# note: the wordlets are already required... no need to grab them

	&AppendAdminLog($username, $status, "Viewed Rebuild Members Intro", "Succeeded", "");


	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_rebuild_mems_intro");
	&CPBottom;
}    # end rebuild members



sub build_members {
	local (@all_members, $member_total, $lastnum, $thread_start, $end_here, $j, $board_off, $end_of_line, $all_members_as_array, $array_max, @members_file, @email_file, @pubs_file, @this_member, $memnum, $memline, $emailline);
	local (*FILE);

	# subroutine parameters:
	# $_[0]: start

	# alter number for slower/faster servers:
	my $increment = 200;

	my $i_array = $increment - 1;

	$board_off = $vars_misc{BBStatus};

	my $start = $_[0];

	if ($start == 0) {

		# turn off board while building!
		&board_off;

		# open members directory
		opendir(MEMS, "$vars_config{MembersPath}");
		my @total_members = grep(/^\d{8}\.cgi$/, readdir(MEMS));
		closedir(MEMS);

		# make sure profile has size
		foreach my $file (@total_members) {
			if((stat("$vars_config{MembersPath}/$file"))[7] > 0) {
				push(@all_members, $file);
			} else {
				&Unlink("$vars_config{MembersPath}/$file");
			} # end if
		} # end foreach
		@all_members = sort(@all_members);

		$member_total = scalar(@all_members);

		if (scalar(@all_members) > $i_array) {

			# print to temp file:
			&WriteFileAsArray("$vars_config{MembersPath}/temp_list.cgi", @all_members);

		}    # if array is $increment (default 400) or more

	} else {

		# get members list:
		@all_members  = grep(/\d{8}/, &OpenFileAsArray("$vars_config{MembersPath}/temp_list.cgi"));
		$member_total = scalar(@all_members);

	}    # if/else starting from 0

	# limit to incrmemental members at a time to reduce server load
	$start     = $start + 0;
	$array_max = $start + $i_array;


	# ok-

	$all_members_as_array = scalar(@all_members) - 1;

	if ($all_members_as_array < $increment) {
		$end_here    = $all_members_as_array;
		$end_of_line = 'true';
	} elsif (($all_members_as_array > $i_array) && ($array_max >= $all_members_as_array)) {
		$end_here    = $all_members_as_array;
		$end_of_line = 'true';

	} else {
		$thread_start = $array_max + 1;    #where to pick up next
		$end_here     = $array_max;
		$end_of_line  = 'false';
	}

	@all_members = @all_members[$start ... $end_here];

	# import temp info:
	if ($in{start} > 0) {
		if (-s "$vars_config{MembersPath}/members_file.cgi") {
			@members_file = &OpenFileAsArray("$vars_config{MembersPath}/members_file.cgi");
		}

		if (-s "$vars_config{MembersPath}/email_file.cgi") {
			@email_file = &OpenFileAsArray("$vars_config{MembersPath}/email_file.cgi");
		}
		if (-s "$vars_config{MembersPath}/pubs_file.cgi") {
			@pubs_file = &OpenFileAsArray("$vars_config{MembersPath}/pubs_file.cgi");
		}
	}



	# cycle thru:
	foreach (@all_members) {

		($memnum, $j) = split (/\./, $_);
		@this_member = &OpenProfile($memnum);

		chomp($this_member[0]);
		chomp($this_member[2]);
		chomp($this_member[15]);

		# memberslist
		$memline = "$this_member[0]" . '|!!|' . "$memnum";
		push (@members_file, "$memline");

		# email file
		$emailline = "$this_member[2]" . '||' . "$memnum";
		push (@email_file, $emailline);

		# public names
		if ($this_member[15] ne '') {
			push (@pubs_file, $this_member[15]);
		}

	}


	# are we finished?
	if ($end_of_line eq 'true') {

		my @reverse = reverse(@all_members);
		($lastnum, $j) = split (/\./, $reverse[0]);

		# print revised stat files
		&UpdateMemberslist(\@members_file);
		&UpdateEmailfile(\@email_file);
		&UpdatePubNames(\@pubs_file);
		&UpdateMemberTotal($member_total);
		&UpdateLastNumber($lastnum);
		#&WriteFileAsArray("$vars_config{MembersPath}/memberslist.cgi",  @members_file);
		#&WriteFileAsArray("$vars_config{MembersPath}/emailfile.cgi",    @email_file);
		#&WriteFileAsArray("$vars_config{MembersPath}/public_names.cgi", @pubs_file);
		#&WriteFileAsString("$vars_config{MembersPath}/membertotal.cgi", "$member_total\n");
		#&WriteFileAsString("$vars_config{MembersPath}/last_number.cgi", "$lastnum\n");

		# turn board back on
		&board_on;

		# remove temp files
		&Unlink("$vars_config{MembersPath}/temp_list.cgi");
		&Unlink("$vars_config{MembersPath}/members_file.cgi");
		&Unlink("$vars_config{MembersPath}/email_file.cgi");
		&Unlink("$vars_config{MembersPath}/pubs_file.cgi");

		&AppendAdminLog($username, $status, "Rebuilt Member Stats", "Succeeded", "");

		&cp_confirm("Member Stat File Rebuild Complete", "You may wish to rebuild the user post histories as well.");

	} else {

		# print updated temp files:
		&WriteFileAsArray("$vars_config{MembersPath}/members_file.cgi", @members_file);
		&WriteFileAsArray("$vars_config{MembersPath}/email_file.cgi",   @email_file);
		&WriteFileAsArray("$vars_config{MembersPath}/pubs_file.cgi",    @pubs_file);

		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=do_rebuild_members&start=$thread_start",
		"We are rebuilding member stat files.  Currently processing member <b>$end_here</b> of <b>$all_members_as_array</b>... Please wait!",
		"Member Stat File Rebuild In Progress", "Continuing Rebuild...");

	}


}    # end build_members

sub do_index {

	$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="index_tng">
	%;
	$CurrentTab = qq%$vars_wordlets_cp{rebuild_index}%;

	# forum options
	my @forums = &OpenForumsFile;

	local $forum_options = qq!
<OPTION VALUE="ALL">Rebuild Search Index for All Forums</OPTION>
	!;

	foreach (@forums) {

		@forum_info = split (/\|\^\|/, $_);
		$forum_options .= qq!
<OPTION VALUE="$forum_info[8]">Rebuild Only: $forum_info[1] (# $forum_info[8])</OPTION>
		!;

	}    # end forum loop

	# note: the wordlets are already required... no need to grab them

	&AppendAdminLog($username, $status, "Viewed Search Indexer Intro", "Succeeded", "");


	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_index_intro");
	&CPBottom;

}    # end do index


sub all_build_forum_stats {
	local (@all_forums, @rev_forums, @last_forum, $last_forum_number, @this_forum, @grab_forum, $next_forum, $thisforum);

	# turn off board while building...
	&board_off;

	# get all forums
	@all_forums        = &OpenForumsFile;
	@rev_forums        = reverse(@all_forums);
	@last_forum        = split (/\|\^\|/, $rev_forums[0]);
	$last_forum_number = $last_forum[8];

	$thisforum = $in{build_forum};
	$next_forum = $thisforum + 1;

	unless($thisforum > $last_forum_number) {
		if ($in{build_forum} eq 'ALL') {
			@this_forum = split (/\|\^\|/, $all_forums[0]);
			$thisforum = $this_forum[8];
			#$in{build_forum} = $thisforum;
			$next_forum = $thisforum + 1;
			if (&DirExists("$vars_config{NonCGIPath}/Forum$thisforum")) {
				&build_forum_stats2($thisforum, "A");
			} else {
				$thisforum = $in{build_forum};
				&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=all_build_forum_stats&build_forum=$next_forum&all=$in{all}",
				"We are rebuilding forum stat files for each of your available forums.  <br />Forum <B>$in{build_forum}</B> appears to have been deleted previously, so we are continuing with forum <b>$next_forum</b>... <p>Please wait!</p>",
				"Forum Stat File Rebuild In Progress", "Continuing Rebuild...");
			}
			$in{build_forum} = $thisforum;
			$next_forum = $thisforum + 1;

		} else {

			$thisforum = $in{build_forum};
			$next_forum = $thisforum + 1;
			if (&DirExists("$vars_config{NonCGIPath}/Forum$thisforum")) {
				&build_forum_stats2($thisforum, "A");
			} else {
				&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=all_build_forum_stats&build_forum=$next_forum&all=$in{all}",
				"We are rebuilding forum stat files for each of your available forums.  <br />Forum <B>$in{build_forum}</B> appears to have been deleted previously, so we are continuing with forum <b>$next_forum</b>... <p>Please wait!</p>",
				"Forum Stat File Rebuild In Progress", "Continuing Rebuild...");
			}

		}
	}

	if ($thisforum > $last_forum_number) {

		# turn board back on

		&AppendAdminLog($username, $status, "Rebuilt Forum Stats", "Succeeded", "");

		&board_on;
		&cp_confirm("Forum Stats Rebuild Complete", "You may wish to rebuild member stat files as well.");
	} else {
		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=all_build_forum_stats&build_forum=$next_forum",
		"We are rebuilding forum stat files for each of your available forums.  <br />We just updated forum <B>$in{build_forum}</B>... <p>Please wait!",
		"Forum Stat File Rebuild In Progress", "Continuing Rebuild...");
	}

}    # all_build...


sub post_history {

	&AppendAdminLog($username, $status, "Viewed Member Indexer Intro", "Succeeded", "");


	$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="update_post_history">
	!;
	$CurrentTab = qq%$vars_wordlets_cp{post_history}%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_post_history");
	&CPBottom;
	exit(0);

}    # end post_history

sub append_post_history {

	# $_[0] : user number
	# $_[1] : post line
	local (*FILE);
	&AppendFileAsString("$vars_config{MembersPath}/user_posts/$_[0].cgi", "$_[1]");
}    # end append_post_history


sub build_history {
	local ($thread_max, @forum_list, $forum_total, $subject, $max_forum_number, $next_forum, $this_line, $exact_path, @forum_line, @topics, $thread_start, $end_here, $start_here, @stat, $this, $forum_status, $topic, $subject, @stats, $checker, $j, @parseit, $thread_line, @forumindex, $board_off, $line, $random, $history_file, $forum_array_line, $end_of_line, $un, %user_number, %user_name, $post_line);
	local (*FILE);

	# used for one file index method

	# subroutine parameters:
	# $_[0]: start
	# $_[1]: thread_point

	# delete current histories
	if (($_[0] == 1) && ($_[1] == 0)) {
		&ClearUserPostHistories;
	}

	$board_off = $vars_misc{BBStatus};

	my $start        = $_[0];
	my $thread_point = $_[1];

	if (($start == 1) && ($thread_point == 0)) {
		$random       = &GeneratePassword;
		$history_file = ("history" . "_$random" . ".cgi");

		# turn off board while building!
		&board_off;
	} else {
		$history_file = $in{history_file};
	}

	# limit to 300 posts at a time to reduce server load
	$thread_max = $thread_point + 149;
	$start      = $start + 0;

	@forum_list  = &OpenForumsFile;
	$forum_total = @forum_list;

	$forum_array_line = $start - 1;
	$this_line        = $forum_list[$forum_array_line];

	@forum_line = split (/\|\^\|/, $this_line);
	$forum_status = $forum_line[3];
	$number       = $forum_line[8];

	$exact_path = "Forum$number";

	if ($forum_line[6] =~ m/private/) {

		# if private, do not add to history!
		$next_forum = $start + 1;
		if ($next_forum > $forum_total) { $end_of_line = 'true'; }

	} else {

		#not private, so add...

		if ($thread_point == 0) {

			# open forum directory... read messages into array
			opendir(FILE, "$vars_config{NonCGIPath}/$exact_path");
			@topics = grep(/^\d\d\d\d\d\d\.cgi$/, readdir(FILE));
			closedir(FILE);

			&WriteFileAsArray("$vars_config{MembersPath}/user_posts/$history_file", @topics);
		} else {

			@topics = &OpenFileAsArray("$vars_config{MembersPath}/user_posts/$history_file");

		}    # end history file build/retrieve


		$max_array_number = @topics - 1;

		if ($max_array_number < 150) {
			$next_forum   = $start + 1;
			$thread_start = 0;
			$start_here   = 0;
			$end_here     = $max_array_number;
		} elsif (($max_array_number > 149) && ($thread_max >= $max_array_number)) {
			$next_forum   = $start + 1;
			$thread_start = 0;
			$start_here   = $thread_point;
			$end_here     = $max_array_number;

		} else {
			$next_forum   = $start;
			$thread_start = $thread_max + 1;    #where to pick up next
			$start_here   = $thread_point;
			$end_here     = $thread_max;
		}

		# is this the last forum to check?
		if ($next_forum > $forum_total) {
			$end_of_line = 'true';
		}

		undef(@forumindex);

		@topics = @topics[$start_here ... $end_here];

		if ($forum_status eq 'On') {
			undef(@forumindex);
			for $this (@topics) {
				($topic, $j) = split (/\./, $this);
				@stat = &OpenTopic($topic, $number);

				foreach $checker (@stat) {
					unless ($checker =~ /^A/) {
						@parseit = split (/\|\|/, $checker);
						$parseit[3] =~ m/^(\d{2})\-(\d{2})\-(\d{2,4})$/;
						my $tempyear = $3;
						if ($tempyear < 1990) {    #aiiieee!  Y2K-10!
							$tempyear += 1900;
						}
						my $dateline = "$tempyear$1$2";
						$post_line = "$dateline|$number|$topic|$parseit[1]|$parseit[7]\n";

						# attribute to author
						chomp($parseit[11]);
						if ($parseit[11] ne '') {

							if (&FileExists("$vars_config{MembersPath}/$parseit[11].cgi")) {
								$user_number{$parseit[11]} .= "$post_line";
							}

						} else {
							if ($user_name{$parseit[2]}) {
								$un = $user_name{$parseit[2]};
							} else {
								$un = &GetUserNumber($parseit[2]);
								$user_name{$parseit[2]} = $un;
							}

							if (($un ne '') && (&FileExists("$vars_config{MembersPath}/$un.cgi"))) {
								$user_number{$un} .= "$post_line";
							}
						}
					}    # end unless
				}    # foreach checker
			}    # end foreach $this

		}    # end if status eq "ON"


		# determine index method:
		&RequireVars("$vars_config{VariablesPath}/vars_wordlets_err.cgi");

		# append user post records now
		foreach $key (keys %user_number) {
			&append_post_history("$key", "$user_number{$key}");
		}

	}    # end if/else private

	$end_here += 1;
#	$end_here = ($end_here < 0 ? 0 : $end_here);
	$max_array_number += 1;
#	$max_array_number = ($max_array_number < 0 ? 0 : $max_array_number);

	# are we finished?
	if ($end_of_line eq 'true') {

		# clear cache
		&ClearForumTopicsCache;

		&AppendAdminLog($username, $status, "Rebuilt Member Index", "Succeeded", "");

		&Unlink("$vars_config{MembersPath}/user_posts/$history_file");

		#&cp_confirm("Post History Build Completed");

		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=update_user_last_post&start=0&increment=200",
		"We have just finished updating the User Post Histories.  We must now add last post information to each user profile.  <p>Please wait!</p>",
		"Post History Build In Progress",
		"Continuing Update...");

	} else {

		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=update_post_history&start=$next_forum&thread_point=$thread_start&history_file=$history_file",
		"We are rebuilding member post histories for each of your available forums.  <br />Currently updating forum <B>$number</B>.  <br />So far, we have processed <b>$end_here</b> of <b>$max_array_number</b> threads in this forum...<p> Please wait!</p>",
		"Post History Build In Progress", "Continuing Rebuild...");

	}


}    # end build_history


sub build_index {
	&build_index_tng;
	exit(0);
}    #end build_index


sub UpdateUsersLastPost {
	my @memberslist = &GetMembersListAsArray;
	my $membercount = scalar(@memberslist);
	$membercount--;
	my $start     = $in{'start'};
	my $increment = $in{'increment'};
	my $end       = $start + $increment;
	$end = $membercount if $end > $membercount;

	#print "<pre>End: $end, Start: $start, Increment: $increment\n";

	&board_off;

	my @partmemberslist = @memberslist[$start .. $end];
	my $partcount       = scalar(@partmemberslist);

	MEMZ: foreach my $item (@partmemberslist) {
		chomp $item;

		#m/^(.+)\|!!\|(\d+)$/;	#just the number
		my ($one, $two) = split (/\|!!\|/, $item);

		my $filename = $two . ".cgi";
		my $number   = $two;

		if (&FileExists("$vars_config{MembersPath}/user_posts/$filename")) {
			my @posts = reverse sort(&OpenFileAsArray("$vars_config{MembersPath}/user_posts/$filename"));

			my @profile = &OpenProfile($number);
			next MEMZ if $profile[0] eq '';
			foreach (@profile) { chomp; }
			chomp($profile[30] = $posts[0]);

			&WriteMemberProfile($number, @profile);
		}    #endif

	}    #endforeach

	if ($end eq $membercount) {    #we're done

		&AppendAdminLog($username, $status, "Rebuilt Member Post Histories", "Succeeded", "");

		# turn board back on!
		&board_on;

		&cp_confirm("User Post Histories Updated", "You may wish to rebuild the search index as well.");

	} else {

		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=update_user_last_post&start=$end&increment=$increment",
		"We are currently updating each user's last post time and date.  <br />We just finished processing members <b>$start</b> through <b>$end</b> of <b>$membercount</b>.  <p>Please wait!</p>",
		"Post History Build In Progress", "Continuing Update...");

	}    #endif

}    #endsub



sub forum_stats2 {
	local (@forums, $forum_options, @forum_info);

	# forum options
	@forums = &OpenForumsFile;

	$forum_options = qq!
<OPTION VALUE="ALL">Rebuild All Forum Stat Files</OPTION>
	!;

	foreach (@forums) {

		@forum_info = split (/\|\^\|/, $_);
		$forum_options .= qq!
<OPTION VALUE="$forum_info[8]">Rebuild Only: $forum_info[1] (# $forum_info[8])</OPTION>
		!;

	}    # end forum loop

	&AppendAdminLog($username, $status, "Viewed Forum Stats Intro", "Succeeded", "");


	$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="build_forum_stats2">
	!;
	$CurrentTab = qq%$vars_wordlets_cp{forum_stats}%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_forum_stats");
	&CPBottom;
	exit(0);

}    # end forum_stats



sub build_forum_stats2 {
	local (@topics, %forum_topics, *FILE);

	&board_off;

	my $thisnumber = $_[0];    # the forum number
	my $allorone   = $_[1];    # A == All, 1 == just this one
	$allorone = $in{all} if $in{all};	#force

	$next_forum = $thisnumber + 1;

	&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");

	&ClearMetaData($thisnumber) unless $in{start_point};

	my($returner, $total) = &create_forum_summary($_[0]);

	if($returner) {
		$total = $returner unless $total;
		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=build_forum_stats2&build_forum=$thisnumber&start_point=$returner&all=$allorone",
		"We are rebuilding forum stat files for each of your available forums.  <br />We are now updating forum <B>$thisnumber</B>...  <br />Currently at <B>$returner</b> of <b>$total</b> total threads. <p> Please wait!",
		"Forum Stat File Rebuild In Progress", "Continuing Rebuild...");
	}

	#board won't operate without this
	&SetExactPath($thisnumber);
	&ClearSingleForumPageCache($exact_path, $_[0]);

	&AppendFileAsString("$vars_config{NonCGIPath}/$exact_path/upgrade.txt", "$version|^|$version_number\n");

	unless($allorone eq "A") {
		&board_on;
		&cp_confirm("Forum Stats Rebuild Complete");
	} # end unless

	if( (caller())[1] ne "cp.cgi" ) {

&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=all_build_forum_stats&build_forum=$next_forum",
"We are rebuilding forum stat files for each of your available forums.  <br />We just updated forum <B>$thisnumber</B>... <p>Please wait!</p>",
"Forum Stat File Rebuild In Progress", "Continuing Rebuild...");

	} else {

&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=all_build_forum_stats&build_forum=$next_forum",
"We are rebuilding forum stat files for each of your available forums.  <br />We just updated forum <B>$thisnumber</B>... <p>Please wait!</p>",
"Forum Stat File Rebuild In Progress", "Continuing Rebuild...");

	}

}    # end build_forum_stats

sub build_index_tng {

	if($in{d}) {
		if($in{d} eq 'all') {
			&board_off;
			if(($in{f} == 0) && ($vars_search{IndexMethod} ne 'PERFORUM')) {
				&Unlink(qq($vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index/forumindex.cgi));
			} elsif(($in{f} =~ m/^\d+$/) && ($in{f} && !$in{sp}) && ($vars_search{IndexMethod} eq 'PERFORUM')) {
				&Unlink(qq($vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index/forumindex$in{f}.cgi));
			} # end if

			# find the next available forum if the current doesn't exist
			$in{f} = &build_index_tng_figureforum($in{f});
			if(!defined $in{f}) {
				&board_on;
				&cp_confirm("Search Index Rebuilt");
			} # end if

			my $resline = &build_index_tng_core_oneforum(1);# nounlink

			if($resline->{done} == 1) {
			my $nextforum = $in{f} + 1;
&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=index_tng&d=all&f=$nextforum",
"We have rebuilt the search index for forum $in{f} ($vars_forums{$in{f}}->[1]).  Please standby...",
"Search Index Rebuild", "Continuing Rebuild...");
			} else {
&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=index_tng&d=all&f=$in{f}&sp=$resline->{sp}",
"We are currently rebuilding the search index for forum $in{f} ($vars_forums{$in{f}}->[1]).  <br /> <br /> We have just processed topics $resline->{startdex} through $resline->{enddex} of $resline->{totaldex}.",
"Search Index Rebuild", "Continuing Rebuild...");
			} # end if
		} elsif($in{d} eq 'one') {
			&board_off;
			$in{f} = $in{build} unless $in{f};
			my $resline = &build_index_tng_core_oneforum;
			if($resline->{done} == 1) {
				&board_on;
				&cp_confirm("Forum $in{f} Search Index Rebuilt");
			} else {
&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=index_tng&d=one&f=$in{f}&sp=$resline->{sp}",
"We are currently rebuilding the search index for forum $in{f} ($vars_forums{$in{f}}->[1]).  <br /> <br /> We have just processed topics $resline->{startdex} through $resline->{enddex} of $resline->{totaldex}.",
"Forum $in{f} Search Index Rebuild", "Continuing Rebuild...");
			} # end if
		} else {
			die "Can't dispatch '$in{d}'";
		} # end
	} elsif($in{build}) {
		if($in{build} eq 'ALL') {
			$in{d} = 'all';
			$in{f} = 0;
			# redispatch
			&build_index_tng;
		} elsif($in{build} =~ m/^\d+$/) {
			die "Uhm, what?" unless &GetForumRecord($in{build});
			$in{d} = 'one';
			$in{f} = $in{build} unless $in{f};
			# redispatch
			&build_index_tng;
		} else {
			die "Uhm, no.";
		} # end if
	} else {
		die "Nothing to do.";
	} # end if
} # end build_index_tng

sub build_index_tng_core_oneforum {
	my $nounlink = shift;
	my $forum = $in{f};
	&GetForumRecord($in{f});	 # JIC

	my $ft = &GetForumTopics($in{f});
	my @topics = sort keys %{$ft};

	my $not = scalar(@topics) - 1;
	if($not > 10000) {
		$vars_search{topic_index_limit} = int($vars_search{topic_index_limit} / 13);
	} elsif($not > 7500) {
		$vars_search{topic_index_limit} = int($vars_search{topic_index_limit} / 8);
	} elsif($not > 5000) {
		$vars_search{topic_index_limit} = int($vars_search{topic_index_limit} / 5);
	} elsif($not > 2500) {
		$vars_search{topic_index_limit} = int($vars_search{topic_index_limit} / 3);
	} elsif($not > 750) {
		$vars_search{topic_index_limit} = int($vars_search{topic_index_limit} / 2);
	} # end if

	if($not > ( $vars_search{topic_index_limit} ) ) {
		if(!$in{sp} || ($in{sp} !~ m/^\d+$/)) {
			my $this = ($vars_search{IndexMethod} eq 'PERFORUM' ? $in{f} : '' );
			&Unlink(qq($vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index/forumindex$this.cgi)) unless $nounlink;
			$in{sp} = 0;
		} # end if
		my $endpoint = $in{sp} + $vars_search{topic_index_limit};
		$endpoint = $not if $endpoint > $not;
		my $done = ($endpoint == $not ? 1 : 0);
		die "CONFUZZLED!" if $in{sp} > $endpoint;

		my @top = @topics[$in{sp} .. $endpoint];
		&build_index_tng_core($in{f}, \@top);

#		$resline->{startdex} through $resline->{enddex} of $resline->{totaldex}

		return({ done => $done, sp => $endpoint,
			startdex => $in{sp} + 0, enddex => $endpoint + 0,
			totaldex => $not });
	} else {
		my $this = ($vars_search{IndexMethod} eq 'PERFORUM' ? $in{f} : '' );
		&Unlink(qq($vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index/forumindex$this.cgi)) unless $nounlink;
		&build_index_tng_core($in{f}, \@topics);
		return({ done => 1 });
	} # end if

	die "You can't get here.";
} # end build_index_tng_core_oneforum

sub build_index_tng_core {
	my($forum, $topiclist) = @_;

	# Temp - overrides FixSubjectEncoding check
	$vars_misc{EnglishSubjectCheck} = "OFF";

	my @dex;

	foreach my $topic (@{$topiclist}) {
		my $thread = &OpenThread($topic, $forum);
		my $prefix = "$forum|$topic";
		my $replies = scalar(@{$thread});

		foreach my $post (1 .. ($replies - 1)) {
			my($m, $d, $y) = split(/\-/, $thread->[$post]->[3]);
			my $p = &indexify($thread->[$post]->[6]);
			next unless $p;
			push(@dex, "$prefix|$thread->[$post]->[1]|" .
				join("-", $m, $d, &Y2K($y)) . "|" .
				$thread->[0]->[4] . "|" .
				$p);
		} # end foreach
	} # end foreach

	my $dir = qq($vars_config{NonCGIPath}/cache-$vars_config{cache_pw}/search_index);
	if(!&DirExists($dir)) {
		mkdir($dir, 0777);
		chmod(0777, $dir);
	} # end if

	$dir .= ($vars_search{IndexMethod} eq "PERFORUM" ? "/forumindex$forum.cgi" : '/forumindex.cgi' );
	&AppendFileAsArray($dir, @dex);

} # end build_index_tng_core

sub build_index_tng_figureforum {
	my $number = shift;
	&GetForumRecord(0);
	my $last_number = (sort {$a <=> $b} keys %vars_forums)[-1];
	while((!exists $vars_forums{$number}) || (!$vars_forums{$number})) {
		$number++;
		return undef if $number > $last_number;
	} # end while
	return $number;
} # end build_index_tng_figureforum

# Danger- do not remove the following line!
1;
# $Id: cp_index.cgi,v 1.15 2002/05/03 18:27:33 cvscapps Exp $