# Import Archives from UBB5 to UBB.classic 6
# this script grabs old archives and imports them as read-only forums for UBB.classic 6

# make sure we have archives to grab:
unless (&FileExists("$vars_config{NonCGIPath}/Archives/archives.pl")) {
	&StandardHTML("Sorry- there are no archives to import.  Are you sure the board you are upgrading from UBB5 contained archives?");
	exit(0);
}

unless (-w "$vars_config{NonCGIPath}/Archives/archives.pl") {
	&StandardHTML("Your archives.pl file does not have write permissions.  Please reset permissions on it and try the import again.");
	exit(0);
}


my @check_archives = &OpenFileAsArray("$vars_config{NonCGIPath}/Archives/archives.pl");
if ($check_archives[0] eq '') {
	&StandardHTML("Sorry- there are no archives to import.  Are you sure the board you are upgrading from UBB5 contained archives?");
	exit(0);
}

sub import_archives {

	# we have archives, so create new forums:
	$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="get_archives">
%;
	$CurrentTab = qq%Import UBB5 Archives%;

	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_import_archives");
	&CPBottom;
}

sub get_archives {
	local ($one, @forums, $new_forum_line, $line, @archives, @cats, @archive_topics, $topic, @this_at, $total_posts, $archive_count, $total_cats, $this_post_count, @revised_archive, $revised_archive_count);
	$total_posts = 0;

	@archives = &OpenFileAsArray("$vars_config{NonCGIPath}/Archives/archives.pl");

	# only update cats if beginning import process...
	if ($in{next} eq '') {

		# add category to category file:
		if (&FileExists("$vars_config{NonCGIPath}/categories.file")) {
			@cats = &OpenFileAsArray("$vars_config{NonCGIPath}/categories.file");
		} else {
			@cats = '';
		}

		$total_cats = @cats;
		$total_cats++;
		my $new_order    = &Do6Digit($total_cats);
		my $new_cat_line = qq!$new_order|^|Our Archives|^|$total_cats\n!;
		push (@cats, $new_cat_line);

		&WriteFileAsArray("$vars_config{NonCGIPath}/categories.file", @cats);
	}    # if next eq ''


	if ($in{next} ne '') { $total_cats = $in{next}; }

	# now add new forums:
	@forums = &OpenForumsFile;

	# get last forum number
	my @rev_forums  = reverse(@forums);
	my @last_forum  = split (/\|\^\|/, $rev_forums[0]);
	my $last_number = $last_forum[8];


	# only do one archive at a time-- in case they are large
	MYARCHIVE: foreach (@archives) {
		chomp($_);
		@this_archive = split (/\|\#\|/, $_);
		$last_number++;

		# create forum directory
		mkdir("$vars_config{NonCGIPath}/Forum$last_number", SEVENSEVENSEVEN);
		chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/Forum$last_number");

		$new_forum_line = "$total_cats|^|$this_archive[1]|^|$this_archive[2]|^|On|^|is not|^|is|^|none&none|^||^|$last_number|^||^|ON|^|no|^||^||^|$last_number|^|abc|^|\n";

		push (@forums, $new_forum_line);

		# import topics
		if (&DirExists("$vars_config{NonCGIPath}/Archives/Archive-$this_archive[0]")) {

			opendir(FILE, "$vars_config{NonCGIPath}/Archives/Archive-$this_archive[0]");
			@archive_topics = grep(/.cgi$/, readdir(FILE));
			closedir(FILE);

			$archive_count = 0;
			foreach $topic (@archive_topics) {
				$archive_count++;
				$archive_count = &Do6Digit($archive_count);
				@this_at       = &OpenFileAsArray("$vars_config{NonCGIPath}/Archives/Archive-$this_archive[0]/$topic");

				# print to new dir:
				$this_post_count = scalar(@this_at) - 1;
				&WriteTopic($last_number, $archive_count, @this_at);
				$archive_count =~ m/^(\d{4})(\d{2})$/;
				my ($lefty, $righty) = ($1, $2);
				&UpdateForumThreadDataForSingleThread($last_number, $lefty, $righty, @this_at);

				$total_posts = $total_posts + $this_post_count;

				# delete old archive record
				chmod(SEVENSEVENSEVEN, "$vars_config{NonCGIPath}/Archives/Archive-$this_archive[0]/$topic");
				&Unlink("$vars_config{NonCGIPath}/Archives/Archive-$this_archive[0]/$topic");

			}    # foreach topic

		}    # if archives exists

		# update forum file
		&WriteFileAsArray("$vars_config{VariablesPath}/vars_forums.cgi", @forums);

		# set stat files
		my $archive_count3 = $archive_count + 0;
		&WriteFileAsString("$vars_config{NonCGIPath}/Forum$last_number/lastnumber.file", "$archive_count\n$archive_count3\n$total_posts\n");

		# adjust old archive file:

		my @newarch = ();
		foreach $one (@archives) {
			push (@newarch, $one) unless ($one =~ /^($this_archive[0])/);
		}

		&WriteFileAsArray("$vars_config{NonCGIPath}/Archives/archives.pl", @newarch);

		&WriteAllForumThreadData($last_number);
		&GenerateDotThreadsFile($last_number);

		last MYARCHIVE;
	}    # foreach archive

	# assign proper template for new forum
	&RequireVars("$vars_config{VariablesPath}/vars_template_match.cgi");
	$thiskey = "forum_$last_number";
	$template_match{$thiskey} = "2";

	&WriteHashesToFile("$vars_config{VariablesPath}/vars_template_match.cgi", ["template_match", "template_html"], [\%template_match, \%template_html]);

	# clear cache
	&ClearSummaryCache;

	# end/continue?
	@revised_archives      = &OpenFileAsArray("$vars_config{NonCGIPath}/Archives/archives.pl");
	$revised_archive_count = @revised_archives;

	if ($revised_archive_count > 0) {
		&cp_transition("$vars_config{CGIURL}/cp.cgi?ubb=get_archives&next=$total_cats",
		"We are still importing your archives.  Please wait for the process to finish!",
		"Archive Importation In Progress", "Continuing Import");
	} else {
		&cp_confirm("Archive Importation Completed!");
	}


}    # end get_archives

# DO NOT REMOVE THIS LINE:
1;
# $Id: cp_import.cgi,v 1.6 2002/04/18 22:27:17 cvscapps Exp $
