# Control panel - routines to define and alter custom Graemlins (smilies)

sub c_g_Intro {
	$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="graemlin_submit">
!;
	$CurrentTab = qq%Update Graemlin$trademark Settings%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_graemlin_intro");
	&CPBottom;
	exit(0);
}    #endsub c_u_Intro

sub c_g_WriteVarsGraemlins {
	my $string = qq%\$vars_graemlins = {\n\t'origs' => {\n%;

	my @warnings;

	foreach my $item (sort keys %{$vars_graemlins->{'origs'}}) {
		my $short = %$vars_graemlins->{'origs'}->{$item};
		$string .= qq%\t\t\tq~$item~% . qq% => {\n%;
		$string .= qq%\t\t\t\tq~trigger~% . q% => q~% . &SmallClean2($short->{'trigger'}) . qq%~,\n%;
		$string .= qq%\t\t\t\tq~image~% . q% => q~% . &SmallClean2($short->{'image'}) . qq%~,\n%;
		$string .= qq%\t\t\t\tq~text~% . q% => q~% . &SmallClean2($short->{'text'}) . qq%~,\n%;
		$string .= qq%\t\t\t},\n%;

		foreach my $ugh (qw(trigger image text)) {
			if ($short->{$ugh} eq '') { push (@warnings, $item); }
		}    #endforeach
	}    #endforeach

	$string .= qq%\t},\n%;
	$string .= qq%\tq~graems~ => {\n%;
	my $internalcount = 0;
	foreach my $item (sort keys %{$vars_graemlins->{'graems'}}) {
		my $shirt = %$vars_graemlins->{'graems'}->{$item};
		$internalcount++;
		$newitem = &Do2Digit($internalcount) . "_" . $shirt->{'trigger'};
		$string .= qq%\t\t\tq~$newitem~% . qq% => {\n%;
		$string .= qq%\t\t\t\tq~trigger~% . q% => q~% . &SmallClean2($shirt->{'trigger'}) . qq%~,\n%;
		$string .= qq%\t\t\t\tq~image~% . q% => q~% . &SmallClean2($shirt->{'image'}) . qq%~,\n%;
		$string .= qq%\t\t\t\tq~text~% . q% => q~% . &SmallClean2($shirt->{'text'}) . qq%~,\n%;
		$string .= qq%\t\t\t},\n%;

		foreach my $ugh (qw(trigger image text)) {
			if ($shirt->{$ugh} eq '') { push (@warnings, $item); }
		}    #endforeach
	}    #endforeach

	$string .= qq%\t},%;
	$string .= qq%\n\tq~custgraems~ => q~$internalcount~,%;
	$string .= qq%\n}\;\n1\;\n%;

	if ($warnings[0]) {

		#foreach(@warnings) { s/^\d\d_(.+)$/$1/g; }
		#my $list = join("<br />", @warnings);
		&StandardHTML("You can not leave fields blank.  Please return and ensure that all fields are filled out correctly.<br />To delete a custom Graemlin, click to the checkbox to the left of its image.");
		exit(0);
	}

	&WriteFileAsString("$vars_config{VariablesPath}/vars_graemlins.cgi", $string);

	&ClearMiscCache;

}    #endsub c_g_WriteVarsGraemlins

sub c_g_ParseGraemlinFormData {

	my (%graemdeletes);
	foreach my $item (sort keys %in) {
		if ($item =~ m/^orig/) {
			my ($junk, $key, $val) = split (/\|\!\|/, $item);
			$vars_graemlins->{'origs'}->{$key}->{$val} = $in{$item};
			if($in{$item} =~ m/("|'|`)/) {
				&StandardHTML("Sorry, your Graemlin name, trigger wording, or description may not contain any quote characters!");
			}
		} elsif ($item =~ m/^graem/) {
			my ($junk, $key, $val) = split (/\|\|/, $item);

			if ($item =~ m/delete$/) {
				$graemdeletes{$key} = 1;
			}
			$vars_graemlins->{'graems'}->{$key}->{$val} = $in{$item};
		}    #endif
	}    #endforeach
	my $thecount = 0;

	foreach my $item (keys %{$vars_graemlins->{'graems'}}) {
		if (exists $graemdeletes{$item}) { delete $vars_graemlins->{'graems'}->{$item}; }
		$thecount++;
	}
	$vars_graemlins->{'custgraems'} = $thecount;

	&c_g_WriteVarsGraemlins;

	&cp_confirm("Graemlin Settings Updated", undef, "Graemlin Settings", "$vars_config{CGIURL}/cp.cgi?ubb=graemlin_intro");

	exit(0);
}    #endsub   c_g_ParseGraemlinFormData


sub c_g_AddGraemlinIntro {

	if ($vars_graemlins->{'custgraems'} > 25) {
		&StandardHTML("You already have 25 custom Graemlin$trademark entries - you can not enter any more");
	}

	$Hiddens = qq!
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="graemlin_new_submit">
!;
	$CurrentTab = qq%Update Graemlin$trademark Settings%;
	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_graemlin_new");
	&CPBottom;
	exit(0);
}    #endsub c_g_AddGraemlinIntro


sub c_g_AddNewGraemlin {

	my ($key, $fn);

	if ($vars_graemlins->{'custgraems'} > 25) {
		&StandardHTML("You already have 25 custom Graemlin$trademark entries - you can not enter any more");
	}

	my $add = ++$vars_graemlins->{'custgraems'};
	foreach my $item (sort keys %in) {
		if ($item =~ m/^graem/) {
			my ($junk, $junk2, $val) = split (/\|\|/, $item);
			$key = &Do2Digit($add) . "_$in{$item}" if $val eq "trigger";
			$fn = $in{$item} if $val eq "image";
			if($in{$item} =~ m/("|'|`)/) {
				&StandardHTML("Sorry, your Graemlin name, trigger wording, or description may not contain any quote characters: $1");
			}
			if($in{$item} =~ m/(\(|\))/) {
				&StandardHTML("Sorry, your Graemlin name, trigger wording, or description may not contain parentheses:  '$1'");
			}
		}    #endif
	}    #endforeach

	unless (&FileExists("$vars_config{NonCGIPath}/graemlins/$fn")) {
		&StandardHTML("$fn does not exist.  Please go back and choose an image that has been uploaded to your noncgi/graemlins directory!");
		exit(0);
	}

	foreach my $item (sort keys %in) {    #again!
		if ($item =~ m/^graem/) {
			my ($junk, $junk2, $val) = split (/\|\|/, $item);
			$vars_graemlins->{'graems'}->{$key}->{$val} = $in{$item};
		}    #endif
	}    #endforeach

	&c_g_WriteVarsGraemlins;

	&cp_confirm("Graemlin Settings Updated", undef, "Graemlin Settings", "$vars_config{CGIURL}/cp.cgi?ubb=graemlin_intro");

	exit(0);

}    #endsub c_g_AddNewGraemlin

1;   # must retutn 'true' for Perl - leave this line alone!

# $Id: cp_graemlins.cgi,v 1.5 2002/03/21 02:10:01 cvscapps Exp $