# Control Panel - Email Members Routines

&RequireVars("$vars_config{VariablesPath}/vars_email.cgi");
&RequireVars("$vars_config{VariablesPath}/vars_template_match.cgi");
&RequireCode("$vars_config{CGIPath}/ubb_lib_mail.cgi");
&RequireVars("$vars_config{VariablesPath}/vars_display.cgi");

sub email_members {
	$Hiddens = qq%<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="email_type">
%;
	$CurrentTab = qq%$vars_wordlets_cp{email_members}%;

	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_email_intro");
	&CPBottom;
}

sub email_type {
	local (@user_profile);
	$Hiddens = qq%
<INPUT TYPE="HIDDEN" NAME="ubb" VALUE="send_email">
<INPUT TYPE="HIDDEN" NAME="email_option" VALUE="$in{email_option}">
%;


	if ($in{email_option} eq 'list_only') {
		$CurrentTab = "Prepare Email List";

	} else {
		$CurrentTab = "Send Emails";

	}

	@user_profile = &OpenProfile($admin_number);
	chomp($user_profile[2]);

	&CPHeader;
	&CPFooter;
	&CPTop;
	&LoadTemplate("cp_email_type");
	&CPBottom;

}    # end email_type


sub send_email {
	local ($one, @all_member_nums, @line, @this_member, @new_array, $bad, $list_served, $sender_included, %good_emails, $random, $message, $HTMLmessage, @user_profile);
	local (*FILE);

	# validate
	if ($in{user_number_start} ne '') {
		unless ($in{user_number_start} > 0) {
			&StandardHTML("$vars_wordlets_err{invalid_number} Low Member Number");
		}
	}

	if ($in{user_number_end} ne '') {
		unless ($in{user_number_start} > 0) {
			&StandardHTML("$vars_wordlets_err{invalid_number} High Member Number");
		}
	}

	if ($in{Posts} ne '') {
		unless ($in{Posts} >= 0) {
			&StandardHTML("$vars_wordlets_err{invalid_number} Number of Posts");
		}
	}

	# filter list first:
	my @all_members_list = &GetMembersListAsArray;

	foreach $one (@all_members_list) {
		@line = split (/\|\!\!\|/, $one);
		chomp($line[1]);
		push (@all_member_nums, $line[1]);
	}

	if (($in{user_number_start} ne '') && ($in{user_number_end} ne '')) {
		foreach (@all_member_nums) {

			if (($_ >= $in{user_number_start}) && ($_ <= $in{user_number_end})) {
				push (@new_array, $_);
			}    # end unless
		}    # end foreach

		@all_member_nums = @new_array;
	}    # end if

	# clear working array
	undef(@new_array);

	THIS: foreach $one (@all_member_nums) {
		next THIS unless $one =~ m/^\d{8}$/;
		$bad = 'no';

		# open profile
		@this_member = &OpenProfile($one);

		# filter by member allow
		chomp($this_member[14]);
		if ($this_member[14] eq 'no') { $bad = 'yes'; }

		# filter by status
		if (($in{user_status} ne '') && ($bad ne 'yes')) {
			chomp($this_member[8]);
			if ($in{user_status} eq 'admin') {
				unless ($this_member[8] eq 'Administrator') { $bad = 'yes'; }
			} else {

				unless (($this_member[8] eq 'Administrator') || ($this_member[8] eq 'Moderator')) {
					$bad = 'yes';
				}
			}

		}    # end user status check

		# posts filter
		if (($in{Posts} ne '') && ($bad ne 'yes')) {
			chomp($this_member[7]);
			if ($in{Math} eq 'GT') {
				unless ($this_member[7] >= $in{Posts}) { $bad = 'yes'; }
			} elsif ($in{Math} eq 'LT') {
				unless ($this_member[7] <= $in{Posts}) { $bad = 'yes'; }
			} else {
				unless ($this_member[7] == $in{Posts}) { $bad = 'yes'; }
			}
		}    # end posts check

		chomp($this_member[2]);
		if ($bad ne 'yes') {
			unless (exists($good_emails{$this_member[2]})) {
				$good_emails{$this_member[2]} = 'y';
				push (@new_array, $this_member[2]);
			}

		}

	}    # end foreach one

	@all_member_nums = @new_array;
	my $total = @all_member_nums;

	# now we have the complete filtered list-> @all_member_nums

	# delimiter:
	if ($in{email_option} eq 'list_only') {

		if ($in{list_type} eq 'lr') {

			if ($in{send_list} eq 'onscreen') {
				$list_served = join ("<BR>", @all_member_nums);
			} else {
				$list_served = join ("\n", @all_member_nums);
			}

		} else {
			$list_served = join (", ", @all_member_nums);
		}

		$random = &GeneratePassword;

		# choose formatting
		if ($in{send_list} eq 'file') {

			&WriteFileAsString("$vars_config{NonCGIPath}/email_members_$random.txt", "$list_served\n");

			&cp_confirm("List Created", "Thank you.  We have created a file containing all matching email addresses.  There were $total unique email addresses.  This file is stored in your UBB NON CGI directory.  The file name is: email_members_$random.txt<P>We advise you to remove this file from your server after you have used it.");
			exit(0);

		} elsif ($in{send_list} eq 'onscreen') {

			&cp_confirm("List Created", "Thank you.  We have printed your entire list below.  There were $total unique email addresses that matched the criteria you provided.<P>$list_served<P>");
			exit(0);


		} else {

			# by email
			&RequireVars("$vars_config{VariablesPath}/vars_wordlets_email.cgi");

			my $s = &EmailWordletFixer;
			eval($s);
			if(defined &EmailWordletFiller) {
				%vars_wordlets_email = &EmailWordletFiller();
			} else {
				&StandardHTML($vars_wordlets_criterr{no_email_wordlet_filler} . ": $@");
			} # end if

			$message = "$vars_wordlets_email{email_list}\n\r\n$list_served";

			# get email address for logged in user
			@user_profile = &OpenProfile($admin_number);
			chomp($user_profile[2]);


			# do not send as HTML email!
			$in{email_type} = "text";
			&ubb_mail_tng({
				'EmailTo' => $user_profile[2],
				'EmailFrom' => $vars_display{BBEmail},
				'EmailReplyTo' => $vars_display{BBEmail},
				'BCCList' => undef,
				'Subject' => "$vars_wordlets_email{email_list_subject}: $random",
				'TextMessage' => $message,
				'HTMLMessage' => undef,
				'CCList' => undef,
			});


			&cp_confirm("List Created", "Thank you.  We have emailed your entire list to $user_profile[2].  There were $total unique email addresses that matched the criteria you provided.  The reference number for this email list is: $random.");
			exit(0);
		}


	} else {

		# actually send emails
		if ($total > 200) {
			&StandardHTML("$vars_wordlets_err{too_many_emails} $total");
		}

		# validate HTML form
		my @ValidateArray = ("return_email", "subject", "message");
		&Validate(@ValidateArray);

		# get email address for logged in user- for BCC
		@user_profile = &OpenProfile($admin_number);
		chomp($user_profile[2]);

		$list_served = join (", ", @all_member_nums);

		my $text_message_or_not;

		# is HTML format to be sent?
		if ($in{email_type} eq 'html') {

			# set email template
			%vars_style = &LoadStyleTemplate("email");
			&LoadTemplate("public_common");
			&set_page_elements;
			my $html_body = qq!<FONT face="$vars_style{FontFace}" size="$vars_style{TextSize}">! . "$in{message}" . qq!</FONT>!;

			$text_message_or_not = "";
			$HTMLmessage = "$EmailHeader $html_body $Footer";
		} else {
			$text_message_or_not = $in{message};
			$HTMLmessage = '';
		}

		foreach (@all_member_nums) {
			if ($_ eq "$user_profile[2]") { $sender_included = 'yes'; }

			&ubb_mail_tng({
				'EmailTo' => $_,
				'EmailFrom' => $in{return_email},
				'EmailReplyTo' => $in{return_email},
				'BCCList' => undef,
				'Subject' => $in{subject},
				'TextMessage' => $text_message_or_not,
				'HTMLMessage' => $HTMLmessage,
				'CCList' => undef,
			});


		}    # foreach

		# send copy to sender:
		if ($sender_included ne 'yes') {
			&ubb_mail_tng({
				'EmailTo' => $user_profile[2],
				'EmailFrom' => $in{return_email},
				'EmailReplyTo' => $in{return_email},
				'BCCList' => undef,
				'Subject' => $in{subject},
				'TextMessage' => $in{message},
				'HTMLMessage' => $HTMLmessage,
				'CCList' => undef,
			});

		}

		&cp_confirm("Email Sent!", "Thank you.  We have sent an email to each member that matches the criteria you selected. We have also sent you a copy of this email.  There were $total unique email addresses that matched the criteria you provided.  Here is the complete list of email addresses:<P>$list_served");
		exit(0);

	}    # end email option if/else


}    # end send_email

# Danger- do not remove the following line!
1;
# $Id: cp_email.cgi,v 1.10 2002/03/15 01:16:44 cvscapps Exp $