#!/usr/bin/perl

# Whoops!  If you see this message in your browser, your web hosting provider
# has not properly mapped the .cgi file extension to Perl.
#
# Please contact them for more information.  Mapping .cgi is easy for both
# Unix and NT servers, and usually only takes a few seconds.






# UBB.classic 6.x
# Official Release Date for UBB.classic 6.0: March 15, 2001
#
# First version of UBB created May 7, 1996 (by Ted O'Neill).
# This entire program is copyright Infopop Corporation, 2002.
# For more info on UBB.classic and other Infopop
# Products and Services, visit: http://www.infopop.com
#
# Program Author: Ted O'Neill, with assistance from Michael Farris, Dave Dreezer
#
# Special Thanks to: Rosemary O'Neill, Mark Badolato, Charles Capps,
# Graeme, Jesus de la Garza, Joe Siegler, Hal, Brett Harris, Kristi Miller,
# Celeste Combs, everyone who beta-tested, and all of our support moderators!
#
# UBB.classic 6.x is dedicated to Edward Kriz.
#
# You may not distribute this program in any manner, modified or otherwise,
# without the express, written written consent from Infopop Corporation.
#
# You may make modifications, but only for your own use and within the confines
# of the UBB.classic License Agreement (see our website for the full license).
#
# You may not distribute "hacks" for UBB.classic without approval from Infopop.
#
# Note: If you modify ANY code within your UBB.classic, we at Infopop Corporation
# cannot offer you support -- thus modify at your own peril :)

BEGIN {	# get our modules directory set up
	($0 =~ m!(.*)(\\|/)[^/\\]+!) && unshift(@INC, $1, "$1$2Modules");
}

use lib("./Modules", ".");	# if there's no $0, or it's not sane...

use strict;
use Fcntl ':flock';
use UBBCGI qw(:cgi);	# CGIPath/Modules/UBBCGI.pm
use UBBCGI::Carp qw(fatalsToBrowser set_message);	# CGIPath/Modules/UBBCGI/Carp.pm

use constant SEVENSEVENSEVEN => 0777;
use constant SIXSIXSIX => 0666;

use vars qw(%vars_wordlets_criterr %vars_forums %vars_poll $vars_groups $user_permissions %vars_pntf $ULTIMATEBB $filehandle %vars_style_reference $masterCharset $trade $catcher $profilecachehit $openprofilecount $openfilecount $unlockcount $lockcount $t2 $t0 $trademark %vars_config %vars_display %vars_email %GotTime $status @memberslist %vars_wordlets_cp %vars_wordlets_email %vars_wordlets_err %vars_wordlets_img %vars_wordlets_date %template_match %vars_wordlets %vars_misc %vars_style %vars_search %vars_registration %vars_time @ubbadmin $username $password $InfopopCopyright $ThisHTML %in %ProfileNumber $memlistopen $CurrentTab %template $template $CPMenu $CPHeader $CPFooter $CPDropDown $Hiddens $public_name $LoginWording $admin_number $direct_to $version $version_number $cache_cookie %member_profile $selscript $exact_path $doingwhat @profile $release_j);

undef($username); undef($password); undef(%ProfileNumber);
undef($memlistopen); undef($Hiddens); undef($public_name);
undef($admin_number); undef(%member_profile); undef($selscript);
undef(@ubbadmin); undef($ThisHTML); undef($CPMenu); undef($CPHeader);
undef($CPFooter); undef($LoginWording); undef($cache_cookie);
undef($status); undef(@memberslist); undef(%in); undef($exact_path);

# We want to do this now rather than continue to make
# up to 1000 calls to CGI.pm routines per instance...
%in = map{$_ => param($_)} param();	#map is your friend!




##################################################################################
# NOTE TO USERS WHO ARE RUNNING UBB.classic IN THE NON-WRITABLE CGI-BIN SITUATION:
# Modify the path in the following 'do' line to reflect the VariablesPath!
# There is NO NEED to modify this line unless you are using a different
# VariablesPath.  PLEASE use the UBB's CGI directory as the VariablesPath
# if at all possible.  Thanks.
##################################################################################

eval {
	do "vars_config.cgi";
};

&CheckDollarAt($@);

#print header;
#print "Eh?";
#exit;


# is ubb6 configured yet/properly?
unless ((-e "$vars_config{MembersPath}/last_number.cgi")
    && (-e "$vars_config{VariablesPath}/vars_config.cgi")
    && (-e "$vars_config{CGIPath}/ultimatebb.cgi")) {
	# need to configure the UBB
	require "ubb_setup.cgi";
	if ($in{ubb} eq '') {
		&InitialConfig;
	} elsif ($in{ubb} eq 'env') {
		&DoEnv;
	} elsif ($in{ubb} eq 'set_initial') {
		&SetInitial;
	} else {
		print<<END;
Content-type: text/plain

Sorry, I can't process ubb=$in{ubb} during an initial setup.  Please try again without it.
END
	} # end if
	exit(0);
} # end unless

	# no need to touch there statements:
eval {	require "ubb_lib.cgi";	}; &CheckDollarAt($@);
	&RequireCode("$vars_config{CGIPath}/ubb_lib_files.cgi");
	&RequireCode("$vars_config{CGIPath}/ubb_lib_filehandler.cgi");
	&RequireCode("$vars_config{CGIPath}/ubb_lib_filehandle.cgi");
	&RequireCode("$vars_config{CGIPath}/ubb_lib_time.cgi");

	# Need to load public_common here so
	# it does not try to redefine cp_lib's
	# &StandardHTML routine with its own.
	&LoadTemplate("public_common");

	&RequireCode("$vars_config{CGIPath}/cp_lib.cgi");

	# init our FileHandler object
	$filehandle = new UBB::FileHandler(\%vars_config, "global");

sub CheckDollarAt {
	my $error = shift;
	return unless $error;

	$masterCharset = "ISO-8859-1" unless $masterCharset;
	print header(
		-charset => "$masterCharset",
		-type    => "text/html",
	);

	print "<p><br />There was a compilation error while loading the UBB.classic libraries and data files: <pre>\n$error</pre><br />";
	print "Please make sure that you uploaded the CGI and Variables files to the proper directory, permissions are set properly "
	. "on the files, and that paths in the control panel are set correctly.</p>";
	exit;
}

$cache_cookie = $vars_config{cache_pw};
$template     = \%template;

# What is this?  Looks left over from 6.0 Beta 3?
unless (exists($vars_config{CachePath})) {
	$vars_config{CachePath} = $vars_config{MembersPath};
}


# grab other required files
foreach my $file (qw(display misc email time search pm registration pntf poll template_match wordlets wordlets_cp wordlets_err wordlets_img wordlets_date wordlets_pntf wordlets_poll wordlets_email)) {
	eval { do "$vars_config{VariablesPath}/vars_$file.cgi"; };
	&CheckDollarAt($@);
} # end foreach

&InitImportantStuff; #ubb_lib.. again, now that we have the vars loaded right

# grab admin cookie
@ubbadmin = cookie("ubbadmin$vars_config{Cookie_Number}");


if ($in{ubb} eq 'logout') { &logout; exit(0); }    #end logout

# members area?
if ($in{ubb} eq 'members_area') {
	print redirect('http://www.infopop.com/cgi-bin/directme.cgi?to=members');
	exit(0);
}    #end members_area
     # about_ot?
if ($in{ubb} eq 'about_ot') {
	print redirect('http://www.infopop.com/cgi-bin/directme.cgi?to=ot');
	exit(0);
}    #end about_ot

# get current date/time
&GetDateTime;

# counter now disabled in control panel - if there's no cache directory, UBB keels over
#&hit_me;

&LoadTemplate("cp_common");

set_message(\&StandardHTML2);	# friendly errors from UBBCGI::Carp

# check our Perl version
die &Template($vars_wordlets_criterr{old_perl}, {VERSION => $]}) if $] < 5.004;

# is user logged in?
if (@ubbadmin) {
	$username     = $ubbadmin[0];
	$password     = $ubbadmin[1];
	$status       = $ubbadmin[2];
	$public_name  = $ubbadmin[3];
	$admin_number = $ubbadmin[4];
	chomp($username);
	chomp($password);
	chomp($status);
	chomp($public_name);
	chomp($admin_number);

	print header();

	# verify cookie id
	my @this_admin = &verify_id_num($username, $password, $admin_number);

	# is admin/mod?
	my $is_one = &is_admin_or_mod("ALL", @this_admin);
	$status = $this_admin[8];
	chomp($status);
	if ($is_one ne 'true') {
		print qq%Content-type: text/html\n\n%;
		&StandardHTML("$vars_wordlets_err{not_admin_or_mod}");
	} # end if

} else {

	# not currently logged in---

	if ($in{username}) {

		$username = $in{username};
		$password = $in{password};

		# verify identity:
		&RequireCode("$vars_config{CGIPath}/ubb_lib_2.cgi");

		my @user_info = &verify_id_4_cpanel($username, $password);
		my $pn        = $user_info[0];
		my $admin_num = $user_info[2];
		my @get_profile = &OpenProfile($admin_num);
		$status = $get_profile[8];
		chomp($status);


		&CheckPermission_CP;
		my $cookie = cookie(
			-name  => "ubbadmin$vars_config{Cookie_Number}",
			-value => [$username, $password, $status, $pn, $admin_num],
			-path  => '/',
		);
		print header(-cookie => $cookie);

	} else {

		&AppendAdminLog("", "", "Prompted to Log In", "Succeeded", "User is not logged in");
		$LoginWording = qq%<font color="navy">&#187;</font> $vars_wordlets_cp{not_logged_in} <font color="navy">&#171;</font>%;
		print header();
		&QueryLogin;
		exit(0);
	} # end if
} # end if


$LoginWording = qq%<font color="Navy">&#187;&#187;</font> $vars_wordlets_cp{welcome} $public_name &nbsp;&nbsp; [<a href="cp.cgi?ubb=logout">$vars_wordlets_cp{logout}</a>]%;

my $ubb = $in{ubb};


if($username && $admin_number) {
	# Yay, security groups!
	&RequireCode("$vars_config{CGIPath}/ubb_lib_secgroups.cgi");
	my @ur = &OpenProfile($admin_number);
	&GetForumRecord(0) if $in{f};
	$vars_groups = new UBB::SecurityGroups({
			'CONFIG' => \%vars_config,
			'FILEHANDLER' => $filehandle,
			'VARSFORUMS' => \%vars_forums,
			'IN' => \%in});
	$vars_groups->load_groups();
	$user_permissions = new UBB::SecurityToken($vars_groups, $admin_number, \@ur, \%vars_forums, \%in);
} # end if


# And now, we decide what we're really supposed to be doing!  :)

if ($ubb eq '') { $ubb = 'entry'; }

# Control Panel Options
if ($ubb eq 'entry') { &cp_entry_page; exit(0); }    # end entry

if (($ubb eq 'vars_display') && ($status eq 'Administrator')) {
	&view_vars("display");
	exit(0);
}    #end vars_display

if (($ubb eq 'set_vars_display') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_display;
	exit(0);
}    #end set_vars_display

if (($ubb eq 'vars_avatar') && ($status eq 'Administrator')) {
	&view_vars("avatar");
	exit(0);
}    #end vars_display

if (($ubb eq 'set_vars_avatar') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_avatar;
	exit(0);
}    #end set_vars_pntf

if (($ubb eq 'vars_pntf') && ($status eq 'Administrator')) {
	&view_vars("pntf");
	exit(0);
}    #end vars_pntf

if (($ubb eq 'set_vars_pntf') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_pntf;
	exit(0);
}    #end set_vars_pntf

if (($ubb eq 'vars_email') && ($status eq 'Administrator')) {
	&view_vars("email");
	exit(0);
}    #end vars_email

if (($ubb eq 'vars_pm') && ($status eq 'Administrator')) {
	&view_vars("pm");
	exit(0);
}    #end vars_pm

if (($ubb eq 'set_vars_pm') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_pm;
	exit(0);
}    #end set_vars_pm

if (($ubb eq 'set_vars_email') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_email;
	exit(0);
}    #end set_vars_email

if (($ubb eq 'vars_time') && ($status eq 'Administrator')) {
	&view_vars("time");
	exit(0);
}    #end vars_time

if (($ubb eq 'set_vars_time') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_time;
	exit(0);
}    #end set_vars_time

if (($ubb eq 'email_members') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_email.cgi");
	&email_members;
	exit(0);
}    #end email_members


if (($ubb eq 'email_type') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_email.cgi");
	&email_type;
	exit(0);
}    #end email_type

if (($ubb eq 'send_email') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_email.cgi");
	&send_email;
	exit(0);
}    #end send_email

if (($ubb eq 'vars_registration') && ($status eq 'Administrator')) {
	&view_vars("registration");
	exit(0);
}    #end vars_registration

if (($ubb eq 'set_vars_registration') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_registration;
	exit(0);
}    #end set_vars_registration

if (($ubb eq "vars_search") && ($status eq 'Administrator')) {
	&view_vars("search");
	exit(0);
}    #end vars_search

if (($ubb eq 'set_vars_search') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_search;
	exit(0);
}    #end set_vars_search

if (($ubb eq 'vars_misc') && ($status eq 'Administrator')) {
	&view_vars("misc");
	exit(0);
}    #end vars_misc

if (($ubb eq 'set_vars_misc') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_misc;
	exit(0);
}    #end set_vars_misc

if (($ubb eq 'vars_poll') && ($status eq 'Administrator')) {
	&view_vars("poll");
	exit(0);
}    #end vars_misc

if (($ubb eq 'set_vars_poll') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_poll;
	exit(0);
}    #end set_vars_misc

if (($ubb eq 'vars_config') && ($status eq 'Administrator')) {
	&view_vars("config");
	exit(0);
}    #end vars_config

if (($ubb eq 'set_vars_config') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&set_vars_config;
	exit(0);
}    #end set_vars_config

if (($ubb eq 'vars_style_temp_list') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_styles.cgi");
	&view_style_templates;
	exit(0);
}    #end vars_style_temp_list

if (($ubb eq 'vars_style') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_styles.cgi");
	&view_style;
	exit(0);
}    #end vars_style

if (($ubb eq 'templates_advanced') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_styles.cgi");
	&templates_advanced;
	exit(0);
}    #end templates_advanced

if (($ubb eq 'templates_advanced_forums') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_styles.cgi");
	&templates_advanced_forums;
	exit(0);
}    #end templates_advanced_forums

if (($ubb eq 'set_advanced_templates') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_styles.cgi");
	&set_advanced_templates("$in{type}");
	exit(0);
}    #end set_advanced_templates

if (($ubb eq 'set_vars_style') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_styles.cgi");
	&set_vars_style;
	exit(0);
}    #end set_vars_style

if (($ubb eq 'add_style_template') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_styles.cgi");
	&add_style_template;
	exit(0);
}    #end add_style_template

if (($ubb eq "set_new_template") && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_styles.cgi");
	&set_new_template;
	exit(0);
}    #end set_new_template

if (($ubb eq "do_add_forum") && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_forums.cgi");
	&do_add_forum;
	exit(0);
}    #end vars_forums

if ($ubb eq 'get_forum_details') {
	&RequireCode("$vars_config{CGIPath}/cp_forums.cgi");
	&get_forum_details;
	exit(0);
}    #end get_forum_details

if ($ubb eq 'update_forum') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_forums.cgi");
	&update_forum;
	exit(0);
}    #end update_forum

if (($ubb eq 'delete_forum') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_forums.cgi");
	&delete_forum;
	exit(0);
}    #end delete_forum

if ($ubb eq 'vars_forums') {
	&RequireCode("$vars_config{CGIPath}/cp_forums.cgi");
	&view_forum_intro;
	exit(0);
}    #end vars_forums

if (($ubb eq 'set_vars_forums') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_forums.cgi");
	&set_vars_forums;
	exit(0);
}    #end set_vars_forums

if (($ubb eq 'cats') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_forums.cgi");
	&view_cats;
	exit(0);
}    #end view_cats

if (($ubb eq 'set_cats') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_forums.cgi");
	&set_cats;
	exit(0);
}    #end set_cats

if (($ubb eq 'addforums') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_forums.cgi");
	&add_forum;
	exit(0);
}    #end set_addforums

if (($ubb eq 'set_vars_mods') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_forums.cgi");
	&set_mods;
	exit(0);
}    #end set_mods

if (($ubb eq 'ban_lists') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_bans.cgi");
	&ban_lists;
	exit(0);
}    #end ban_lists

if (($ubb eq 'update_bans') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_bans.cgi");
	&update_bans;
	exit(0);
}    #end update_bans

if (($ubb eq 'vars_mod') && ($status eq 'Administrator')) {
	&view_vars("mods");
	exit(0);
}    #end vars_mod

if (($ubb eq 'user_settings') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&user_settings;
	exit(0);
}    #end user_settings


if (($ubb eq 'user_posts') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&recent_user_posts_for_admin;
	exit(0);
}    #end user_settings

if (($ubb eq 'search_members2') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&search_members2;
	exit(0);
}    #fear the memsearch!

if (($ubb eq 'continue_user_search') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&continue_user_search;
	exit(0);
}    #end

if (($ubb eq 'show_user_search_results') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&show_user_search_results;
	exit(0);
}    #end

if (($ubb eq 'update_members') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&update_members;
	exit(0);
}    #end update_members

if (($ubb eq 'get_profile_for_admin') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&get_profile_for_admin;
	exit(0);
}    #end get_profile_for_admin

if (($ubb eq 'edit_profile') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&edit_profile;
	exit(0);
}    #end edit_profile

if (($ubb eq 'new_members') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&new_members;
	exit(0);
}    #end new_members

if (($ubb eq 'reg_moderation') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&reg_moderation;
	exit(0);
}    #end reg_moderation

if (($ubb eq 'update_q') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_users.cgi");
	&update_q;
	exit(0);
}    #end update_q

if (($ubb eq 'cache') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_cache.cgi");
	&cache;
	exit(0);
}    #end cache

if (($ubb eq 'clear_cache') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_cache.cgi");
	&clear_cache;
	exit(0);
}    #end clear_cache


if (($ubb =~ /wordlets/) && ($ubb !~ m/^(set|update)/) && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_wordlets.cgi");
	&view_wordlets($ubb);
	exit(0);
}    #end view_wordlets

if (($ubb eq 'set_wordlets') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_wordlets.cgi");
	&set_wordlets;
	exit(0);
}    #end set_wordlets


if (($ubb eq 'update_wordlets') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_new_wordlets.cgi");
	&c_n_w_PresentLists;
	exit(0);
}    #end set_wordlets

if (($ubb eq 'update_wordlets_submit') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_new_wordlets.cgi");
	&c_n_w_SeperateInput;
	exit(0);
}    #end set_wordlets


if (($ubb eq 'update_wordlets_intro') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_new_wordlets.cgi");
	&c_n_w_UpdateWordlets;
	exit(0);
}    #end set_wordlets

if ($ubb eq 'version_check') {
	&RequireCode("$vars_config{CGIPath}/cp_license.cgi");
	&version_check;
	exit(0);
}    #end version_check

if ($ubb eq 'prune') {
	&RequireCode("$vars_config{CGIPath}/cp_prune.cgi");
	&prune;
	exit(0);
}    #end prune

if ($ubb eq 'prune_option') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_prune.cgi");
	&prune_by;
	exit(0);
}    #end prune_option

if ($ubb eq 'prune_request') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_prune.cgi");
	if ($in{prune_option} eq "DATE") {
		&prune_by_date_request;
	} else {
		&prune_by_user_request;
	}
	exit(0);
}    #end prune_request

if ($ubb eq 'prune_submit') {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_prune.cgi");
	&prune_submit;
	exit(0);
}    #end prune_submit

if ($ubb eq 'prune_user_refresh') {
	&RequireCode("$vars_config{CGIPath}/cp_prune.cgi");
	&ContinueUserPrune;
	exit(0);
}    #end prune_submit

if ($ubb eq 'prune_refresh') {
	&RequireCode("$vars_config{CGIPath}/cp_prune.cgi");
	&prune_submit;
	exit(0);
}    #end prune_submit

if ($ubb eq 'prune_user_history') {
	&RequireCode("$vars_config{CGIPath}/cp_prune.cgi");
	&PruneUserHistory;
	exit(0);
}    #end prune_submit

if ($ubb eq 'do_index') {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");
	&do_index;
	exit(0);
}

if($ubb eq 'index_tng') {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");
	&build_index_tng;
	exit(0);
} # end index_tng

if ($ubb eq 'index') {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");

	if ($in{start} eq '')        { $in{start}        = 1; }
	if ($in{thread_point} eq '') { $in{thread_point} = 0; }

	&build_index($in{start}, $in{thread_point});
	exit(0);

}    #end index

if (($ubb eq 'post_history') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");
	&post_history;
	exit(0);
}    #end post_history

if (($ubb eq 'update_post_history') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");

	if ($in{start} eq '')        { $in{start}        = 1; }
	if ($in{thread_point} eq '') { $in{thread_point} = 0; }

	&build_history($in{start}, $in{thread_point});
	exit(0);

}    #end update_post_history

# new:
if (($ubb eq 'rebuild_members') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");
	&rebuild_members;
	exit(0);
}    #end post_history

if (($ubb eq 'update_user_last_post') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");
	&UpdateUsersLastPost;
	exit(0);
}    #end post_history


if (($ubb eq 'do_rebuild_members') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");

	if ($in{start} eq '') { $in{start} = 0; }

	&build_members($in{start}, $in{thread_point});
	exit(0);

}    #end do_rebuild_members


if (($ubb eq 'forum_stats2') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");
	&forum_stats2;
	exit(0);
}    #end forum_stats

if (($ubb eq 'build_forum_stats2') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");
	if ($in{build_forum} eq 'ALL') {
		&all_build_forum_stats($in{build_forum});
	} else {
		&build_forum_stats2($in{build_forum}, 1);
	}
	exit(0);
}    #end build_forum_stats

if (($ubb eq "all_build_forum_stats") && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_index.cgi");
	&all_build_forum_stats($in{build_forum});
	exit(0);
}    #end all_build_forum_stats

if (($ubb eq 'import_archives') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_import.cgi");
	&import_archives;
	exit(0);
}    # end import_archives

if (($ubb eq 'get_archives') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_import.cgi");
	&get_archives;
	exit(0);
}    # end get_archives

if (($ubb eq 'upgrade') && ($status eq 'Administrator')) {
	&RequireCode("$vars_config{CGIPath}/cp_upgrade.cgi");
	&c_u_Intro;
	exit(0);
}    # end upgrade

if (($ubb eq 'run_upgrade') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireCode("$vars_config{CGIPath}/cp_upgrade.cgi");
	&c_u_DoUpgrade;
	exit(0);
}    # end run_upgrade

if (($ubb eq 'graemlin_intro') && ($status eq 'Administrator')) {
	&RequireVars("$vars_config{VariablesPath}/vars_graemlins.cgi");
	&RequireCode("$vars_config{CGIPath}/cp_graemlins.cgi");
	&c_g_Intro;
	exit(0);
}    # end graemlin_intro

if (($ubb eq 'graemlin_submit') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireVars("$vars_config{VariablesPath}/vars_graemlins.cgi");
	&RequireCode("$vars_config{CGIPath}/cp_graemlins.cgi");
	&c_g_ParseGraemlinFormData;
	exit(0);
}    # end graemlin_submit

if (($ubb eq 'graemlin_new') && ($status eq 'Administrator')) {
	&RequireVars("$vars_config{VariablesPath}/vars_graemlins.cgi");
	&RequireCode("$vars_config{CGIPath}/cp_graemlins.cgi");
	&c_g_AddGraemlinIntro;
	exit(0);
}    # end graemlin_new


if (($ubb eq 'graemlin_new_submit') && ($status eq 'Administrator')) {
	&GetOrPost("POST");
	&RequireVars("$vars_config{VariablesPath}/vars_graemlins.cgi");
	&RequireCode("$vars_config{CGIPath}/cp_graemlins.cgi");
	&c_g_AddNewGraemlin;
	exit(0);
}    # end graemlin_new_submit

if ((($ubb eq 'group_edit') || ($ubb eq 'add_group')) && ($status eq 'Administrator')) {
	&LoadTemplate("cp_user_groups");
	$CurrentTab = "User Groups";
	&addedit_group($in{g}, $ubb);
	exit(0);
}    # end add_group group_edit

if ((($ubb eq 'toggle_on') || (($ubb eq 'toggle_off'))) && ($status eq 'Administrator')) {
	&toggle;
	exit(0);
}    # end toggle

if(($ubb eq "do_group") && ($status eq "Administrator")) {
	&RequireCode("cp_user_groups.cgi");
	&group_edit_add;
	exit(0);
} # end if

if(($ubb eq "user_titles") && ($status eq "Administrator")) {
	&RequireCode("cp_users.cgi");
	&user_titles_intro;
	exit(0);
} # end if

if(($ubb eq "user_titles_update") && ($status eq "Administrator")) {
	&RequireCode("cp_users.cgi");
	&user_titles_update;
	exit(0);
} # end if

if(($ubb eq "import_template") && ($status eq "Administrator")) {
	&RequireCode("cp_styles.cgi");
	&import_template;
	exit(0);
} # end if

if(($ubb eq "export_template") && ($status eq "Administrator")) {
	&RequireCode("cp_styles.cgi");
	&export_template;
	exit(0);
} # end if

# default error-- obviously they do not have permission
print header;
&StandardHTML("$vars_wordlets_cp{no_access}");
exit(0);
# $Id: cp.cgi,v 1.16 2002/05/08 20:53:30 cvscapps Exp $
