<?php
include_once("core/main.php");
// this is forced here for security reasons
if( !check_module("downloads") ) die( "module not enabled" );
if( !$cfg["downloads"]["useradd"] ) die( "function not allowed" );

require_once("phpdbform/phpdbform_form.php");

$index_page = false;
$page_name = $lang["DOWNLOAD_UPLOAD"];

draw_header();
if( !$_SESSION["wt"]["logged"] )
{
    theme_draw_centerbox_open( $lang["DOWNLOAD_UPLOAD"] );
	print "<span class=\"error\">{$lang["NOT_LOGGED_UPLOAD"]}</span>";
	theme_draw_centerbox_close();
    draw_footer();
    exit;
}

$listcat = array();
$ret = db_query("select cod, name from {$config["prefix"]}_downloadscat order by name");
while( $row = db_fetch_array($ret) )
{
	$listcat[] = array( $row["cod"], $row["name"] );
}
db_free_result($ret);

$form = new phpform( "dluploadform", "add_download2.php" );
$form->add_static_listbox( "category", $lang["DOWNLOAD_CATEGORY"], $listcat );
$form->add_textbox( "name", $lang["DOWNLOAD_ULNAME"], 30, 30 );
$form->add_textbox( "url", $lang["DOWNLOAD_ULURL"], 30, 255 );
$form->fields["url"]->value = "http://";
$form->add_textbox( "author_name", $lang["DOWNLOAD_ULAUTHORNAME"], 30, 30 );
$ret = db_query( "select realname from {$config["prefix"]}_users where uid='{$_SESSION["wt"]["uid"]}'" );
$form->fields["author_name"]->value = db_result( $ret, 0, 0 );
db_free_result($ret);
$form->add_textbox( "author_email", $lang["DOWNLOAD_ULAUTHOREMAIL"], 30, 50 );
$form->add_date( "date", $lang["DOWNLOAD_ULDATE"], $cfg["core"]["date_format"] );
$form->fields["date"]->value = date("Y-m-d");
$form->add_textbox( "size", $lang["DOWNLOAD_ULSIZE"], 10, 10 );
$form->add_textarea( "short_description", $lang["DOWNLOAD_ULSDESCR"], 30, 3 );
$form->add_textarea( "description", $lang["DOWNLOAD_ULLDESCR"], 30, 6 );
$form->add_textbox( "url_ss", $lang["DOWNLOAD_ULURLSS"], 30, 127 );
$form->fields["url_ss"]->value = "http://";
$form->add_textarea( "comments", $lang["DOWNLOAD_ULCOMMENTS"], 30, 3 );

theme_draw_centerbox_open( $lang["DOWNLOAD_UPLOAD"] );
$ok = false;
$errors = array();

if( $form->process() )
{
	if( !isset($_SESSION["wt"]["adddownload"]) )
	{
		$form->fields["category"]->value = intval($form->fields["category"]->value);
		$form->fields["name"]->value = trim(strip_tags($form->fields["name"]->value));
		$form->fields["url"]->value = trim(strip_tags($form->fields["url"]->value));
		$form->fields["author_name"]->value = trim(strip_tags($form->fields["author_name"]->value));
		$form->fields["author_email"]->value = trim(strip_tags($form->fields["author_email"]->value));
		$form->fields["date"]->value = trim(strip_tags($form->fields["date"]->value));
		$form->fields["size"]->value = intval($form->fields["size"]->value);
		$form->fields["short_description"]->value = trim(strip_tags($form->fields["short_description"]->value));
		$form->fields["description"]->value = trim(strip_tags($form->fields["description"]->value));
		$form->fields["url_ss"]->value = trim(strip_tags($form->fields["url_ss"]->value));
		$form->fields["comments"]->value = trim(strip_tags($form->fields["comments"]->value));

		if( empty($form->fields["name"]->value) ) $errors[] = $lang["DOWNLOAD_ULERR_NAME"];
		if( (substr( $form->fields["url"]->value, 0, 7 ) != "http://")
			&& (substr( $form->fields["url"]->value, 0, 6 ) != "ftp://")
			|| (strlen($form->fields["url"]->value) < 10 ) )
				$errors[] = $lang["DOWNLOAD_ULERR_URL"];
		if( $form->fields["size"]->value <= 0 ) $errors[] = $lang["DOWNLOAD_ULERR_SIZE"];
		if( strlen($form->fields["short_description"]->value) <= 10 ) $errors[] = $lang["DOWNLOAD_ULERR_SDESCR"];

		if( !empty($errors) )
		{
			print "<div class=\"error\">";
			while( $err = each($errors) )
			{
				print "{$err[1]}<br>\n";
			}
			print "</div>\n";
		} else $ok = true;

		if( $ok )
		{
			$stmt = "insert into {$config["prefix"]}_downloads set"
				." category = {$form->fields["category"]->value},"
				." name = '".addslashes($form->fields["name"]->value)."',"
				." active = 'N',"
				." url = '".addslashes($form->fields["url"]->value)."',"
				." date = '".addslashes($form->fields["date"]->value)."',"
				." size = {$form->fields["size"]->value},"
				." count = 0, rate_sum = 0, rate_count = 0,"
				." short_description = '".addslashes($form->fields["short_description"]->value)."',"
				." description = '".addslashes($form->fields["description"]->value)."',"
				." author_name = '".addslashes($form->fields["author_name"]->value)."',"
				." author_email = '".addslashes($form->fields["author_email"]->value)."',"
				." comments = '".addslashes($form->fields["comments"]->value)."\nIP: ".$_SERVER["REMOTE_ADDR"]."\nDate: ".date("Y-m-d H:i:s")."',"
				." url_screenshot = '".addslashes($form->fields["url_ss"]->value)."'";
			$ret = db_query( $stmt );
			if( !$ret )
			{
				$ok = false;
				print "<div class=\"error\">".$lang["ERROR_04"]."<br>".db_error()."</div>";
			} else {
				print "<div class=\"info\">".$lang["DOWNLOAD_ULOK"]."</div>";
				mail($cfg["core"]["mail_admin"], $lang["DOWNLOAD_ULTHANKS_TITLE"], $lang["DOWNLOAD_ULTHANKS_TEXT"]."\n\n".$cfg["core"]["url"],"From: ".$cfg["core"]["mail_admin"]."\n");
				$_SESSION["wt"]["adddownload"] = true;
			}
		}
	} else $ok = true;
} else {
	if( isset($_SESSION["wt"]["adddownload"]) ) unset($_SESSION["wt"]["adddownload"]);
}
if( !$ok ) $form->draw();
theme_draw_centerbox_close();

draw_footer();
?>