<?php
// phpdbform without the selectform
// we need to fill $form->keyvalue with the key values (comma separated)
include_once("phpdbform/phpdbform_main.php");
include_once("phpdbform/phpdbform_mysql.php");
include_once("phpdbform/phpdbform_db.php");
check_login();

$db = new phpdbform_db( "phpdbform", "localhost", "root", "" );
$db->connect();
$form = new phpdbform( $db, "contact", "cod" );

$form->add_textbox( "name", "Name:", 30 );
$form->add_textbox( "email", "E-mail:", 30 );
$form->add_static_listbox( "sex", "Male", "male,female" );
$form->add_checkbox( "active", "Active?", "Y", "N" );
$form->add_listbox( "type", "Type", $db, "type", "cod", "type", "type" );
$form->add_static_radiobox( "os", "Operating System:", "linux,windows,unix" );
$form->add_date( "birthday", "BirthDay", "fmtEUR" ); // fmtUSA, fmtEUR, fmtSQL
$form->add_textarea( "obs", "Obs", 30, 6 );

$events = "";

// $lform contains the form that called this event
function show_delete_message( &$lform )
{
    global $events;
    $events = "alert(\"record deleted\");";
    return true;
}

function show_insert_message( &$lform )
{
    global $events;
    $events = "alert(\"record inserted\");";
    return true;
}

function show_update_message( &$lform )
{
    global $events;
    $events = "alert(\"record updated\");";
    return true;
}

// this show how to append events into phpdbform
// if they return true, the actions will be taken (insert/delete/update)
// on false, it won't execute
$form->ondelete = "show_delete_message";
$form->oninsert = "show_insert_message";
$form->onupdate = "show_update_message";

draw_adm_header( "Test Contact 3", $emptyHeader );
?>
<table border="1" cellspacing="0" cellpadding="4" align="center">
<tr><th>Listing</th><th>Editing</th></tr>
<tr><td width="200" valign="top">
<a href="test_contact3.php">Insert new record</a><br>
<?php
// process the form first
if( isset($_GET["cod"]) )
{
    $form->keyvalue = array( intval($_GET["cod"]) );
}
$form->process();
// listing values from contact, set url param cod with the key
$ret = $db->query( "select cod, name from contact order by name", "filling contact listing" );
while( $row = $db->fetch_row($ret) )
{
    echo "<a href=\"test_contact3.php?cod={$row[0]}\">{$row[1]}</a><br>";
}
$db->free_result( $ret );
?>
</td><td width="300">
<?
$form->draw();
?>
</td></tr></table>
<script language="JavaScript">
<?php echo $events; ?>
</script>
<?php
draw_adm_footer();
?>