<?

#################################################################
#																#
#      OOPS  2001-2003 Andrey Lugovoy (440hz)					#
# CopyRight  2003 PeterService									#
#																#
# project   : www.billing.ru									#
# mailto    : andrey.lugovoy@billing.ru							#
#																#
#################################################################

### TREES.INC ###################################################

#    ()

class OOPSTree {
	var $root;		# 
	var $db;		# 
	var $table;		#  

	function OOPSTree($db,$table="TREE",$root="0") {
		$this->root = $root;
		$this->db = $db;
		$this->table = $table;
	}

	function Inc($NID) {
		$this->db->Query("UPDATE ".$this->table." SET SONS = SONS + 1 WHERE ID = '".$NID."'");
	}

	function Dec($NID) {
		$this->db->Query("UPDATE ".$this->table." SET SONS = SONS - 1 WHERE ID = '".$NID."'");
	}

	function CreateNode($FID,$NAME,$OID='',$NID='') {

		if($FID == '') $FID = $this->root;

		if($NID == '')
			$NID = $this->db->GetFreeID($this->table);
		$NAME = OOPSTypograf($NAME);
		$this->db->Query("INSERT INTO ".$this->table." (ID,FID,NAME,DATE,OID) VALUES('".$NID."','".$FID."','".$NAME."',".time().",'".$OID."')");
		$this->Inc($FID);
		return $NID;

	}

	function CreateRoot($NAME) {
		return $this->CreateNode($this->root,$NAME);
	}

	function UpdateNode($NID,$NAME,$OID='') {

		$NAME = OOPSTypograf($NAME);
		$this->db->Query("UPDATE ".$this->table." SET NAME = '".$NAME."', DATE = ".time().", OID = '".$OID."' WHERE ID = '".$NID."'");

	}

	function GetNode($NID) {
		return $this->db->QueryObject("SELECT * FROM ".$this->table." WHERE ID = '".$NID."'");
	}

	function GetFatherId($NID) {
		$FATHER = $this->db->QueryObject("SELECT FID FROM ".$this->table." WHERE ID = '".$NID."'");
		return $FATHER->FID;
	}

	function GetFather($NID) {
		return $this->GetNode($this->GetFatherId($NID));
	}

	function GetNodeByName($NAME) {
		return $this->db->QueryObject("SELECT * FROM ".$this->table." WHERE NAME = '".$NAME."'");
	}
	function GetNodeIdByName($NAME) {
		$NODE = $this->db->QueryObject("SELECT ID FROM ".$this->table." WHERE NAME = '".$NAME."'"); 
		return $NODE->ID;
	}

	function GetNodeByObj($OID) {
		return $this->db->QueryObject("SELECT * FROM ".$this->table." WHERE OID = '".$OID."'");
	}

	function MoveNode($NID,$FID) {

		$NODE = $this->GetNode($NID);
		$this->Dec($NODE->FID);
		$this->db->Query("UPDATE ".$this->table." SET FID = '".$FID."', DATE = ".time()." WHERE ID = '".$NID."'");
		$this->Inc($FID);

	}

	function GetSons($NID) {
		return $this->db->QueryObjects("SELECT * FROM ".$this->table." WHERE FID = '".$NID."' ORDER BY NAME");
	}

	function GetSonsByDate($NID,$ORDER=0) {

		switch($ORDER) {
			case 0:
				return $this->db->QueryObjects("SELECT * FROM ".$this->table." WHERE FID = '".$NID."' ORDER BY DATE");
			case 1:
				return $this->db->QueryObjects("SELECT * FROM ".$this->table." WHERE FID = '".$NID."' ORDER BY DATE DESC");
		}
	}

	function GetSon($NID) {
		return $this->db->QueryObject("SELECT * FROM ".$this->table." WHERE FID = '".$NID."' LIMIT 0,1");
	}

	function GetRoot() {
		return $this->GetSons($this->root);
	}

	function DeleteNode($NID) {

		$NODE = $this->GetNode($NID);
		#  
		if($NODE->SONS) {
			$SONS = $this->GetSons($NID);
			$SONSC = count($SONS);

			#      
			for($i=0;$i<$SONSC;$i++) {
				$SONSO = $SONS[$i];
				$this->DeleteNode($SONSO->ID);
			}
		}
		$this->Dec($NODE->FID);
#		print("DELETE FROM ".$this->table." WHERE ID = '".$NID."'");
		$this->db->Query("DELETE FROM ".$this->table." WHERE ID = '".$NID."'");
	}
}

class OOPSClass extends OOPSTree {

	function OOPSClass($db,$table="CLASS",$root="0") {
		$this->OOPSTree($db,$table,$root);
	}

	function AddProperty($CID,$NAME,$TYPE,$POS=0) {
		$ID = $this->db->GetFreeID("CLASS2PROP");
		$this->db->Query("INSERT INTO CLASS2PROP (ID,NAME,CID,TYPE,DATE,POS) VALUES ('".$ID."','".$NAME."','".$CID."','".$TYPE."',".time().",".$POS.")");
	}

	function DelProperty($ID) {
		$this->db->Delete("CLASS2PROP",$ID); 
	}

	function UpProperty($ID) {
		$this->db->Query("UPDATE CLASS2PROP SET POS = POS + 1 WHERE ID = '".$ID."'"); 
		$this->UpdateObjectsPos($ID);
	}

	function DownProperty($ID) {
		$this->db->Query("UPDATE CLASS2PROP SET POS = POS - 1 WHERE ID = '".$ID."'"); 
		$this->UpdateObjectsPos($ID);
	}

	function UpdateObjectsPos($ID) {
		$TMP = $this->db->QueryObject("SELECT TYPE,POS FROM CLASS2PROP WHERE ID = '".$ID."'");
		$P = $this->db->QueryObjects("SELECT ID FROM PROP".$TMP->TYPE." WHERE PID = '".$ID."'");
		$PC = count($P);
		for($i=0;$i<$PC;$i++) {
			$PO = $P[$i];
			$this->db->Query("UPDATE OBJECT2PROP SET POS = ".$TMP->POS." WHERE ID_PROP = '".$PO->ID."'");
		}
	}

	function GetProperty($CID) {
		return $this->db->QueryObjects("SELECT * FROM CLASS2PROP WHERE CID = '".$CID."' ORDER BY POS");
	}

	function GetFatherProperty($CID,$PROP=array()) {


		if($CID == $this->root) return array();
		
		$FATHER = $this->GetFather($CID);
		$PROP = $this->GetProperty($FATHER->ID);
		$PROP = array_merge($PROP,$this->GetFatherProperty($FATHER->ID,$PROP));
		return $PROP;
	}

	function GetPropertyType($PID) {
		$TYPE = $this->GetSon($PID);
		return $TYPE->NAME;
	}

	function GetAllProperty($CID) {
		return array_merge($this->GetFatherProperty($CID),$this->GetProperty($CID));
	}

	function RebuildObjects($ID_CLASS) {

		$NODE = $this->GetNode($ID_CLASS);

#print("<br>  ".$NODE->NAME."");
#print("<br> ".$NODE->SONS." ");

#flush();

		if($NODE->SONS) {
			$SONS = $this->GetSons($ID_CLASS);
			foreach($SONS AS $SON) {
#				print("<br>  ".$SON->NAME."");
#				flush();
				$this->RebuildObjects($SON->ID);
			}
		} else {
			$OBJS = $this->db->QueryObjects("SELECT DISTINCT ID_OBJECT FROM OBJECT2PROP WHERE ID_CLASS = '".$ID_CLASS."'");
			foreach($OBJS AS $OBJ) {
#				print("<br>   ".$NODE->NAME." ".$OBJ->ID_OBJECT);
#				flush();
				OOPSObjectredo($this,$OBJ->ID_OBJECT);
			}
		}


	}


}

?>