<?

#################################################################
#																#
#      OOPS  2001-2003 Andrey Lugovoy (440hz)					#
# CopyRight  2003 PeterService									#
#																#
# project   : www.billing.ru									#
# mailto    : andrey.lugovoy@billing.ru							#
#																#
#################################################################

### MAIL.INC ####################################################

#   

define ('MAILADDR_OK',				0);			#  
define ('MAILADDR_SYNTAX',			1);			#  
define ('MAILADDR_DOMAIN_NAME',		2);			#  
define ('MAILADDR_DOMAIN_EXISTS',	3);			#  
define ('MAILADDR_MX_EXISTS',		4);			#     
define ('MAILADDR_NAME',			5);			#   
define ('MAILADDR_LEN',				6);			#  > 128

define ('WEBMASTER','webmaster@billing.ru');
define ('ROBOT',    'robot@billing.ru');
define ('MARKETING','ldich@billing.ru');
define ('SUPPORT',  'support@billing.ru');

function OOPS_is_email($s) {

	#   
	if( !ereg('^[^@]+@[^@]+$', $s) )
		return MAILADDR_SYNTAX;

	list($u, $d) = explode('@', $s);

	if( eregi('^([0-9a-z]+(-[0-9a-z]+)*[.])+[a-z]{2,3}$', $s))
		return MAILADDR_DOMAIN_NAME;
	
	#   
	if( !checkdnsrr($d,"SOA") )
		return MAILADDR_DOMAIN_EXISTS;
	#   
	if( !checkdnsrr($d,'MX') ) {
		return MAILADDR_MX_EXISTS;
	}

	#   
	if( !eregi('^[0-9a-z_\./=+&$-]+$', $u) )
		return MAILADDR_NAME;

	#   
	if( strlen($s) > 128 )
		return MAILADDR_LEN;

	return MAILADDR_OK;
}

function OOPSCheckMailAddr($mail) {
	return OOPS_is_email($mail);
}

function OOPSMailer($TIT="",$TEXT="",$TO="",$FROM='From: <webmaster@billing.ru>') {

	if(empty($TIT)) return;
	if(empty($TEXT)) return;
	
	if(empty($TO)) $TO = 'andrey.lugovoy@billing.ru';

	$TIT = "BILLING.RU: ".$TIT;

	$NL = "\n";
	$LINE = "---------------------------------------------------------------------------";
	
	$TEXT = ereg_replace("[\r\n]",$NL,$TEXT);
	$TEXT = ereg_replace("<LINE>",$NL.$LINE.$NL,$TEXT);

	$BODY = array();

	$BODY[] = 'BILLING.RU                                                 '.date("d.m.Y H:i");
	$BODY[] = $LINE;

	$STR = explode($NL,$TEXT);
	$BODY[] = "";
	foreach($STR AS $S) {
		$BODY[] = $S;
	}

	$BODY[] = "";
	$BODY[] = $LINE;
	$BODY[] = WEBMASTER;

	$TEXT = $NL.$NL;

	foreach($BODY AS $B) {
		$TEXT .= "     ".$B.$NL;
	}

	$TEXT .= $NL.$NL;


	$TEXT = OOPSPreMail($TEXT);


	mail($TO,convert_cyr_string($TIT,"w","k"),convert_cyr_string($TEXT,"w","k"),$FROM."\nContent-Type: text/plain; charset=koi8-r\nReturn-Path: ".ROBOT."\nErrors-to: ".ROBOT."\n");

}

function OOPSPreMail($TEXT="") {

	$TEXT = str_replace("&nbsp;"  ,' ',$TEXT);
	$TEXT = str_replace("&raquo;" ,'"',$TEXT);
	$TEXT = str_replace("&laquo;" ,'"',$TEXT);

	$TEXT = str_replace("" ,'"',$TEXT);
	$TEXT = str_replace("" ,'"',$TEXT);

	$TEXT = str_replace("&#151;"  ,'-',$TEXT);

	return $TEXT;

}

function OOPSMailNotify($TIT="",$TEXT="") {

	OOPSMailer($TIT,$TEXT,WEBMASTER);

}

function OOPSMailNotifyMark($TIT="",$TEXT="") {

	OOPSMailer($TIT,$TEXT,MARKETING);

}

function OOPSMailerFromSupport($TIT="",$TEXT="",$TO="") {

	if(empty($TIT)) return;
	if(empty($TEXT)) return;
	
	if(empty($TO)) $TO = 'andrey.lugovoy@billing.ru';

	$TIT = "BILLING.RU: ".$TIT;

	$NL = "\n";
	$LINE = "---------------------------------------------------------------------------";
	
	$TEXT = ereg_replace("[\r\n]",$NL,$TEXT);
	$TEXT = ereg_replace("<LINE>",$NL.$LINE.$NL,$TEXT);

	$BODY = array();

	$BODY[] = 'BILLING.RU                                                 '.date("d.m.Y H:i");
	$BODY[] = $LINE;

	$STR = explode($NL,$TEXT);
	$BODY[] = "";
	foreach($STR AS $S) {
		$BODY[] = $S;
	}

	$BODY[] = "";
	$BODY[] = $LINE;
	$BODY[] = WEBMASTER;

	$TEXT = $NL.$NL;

	foreach($BODY AS $B) {
		$TEXT .= "     ".$B.$NL;
	}

	$TEXT .= $NL.$NL;

	mail($TO,convert_cyr_string($TIT,"w","k"),convert_cyr_string($TEXT,"w","k"),$FROM."From: ".SUPPORT."\nContent-Type: text/plain; charset=koi8-r\nReturn-Path: ".ROBOT."\nErrors-to: ".ROBOT."\n");

}

function OOPSMailerX($TIT="",$TEXT="",$TO="",$FROM='From: Webmaster <webmaster@billing.ru>') {

	if(empty($TIT)) return;
	if(empty($TEXT)) return;
	
	if(empty($TO)) $TO = 'andrey.lugovoy@billing.ru';

	$TIT = "BILLING.RU: ".$TIT;

	$NL = "\n";
	$LINE = "---------------------------------------------------------------------------";
	
	$TEXT = ereg_replace("[\r\n]",$NL,$TEXT);
	$TEXT = ereg_replace("<LINE>",$NL.$LINE.$NL,$TEXT);

	$BODY = array();

	$BODY[] = 'BILLING.RU                                                 '.date("d.m.Y H:i");
	$BODY[] = $LINE;

	$STR = explode($NL,$TEXT);
	$BODY[] = "";
	foreach($STR AS $S) {
		$BODY[] = $S;
	}

	$BODY[] = "";
	$BODY[] = $LINE;
	$BODY[] = WEBMASTER;

	$TEXT = $NL.$NL;

	foreach($BODY AS $B) {
		if($B)
			$TEXT .= "     ".$B.$NL;
	}

	$TEXT .= $NL.$NL;

	$TEXT = OOPSPreMail($TEXT);

	mail($TO,convert_cyr_string($TIT,"w","k"),convert_cyr_string($TEXT,"w","k"),$FROM."\nContent-Type: text/plain; charset=koi8-r\nReturn-Path: ".ROBOT."\nErrors-to: ".ROBOT."\n");

}



?>